/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson<T>
extends ResourceDataAbstract<Map<MinecraftKey, T>> {
    private static final Logger a = LogUtils.getLogger();
    private final DynamicOps<JsonElement> b;
    private final Codec<T> c;
    private final FileToIdConverter d;

    protected ResourceDataJson(HolderLookup.a var0, Codec<T> var1, ResourceKey<? extends IRegistry<T>> var2) {
        this(var0.a(JsonOps.INSTANCE), var1, FileToIdConverter.a(var2));
    }

    protected ResourceDataJson(Codec<T> var0, FileToIdConverter var1) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, var0, var1);
    }

    private ResourceDataJson(DynamicOps<JsonElement> var0, Codec<T> var1, FileToIdConverter var2) {
        this.b = var0;
        this.c = var1;
        this.d = var2;
    }

    protected Map<MinecraftKey, T> a(IResourceManager var0, GameProfilerFiller var1) {
        HashMap var2 = new HashMap();
        ResourceDataJson.a(var0, this.d, this.b, this.c, var2);
        return var2;
    }

    public static <T> void a(IResourceManager var0, ResourceKey<? extends IRegistry<T>> var1, DynamicOps<JsonElement> var2, Codec<T> var3, Map<MinecraftKey, T> var4) {
        ResourceDataJson.a(var0, FileToIdConverter.a(var1), var2, var3, var4);
    }

    public static <T> void a(IResourceManager var0, FileToIdConverter var1, DynamicOps<JsonElement> var22, Codec<T> var3, Map<MinecraftKey, T> var4) {
        for (Map.Entry<MinecraftKey, IResource> var6 : var1.a(var0).entrySet()) {
            MinecraftKey var7 = var6.getKey();
            MinecraftKey var8 = var1.b(var7);
            try {
                BufferedReader var9 = var6.getValue().e();
                try {
                    var3.parse(var22, (Object)StrictJsonParser.a(var9)).ifSuccess(var2 -> {
                        if (var4.putIfAbsent(var8, var2) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(var8));
                        }
                    }).ifError(var2 -> a.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{var8, var7, var2}));
                }
                finally {
                    if (var9 == null) continue;
                    ((Reader)var9).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var9) {
                a.error("Couldn't parse data file '{}' from '{}'", new Object[]{var8, var7, var9});
            }
        }
    }

    @Override
    protected /* synthetic */ Object b(IResourceManager iResourceManager, GameProfilerFiller gameProfilerFiller) {
        return this.a(iResourceManager, gameProfilerFiller);
    }
}

