/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManagerFallback;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ResourceManager
implements IReloadableResourceManager {
    private static final Logger a = LogUtils.getLogger();
    private final Map<String, ResourceManagerFallback> c;
    private final List<IResourcePack> d;

    public ResourceManager(EnumResourcePackType var0, List<IResourcePack> var12) {
        this.d = List.copyOf(var12);
        HashMap<String, ResourceManagerFallback> var2 = new HashMap<String, ResourceManagerFallback>();
        List var3 = var12.stream().flatMap(var1 -> var1.a(var0).stream()).distinct().toList();
        for (IResourcePack var5 : var12) {
            ResourceFilterSection var6 = this.a(var5);
            Set<String> var7 = var5.a(var0);
            Predicate<MinecraftKey> var8 = var6 != null ? var1 -> var6.b(var1.a()) : null;
            for (String var10 : var3) {
                boolean var122;
                boolean var11 = var7.contains(var10);
                boolean bl = var122 = var6 != null && var6.a(var10);
                if (!var11 && !var122) continue;
                ResourceManagerFallback var13 = (ResourceManagerFallback)var2.get(var10);
                if (var13 == null) {
                    var13 = new ResourceManagerFallback(var0, var10);
                    var2.put(var10, var13);
                }
                if (var11 && var122) {
                    var13.a(var5, var8);
                    continue;
                }
                if (var11) {
                    var13.a(var5);
                    continue;
                }
                var13.a(var5.b(), var8);
            }
        }
        this.c = var2;
    }

    private @Nullable ResourceFilterSection a(IResourcePack var0) {
        try {
            return var0.a(ResourceFilterSection.a);
        }
        catch (IOException var1) {
            a.error("Failed to get filter section from pack {}", (Object)var0.b());
            return null;
        }
    }

    @Override
    public Set<String> a() {
        return this.c.keySet();
    }

    @Override
    public Optional<IResource> getResource(MinecraftKey var0) {
        IResourceManager var1 = this.c.get(var0.b());
        if (var1 != null) {
            return var1.getResource(var0);
        }
        return Optional.empty();
    }

    @Override
    public List<IResource> a(MinecraftKey var0) {
        IResourceManager var1 = this.c.get(var0.b());
        if (var1 != null) {
            return var1.a(var0);
        }
        return List.of();
    }

    @Override
    public Map<MinecraftKey, IResource> b(String var0, Predicate<MinecraftKey> var1) {
        ResourceManager.a(var0);
        TreeMap<MinecraftKey, IResource> var2 = new TreeMap<MinecraftKey, IResource>();
        for (ResourceManagerFallback var4 : this.c.values()) {
            var2.putAll(var4.b(var0, var1));
        }
        return var2;
    }

    @Override
    public Map<MinecraftKey, List<IResource>> c(String var0, Predicate<MinecraftKey> var1) {
        ResourceManager.a(var0);
        TreeMap<MinecraftKey, List<IResource>> var2 = new TreeMap<MinecraftKey, List<IResource>>();
        for (ResourceManagerFallback var4 : this.c.values()) {
            var2.putAll(var4.c(var0, var1));
        }
        return var2;
    }

    private static void a(String var0) {
        if (var0.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + var0);
        }
    }

    @Override
    public Stream<IResourcePack> b() {
        return this.d.stream();
    }

    @Override
    public void close() {
        this.d.forEach(IResourcePack::close);
    }
}

