/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.FileUtils;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatisticManager
extends StatisticManager {
    private static final Gson b = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger c = LogUtils.getLogger();
    private static final Codec<Map<Statistic<?>, Integer>> d = Codec.dispatchedMap(BuiltInRegistries.w.q(), SystemUtils.b(ServerStatisticManager::a)).xmap(map -> {
        HashMap map1 = new HashMap();
        map.forEach((statisticwrapper, map2) -> map1.putAll(map2));
        return map1;
    }, map -> map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Statistic)entry.getKey()).a(), SystemUtils.a())));
    private final Path e;
    private final Set<Statistic<?>> f = Sets.newHashSet();

    private static <T> Codec<Map<Statistic<T>, Integer>> a(StatisticWrapper<T> statisticwrapper) {
        Codec<T> codec = statisticwrapper.b().q();
        Objects.requireNonNull(statisticwrapper);
        Codec codec1 = codec.flatComapMap(statisticwrapper::b, statistic -> statistic.a() == statisticwrapper ? DataResult.success(statistic.b()) : DataResult.error(() -> {
            String s2 = String.valueOf(statisticwrapper);
            return "Expected type " + s2 + ", but got " + String.valueOf(statistic.a());
        }));
        return Codec.unboundedMap((Codec)codec1, (Codec)Codec.INT);
    }

    public ServerStatisticManager(MinecraftServer minecraftserver, Path path) {
        this.e = path;
        for (Map.Entry<MinecraftKey, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Statistic<MinecraftKey> wrapper = StatisticList.i.b(entry.getKey());
            this.a.put(wrapper, entry.getValue().intValue());
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                JsonElement jsonelement = StrictJsonParser.a(reader);
                this.a(minecraftserver.aA(), jsonelement);
            }
            catch (IOException ioexception) {
                c.error("Couldn't read statistics file {}", (Object)path, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                c.error("Couldn't parse statistics file {}", (Object)path, (Object)jsonparseexception);
            }
        }
    }

    public void a() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.c(this.e.getParent());
            try (BufferedWriter writer = Files.newBufferedWriter(this.e, StandardCharsets.UTF_8, new OpenOption[0]);){
                b.toJson(this.b(), b.newJsonWriter((Writer)writer));
            }
        }
        catch (JsonIOException | IOException ioexception) {
            c.error("Couldn't save stats to {}", (Object)this.e, (Object)ioexception);
        }
    }

    @Override
    public void a(EntityHuman entityhuman, Statistic<?> statistic, int i2) {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        super.a(entityhuman, statistic, i2);
        this.f.add(statistic);
    }

    private Set<Statistic<?>> d() {
        HashSet set = Sets.newHashSet(this.f);
        this.f.clear();
        return set;
    }

    public void a(DataFixer datafixer, JsonElement jsonelement) {
        Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
        dynamic = DataFixTypes.h.a(datafixer, dynamic, GameProfileSerializer.b(dynamic, 1343));
        this.a.putAll(d.parse(dynamic.get("stats").orElseEmptyMap()).resultOrPartial(s2 -> c.error("Failed to parse statistics for {}: {}", (Object)this.e, s2)).orElse(Map.of()));
    }

    protected JsonElement b() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("stats", (JsonElement)d.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.a).getOrThrow());
        jsonobject.addProperty("DataVersion", (Number)SharedConstants.b().a().b());
        return jsonobject;
    }

    public void c() {
        this.f.addAll((Collection<Statistic<?>>)this.a.keySet());
    }

    public void a(EntityPlayer entityplayer) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Statistic<?> statistic : this.d()) {
            object2intmap.put(statistic, this.a(statistic));
        }
        entityplayer.g.b(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)object2intmap));
    }
}

