/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.ItemStackTagFix;

public class BlockPosFormatAndRenamesFix
extends DataFix {
    private static final List<String> a = List.of("minecraft:witch", "minecraft:ravager", "minecraft:pillager", "minecraft:illusioner", "minecraft:evoker", "minecraft:vindicator");

    public BlockPosFormatAndRenamesFix(Schema var0) {
        super(var0, true);
    }

    private Typed<?> a(Typed<?> var0, Map<String, String> var12) {
        return var0.update(DSL.remainderFinder(), var1 -> {
            for (Map.Entry var3 : var12.entrySet()) {
                var1 = var1.renameAndFixField((String)var3.getKey(), (String)var3.getValue(), ExtraDataFixUtils::a);
            }
            return var1;
        });
    }

    private <T> Dynamic<T> a(Dynamic<T> var0) {
        return var0.update("frames", var02 -> var02.createList(var02.asStream().map(var0 -> {
            var0 = var0.renameAndFixField("Pos", "pos", ExtraDataFixUtils::a);
            var0 = var0.renameField("Rotation", "rotation");
            var0 = var0.renameField("EntityId", "entity_id");
            return var0;
        }))).update("banners", var02 -> var02.createList(var02.asStream().map(var0 -> {
            var0 = var0.renameField("Pos", "pos");
            var0 = var0.renameField("Color", "color");
            var0 = var0.renameField("Name", "name");
            return var0;
        })));
    }

    public TypeRewriteRule makeRule() {
        ArrayList<TypeRewriteRule> var03 = new ArrayList<TypeRewriteRule>();
        this.a(var03);
        this.b(var03);
        var03.add(this.writeFixAndRead("BlockPos format for map frames", this.getInputSchema().getType(DataConverterTypes.k), this.getOutputSchema().getType(DataConverterTypes.k), var0 -> var0.update("data", this::a)));
        Type var1 = this.getInputSchema().getType(DataConverterTypes.x);
        var03.add(this.fixTypeEverywhereTyped("BlockPos format for compass target", var1, ItemStackTagFix.a(var1, "minecraft:compass"::equals, var02 -> var02.update(DSL.remainderFinder(), var0 -> var0.update("LodestonePos", ExtraDataFixUtils::a)))));
        return TypeRewriteRule.seq(var03);
    }

    private void a(List<TypeRewriteRule> var0) {
        var0.add(this.a(DataConverterTypes.H, "minecraft:bee", Map.of("HivePos", "hive_pos", "FlowerPos", "flower_pos")));
        var0.add(this.a(DataConverterTypes.H, "minecraft:end_crystal", Map.of("BeamTarget", "beam_target")));
        var0.add(this.a(DataConverterTypes.H, "minecraft:wandering_trader", Map.of("WanderTarget", "wander_target")));
        for (String var2 : a) {
            var0.add(this.a(DataConverterTypes.H, var2, Map.of("PatrolTarget", "patrol_target")));
        }
        var0.add(this.fixTypeEverywhereTyped("BlockPos format in Leash for mobs", this.getInputSchema().getType(DataConverterTypes.H), var02 -> var02.update(DSL.remainderFinder(), var0 -> var0.renameAndFixField("Leash", "leash", ExtraDataFixUtils::a))));
    }

    private void b(List<TypeRewriteRule> var0) {
        var0.add(this.a(DataConverterTypes.w, "minecraft:beehive", Map.of("FlowerPos", "flower_pos")));
        var0.add(this.a(DataConverterTypes.w, "minecraft:end_gateway", Map.of("ExitPortal", "exit_portal")));
    }

    private TypeRewriteRule a(DSL.TypeReference var0, String var1, Map<String, String> var22) {
        String var3 = "BlockPos format in " + String.valueOf(var22.keySet()) + " for " + var1 + " (" + var0.typeName() + ")";
        OpticFinder var4 = DSL.namedChoice((String)var1, (Type)this.getInputSchema().getChoiceType(var0, var1));
        return this.fixTypeEverywhereTyped(var3, this.getInputSchema().getType(var0), var2 -> var2.updateTyped(var4, var1 -> this.a((Typed<?>)var1, var22)));
    }
}

