/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jspecify.annotations.Nullable;

public class ChunkProtoTickListFix
extends DataFix {
    private static final int a = 16;
    private static final ImmutableSet<String> b = ImmutableSet.of((Object)"minecraft:bubble_column", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant", (Object)"minecraft:seagrass", (Object)"minecraft:tall_seagrass");

    public ChunkProtoTickListFix(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.d);
        OpticFinder var1 = var0.findField("Level");
        OpticFinder var2 = var1.type().findField("Sections");
        OpticFinder var3 = ((List.ListType)var2.type()).getElement().finder();
        OpticFinder var4 = var3.type().findField("block_states");
        OpticFinder var5 = var3.type().findField("biomes");
        OpticFinder var6 = var4.type().findField("palette");
        OpticFinder var72 = var1.type().findField("TileTicks");
        return this.fixTypeEverywhereTyped("ChunkProtoTickListFix", var0, var7 -> var7.updateTyped(var1, var6 -> {
            var6 = var6.update(DSL.remainderFinder(), var0 -> (Dynamic)DataFixUtils.orElse(var0.get("LiquidTicks").result().map(var1 -> var0.set("fluid_ticks", var1).remove("LiquidTicks")), (Object)var0));
            Object var7 = (Dynamic)var6.get(DSL.remainderFinder());
            MutableInt var8 = new MutableInt();
            Int2ObjectArrayMap var9 = new Int2ObjectArrayMap();
            var6.getOptionalTyped(var2).ifPresent(arg_0 -> ChunkProtoTickListFix.a(var3, var5, var8, var4, (Int2ObjectMap)var9, var6, arg_0));
            byte var10 = var8.byteValue();
            var6 = var6.update(DSL.remainderFinder(), var12 -> var12.update("yPos", var1 -> var1.createByte(var10)));
            if (var6.getOptionalTyped(var72).isPresent() || var7.get("fluid_ticks").result().isPresent()) {
                return var6;
            }
            int var11 = var7.get("xPos").asInt(0);
            int var122 = var7.get("zPos").asInt(0);
            Dynamic<?> var132 = this.a((Dynamic<?>)var7, (Int2ObjectMap<Supplier<a>>)var9, var10, var11, var122, "LiquidsToBeTicked", ChunkProtoTickListFix::b);
            Dynamic<?> var14 = this.a((Dynamic<?>)var7, (Int2ObjectMap<Supplier<a>>)var9, var10, var11, var122, "ToBeTicked", ChunkProtoTickListFix::a);
            Optional var15 = var72.type().readTyped(var14).result();
            if (var15.isPresent()) {
                var6 = var6.set(var72, (Typed)((Pair)var15.get()).getFirst());
            }
            return var6.update(DSL.remainderFinder(), var1 -> var1.remove("ToBeTicked").remove("LiquidsToBeTicked").set("fluid_ticks", var132));
        }));
    }

    private Dynamic<?> a(Dynamic<?> var02, Int2ObjectMap<Supplier<a>> var1, byte var2, int var3, int var4, String var5, Function<Dynamic<?>, String> var6) {
        Stream<Object> var7 = Stream.empty();
        List var8 = var02.get(var5).asList(Function.identity());
        for (int var9 = 0; var9 < var8.size(); ++var9) {
            int var10 = var9 + var2;
            Supplier var11 = (Supplier)var1.get(var10);
            Stream<Dynamic> var12 = ((Dynamic)var8.get(var9)).asStream().mapToInt(var0 -> var0.asShort((short)-1)).filter(var0 -> var0 > 0).mapToObj(arg_0 -> this.a(var02, (Supplier)var11, var3, var10, var4, var6, arg_0));
            var7 = Stream.concat(var7, var12);
        }
        return var02.createList(var7);
    }

    private static String a(@Nullable Dynamic<?> var0) {
        return var0 != null ? var0.get("Name").asString("minecraft:air") : "minecraft:air";
    }

    private static String b(@Nullable Dynamic<?> var0) {
        if (var0 == null) {
            return "minecraft:empty";
        }
        String var1 = var0.get("Name").asString("");
        if ("minecraft:water".equals(var1)) {
            return var0.get("Properties").get("level").asInt(0) == 0 ? "minecraft:water" : "minecraft:flowing_water";
        }
        if ("minecraft:lava".equals(var1)) {
            return var0.get("Properties").get("level").asInt(0) == 0 ? "minecraft:lava" : "minecraft:flowing_lava";
        }
        if (b.contains((Object)var1) || var0.get("Properties").get("waterlogged").asBoolean(false)) {
            return "minecraft:water";
        }
        return "minecraft:empty";
    }

    private Dynamic<?> a(Dynamic<?> var0, @Nullable Supplier<a> var1, int var2, int var3, int var4, int var5, Function<Dynamic<?>, String> var6) {
        int var7 = var5 & 0xF;
        int var8 = var5 >>> 4 & 0xF;
        int var9 = var5 >>> 8 & 0xF;
        String var10 = var6.apply(var1 != null ? var1.get().a(var7, var8, var9) : null);
        return var0.createMap((Map)ImmutableMap.builder().put((Object)var0.createString("i"), (Object)var0.createString(var10)).put((Object)var0.createString("x"), (Object)var0.createInt(var2 * 16 + var7)).put((Object)var0.createString("y"), (Object)var0.createInt(var3 * 16 + var8)).put((Object)var0.createString("z"), (Object)var0.createInt(var4 * 16 + var9)).put((Object)var0.createString("t"), (Object)var0.createInt(0)).put((Object)var0.createString("p"), (Object)var0.createInt(0)).build());
    }

    private /* synthetic */ Dynamic a(Dynamic var0, Supplier var1, int var2, int var3, int var4, Function var5, int var6) {
        return this.a(var0, (Supplier<a>)var1, var2, var3, var4, var6, var5);
    }

    private static /* synthetic */ void a(OpticFinder var0, OpticFinder var1, MutableInt var2, OpticFinder var3, Int2ObjectMap var4, OpticFinder var52, Typed var6) {
        var6.getAllTyped(var0).forEach(var5 -> {
            Dynamic var6 = (Dynamic)var5.get(DSL.remainderFinder());
            int var7 = var6.get("Y").asInt(Integer.MAX_VALUE);
            if (var7 == Integer.MAX_VALUE) {
                return;
            }
            if (var5.getOptionalTyped(var1).isPresent()) {
                var2.setValue(Math.min(var7, var2.intValue()));
            }
            var5.getOptionalTyped(var3).ifPresent(var3 -> var4.put(var7, (Object)Suppliers.memoize(() -> {
                OpticFinder var52 = var3.getOptionalTyped(var52).map(var02 -> var02.write().result().map(var0 -> var0.asList(Function.identity())).orElse(Collections.emptyList())).orElse(Collections.emptyList());
                Object var3 = ((Dynamic)var3.get(DSL.remainderFinder())).get("data").asLongStream().toArray();
                return new a((List<? extends Dynamic<?>>)var52, (long[])var3);
            })));
        });
    }

    public static final class a {
        private static final long a = 4L;
        private final List<? extends Dynamic<?>> b;
        private final long[] c;
        private final int d;
        private final long e;
        private final int f;

        public a(List<? extends Dynamic<?>> var0, long[] var1) {
            this.b = var0;
            this.c = var1;
            this.d = Math.max(4, ChunkHeightAndBiomeFix.a(var0.size()));
            this.e = (1L << this.d) - 1L;
            this.f = (char)(64 / this.d);
        }

        public @Nullable Dynamic<?> a(int var0, int var1, int var2) {
            int var3 = this.b.size();
            if (var3 < 1) {
                return null;
            }
            if (var3 == 1) {
                return this.b.getFirst();
            }
            int var4 = this.b(var0, var1, var2);
            int var5 = var4 / this.f;
            if (var5 < 0 || var5 >= this.c.length) {
                return null;
            }
            long var6 = this.c[var5];
            int var8 = (var4 - var5 * this.f) * this.d;
            int var9 = (int)(var6 >> var8 & this.e);
            if (var9 < 0 || var9 >= var3) {
                return null;
            }
            return this.b.get(var9);
        }

        private int b(int var0, int var1, int var2) {
            return (var1 << 4 | var2) << 4 | var0;
        }

        public List<? extends Dynamic<?>> a() {
            return this.b;
        }

        public long[] b() {
            return this.c;
        }
    }
}

