/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterEquipment
extends DataFix {
    public DataConverterEquipment(Schema var0) {
        super(var0, true);
    }

    public TypeRewriteRule makeRule() {
        return this.a(this.getInputSchema().getTypeRaw(DataConverterTypes.x), this.getOutputSchema().getTypeRaw(DataConverterTypes.x));
    }

    private <ItemStackOld, ItemStackNew> TypeRewriteRule a(Type<ItemStackOld> var02, Type<ItemStackNew> var12) {
        Type var2 = DSL.named((String)DataConverterTypes.E.typeName(), (Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(var02))));
        Type var3 = DSL.named((String)DataConverterTypes.E.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(var12))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(var12))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", var12)), (Type)DSL.optional((Type)DSL.field((String)"saddle", var12))));
        if (!var2.equals((Object)this.getInputSchema().getType(DataConverterTypes.E))) {
            throw new IllegalStateException("Input entity_equipment type does not match expected");
        }
        if (!var3.equals((Object)this.getOutputSchema().getType(DataConverterTypes.E))) {
            throw new IllegalStateException("Output entity_equipment type does not match expected");
        }
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix - drop chances", this.getInputSchema().getType(DataConverterTypes.H), var0 -> var0.update(DSL.remainderFinder(), DataConverterEquipment::a)), (TypeRewriteRule)this.fixTypeEverywhere("EntityEquipmentToArmorAndHandFix - equipment", var2, var3, var1 -> {
            Object var2 = ((Pair)var12.read(new Dynamic(var1).emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
            Either var3 = Either.right((Object)DSL.unit());
            return var22 -> var22.mapSecond(var2 -> {
                List var3 = (List)var2.map(Function.identity(), var0 -> List.of());
                Either var4 = Either.right((Object)DSL.unit());
                Either var5 = Either.right((Object)DSL.unit());
                if (!var3.isEmpty()) {
                    var4 = Either.left((Object)Lists.newArrayList((Object[])new Object[]{var3.getFirst(), var2}));
                }
                if (var3.size() > 1) {
                    ArrayList var6 = Lists.newArrayList((Object[])new Object[]{var2, var2, var2, var2});
                    for (int var7 = 1; var7 < Math.min(var3.size(), 5); ++var7) {
                        var6.set(var7 - 1, var3.get(var7));
                    }
                    var5 = Either.left((Object)var6);
                }
                return Pair.of((Object)var5, (Object)Pair.of((Object)var4, (Object)Pair.of((Object)var3, (Object)var3)));
            });
        }));
    }

    private static Dynamic<?> a(Dynamic<?> var02) {
        Optional var1 = var02.get("DropChances").asStreamOpt().result();
        var02 = var02.remove("DropChances");
        if (var1.isPresent()) {
            Iterator var2 = Stream.concat(((Stream)var1.get()).map(var0 -> Float.valueOf(var0.asFloat(0.0f))), Stream.generate(() -> Float.valueOf(0.0f))).iterator();
            float var3 = ((Float)var2.next()).floatValue();
            if (var02.get("HandDropChances").result().isEmpty()) {
                var02 = var02.set("HandDropChances", var02.createList(Stream.of(Float.valueOf(var3), Float.valueOf(0.0f)).map(arg_0 -> ((Dynamic)var02).createFloat(arg_0))));
            }
            if (var02.get("ArmorDropChances").result().isEmpty()) {
                var02 = var02.set("ArmorDropChances", var02.createList(Stream.of((Float)var2.next(), (Float)var2.next(), (Float)var2.next(), (Float)var2.next()).map(arg_0 -> ((Dynamic)var02).createFloat(arg_0))));
            }
        }
        return var02;
    }
}

