/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class GameRuleRegistryFix
extends DataFix {
    public GameRuleRegistryFix(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("GameRuleRegistryFix", this.getInputSchema().getType(DataConverterTypes.a), var02 -> var02.update(DSL.remainderFinder(), var0 -> var0.renameAndFixField("GameRules", "game_rules", var02 -> {
            boolean var1 = Boolean.parseBoolean(var02.get("doFireTick").asString("true"));
            boolean var2 = Boolean.parseBoolean(var02.get("allowFireTicksAwayFromPlayer").asString("false"));
            int var3 = !var1 ? 0 : (!var2 ? 128 : -1);
            if (var3 != 128) {
                var02 = var02.set("minecraft:fire_spread_radius_around_player", var02.createInt(var3));
            }
            return var02.remove("spawnChunkRadius").remove("entitiesWithPassengersCanUsePortals").remove("doFireTick").remove("allowFireTicksAwayFromPlayer").renameAndFixField("allowEnteringNetherUsingPortals", "minecraft:allow_entering_nether_using_portals", GameRuleRegistryFix::b).renameAndFixField("announceAdvancements", "minecraft:show_advancement_messages", GameRuleRegistryFix::b).renameAndFixField("blockExplosionDropDecay", "minecraft:block_explosion_drop_decay", GameRuleRegistryFix::b).renameAndFixField("commandBlockOutput", "minecraft:command_block_output", GameRuleRegistryFix::b).renameAndFixField("enableCommandBlocks", "minecraft:command_blocks_work", GameRuleRegistryFix::b).renameAndFixField("commandBlocksEnabled", "minecraft:command_blocks_work", GameRuleRegistryFix::b).renameAndFixField("commandModificationBlockLimit", "minecraft:max_block_modifications", var0 -> GameRuleRegistryFix.a(var0, 1)).renameAndFixField("disableElytraMovementCheck", "minecraft:elytra_movement_check", GameRuleRegistryFix::c).renameAndFixField("disablePlayerMovementCheck", "minecraft:player_movement_check", GameRuleRegistryFix::c).renameAndFixField("disableRaids", "minecraft:raids", GameRuleRegistryFix::c).renameAndFixField("doDaylightCycle", "minecraft:advance_time", GameRuleRegistryFix::b).renameAndFixField("doEntityDrops", "minecraft:entity_drops", GameRuleRegistryFix::b).renameAndFixField("doImmediateRespawn", "minecraft:immediate_respawn", GameRuleRegistryFix::b).renameAndFixField("doInsomnia", "minecraft:spawn_phantoms", GameRuleRegistryFix::b).renameAndFixField("doLimitedCrafting", "minecraft:limited_crafting", GameRuleRegistryFix::b).renameAndFixField("doMobLoot", "minecraft:mob_drops", GameRuleRegistryFix::b).renameAndFixField("doMobSpawning", "minecraft:spawn_mobs", GameRuleRegistryFix::b).renameAndFixField("doPatrolSpawning", "minecraft:spawn_patrols", GameRuleRegistryFix::b).renameAndFixField("doTileDrops", "minecraft:block_drops", GameRuleRegistryFix::b).renameAndFixField("doTraderSpawning", "minecraft:spawn_wandering_traders", GameRuleRegistryFix::b).renameAndFixField("doVinesSpread", "minecraft:spread_vines", GameRuleRegistryFix::b).renameAndFixField("doWardenSpawning", "minecraft:spawn_wardens", GameRuleRegistryFix::b).renameAndFixField("doWeatherCycle", "minecraft:advance_weather", GameRuleRegistryFix::b).renameAndFixField("drowningDamage", "minecraft:drowning_damage", GameRuleRegistryFix::b).renameAndFixField("enderPearlsVanishOnDeath", "minecraft:ender_pearls_vanish_on_death", GameRuleRegistryFix::b).renameAndFixField("fallDamage", "minecraft:fall_damage", GameRuleRegistryFix::b).renameAndFixField("fireDamage", "minecraft:fire_damage", GameRuleRegistryFix::b).renameAndFixField("forgiveDeadPlayers", "minecraft:forgive_dead_players", GameRuleRegistryFix::b).renameAndFixField("freezeDamage", "minecraft:freeze_damage", GameRuleRegistryFix::b).renameAndFixField("globalSoundEvents", "minecraft:global_sound_events", GameRuleRegistryFix::b).renameAndFixField("keepInventory", "minecraft:keep_inventory", GameRuleRegistryFix::b).renameAndFixField("lavaSourceConversion", "minecraft:lava_source_conversion", GameRuleRegistryFix::b).renameAndFixField("locatorBar", "minecraft:locator_bar", GameRuleRegistryFix::b).renameAndFixField("logAdminCommands", "minecraft:log_admin_commands", GameRuleRegistryFix::b).renameAndFixField("maxCommandChainLength", "minecraft:max_command_sequence_length", var0 -> GameRuleRegistryFix.a(var0, 0)).renameAndFixField("maxCommandForkCount", "minecraft:max_command_forks", var0 -> GameRuleRegistryFix.a(var0, 0)).renameAndFixField("maxEntityCramming", "minecraft:max_entity_cramming", var0 -> GameRuleRegistryFix.a(var0, 0)).renameAndFixField("minecartMaxSpeed", "minecraft:max_minecart_speed", GameRuleRegistryFix::a).renameAndFixField("mobExplosionDropDecay", "minecraft:mob_explosion_drop_decay", GameRuleRegistryFix::b).renameAndFixField("mobGriefing", "minecraft:mob_griefing", GameRuleRegistryFix::b).renameAndFixField("naturalRegeneration", "minecraft:natural_health_regeneration", GameRuleRegistryFix::b).renameAndFixField("playersNetherPortalCreativeDelay", "minecraft:players_nether_portal_creative_delay", var0 -> GameRuleRegistryFix.a(var0, 0)).renameAndFixField("playersNetherPortalDefaultDelay", "minecraft:players_nether_portal_default_delay", var0 -> GameRuleRegistryFix.a(var0, 0)).renameAndFixField("playersSleepingPercentage", "minecraft:players_sleeping_percentage", var0 -> GameRuleRegistryFix.a(var0, 0)).renameAndFixField("projectilesCanBreakBlocks", "minecraft:projectiles_can_break_blocks", GameRuleRegistryFix::b).renameAndFixField("pvp", "minecraft:pvp", GameRuleRegistryFix::b).renameAndFixField("randomTickSpeed", "minecraft:random_tick_speed", var0 -> GameRuleRegistryFix.a(var0, 0)).renameAndFixField("reducedDebugInfo", "minecraft:reduced_debug_info", GameRuleRegistryFix::b).renameAndFixField("sendCommandFeedback", "minecraft:send_command_feedback", GameRuleRegistryFix::b).renameAndFixField("showDeathMessages", "minecraft:show_death_messages", GameRuleRegistryFix::b).renameAndFixField("snowAccumulationHeight", "minecraft:max_snow_accumulation_height", var0 -> GameRuleRegistryFix.a(var0, 0, 8)).renameAndFixField("spawnMonsters", "minecraft:spawn_monsters", GameRuleRegistryFix::b).renameAndFixField("spawnRadius", "minecraft:respawn_radius", GameRuleRegistryFix::a).renameAndFixField("spawnerBlocksEnabled", "minecraft:spawner_blocks_work", GameRuleRegistryFix::b).renameAndFixField("spectatorsGenerateChunks", "minecraft:spectators_generate_chunks", GameRuleRegistryFix::b).renameAndFixField("tntExplodes", "minecraft:tnt_explodes", GameRuleRegistryFix::b).renameAndFixField("tntExplosionDropDecay", "minecraft:tnt_explosion_drop_decay", GameRuleRegistryFix::b).renameAndFixField("universalAnger", "minecraft:universal_anger", GameRuleRegistryFix::b).renameAndFixField("waterSourceConversion", "minecraft:water_source_conversion", GameRuleRegistryFix::b);
        })));
    }

    private static Dynamic<?> a(Dynamic<?> var0) {
        return GameRuleRegistryFix.a(var0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Dynamic<?> a(Dynamic<?> var0, int var1) {
        return GameRuleRegistryFix.a(var0, var1, Integer.MAX_VALUE);
    }

    private static Dynamic<?> a(Dynamic<?> var0, int var1, int var2) {
        String var3 = var0.asString("");
        try {
            int var4 = Integer.parseInt(var3);
            return var0.createInt(MathHelper.a(var4, var1, var2));
        }
        catch (NumberFormatException var4) {
            return var0;
        }
    }

    private static Dynamic<?> b(Dynamic<?> var0) {
        return var0.createBoolean(Boolean.parseBoolean(var0.asString("")));
    }

    private static Dynamic<?> c(Dynamic<?> var0) {
        return var0.createBoolean(!Boolean.parseBoolean(var0.asString("")));
    }
}

