/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import org.slf4j.Logger;

public class DataConverterSchemaV99
extends Schema {
    private static final Logger c = LogUtils.getLogger();
    static final Map<String, String> d = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
        var0.put("minecraft:furnace", "Furnace");
        var0.put("minecraft:lit_furnace", "Furnace");
        var0.put("minecraft:chest", "Chest");
        var0.put("minecraft:trapped_chest", "Chest");
        var0.put("minecraft:ender_chest", "EnderChest");
        var0.put("minecraft:jukebox", "RecordPlayer");
        var0.put("minecraft:dispenser", "Trap");
        var0.put("minecraft:dropper", "Dropper");
        var0.put("minecraft:sign", "Sign");
        var0.put("minecraft:mob_spawner", "MobSpawner");
        var0.put("minecraft:noteblock", "Music");
        var0.put("minecraft:brewing_stand", "Cauldron");
        var0.put("minecraft:enhanting_table", "EnchantTable");
        var0.put("minecraft:command_block", "CommandBlock");
        var0.put("minecraft:beacon", "Beacon");
        var0.put("minecraft:skull", "Skull");
        var0.put("minecraft:daylight_detector", "DLDetector");
        var0.put("minecraft:hopper", "Hopper");
        var0.put("minecraft:banner", "Banner");
        var0.put("minecraft:flower_pot", "FlowerPot");
        var0.put("minecraft:repeating_command_block", "CommandBlock");
        var0.put("minecraft:chain_command_block", "CommandBlock");
        var0.put("minecraft:standing_sign", "Sign");
        var0.put("minecraft:wall_sign", "Sign");
        var0.put("minecraft:piston_head", "Piston");
        var0.put("minecraft:daylight_detector_inverted", "DLDetector");
        var0.put("minecraft:unpowered_comparator", "Comparator");
        var0.put("minecraft:powered_comparator", "Comparator");
        var0.put("minecraft:wall_banner", "Banner");
        var0.put("minecraft:standing_banner", "Banner");
        var0.put("minecraft:structure_block", "Structure");
        var0.put("minecraft:end_portal", "Airportal");
        var0.put("minecraft:end_gateway", "EndGateway");
        var0.put("minecraft:shield", "Banner");
    });
    public static final Map<String, String> a = Map.of("minecraft:armor_stand", "ArmorStand", "minecraft:painting", "Painting");
    protected static final Hook.HookFunction b = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> var0, T var1) {
            return DataConverterSchemaV99.a(new Dynamic(var0, var1), d, a);
        }
    };

    public DataConverterSchemaV99(int var0, Schema var1) {
        super(var0, var1);
    }

    protected static void a(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.I.in(var0)));
    }

    protected static void b(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.I.in(var0)));
    }

    protected static void c(Schema var0, Map<String, Supplier<TypeTemplate>> var1, String var2) {
        var0.register(var1, var2, () -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))));
    }

    public Map<String, Supplier<TypeTemplate>> registerEntities(Schema var0) {
        HashMap var12 = Maps.newHashMap();
        var0.register((Map)var12, "Item", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)DataConverterTypes.x.in(var0)));
        var0.registerSimple((Map)var12, "XPOrb");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "ThrownEgg");
        var0.registerSimple((Map)var12, "LeashKnot");
        var0.registerSimple((Map)var12, "Painting");
        var0.register((Map)var12, "Arrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.I.in(var0)));
        var0.register((Map)var12, "TippedArrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.I.in(var0)));
        var0.register((Map)var12, "SpectralArrow", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.I.in(var0)));
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Snowball");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "Fireball");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "SmallFireball");
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "ThrownEnderpearl");
        var0.registerSimple((Map)var12, "EyeOfEnderSignal");
        var0.register((Map)var12, "ThrownPotion", var1 -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.I.in(var0), (String)"Potion", (TypeTemplate)DataConverterTypes.x.in(var0)));
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "ThrownExpBottle");
        var0.register((Map)var12, "ItemFrame", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)DataConverterTypes.x.in(var0)));
        DataConverterSchemaV99.a(var0, (Map<String, Supplier<TypeTemplate>>)var12, "WitherSkull");
        var0.registerSimple((Map)var12, "PrimedTnt");
        var0.register((Map)var12, "FallingSand", var1 -> DSL.optionalFields((String)"Block", (TypeTemplate)DataConverterTypes.I.in(var0), (String)"TileEntityData", (TypeTemplate)DataConverterTypes.w.in(var0)));
        var0.register((Map)var12, "FireworksRocketEntity", var1 -> DSL.optionalFields((String)"FireworksItem", (TypeTemplate)DataConverterTypes.x.in(var0)));
        var0.registerSimple((Map)var12, "Boat");
        var0.register((Map)var12, "Minecart", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.I.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))));
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "MinecartRideable");
        var0.register((Map)var12, "MinecartChest", var1 -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.I.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))));
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "MinecartFurnace");
        DataConverterSchemaV99.b(var0, (Map<String, Supplier<TypeTemplate>>)var12, "MinecartTNT");
        var0.register((Map)var12, "MinecartSpawner", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.I.in(var0), (TypeTemplate)DataConverterTypes.L.in(var0)));
        var0.register((Map)var12, "MinecartHopper", var1 -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.I.in(var0), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))));
        var0.register((Map)var12, "MinecartCommandBlock", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.I.in(var0), (String)"LastOutput", (TypeTemplate)DataConverterTypes.D.in(var0)));
        var0.registerSimple((Map)var12, "ArmorStand");
        var0.registerSimple((Map)var12, "Creeper");
        var0.registerSimple((Map)var12, "Skeleton");
        var0.registerSimple((Map)var12, "Spider");
        var0.registerSimple((Map)var12, "Giant");
        var0.registerSimple((Map)var12, "Zombie");
        var0.registerSimple((Map)var12, "Slime");
        var0.registerSimple((Map)var12, "Ghast");
        var0.registerSimple((Map)var12, "PigZombie");
        var0.register((Map)var12, "Enderman", var1 -> DSL.optionalFields((String)"carried", (TypeTemplate)DataConverterTypes.I.in(var0)));
        var0.registerSimple((Map)var12, "CaveSpider");
        var0.registerSimple((Map)var12, "Silverfish");
        var0.registerSimple((Map)var12, "Blaze");
        var0.registerSimple((Map)var12, "LavaSlime");
        var0.registerSimple((Map)var12, "EnderDragon");
        var0.registerSimple((Map)var12, "WitherBoss");
        var0.registerSimple((Map)var12, "Bat");
        var0.registerSimple((Map)var12, "Witch");
        var0.registerSimple((Map)var12, "Endermite");
        var0.registerSimple((Map)var12, "Guardian");
        var0.registerSimple((Map)var12, "Pig");
        var0.registerSimple((Map)var12, "Sheep");
        var0.registerSimple((Map)var12, "Cow");
        var0.registerSimple((Map)var12, "Chicken");
        var0.registerSimple((Map)var12, "Squid");
        var0.registerSimple((Map)var12, "Wolf");
        var0.registerSimple((Map)var12, "MushroomCow");
        var0.registerSimple((Map)var12, "SnowMan");
        var0.registerSimple((Map)var12, "Ozelot");
        var0.registerSimple((Map)var12, "VillagerGolem");
        var0.register((Map)var12, "EntityHorse", var1 -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0)), (String)"ArmorItem", (TypeTemplate)DataConverterTypes.x.in(var0), (String)"SaddleItem", (TypeTemplate)DataConverterTypes.x.in(var0)));
        var0.registerSimple((Map)var12, "Rabbit");
        var0.register((Map)var12, "Villager", var1 -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0)), (String)"Offers", (TypeTemplate)DSL.optionalFields((String)"Recipes", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.B.in(var0)))));
        var0.registerSimple((Map)var12, "EnderCrystal");
        var0.register((Map)var12, "AreaEffectCloud", var1 -> DSL.optionalFields((String)"Particle", (TypeTemplate)DataConverterTypes.C.in(var0)));
        var0.registerSimple((Map)var12, "ShulkerBullet");
        var0.registerSimple((Map)var12, "DragonFireball");
        var0.registerSimple((Map)var12, "Shulker");
        return var12;
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema var0) {
        HashMap var12 = Maps.newHashMap();
        DataConverterSchemaV99.c(var0, var12, "Furnace");
        DataConverterSchemaV99.c(var0, var12, "Chest");
        var0.registerSimple((Map)var12, "EnderChest");
        var0.register((Map)var12, "RecordPlayer", var1 -> DSL.optionalFields((String)"RecordItem", (TypeTemplate)DataConverterTypes.x.in(var0)));
        DataConverterSchemaV99.c(var0, var12, "Trap");
        DataConverterSchemaV99.c(var0, var12, "Dropper");
        var0.register((Map)var12, "Sign", () -> DataConverterSchemaV99.a(var0));
        var0.register((Map)var12, "MobSpawner", var1 -> DataConverterTypes.L.in(var0));
        var0.registerSimple((Map)var12, "Music");
        var0.registerSimple((Map)var12, "Piston");
        DataConverterSchemaV99.c(var0, var12, "Cauldron");
        var0.registerSimple((Map)var12, "EnchantTable");
        var0.registerSimple((Map)var12, "Airportal");
        var0.register((Map)var12, "Control", () -> DSL.optionalFields((String)"LastOutput", (TypeTemplate)DataConverterTypes.D.in(var0)));
        var0.registerSimple((Map)var12, "Beacon");
        var0.register((Map)var12, "Skull", () -> DSL.optionalFields((String)"custom_name", (TypeTemplate)DataConverterTypes.D.in(var0)));
        var0.registerSimple((Map)var12, "DLDetector");
        DataConverterSchemaV99.c(var0, var12, "Hopper");
        var0.registerSimple((Map)var12, "Comparator");
        var0.register((Map)var12, "FlowerPot", var1 -> DSL.optionalFields((String)"Item", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DataConverterTypes.J.in(var0))));
        var0.register((Map)var12, "Banner", () -> DSL.optionalFields((String)"CustomName", (TypeTemplate)DataConverterTypes.D.in(var0)));
        var0.registerSimple((Map)var12, "Structure");
        var0.registerSimple((Map)var12, "EndGateway");
        return var12;
    }

    public static TypeTemplate a(Schema var0) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"Text1", (Object)DataConverterTypes.D.in(var0)), Pair.of((Object)"Text2", (Object)DataConverterTypes.D.in(var0)), Pair.of((Object)"Text3", (Object)DataConverterTypes.D.in(var0)), Pair.of((Object)"Text4", (Object)DataConverterTypes.D.in(var0)), Pair.of((Object)"FilteredText1", (Object)DataConverterTypes.D.in(var0)), Pair.of((Object)"FilteredText2", (Object)DataConverterTypes.D.in(var0)), Pair.of((Object)"FilteredText3", (Object)DataConverterTypes.D.in(var0)), Pair.of((Object)"FilteredText4", (Object)DataConverterTypes.D.in(var0))});
    }

    public void registerTypes(Schema var0, Map<String, Supplier<TypeTemplate>> var1, Map<String, Supplier<TypeTemplate>> var2) {
        var0.registerType(false, DataConverterTypes.a, () -> DSL.optionalFields((String)"CustomBossEvents", (TypeTemplate)DSL.compoundList((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)DataConverterTypes.D.in(var0))), (TypeTemplate)DataConverterTypes.b.in(var0)));
        var0.registerType(false, DataConverterTypes.b, DSL::remainder);
        var0.registerType(false, DataConverterTypes.c, () -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0)), (String)"EnderItems", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))));
        var0.registerType(false, DataConverterTypes.d, () -> DSL.fields((String)"Level", (TypeTemplate)DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.G.in(var0)), (String)"TileEntities", (TypeTemplate)DSL.list((TypeTemplate)DSL.or((TypeTemplate)DataConverterTypes.w.in(var0), (TypeTemplate)DSL.remainder())), (String)"TileTicks", (TypeTemplate)DSL.list((TypeTemplate)DSL.fields((String)"i", (TypeTemplate)DataConverterTypes.I.in(var0))))));
        var0.registerType(true, DataConverterTypes.w, () -> DSL.optionalFields((String)"components", (TypeTemplate)DataConverterTypes.A.in(var0), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)var2)));
        var0.registerType(true, DataConverterTypes.G, () -> DSL.optionalFields((String)"Riding", (TypeTemplate)DataConverterTypes.G.in(var0), (TypeTemplate)DataConverterTypes.H.in(var0)));
        var0.registerType(false, DataConverterTypes.F, () -> DSL.constType(DataConverterSchemaNamed.a()));
        var0.registerType(true, DataConverterTypes.H, () -> DSL.and((TypeTemplate)DataConverterTypes.E.in(var0), (TypeTemplate)DSL.optionalFields((String)"CustomName", (TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)var1))));
        var0.registerType(true, DataConverterTypes.x, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"id", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DataConverterTypes.J.in(var0)), (String)"tag", (TypeTemplate)DataConverterSchemaV99.b(var0)), (Hook.HookFunction)b, (Hook.HookFunction)Hook.HookFunction.IDENTITY));
        var0.registerType(false, DataConverterTypes.f, DSL::remainder);
        var0.registerType(false, DataConverterTypes.I, () -> DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DSL.constType(DataConverterSchemaNamed.a())));
        var0.registerType(false, DataConverterTypes.J, () -> DSL.constType(DataConverterSchemaNamed.a()));
        var0.registerType(false, DataConverterTypes.h, DSL::remainder);
        var0.registerType(false, DataConverterTypes.i, DSL::remainder);
        var0.registerType(false, DataConverterTypes.j, DSL::remainder);
        var0.registerType(false, DataConverterTypes.k, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"banners", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)DataConverterTypes.D.in(var0))))));
        var0.registerType(false, DataConverterTypes.l, DSL::remainder);
        var0.registerType(false, DataConverterTypes.m, DSL::remainder);
        var0.registerType(false, DataConverterTypes.n, DSL::remainder);
        var0.registerType(false, DataConverterTypes.o, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Objectives", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.N.in(var0)), (String)"Teams", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.O.in(var0)), (String)"PlayerScores", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"display", (TypeTemplate)DataConverterTypes.D.in(var0))))));
        var0.registerType(false, DataConverterTypes.p, DSL::remainder);
        var0.registerType(false, DataConverterTypes.q, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Features", (TypeTemplate)DSL.compoundList((TypeTemplate)DataConverterTypes.M.in(var0)))));
        var0.registerType(false, DataConverterTypes.r, DSL::remainder);
        var0.registerType(false, DataConverterTypes.v, DSL::remainder);
        var0.registerType(false, DataConverterTypes.M, DSL::remainder);
        var0.registerType(false, DataConverterTypes.N, DSL::remainder);
        var0.registerType(false, DataConverterTypes.O, () -> DSL.optionalFields((String)"MemberNamePrefix", (TypeTemplate)DataConverterTypes.D.in(var0), (String)"MemberNameSuffix", (TypeTemplate)DataConverterTypes.D.in(var0), (String)"DisplayName", (TypeTemplate)DataConverterTypes.D.in(var0)));
        var0.registerType(true, DataConverterTypes.L, DSL::remainder);
        var0.registerType(false, DataConverterTypes.t, DSL::remainder);
        var0.registerType(false, DataConverterTypes.S, DSL::remainder);
        var0.registerType(false, DataConverterTypes.u, () -> DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.G.in(var0))));
        var0.registerType(true, DataConverterTypes.A, DSL::remainder);
        var0.registerType(true, DataConverterTypes.B, () -> DSL.optionalFields((String)"buy", (TypeTemplate)DataConverterTypes.x.in(var0), (String)"buyB", (TypeTemplate)DataConverterTypes.x.in(var0), (String)"sell", (TypeTemplate)DataConverterTypes.x.in(var0)));
        var0.registerType(true, DataConverterTypes.C, () -> DSL.constType((Type)DSL.string()));
        var0.registerType(true, DataConverterTypes.D, () -> DSL.constType((Type)DSL.string()));
        var0.registerType(false, DataConverterTypes.g, () -> DSL.optionalFields((String)"entities", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)DataConverterTypes.G.in(var0))), (String)"blocks", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)DataConverterTypes.w.in(var0))), (String)"palette", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.y.in(var0))));
        var0.registerType(false, DataConverterTypes.y, DSL::remainder);
        var0.registerType(false, DataConverterTypes.z, DSL::remainder);
        var0.registerType(true, DataConverterTypes.E, () -> DSL.optional((TypeTemplate)DSL.field((String)"Equipment", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0)))));
    }

    public static TypeTemplate b(Schema var0) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"EntityTag", (Object)DataConverterTypes.G.in(var0)), Pair.of((Object)"BlockEntityTag", (Object)DataConverterTypes.w.in(var0)), Pair.of((Object)"CanDestroy", (Object)DSL.list((TypeTemplate)DataConverterTypes.I.in(var0))), Pair.of((Object)"CanPlaceOn", (Object)DSL.list((TypeTemplate)DataConverterTypes.I.in(var0))), Pair.of((Object)"Items", (Object)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))), Pair.of((Object)"ChargedProjectiles", (Object)DSL.list((TypeTemplate)DataConverterTypes.x.in(var0))), Pair.of((Object)"pages", (Object)DSL.list((TypeTemplate)DataConverterTypes.D.in(var0))), Pair.of((Object)"filtered_pages", (Object)DSL.compoundList((TypeTemplate)DataConverterTypes.D.in(var0))), Pair.of((Object)"display", (Object)DSL.optionalFields((String)"Name", (TypeTemplate)DataConverterTypes.D.in(var0), (String)"Lore", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.D.in(var0))))});
    }

    protected static <T> T a(Dynamic<T> var0, Map<String, String> var1, Map<String, String> var2) {
        return (T)var0.update("tag", var3 -> var3.update("BlockEntityTag", var2 -> {
            Object var3 = var0.get("id").asString().result().map(DataConverterSchemaNamed::a).orElse("minecraft:air");
            if (!"minecraft:air".equals(var3)) {
                String var4 = (String)var1.get(var3);
                if (var4 == null) {
                    c.warn("Unable to resolve BlockEntity for ItemStack: {}", var3);
                } else {
                    return var2.set("id", var0.createString(var4));
                }
            }
            return var2;
        }).update("EntityTag", var2 -> {
            if (var2.get("id").result().isPresent()) {
                return var2;
            }
            Object var3 = DataConverterSchemaNamed.a(var0.get("id").asString(""));
            String var4 = (String)var2.get(var3);
            if (var4 != null) {
                return var2.set("id", var0.createString(var4));
            }
            return var2;
        })).getValue();
    }
}

