/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.SlotProvider;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.schedule.Activity;
import org.jspecify.annotations.Nullable;

public final class DebugBrainDump
extends Record {
    private final String b;
    private final String c;
    private final int d;
    private final float e;
    private final float f;
    private final String g;
    private final boolean h;
    private final int i;
    private final List<String> j;
    private final List<String> k;
    private final List<String> l;
    private final List<String> m;
    private final Set<BlockPosition> n;
    private final Set<BlockPosition> o;
    public static final StreamCodec<PacketDataSerializer, DebugBrainDump> a = StreamCodec.a((B var0, V var1) -> var1.a((PacketDataSerializer)((Object)var0)), DebugBrainDump::new);

    public DebugBrainDump(PacketDataSerializer var0) {
        this(var0.p(), var0.p(), var0.readInt(), var0.readFloat(), var0.readFloat(), var0.p(), var0.readBoolean(), var0.readInt(), var0.a(PacketDataSerializer::p), var0.a(PacketDataSerializer::p), var0.a(PacketDataSerializer::p), var0.a(PacketDataSerializer::p), (Set)((Object)var0.a(HashSet::new, BlockPosition.b)), (Set)((Object)var0.a(HashSet::new, BlockPosition.b)));
    }

    public DebugBrainDump(String var0, String var1, int var2, float var3, float var4, String var5, boolean var6, int var7, List<String> var8, List<String> var9, List<String> var10, List<String> var11, Set<BlockPosition> var12, Set<BlockPosition> var13) {
        this.b = var0;
        this.c = var1;
        this.d = var2;
        this.e = var3;
        this.f = var4;
        this.g = var5;
        this.h = var6;
        this.i = var7;
        this.j = var8;
        this.k = var9;
        this.l = var10;
        this.m = var11;
        this.n = var12;
        this.o = var13;
    }

    public void a(PacketDataSerializer var0) {
        var0.a(this.b);
        var0.a(this.c);
        var0.q(this.d);
        var0.a(this.e);
        var0.a(this.f);
        var0.a(this.g);
        var0.a(this.h);
        var0.q(this.i);
        var0.a(this.j, PacketDataSerializer::a);
        var0.a(this.k, PacketDataSerializer::a);
        var0.a(this.l, PacketDataSerializer::a);
        var0.a(this.m, PacketDataSerializer::a);
        var0.a(this.n, BlockPosition.b);
        var0.a(this.o, BlockPosition.b);
    }

    public static DebugBrainDump a(WorldServer var02, EntityLiving var1) {
        List<String> list;
        int n2;
        Object var13;
        InventoryCarrier var11;
        SlotProvider var12;
        int var4;
        String var3;
        String var2 = DebugEntityNameGenerator.a(var1);
        if (var1 instanceof EntityVillager) {
            EntityVillager var5 = (EntityVillager)var1;
            var3 = var5.gZ().b().g();
            var4 = var5.d();
        } else {
            var3 = "";
            var4 = 0;
        }
        float var5 = var1.eZ();
        float var6 = var1.fq();
        BehaviorController<?> var7 = var1.ev();
        long var8 = var1.ao().au();
        String var10 = var1 instanceof InventoryCarrier ? ((var12 = (var11 = (InventoryCarrier)((Object)var1)).gP()).c() ? "" : var12.toString()) : "";
        boolean bl = var11 = var1 instanceof EntityVillager && ((EntityVillager)(var12 = (EntityVillager)var1)).a(var8);
        if (var1 instanceof Warden) {
            var13 = (Warden)var1;
            n2 = ((Warden)var13).p();
        } else {
            n2 = -1;
        }
        int var20 = n2;
        var13 = var7.c().stream().map(Activity::a).toList();
        List<String> var14 = var7.d().stream().map(BehaviorControl::b).toList();
        List<String> var15 = DebugBrainDump.a(var02, var1, var8).map(var0 -> UtilColor.a(var0, 255, true)).toList();
        Set<BlockPosition> var16 = DebugBrainDump.a(var7, MemoryModuleType.c, MemoryModuleType.b, MemoryModuleType.e);
        Set<BlockPosition> var17 = DebugBrainDump.a(var7, MemoryModuleType.d);
        if (var1 instanceof EntityVillager) {
            EntityVillager var19 = (EntityVillager)var1;
            list = DebugBrainDump.a(var19);
        } else {
            list = List.of();
        }
        List<String> var18 = list;
        return new DebugBrainDump(var2, var3, var4, var5, var6, var10, var11, var20, (List<String>)var13, var14, var15, var18, var16, var17);
    }

    @SafeVarargs
    private static Set<BlockPosition> a(BehaviorController<?> var0, MemoryModuleType<GlobalPos> ... var1) {
        return Stream.of(var1).filter(var0::a).map(var0::c).flatMap(Optional::stream).map(GlobalPos::b).collect(Collectors.toSet());
    }

    private static List<String> a(EntityVillager var0) {
        ArrayList<String> var12 = new ArrayList<String>();
        var0.he().a().forEach((var1, var22) -> {
            String var32 = DebugEntityNameGenerator.a(var1);
            var22.forEach((var2, var3) -> var12.add(var32 + ": " + String.valueOf(var2) + ": " + var3));
        });
        return var12;
    }

    private static Stream<String> a(WorldServer var0, EntityLiving var1, long var2) {
        return var1.ev().b().entrySet().stream().map(var3 -> {
            MemoryModuleType var4 = (MemoryModuleType)var3.getKey();
            Optional var5 = (Optional)var3.getValue();
            return DebugBrainDump.a(var0, var2, var4, var5);
        }).sorted();
    }

    private static String a(WorldServer var0, long var1, MemoryModuleType<?> var3, Optional<? extends ExpirableMemory<?>> var4) {
        Object var5;
        if (var4.isPresent()) {
            ExpirableMemory<?> var6 = var4.get();
            Object var7 = var6.c();
            if (var3 == MemoryModuleType.E) {
                long var8 = var1 - (Long)var7;
                var5 = var8 + " ticks ago";
            } else {
                var5 = var6.e() ? DebugBrainDump.a(var0, var7) + " (ttl: " + var6.b() + ")" : DebugBrainDump.a(var0, var7);
            }
        } else {
            var5 = "-";
        }
        return BuiltInRegistries.A.b(var3).a() + ": " + (String)var5;
    }

    private static String a(WorldServer var0, @Nullable Object var12) {
        Object object = var12;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UUID.class, Entity.class, MemoryTarget.class, BehaviorPositionEntity.class, GlobalPos.class, BehaviorTarget.class, DamageSource.class, Collection.class}, (Object)object, n2)) {
            case -1 -> "-";
            case 0 -> {
                UUID var4 = (UUID)object;
                yield DebugBrainDump.a(var0, var0.d(var4));
            }
            case 1 -> {
                Entity var5 = (Entity)object;
                yield DebugEntityNameGenerator.a(var5);
            }
            case 2 -> {
                MemoryTarget var6 = (MemoryTarget)object;
                yield DebugBrainDump.a(var0, var6.a());
            }
            case 3 -> {
                BehaviorPositionEntity var7 = (BehaviorPositionEntity)object;
                yield DebugBrainDump.a(var0, var7.c());
            }
            case 4 -> {
                GlobalPos var8 = (GlobalPos)object;
                yield DebugBrainDump.a(var0, var8.b());
            }
            case 5 -> {
                BehaviorTarget var9 = (BehaviorTarget)object;
                yield DebugBrainDump.a(var0, var9.b());
            }
            case 6 -> {
                DamageSource var10 = (DamageSource)object;
                Entity var11 = var10.d();
                if (var11 == null) {
                    yield var12.toString();
                }
                yield DebugBrainDump.a(var0, var11);
            }
            case 7 -> {
                Collection var11 = (Collection)object;
                yield "[" + var11.stream().map(var1 -> DebugBrainDump.a(var0, var1)).collect(Collectors.joining(", ")) + "]";
            }
            default -> var12.toString();
        };
    }

    public boolean a(BlockPosition var0) {
        return this.n.contains(var0);
    }

    public boolean b(BlockPosition var0) {
        return this.o.contains(var0);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DebugBrainDump.class, "name;profession;xp;health;maxHealth;inventory;wantsGolem;angerLevel;activities;behaviors;memories;gossips;pois;potentialPois", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DebugBrainDump.class, "name;profession;xp;health;maxHealth;inventory;wantsGolem;angerLevel;activities;behaviors;memories;gossips;pois;potentialPois", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DebugBrainDump.class, "name;profession;xp;health;maxHealth;inventory;wantsGolem;angerLevel;activities;behaviors;memories;gossips;pois;potentialPois", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this, var0);
    }

    public String a() {
        return this.b;
    }

    public String b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public float d() {
        return this.e;
    }

    public float e() {
        return this.f;
    }

    public String f() {
        return this.g;
    }

    public boolean g() {
        return this.h;
    }

    public int h() {
        return this.i;
    }

    public List<String> i() {
        return this.j;
    }

    public List<String> j() {
        return this.k;
    }

    public List<String> k() {
        return this.l;
    }

    public List<String> l() {
        return this.m;
    }

    public Set<BlockPosition> m() {
        return this.n;
    }

    public Set<BlockPosition> n() {
        return this.o;
    }
}

