/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ARGB;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.debug.DebugEntityBlockIntersection;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SlotProvider;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.CustomTimingsHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements SyncedDataHolder,
DebugValueSource,
INamableTileEntity,
ItemOwner,
SlotProvider,
EntityAccess,
ScoreHolder,
DataComponentGetter {
    private static final int CURRENT_LEVEL = 2;
    private CraftEntity bukkitEntity;
    private static final Logger b = LogUtils.getLogger();
    public static final String v = "id";
    public static final String w = "UUID";
    public static final String x = "Passengers";
    public static final String y = "data";
    public static final String z = "Pos";
    public static final String A = "Motion";
    public static final String B = "Rotation";
    public static final String C = "PortalCooldown";
    public static final String D = "NoGravity";
    public static final String E = "Air";
    public static final String F = "OnGround";
    public static final String G = "fall_distance";
    public static final String H = "Fire";
    public static final String I = "Silent";
    public static final String J = "Glowing";
    public static final String K = "Invulnerable";
    public static final String L = "CustomName";
    private static final AtomicInteger c = new AtomicInteger();
    public static final int M = 0;
    public static final int N = 60;
    public static final int O = 300;
    public static final int P = 1024;
    private static final Codec<List<String>> d = Codec.STRING.sizeLimitedListOf(1024);
    public static final float Q = 0.2f;
    public static final double R = 0.500001;
    public static final double S = 0.999999;
    public static final int T = 140;
    public static final int U = 40;
    public static final int V = 3;
    private static final AxisAlignedBB e = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double r = 0.014;
    private static final double s = 0.007;
    private static final double t = 0.0023333333333333335;
    private static final int u = 16;
    private static final double aN = 8.0;
    private static double aO = 1.0;
    private final EntityTypes<?> aP;
    private boolean aQ;
    private int aR;
    public boolean W;
    public ImmutableList<Entity> aS;
    protected int X;
    private @Nullable Entity aT;
    private net.minecraft.world.level.World aU;
    public double Y;
    public double Z;
    public double aa;
    private Vec3D aV;
    private BlockPosition aW;
    private ChunkCoordIntPair aX;
    private Vec3D aY;
    private float aZ;
    private float ba;
    public float ab;
    public float ac;
    private AxisAlignedBB bb;
    public boolean bc;
    public boolean ad;
    public boolean ae;
    public boolean af;
    public boolean ag;
    public boolean ah;
    protected Vec3D ai;
    private @Nullable RemovalReason bd;
    public static final float aj = 0.6f;
    public static final float ak = 1.8f;
    public float al;
    public float am;
    public double an;
    private float be = 1.0f;
    public double ao;
    public double ap;
    public double aq;
    public boolean ar;
    public final RandomSource as;
    public int at;
    private int bf;
    public boolean au;
    protected Object2DoubleMap<TagKey<FluidType>> av;
    protected boolean aw;
    private final Set<TagKey<FluidType>> bg;
    public int ax;
    protected boolean ay = true;
    protected final DataWatcher az;
    protected static final DataWatcherObject<Byte> aA = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int aB = 0;
    private static final int bh = 1;
    private static final int bi = 3;
    private static final int bj = 4;
    private static final int bk = 5;
    protected static final int aC = 6;
    protected static final int aD = 7;
    private static final DataWatcherObject<Integer> bl = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> bm = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> bn = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bo = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bp = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> aE = DataWatcher.a(Entity.class, DataWatcherRegistry.v);
    private static final DataWatcherObject<Integer> bq = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback br;
    private final VecDeltaCodec bs;
    public boolean aF;
    public @Nullable PortalProcessor aG;
    public int bt;
    private boolean bu;
    protected UUID aH;
    protected String aI;
    private boolean bv;
    private final Set<String> bw;
    private final double[] bx;
    private long by;
    private EntitySize bz;
    private float bA;
    public boolean aJ;
    public boolean aK;
    public Optional<BlockPosition> aL;
    private boolean bB = false;
    private float bC;
    private int bD;
    public boolean bE;
    private Vec3D bF;
    private @Nullable Vec3D bG;
    private @Nullable IBlockData bH = null;
    public static final int aM = 100;
    private final ArrayDeque<c> bI;
    private final List<c> bJ;
    private final LongSet bK;
    private final InsideBlockEffectApplier.a bL;
    private CustomData bM;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    public CustomTimingsHandler tickTimer = SpigotTimings.getEntityTimings(this);
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent ichatbasecomponent) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean x_() {
            return ((WorldServer)Entity.this.ao()).U().a(GameRules.R);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }
    };

    static boolean isLevelAtLeast(ValueInput tag, int level) {
        int updateLevel = tag.a("Bukkit.updateLevel", -1);
        return updateLevel != -1 && tag.a("Bukkit.updateLevel", -1) >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.aU.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public float getBukkitYaw() {
        return this.aZ;
    }

    public boolean isChunkLoaded() {
        return this.aU.b((int)Math.floor(this.dP()) >> 4, (int)Math.floor(this.dV()) >> 4);
    }

    public Entity(EntityTypes<?> entitytypes, net.minecraft.world.level.World world) {
        this.aR = c.incrementAndGet();
        this.aS = ImmutableList.of();
        this.aY = Vec3D.c;
        this.bb = e;
        this.ai = Vec3D.c;
        this.as = RandomSource.a();
        this.av = new Object2DoubleArrayMap(2);
        this.bg = new HashSet<TagKey<FluidType>>();
        this.br = EntityInLevelCallback.a;
        this.bs = new VecDeltaCodec();
        this.aH = MathHelper.a(this.as);
        this.aI = this.aH.toString();
        this.bw = Sets.newHashSet();
        this.bx = new double[]{0.0, 0.0, 0.0};
        this.aL = Optional.empty();
        this.bF = Vec3D.c;
        this.bI = new ArrayDeque(100);
        this.bJ = new ObjectArrayList();
        this.bK = new LongOpenHashSet();
        this.bL = new InsideBlockEffectApplier.a();
        this.bM = CustomData.a;
        this.aP = entitytypes;
        this.aU = world;
        this.bz = entitytypes.n();
        this.aV = Vec3D.c;
        this.aW = BlockPosition.c;
        this.aX = ChunkCoordIntPair.e;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        DataWatcher.a datawatcher_a = new DataWatcher.a(this);
        datawatcher_a.a(aA, (byte)0);
        datawatcher_a.a(bl, this.cJ());
        datawatcher_a.a(bn, false);
        datawatcher_a.a(bm, Optional.empty());
        datawatcher_a.a(bo, false);
        datawatcher_a.a(bp, false);
        datawatcher_a.a(aE, EntityPose.a);
        datawatcher_a.a(bq, 0);
        this.a(datawatcher_a);
        this.az = datawatcher_a.a();
        this.a_(0.0, 0.0, 0.0);
        this.bA = this.bz.c();
    }

    public boolean a(BlockPosition blockposition, IBlockData iblockdata) {
        VoxelShape voxelshape = iblockdata.b((IBlockAccess)this.ao(), blockposition, VoxelShapeCollision.a(this)).a(blockposition);
        return VoxelShapes.c(voxelshape, VoxelShapes.a(this.dj()), OperatorBoolean.i);
    }

    public int h_() {
        ScoreboardTeam scoreboardteambase = this.cI();
        return scoreboardteambase != null && ((ScoreboardTeamBase)scoreboardteambase).o().f() != null ? ((ScoreboardTeamBase)scoreboardteambase).o().f() : 0xFFFFFF;
    }

    public boolean au() {
        return false;
    }

    public boolean av() {
        return this.cb() && !this.eh() && !this.au();
    }

    public final void aw() {
        if (this.cr()) {
            this.ce();
        }
        if (this.cq()) {
            this.cf();
        }
    }

    public void e(double d0, double d1, double d2) {
        this.bs.e(new Vec3D(d0, d1, d2));
    }

    public VecDeltaCodec ax() {
        return this.bs;
    }

    public EntityTypes<?> ay() {
        return this.aP;
    }

    public boolean az() {
        return this.aQ;
    }

    public void c(boolean flag) {
        this.aQ = flag;
    }

    @Override
    public int aA() {
        return this.aR;
    }

    public void e(int i2) {
        this.aR = i2;
    }

    public Set<String> aB() {
        return this.bw;
    }

    public boolean a(String s2) {
        return this.bw.size() >= 1024 ? false : this.bw.add(s2);
    }

    public boolean b(String s2) {
        return this.bw.remove(s2);
    }

    public void c(WorldServer worldserver) {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
    }

    public final void aC() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void a(DataWatcher.a var1);

    public DataWatcher aD() {
        return this.az;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.aD().c();
        if (list != null) {
            to.g.b(new PacketPlayOutEntityMetadata(this.aA(), list));
        }
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).aR == this.aR : false;
    }

    public int hashCode() {
        return this.aR;
    }

    public void a(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void aE() {
    }

    public void b(RemovalReason entity_removalreason) {
    }

    public void c(EntityPose entitypose) {
        if (entitypose == this.aF()) {
            return;
        }
        this.aU.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[entitypose.ordinal()]));
        this.az.a(aE, entitypose);
    }

    public EntityPose aF() {
        return this.az.a(aE);
    }

    public boolean d(EntityPose entitypose) {
        return this.aF() == entitypose;
    }

    public boolean a(Entity entity, double d0) {
        return this.dI().a((IPosition)entity.dI(), d0);
    }

    public boolean a(Entity entity, double d0, double d1) {
        double d2 = entity.dP() - this.dP();
        double d3 = entity.dR() - this.dR();
        double d4 = entity.dV() - this.dV();
        return MathHelper.e(d2, d4) < MathHelper.n(d0) && MathHelper.n(d3) < MathHelper.n(d1);
    }

    protected void a(float f2, float f1) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.aU.getCraftServer().getLogger().warning(this.da() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        if (f1 == Float.POSITIVE_INFINITY || f1 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.aU.getCraftServer().getLogger().warning(this.da() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            f1 = 0.0f;
        }
        this.v(f2 % 360.0f);
        this.w(f1 % 360.0f);
    }

    public final void b(Vec3D vec3d) {
        this.a_(vec3d.a(), vec3d.b(), vec3d.c());
    }

    public void a_(double d0, double d1, double d2) {
        this.n(d0, d1, d2);
        this.a(this.aG());
    }

    protected final AxisAlignedBB aG() {
        return this.c(this.aV);
    }

    protected AxisAlignedBB c(Vec3D vec3d) {
        return this.bz.a(vec3d);
    }

    protected void aH() {
        this.bG = null;
        this.a_(this.aV.g, this.aV.h, this.aV.i);
    }

    public void b(double d0, double d1) {
        float f2 = (float)d1 * 0.15f;
        float f1 = (float)d0 * 0.15f;
        this.w(this.ee() + f2);
        this.v(this.ec() + f1);
        this.w(MathHelper.a(this.ee(), -90.0f, 90.0f));
        this.ac += f2;
        this.ab += f1;
        this.ac = MathHelper.a(this.ac, -90.0f, 90.0f);
        if (this.aT != null) {
            this.aT.l(this);
        }
    }

    public void aI() {
    }

    public void g() {
        this.aJ();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer)) {
            this.cn();
        }
    }

    public void aJ() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("entityBaseTick");
        this.aK();
        this.bH = null;
        if (this.cq() && this.dz().eh()) {
            this.cf();
        }
        if (this.X > 0) {
            --this.X;
        }
        if (this instanceof EntityPlayer) {
            this.cn();
        }
        if (this.bL()) {
            this.bM();
        }
        this.aK = this.aJ;
        this.aJ = false;
        this.bG();
        this.u();
        this.bF();
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.bf > 0) {
                if (this.bx()) {
                    this.aT();
                } else {
                    if (this.bf % 20 == 0 && !this.bN()) {
                        this.a(worldserver, this.en().d(), 1.0f);
                    }
                    this.h(this.bf - 1);
                }
            }
        } else {
            this.aT();
        }
        if (this.bN()) {
            this.an *= 0.5;
        } else {
            this.lastLavaContact = null;
        }
        this.aL();
        if (!this.ao().B_()) {
            this.d(this.bf > 0);
        }
        this.ay = false;
        world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver1 = (WorldServer)world;
            if (this instanceof Leashable) {
                Leashable.a_(worldserver1, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        gameprofilerfiller.c();
    }

    protected void aK() {
        if (this.bG == null) {
            this.bG = this.dI();
        }
        this.bF = this.dI().d(this.bG);
        this.bG = this.dI();
    }

    public void d(boolean flag) {
        this.b(0, flag || this.bE);
    }

    public void aL() {
        if (this.dR() < (double)(this.ao().K_() - 64)) {
            this.aU();
        }
    }

    public void aM() {
        this.bt = this.co();
    }

    public void f(int i2) {
        this.bt = i2;
    }

    public int aN() {
        return this.bt;
    }

    public boolean aO() {
        return this.bt > 0;
    }

    protected void O() {
        if (this.aO()) {
            --this.bt;
        }
    }

    public void aP() {
        if (!this.bx()) {
            if (this instanceof EntityLiving && this.bf <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.aU, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.aU.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
        }
    }

    public void aQ() {
        WorldServer worldserver;
        net.minecraft.world.level.World world;
        if (!this.bx() && (world = this.ao()) instanceof WorldServer && this.a(worldserver = (WorldServer)world, this.en().e().directBlock(this.aU, this.lastLavaContact), 4.0f) && this.aR() && !this.bq()) {
            worldserver.a((Entity)null, this.dP(), this.dR(), this.dV(), SoundEffects.lO, this.dB(), 0.4f, 2.0f + this.as.i() * 0.4f);
        }
    }

    protected boolean aR() {
        return true;
    }

    public final void e(float f2) {
        this.igniteForSeconds(f2, true);
    }

    public final void igniteForSeconds(float f2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f2);
            this.aU.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f2 = event.getDuration();
        }
        this.g(MathHelper.b(f2 * 20.0f));
    }

    public void g(int i2) {
        if (this.bf < i2) {
            this.h(i2);
        }
        this.cL();
    }

    public void h(int i2) {
        this.bf = i2;
    }

    public int aS() {
        return this.bf;
    }

    public void aT() {
        this.h(Math.min(0, this.aS()));
    }

    protected void aU() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean f(double d0, double d1, double d2) {
        return this.b(this.dj().d(d0, d1, d2));
    }

    private boolean b(AxisAlignedBB axisalignedbb) {
        return this.ao().a(this, axisalignedbb) && !this.ao().d(axisalignedbb);
    }

    public void e(boolean flag) {
        this.bc = flag;
        this.b(flag, (Vec3D)null);
    }

    public void a(boolean flag, Vec3D vec3d) {
        this.a(flag, this.ad, vec3d);
    }

    public void a(boolean flag, boolean flag1, Vec3D vec3d) {
        this.bc = flag;
        this.ad = flag1;
        this.b(flag, vec3d);
    }

    public boolean d(BlockPosition blockposition) {
        return this.aL.isPresent() && this.aL.get().equals(blockposition);
    }

    protected void b(boolean flag, @Nullable Vec3D vec3d) {
        if (flag) {
            AxisAlignedBB axisalignedbb = this.dj();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 1.0E-6, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
            Optional<BlockPosition> optional = this.aU.j(this, axisalignedbb1);
            if (!optional.isPresent() && !this.bB) {
                if (vec3d != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.d(-vec3d.g, 0.0, -vec3d.i);
                    optional = this.aU.j(this, axisalignedbb2);
                    this.aL = optional;
                }
            } else {
                this.aL = optional;
            }
            this.bB = optional.isEmpty();
        } else {
            this.bB = false;
            if (this.aL.isPresent()) {
                this.aL = Optional.empty();
            }
        }
    }

    public boolean aV() {
        return this.bc;
    }

    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        SpigotTimings.entityMoveTimer.startTiming();
        if (this.ar) {
            this.a_(this.dP() + vec3d.g, this.dR() + vec3d.h, this.dV() + vec3d.i);
            this.ad = false;
            this.ae = false;
            this.af = false;
            this.ag = false;
        } else {
            Vec3D vec3d1;
            double d0;
            if (enummovetype == EnumMoveType.c && (vec3d = this.e(vec3d)).equals(Vec3D.c)) {
                return;
            }
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            gameprofilerfiller.a("move");
            if (this.ai.h() > 1.0E-7) {
                if (enummovetype != EnumMoveType.c) {
                    vec3d = vec3d.h(this.ai);
                }
                this.ai = Vec3D.c;
                this.k(Vec3D.c);
            }
            if ((d0 = (vec3d1 = this.a(vec3d = this.a(vec3d, enummovetype))).h()) > 1.0E-7 || vec3d.h() - d0 < 1.0E-7) {
                if (this.an != 0.0 && d0 >= 1.0) {
                    double d1 = Math.min(vec3d1.g(), 8.0);
                    Vec3D vec3d2 = this.dI().e(vec3d1.d().c(d1));
                    MovingObjectPositionBlock movingobjectpositionblock = this.ao().a(new RayTrace(this.dI(), vec3d2, RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this));
                    if (movingobjectpositionblock.d() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.l();
                    }
                }
                Vec3D vec3d3 = this.dI();
                Vec3D vec3d4 = vec3d3.e(vec3d1);
                this.a(new c(vec3d3, vec3d4, vec3d));
                this.b(vec3d4);
            }
            gameprofilerfiller.c();
            gameprofilerfiller.a("rest");
            boolean flag = !MathHelper.b(vec3d.g, vec3d1.g);
            boolean flag1 = !MathHelper.b(vec3d.i, vec3d1.i);
            boolean bl = this.ad = flag || flag1;
            if (Math.abs(vec3d.h) > 0.0 || this.dv()) {
                this.ae = vec3d.h != vec3d1.h;
                this.af = this.ae && vec3d.h < 0.0;
                this.a(this.af, this.ad, vec3d1);
            }
            this.ag = this.ad ? this.d(vec3d1) : false;
            BlockPosition blockposition = this.be();
            IBlockData iblockdata = this.ao().a_(blockposition);
            if (this.dv()) {
                this.a(vec3d1.h, this.aV(), iblockdata, blockposition);
            }
            if (this.eh()) {
                gameprofilerfiller.c();
            } else {
                MovementEmission entity_movementemission;
                if (this.ad) {
                    Vec3D vec3d5 = this.dN();
                    this.m(flag ? 0.0 : vec3d5.g, vec3d5.h, flag1 ? 0.0 : vec3d5.i);
                }
                if (this.dx()) {
                    Block block = iblockdata.b();
                    if (vec3d.h != vec3d1.h) {
                        block.a(this.ao(), this);
                    }
                }
                if (this.ad && this.getBukkitEntity() instanceof Vehicle) {
                    Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                    org.bukkit.block.Block bl2 = this.aU.getWorld().getBlockAt(MathHelper.c(this.dP()), MathHelper.c(this.dR()), MathHelper.c(this.dV()));
                    if (vec3d.g > vec3d1.g) {
                        bl2 = bl2.getRelative(BlockFace.EAST);
                    } else if (vec3d.g < vec3d1.g) {
                        bl2 = bl2.getRelative(BlockFace.WEST);
                    } else if (vec3d.i > vec3d1.i) {
                        bl2 = bl2.getRelative(BlockFace.SOUTH);
                    } else if (vec3d.i < vec3d1.i) {
                        bl2 = bl2.getRelative(BlockFace.NORTH);
                    }
                    if (!bl2.getType().isAir()) {
                        VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl2);
                        this.aU.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                }
                if ((!this.ao().B_() || this.dv()) && (entity_movementemission = this.bv()).a() && !this.cq()) {
                    this.a(entity_movementemission, vec3d1, blockposition, iblockdata);
                }
                float f2 = this.bi();
                this.k(this.dN().d(f2, 1.0, f2));
                gameprofilerfiller.c();
            }
        }
        SpigotTimings.entityMoveTimer.stopTiming();
    }

    private void a(MovementEmission entity_movementemission, Vec3D vec3d, BlockPosition blockposition, IBlockData iblockdata) {
        float f2 = 0.6f;
        float f1 = (float)(vec3d.g() * (double)0.6f);
        float f22 = (float)(vec3d.i() * (double)0.6f);
        BlockPosition blockposition1 = this.bg();
        IBlockData iblockdata1 = this.ao().a_(blockposition1);
        boolean flag = this.c(iblockdata1);
        this.al += flag ? f1 : f22;
        this.am += f1;
        if (this.al > this.be && !iblockdata1.l()) {
            boolean flag1 = blockposition1.equals(blockposition);
            boolean flag2 = this.a(blockposition, iblockdata, entity_movementemission.c(), flag1, vec3d);
            if (!flag1) {
                flag2 |= this.a(blockposition1, iblockdata1, false, entity_movementemission.b(), vec3d);
            }
            if (flag2) {
                this.be = this.bj();
            } else if (this.by()) {
                this.be = this.bj();
                if (entity_movementemission.c()) {
                    this.bn();
                }
                if (entity_movementemission.b()) {
                    this.c(GameEvent.Q);
                }
            }
        } else if (iblockdata1.l()) {
            this.bd();
        }
    }

    protected void aW() {
        this.bJ.clear();
        this.bJ.addAll(this.bI);
        this.bI.clear();
        if (this.bJ.isEmpty()) {
            this.bJ.add(new c(this.bS(), this.dI()));
        } else if (this.bJ.getLast().b.g(this.dI()) > 9.999999439624929E-11) {
            this.bJ.add(new c(this.bJ.getLast().b, this.dI()));
        }
        this.b(this.bJ);
    }

    private void a(c entity_c) {
        if (this.bI.size() >= 100) {
            c entity_c1 = this.bI.removeFirst();
            c entity_c2 = this.bI.removeFirst();
            c entity_c3 = new c(entity_c1.a(), entity_c2.b());
            this.bI.addFirst(entity_c3);
        }
        this.bI.add(entity_c);
    }

    public void aX() {
        if (!this.bI.isEmpty()) {
            this.bI.removeLast();
        }
    }

    protected void aY() {
        this.bI.clear();
    }

    public boolean aZ() {
        return Math.abs(this.bF.i()) > (double)1.0E-5f;
    }

    public void a(Vec3D vec3d, Vec3D vec3d1) {
        this.b(List.of(new c(vec3d, vec3d1)));
    }

    private void b(List<c> list) {
        if (this.ba()) {
            boolean flag2;
            if (this.aV()) {
                BlockPosition blockposition = this.be();
                IBlockData iblockdata = this.ao().a_(blockposition);
                iblockdata.b().a(this.ao(), blockposition, iblockdata, this);
            }
            boolean flag = this.cp();
            boolean flag1 = this.eb();
            int i2 = this.aS();
            this.a(list, this.bL);
            this.bL.a(this);
            if (this.bz()) {
                this.aT();
            }
            if (flag && !this.cp() || flag1 && !this.eb()) {
                this.bb();
            }
            boolean bl = flag2 = this.aS() > i2;
            if (!(this.ao().B_() || this.cp() || flag2)) {
                this.h(-this.dC());
            }
        }
    }

    protected boolean ba() {
        return !this.eh() && !this.ar;
    }

    private boolean c(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.bd) || iblockdata.a(Blocks.rP);
    }

    private boolean a(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean flag1, Vec3D vec3d) {
        if (iblockdata.l()) {
            return false;
        }
        boolean flag2 = this.c(iblockdata);
        if ((this.aV() || flag2 || this.cz() && vec3d.h == 0.0 || this.cH()) && !this.cB()) {
            if (flag) {
                this.c(blockposition, iblockdata);
            }
            if (flag1) {
                this.ao().a(GameEvent.P, this.dI(), GameEvent.a.a(this, iblockdata));
            }
            return true;
        }
        return false;
    }

    protected boolean d(Vec3D vec3d) {
        return false;
    }

    protected void bb() {
        if (!this.aU.B_()) {
            this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), SoundEffects.lT, this.dB(), 0.7f, 1.6f + (this.as.i() - this.as.i()) * 0.4f);
        }
    }

    public void bc() {
        if (this.cp()) {
            this.bb();
        }
        this.aT();
    }

    protected void bd() {
        if (this.bp()) {
            this.bo();
            if (this.bv().b()) {
                this.c(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition be() {
        return this.f(0.2f);
    }

    public BlockPosition bf() {
        return this.f(0.500001f);
    }

    public BlockPosition bg() {
        return this.f(1.0E-5f);
    }

    protected BlockPosition f(float f2) {
        if (this.aL.isPresent()) {
            BlockPosition blockposition = this.aL.get();
            if (f2 <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.ao().a_(blockposition);
            return ((double)f2 > 0.5 || !iblockdata.a(TagsBlock.S)) && !iblockdata.a(TagsBlock.I) && !(iblockdata.b() instanceof BlockFenceGate) ? blockposition.h(MathHelper.c(this.aV.h - (double)f2)) : blockposition;
        }
        int i2 = MathHelper.c(this.aV.g);
        int j2 = MathHelper.c(this.aV.h - (double)f2);
        int k2 = MathHelper.c(this.aV.i);
        return new BlockPosition(i2, j2, k2);
    }

    protected float bh() {
        float f2 = this.ao().a_(this.dK()).b().j();
        float f1 = this.ao().a_(this.bf()).b().j();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float bi() {
        IBlockData iblockdata = this.ao().a_(this.dK());
        float f2 = iblockdata.b().i();
        return !iblockdata.a(Blocks.J) && !iblockdata.a(Blocks.oa) ? ((double)f2 == 1.0 ? this.ao().a_(this.bf()).b().i() : f2) : f2;
    }

    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        return vec3d;
    }

    protected Vec3D e(Vec3D vec3d) {
        if (vec3d.h() <= 1.0E-7) {
            return vec3d;
        }
        long i2 = this.ao().au();
        if (i2 != this.by) {
            Arrays.fill(this.bx, 0.0);
            this.by = i2;
        }
        if (vec3d.g != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, vec3d.g);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(d0, 0.0, 0.0);
        }
        if (vec3d.h != 0.0) {
            double d1 = this.a(EnumDirection.EnumAxis.b, vec3d.h);
            return Math.abs(d1) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, d1, 0.0);
        }
        if (vec3d.i != 0.0) {
            double d2 = this.a(EnumDirection.EnumAxis.c, vec3d.i);
            return Math.abs(d2) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, 0.0, d2);
        }
        return Vec3D.c;
    }

    private double a(EnumDirection.EnumAxis enumdirection_enumaxis, double d0) {
        int i2 = enumdirection_enumaxis.ordinal();
        double d1 = MathHelper.a(d0 + this.bx[i2], -0.51, 0.51);
        d0 = d1 - this.bx[i2];
        this.bx[i2] = d1;
        return d0;
    }

    public double b(double d0) {
        AxisAlignedBB axisalignedbb = this.dj();
        AxisAlignedBB axisalignedbb1 = axisalignedbb.b(axisalignedbb.b - d0).e(axisalignedbb.b);
        List<VoxelShape> list = Entity.a(this, this.aU, axisalignedbb1);
        return list.isEmpty() ? d0 : -VoxelShapes.a(EnumDirection.EnumAxis.b, axisalignedbb, list, -d0);
    }

    private Vec3D a(Vec3D vec3d) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.dj();
        List<VoxelShape> list = this.ao().e(this, axisalignedbb.b(vec3d));
        Vec3D vec3d1 = vec3d.h() == 0.0 ? vec3d : Entity.a(this, vec3d, axisalignedbb, this.ao(), list);
        boolean flag = vec3d.g != vec3d1.g;
        boolean flag1 = vec3d.h != vec3d1.h;
        boolean flag2 = vec3d.i != vec3d1.i;
        boolean bl = flag3 = flag1 && vec3d.h < 0.0;
        if (this.eg() > 0.0f && (flag3 || this.aV()) && (flag || flag2)) {
            float[] afloat;
            AxisAlignedBB axisalignedbb1 = flag3 ? axisalignedbb.d(0.0, vec3d1.h, 0.0) : axisalignedbb;
            AxisAlignedBB axisalignedbb2 = axisalignedbb1.b(vec3d.g, this.eg(), vec3d.i);
            if (!flag3) {
                axisalignedbb2 = axisalignedbb2.b(0.0, -1.0E-5f, 0.0);
            }
            List<VoxelShape> list1 = Entity.a(this, this.aU, list, axisalignedbb2);
            float f2 = (float)vec3d1.h;
            for (float f1 : afloat = Entity.a(axisalignedbb1, list1, this.eg(), f2)) {
                Vec3D vec3d2 = Entity.a(new Vec3D(vec3d.g, f1, vec3d.i), axisalignedbb1, list1);
                if (!(vec3d2.j() > vec3d1.j())) continue;
                double d0 = axisalignedbb.b - axisalignedbb1.b;
                return vec3d2.a(0.0, d0, 0.0);
            }
        }
        return vec3d1;
    }

    private static float[] a(AxisAlignedBB axisalignedbb, List<VoxelShape> list, float f2, float f1) {
        FloatArraySet floatset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : list) {
            DoubleList doublelist = voxelshape.a(EnumDirection.EnumAxis.b);
            DoubleListIterator doublelistiterator = doublelist.iterator();
            while (doublelistiterator.hasNext()) {
                double d0 = doublelistiterator.next();
                float f22 = (float)(d0 - axisalignedbb.b);
                if (!(f22 >= 0.0f) || f22 == f1) continue;
                if (f22 > f2) continue block0;
                floatset.add(f22);
            }
        }
        float[] afloat = floatset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3D a(@Nullable Entity entity, Vec3D vec3d, AxisAlignedBB axisalignedbb, net.minecraft.world.level.World world, List<VoxelShape> list) {
        List<VoxelShape> list1 = Entity.a(entity, world, list, axisalignedbb.b(vec3d));
        return Entity.a(vec3d, axisalignedbb, list1);
    }

    public static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World world, AxisAlignedBB axisalignedbb) {
        List<VoxelShape> list = world.e(entity, axisalignedbb);
        return Entity.a(entity, world, list, axisalignedbb);
    }

    private static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World world, List<VoxelShape> list, AxisAlignedBB axisalignedbb) {
        boolean flag;
        ImmutableList.Builder immutablelist_builder = ImmutableList.builderWithExpectedSize((int)(list.size() + 1));
        if (!list.isEmpty()) {
            immutablelist_builder.addAll(list);
        }
        WorldBorder worldborder = world.w();
        boolean bl = flag = entity != null && worldborder.a(entity, axisalignedbb);
        if (flag) {
            immutablelist_builder.add((Object)worldborder.b());
        }
        immutablelist_builder.addAll(world.g(entity, axisalignedbb));
        return immutablelist_builder.build();
    }

    private static Vec3D a(Vec3D vec3d, AxisAlignedBB axisalignedbb, List<VoxelShape> list) {
        if (list.isEmpty()) {
            return vec3d;
        }
        Vec3D vec3d1 = Vec3D.c;
        for (EnumDirection.EnumAxis enumdirection_enumaxis : EnumDirection.b(vec3d)) {
            double d0 = vec3d.a(enumdirection_enumaxis);
            if (d0 == 0.0) continue;
            double d1 = VoxelShapes.a(enumdirection_enumaxis, axisalignedbb.c(vec3d1), list, d0);
            vec3d1 = vec3d1.a(enumdirection_enumaxis, d1);
        }
        return vec3d1;
    }

    protected float bj() {
        return (int)this.al + 1;
    }

    protected SoundEffect bk() {
        return SoundEffects.lX;
    }

    protected SoundEffect bl() {
        return SoundEffects.lW;
    }

    protected SoundEffect bm() {
        return SoundEffects.lW;
    }

    public SoundEffect getSwimSound0() {
        return this.bk();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.bl();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.bm();
    }

    private void a(List<c> list, InsideBlockEffectApplier.a insideblockeffectapplier_a) {
        if (this.ba()) {
            LongSet longset = this.bK;
            for (c entity_c : list) {
                Vec3D vec3d = entity_c.a;
                Vec3D vec3d1 = entity_c.b().d(entity_c.a());
                int i2 = 16;
                if (entity_c.c().isPresent() && vec3d1.h() > 0.0) {
                    for (EnumDirection.EnumAxis enumdirection_enumaxis : EnumDirection.b(entity_c.c().get())) {
                        double d0 = vec3d1.a(enumdirection_enumaxis);
                        if (d0 == 0.0) continue;
                        Vec3D vec3d2 = vec3d.a(enumdirection_enumaxis.e(), d0);
                        i2 -= this.a(vec3d, vec3d2, insideblockeffectapplier_a, longset, i2);
                        vec3d = vec3d2;
                    }
                } else {
                    i2 -= this.a(entity_c.a(), entity_c.b(), insideblockeffectapplier_a, longset, 16);
                }
                if (i2 > 0) continue;
                this.a(entity_c.b(), entity_c.b(), insideblockeffectapplier_a, longset, 1);
            }
            longset.clear();
        }
    }

    private int a(Vec3D vec3d, Vec3D vec3d1, InsideBlockEffectApplier.a insideblockeffectapplier_a, LongSet longset, int i2) {
        WorldServer worldserver;
        AxisAlignedBB axisalignedbb = this.c(vec3d1).h(1.0E-5f);
        boolean flag = vec3d.g(vec3d1) > MathHelper.n(0.9999900000002526);
        net.minecraft.world.level.World world = this.aU;
        boolean flag1 = world instanceof WorldServer && (worldserver = (WorldServer)world).s().bw().a(DebugSubscriptions.g);
        boolean flag2 = flag1;
        AtomicInteger atomicinteger = new AtomicInteger();
        IBlockAccess.a(vec3d, vec3d1, axisalignedbb, (BlockPosition blockposition, int j2) -> {
            if (!this.cb()) {
                return false;
            }
            if (j2 >= i2) {
                return false;
            }
            atomicinteger.set(j2);
            IBlockData iblockdata = this.ao().a_(blockposition);
            if (iblockdata.l()) {
                if (flag2) {
                    this.a((WorldServer)this.ao(), blockposition.j(), false, false);
                }
                return true;
            }
            VoxelShape voxelshape = iblockdata.a((IBlockAccess)this.ao(), blockposition, this);
            boolean flag3 = voxelshape == VoxelShapes.b() || this.a(vec3d, vec3d1, voxelshape.a(new Vec3D(blockposition)).e());
            boolean flag4 = this.a(iblockdata.y(), blockposition, vec3d, vec3d1);
            if ((flag3 || flag4) && longset.add(blockposition.a())) {
                if (flag3) {
                    try {
                        boolean flag5 = flag || axisalignedbb.b(blockposition);
                        insideblockeffectapplier_a.a(j2);
                        iblockdata.a(this.ao(), blockposition, this, insideblockeffectapplier_a, flag5);
                        this.a(iblockdata);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                        CrashReportSystemDetails.a(crashreportsystemdetails, this.ao(), blockposition, iblockdata);
                        CrashReportSystemDetails crashreportsystemdetails1 = crashreport.a("Entity being checked for collision");
                        this.a(crashreportsystemdetails1);
                        throw new ReportedException(crashreport);
                    }
                }
                if (flag4) {
                    insideblockeffectapplier_a.a(j2);
                    iblockdata.y().a(this.ao(), blockposition, this, insideblockeffectapplier_a);
                }
                if (flag2) {
                    this.a((WorldServer)this.ao(), blockposition.j(), flag3, flag4);
                }
                return true;
            }
            return true;
        });
        return atomicinteger.get() + 1;
    }

    private void a(WorldServer worldserver, BlockPosition blockposition, boolean flag, boolean flag1) {
        DebugEntityBlockIntersection debugentityblockintersection = flag1 ? DebugEntityBlockIntersection.b : (flag ? DebugEntityBlockIntersection.a : DebugEntityBlockIntersection.c);
        worldserver.W().a(blockposition, DebugSubscriptions.g, debugentityblockintersection);
    }

    public boolean a(Fluid fluid, BlockPosition blockposition, Vec3D vec3d, Vec3D vec3d1) {
        AxisAlignedBB axisalignedbb = fluid.e(this.ao(), blockposition);
        return axisalignedbb != null && this.a(vec3d, vec3d1, List.of(axisalignedbb));
    }

    public boolean a(Vec3D vec3d, Vec3D vec3d1, List<AxisAlignedBB> list) {
        AxisAlignedBB axisalignedbb = this.c(vec3d);
        Vec3D vec3d2 = vec3d1.d(vec3d);
        return axisalignedbb.a(vec3d2, list);
    }

    protected void a(IBlockData iblockdata) {
    }

    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1 = worldserver.C().b();
        Vec3D vec3d = blockposition1.b();
        int i2 = worldserver.q(blockposition1).a(HeightMap.Type.f, blockposition1.u(), blockposition1.w()) + 1;
        return BlockPosition.a(vec3d.g, (double)i2, vec3d.i);
    }

    public void a(Holder<GameEvent> holder, @Nullable Entity entity) {
        this.ao().a(entity, holder, this.aV);
    }

    public void c(Holder<GameEvent> holder) {
        this.a(holder, this);
    }

    private void c(BlockPosition blockposition, IBlockData iblockdata) {
        this.b(blockposition, iblockdata);
        if (this.d(iblockdata)) {
            this.q();
        }
    }

    protected void bn() {
        Entity entity = Objects.requireNonNullElse(this.dl(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D vec3d = entity.dN();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.g * vec3d.g * (double)0.2f + vec3d.h * vec3d.h + vec3d.i * vec3d.i * (double)0.2f) * f2);
        this.g(f1);
    }

    protected BlockPosition e(BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.d();
        IBlockData iblockdata = this.ao().a_(blockposition1);
        return !iblockdata.a(TagsBlock.bA) && !iblockdata.a(TagsBlock.bB) ? blockposition : blockposition1;
    }

    protected void a(IBlockData iblockdata, IBlockData iblockdata1) {
        SoundEffectType soundeffecttype = iblockdata.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        this.b(iblockdata1);
    }

    protected void b(IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.05f, soundeffecttype.b() * 0.8f);
    }

    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    private boolean d(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.bz) && this.at >= this.bD + 20;
    }

    private void q() {
        this.bC *= (float)Math.pow(0.997, this.at - this.bD);
        this.bC = Math.min(1.0f, this.bC + 0.07f);
        float f2 = 0.5f + this.bC * this.as.i() * 1.2f;
        float f1 = 0.1f + this.bC * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bD = this.at;
    }

    protected void g(float f2) {
        this.a(this.bk(), f2, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
    }

    protected void bo() {
    }

    protected boolean bp() {
        return false;
    }

    public void a(SoundEffect soundeffect, float f2, float f1) {
        if (!this.bq()) {
            this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), soundeffect, this.dB(), f2, f1);
        }
    }

    public void a(SoundEffect soundeffect) {
        if (!this.bq()) {
            this.a(soundeffect, 1.0f, 1.0f);
        }
    }

    public boolean bq() {
        return this.az.a(bo);
    }

    public void f(boolean flag) {
        this.az.a(bo, flag);
    }

    public boolean br() {
        return this.az.a(bp);
    }

    public void g(boolean flag) {
        this.az.a(bp, flag);
    }

    protected double bs() {
        return 0.0;
    }

    public final double bt() {
        return this.br() ? 0.0 : this.bs();
    }

    protected void bu() {
        double d0 = this.bt();
        if (d0 != 0.0) {
            this.k(this.dN().b(0.0, -d0, 0.0));
        }
    }

    protected MovementEmission bv() {
        return MovementEmission.d;
    }

    public boolean bw() {
        return false;
    }

    public final void a(double d0, double d1, double d2, boolean flag) {
        if (!this.dD()) {
            this.b(flag, new Vec3D(d0, d1, d2));
            BlockPosition blockposition = this.be();
            IBlockData iblockdata = this.ao().a_(blockposition);
            this.a(d1, flag, iblockdata, blockposition);
        }
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (!this.by() && d0 < 0.0) {
            this.an -= (double)((float)d0);
        }
        if (flag) {
            if (this.an > 0.0) {
                iblockdata.b().a(this.ao(), iblockdata, blockposition, this, this.an);
                this.ao().a(GameEvent.A, this.aV, GameEvent.a.a(this, this.aL.map(blockposition1 -> this.ao().a_((BlockPosition)blockposition1)).orElse(iblockdata)));
            }
            this.l();
        }
    }

    public boolean bx() {
        return this.ay().d();
    }

    public boolean a(double d0, float f2, DamageSource damagesource) {
        if (this.aP.a(TagsEntity.p)) {
            return false;
        }
        this.b(d0, f2, damagesource);
        return false;
    }

    protected void b(double d0, float f2, DamageSource damagesource) {
        if (this.cr()) {
            for (Entity entity : this.dn()) {
                entity.a(d0, f2, damagesource);
            }
        }
    }

    public boolean by() {
        return this.au;
    }

    boolean bz() {
        BlockPosition blockposition = this.dK();
        return this.ao().v(blockposition) || this.ao().v(BlockPosition.a((double)blockposition.u(), this.dj().e, (double)blockposition.w()));
    }

    public boolean bA() {
        return this.by() || this.bz();
    }

    public boolean bB() {
        return this.by() || this.bN();
    }

    public boolean bC() {
        return this.aw && this.by();
    }

    public boolean bD() {
        return this.by() && !this.bC();
    }

    public boolean bE() {
        if (ARGB.b(this.aU.c().a(EnvironmentAttributes.k, this.dI())) == 0) {
            return false;
        }
        float f2 = this.aU.c().a(EnvironmentAttributes.l, this.dI()).floatValue();
        if (this.dR() + (double)this.dG() < (double)f2) {
            return false;
        }
        float f1 = f2 + 4.0f;
        return this.dR() <= (double)f1;
    }

    public void bF() {
        if (this.cB()) {
            this.j(this.cA() && this.by() && !this.cq());
        } else {
            this.j(this.cA() && this.bC() && !this.cq() && this.ao().b_(this.aW).a(TagsFluid.a));
        }
    }

    protected boolean bG() {
        this.av.clear();
        this.bH();
        double d0 = this.aU.c().a(EnvironmentAttributes.F) != false ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.by() || flag;
    }

    void bH() {
        AbstractBoat abstractboat;
        Entity entity = this.dz();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).bC()) {
            this.au = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.au && !this.ay) {
                this.bI();
            }
            this.l();
            this.au = true;
        } else {
            this.au = false;
        }
    }

    private void u() {
        AbstractBoat abstractboat;
        this.aw = this.a(TagsFluid.a);
        this.bg.clear();
        double d0 = this.dT();
        Entity entity = this.dz();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).bC() && abstractboat.dj().e >= d0 && abstractboat.dj().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dP(), d0, this.dV());
        Fluid fluid = this.ao().b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a(this.ao(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.bg;
            Objects.requireNonNull(this.bg);
            stream.forEach(set::add);
        }
    }

    protected void bI() {
        Entity entity = Objects.requireNonNullElse(this.dl(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D vec3d = entity.dN();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.g * vec3d.g * (double)0.2f + vec3d.h * vec3d.h + vec3d.i * vec3d.i * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.bl(), f1, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
        } else {
            this.a(this.bm(), f1, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
        }
        float f22 = MathHelper.c(this.dR());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bz.a() * 20.0f) {
            double d0 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            double d1 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            this.ao().a(Particles.d, this.dP() + d0, (double)(f22 + 1.0f), this.dV() + d1, vec3d.g, vec3d.h - this.as.j() * (double)0.2f, vec3d.i);
            ++i2;
        }
        int j2 = 0;
        while ((float)j2 < 1.0f + this.bz.a() * 20.0f) {
            double d2 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            double d3 = (this.as.j() * 2.0 - 1.0) * (double)this.bz.a();
            this.ao().a(Particles.aq, this.dP() + d2, (double)(f22 + 1.0f), this.dV() + d3, vec3d.g, vec3d.h, vec3d.i);
            ++j2;
        }
        this.c(GameEvent.O);
    }

    @Deprecated
    protected IBlockData bJ() {
        return this.ao().a_(this.be());
    }

    public IBlockData bK() {
        return this.ao().a_(this.bg());
    }

    public boolean bL() {
        return this.cA() && !this.by() && !this.au() && !this.cz() && !this.bN() && this.cb();
    }

    protected void bM() {
        BlockPosition blockposition = this.be();
        IBlockData iblockdata = this.ao().a_(blockposition);
        if (iblockdata.o() != EnumRenderType.a) {
            Vec3D vec3d = this.dN();
            BlockPosition blockposition1 = this.dK();
            double d0 = this.dP() + (this.as.j() - 0.5) * (double)this.bz.a();
            double d1 = this.dV() + (this.as.j() - 0.5) * (double)this.bz.a();
            if (blockposition1.u() != blockposition.u()) {
                d0 = MathHelper.a(d0, (double)blockposition.u(), (double)blockposition.u() + 1.0);
            }
            if (blockposition1.w() != blockposition.w()) {
                d1 = MathHelper.a(d1, (double)blockposition.w(), (double)blockposition.w() + 1.0);
            }
            this.ao().a(new ParticleParamBlock(Particles.b, iblockdata), d0, this.dR() + 0.1, d1, vec3d.g * -4.0, 1.5, vec3d.i * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> tagkey) {
        return this.bg.contains(tagkey);
    }

    public boolean bN() {
        return !this.ay && this.av.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float f2, Vec3D vec3d) {
        Vec3D vec3d1 = Entity.a(vec3d, f2, this.ec());
        this.k(this.dN().e(vec3d1));
    }

    protected static Vec3D a(Vec3D vec3d, float f2, float f1) {
        double d0 = vec3d.h();
        if (d0 < 1.0E-7) {
            return Vec3D.c;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? vec3d.d() : vec3d).c((double)f2);
        float f22 = MathHelper.a((double)(f1 * ((float)Math.PI / 180)));
        float f3 = MathHelper.b((double)(f1 * ((float)Math.PI / 180)));
        return new Vec3D(vec3d1.g * (double)f3 - vec3d1.i * (double)f22, vec3d1.h, vec3d1.i * (double)f3 + vec3d1.g * (double)f22);
    }

    @Deprecated
    public float bO() {
        return this.ao().f(this.dO(), this.dU()) ? this.ao().D(BlockPosition.a(this.dP(), this.dT(), this.dV())) : 0.0f;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.g(d0, d1, d2);
        this.b(f2, f1);
    }

    public void b(float f2, float f1) {
        this.v(f2 % 360.0f);
        this.w(MathHelper.a(f1, -90.0f, 90.0f) % 360.0f);
        this.ab = this.ec();
        this.ac = this.ee();
    }

    public void g(double d0, double d1, double d2) {
        double d3 = MathHelper.a(d0, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(d2, -3.0E7, 3.0E7);
        this.Y = d3;
        this.Z = d1;
        this.aa = d4;
        this.a_(d3, d1, d4);
        if (this.valid) {
            this.aU.d((int)Math.floor(this.dP()) >> 4, (int)Math.floor(this.dV()) >> 4);
        }
    }

    public void f(Vec3D vec3d) {
        this.d(vec3d.g, vec3d.h, vec3d.i);
    }

    public void d(double d0, double d1, double d2) {
        this.b(d0, d1, d2, this.ec(), this.ee());
    }

    public void a(BlockPosition blockposition, float f2, float f1) {
        this.b(blockposition.c(), f2, f1);
    }

    public void b(Vec3D vec3d, float f2, float f1) {
        this.b(vec3d.g, vec3d.h, vec3d.i, f2, f1);
    }

    public void b(double d0, double d1, double d2, float f2, float f1) {
        this.n(d0, d1, d2);
        this.v(f2);
        this.w(f1);
        this.bP();
        this.aH();
    }

    public final void bP() {
        this.bQ();
        this.bR();
    }

    public final void c(Vec3D vec3d, float f2, float f1) {
        this.m(vec3d);
        this.f(f2, f1);
    }

    protected void bQ() {
        this.m(this.aV);
    }

    public void bR() {
        this.f(this.ec(), this.ee());
    }

    private void m(Vec3D vec3d) {
        this.Y = this.ao = vec3d.g;
        this.Z = this.ap = vec3d.h;
        this.aa = this.aq = vec3d.i;
    }

    private void f(float f2, float f1) {
        this.ab = f2;
        this.ac = f1;
    }

    public final Vec3D bS() {
        return new Vec3D(this.ao, this.ap, this.aq);
    }

    public float f(Entity entity) {
        float f2 = (float)(this.dP() - entity.dP());
        float f1 = (float)(this.dR() - entity.dR());
        float f22 = (float)(this.dV() - entity.dV());
        return MathHelper.a(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double h(double d0, double d1, double d2) {
        double d3 = this.dP() - d0;
        double d4 = this.dR() - d1;
        double d5 = this.dV() - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double g(Entity entity) {
        return this.g(entity.dI());
    }

    public double g(Vec3D vec3d) {
        double d0 = this.dP() - vec3d.g;
        double d1 = this.dR() - vec3d.h;
        double d2 = this.dV() - vec3d.i;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void a_(EntityHuman entityhuman) {
    }

    public void h(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.A(entity) && !entity.ar && !this.ar && (d2 = MathHelper.a(d0 = entity.dP() - this.dP(), d1 = entity.dV() - this.dV())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.cr() && this.bY()) {
                this.i(-d0, 0.0, -d1);
            }
            if (!entity.cr() && entity.bY()) {
                entity.i(d0, 0.0, d1);
            }
        }
    }

    public void h(Vec3D vec3d) {
        if (vec3d.n()) {
            this.i(vec3d.g, vec3d.h, vec3d.i);
        }
    }

    public void i(double d0, double d1, double d2) {
        if (Double.isFinite(d0) && Double.isFinite(d1) && Double.isFinite(d2)) {
            this.k(this.dN().b(d0, d1, d2));
            this.aF = true;
        }
    }

    protected void bT() {
        this.ah = true;
    }

    @Deprecated
    public final void a(DamageSource damagesource, float f2) {
        net.minecraft.world.level.World world = this.aU;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, damagesource, f2);
        }
    }

    @Deprecated
    public final boolean b(DamageSource damagesource, float f2) {
        net.minecraft.world.level.World world = this.aU;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return this.a(worldserver, damagesource, f2);
        }
        return this.b(damagesource);
    }

    public abstract boolean a(WorldServer var1, DamageSource var2, float var3);

    public boolean b(DamageSource damagesource) {
        return false;
    }

    public final Vec3D h(float f2) {
        return this.c(this.i(f2), this.j(f2));
    }

    public EnumDirection bU() {
        return EnumDirection.a(this.h(1.0f));
    }

    public float i(float f2) {
        return this.k(f2);
    }

    public float j(float f2) {
        return this.l(f2);
    }

    public float k(float f2) {
        return f2 == 1.0f ? this.ee() : MathHelper.h(f2, this.ac, this.ee());
    }

    public float l(float f2) {
        return f2 == 1.0f ? this.ec() : MathHelper.i(f2, this.ab, this.ec());
    }

    public final Vec3D c(float f2, float f1) {
        float f22 = f2 * ((float)Math.PI / 180);
        float f3 = -f1 * ((float)Math.PI / 180);
        float f4 = MathHelper.b((double)f3);
        float f5 = MathHelper.a((double)f3);
        float f6 = MathHelper.b((double)f22);
        float f7 = MathHelper.a((double)f22);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D m(float f2) {
        return this.d(this.i(f2), this.j(f2));
    }

    protected final Vec3D d(float f2, float f1) {
        return this.c(f2 - 90.0f, f1);
    }

    public final Vec3D bV() {
        return new Vec3D(this.dP(), this.dT(), this.dV());
    }

    public final Vec3D n(float f2) {
        double d0 = MathHelper.d((double)f2, this.Y, this.dP());
        double d1 = MathHelper.d((double)f2, this.Z, this.dR()) + (double)this.dk();
        double d2 = MathHelper.d((double)f2, this.aa, this.dV());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D o(float f2) {
        return this.n(f2);
    }

    public final Vec3D p(float f2) {
        double d0 = MathHelper.d((double)f2, this.Y, this.dP());
        double d1 = MathHelper.d((double)f2, this.Z, this.dR());
        double d2 = MathHelper.d((double)f2, this.aa, this.dV());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double d0, float f2, boolean flag) {
        Vec3D vec3d = this.n(f2);
        Vec3D vec3d1 = this.h(f2);
        Vec3D vec3d2 = vec3d.b(vec3d1.g * d0, vec3d1.h * d0, vec3d1.i * d0);
        return this.ao().a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, flag ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bW() {
        return this.cb() && this.bX();
    }

    public boolean bX() {
        return false;
    }

    public boolean bY() {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bY();
    }

    public void a(Entity entity, DamageSource damagesource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entity, this, damagesource);
        }
    }

    public boolean j(double d0, double d1, double d2) {
        double d3 = this.dP() - d0;
        double d4 = this.dR() - d1;
        double d5 = this.dV() - d2;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double d0) {
        double d1 = this.dj().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * aO) * d1;
    }

    public boolean b(ValueOutput valueoutput) {
        return this.saveAsPassenger(valueoutput, true);
    }

    public boolean saveAsPassenger(ValueOutput valueoutput, boolean includeAll) {
        if (this.bd != null && !this.bd.b()) {
            return false;
        }
        String s2 = this.ca();
        if (!this.persist || s2 == null) {
            return false;
        }
        valueoutput.a(v, s2);
        this.saveWithoutId(valueoutput, includeAll);
        return true;
    }

    public boolean c(ValueOutput valueoutput) {
        return this.cq() ? false : this.b(valueoutput);
    }

    public void d(ValueOutput valueoutput) {
        this.saveWithoutId(valueoutput, true);
    }

    public void saveWithoutId(ValueOutput valueoutput, boolean includeAll) {
        try {
            int i2;
            if (includeAll) {
                if (this.aT != null) {
                    valueoutput.a(z, Vec3D.a, new Vec3D(this.aT.dP(), this.dR(), this.aT.dV()));
                } else {
                    valueoutput.a(z, Vec3D.a, this.dI());
                }
            }
            valueoutput.a(A, Vec3D.a, this.dN());
            if (Float.isNaN(this.aZ)) {
                this.aZ = 0.0f;
            }
            if (Float.isNaN(this.ba)) {
                this.ba = 0.0f;
            }
            valueoutput.a(B, Vec2F.i, new Vec2F(this.ec(), this.ee()));
            valueoutput.a(G, this.an);
            valueoutput.a(H, (short)this.bf);
            valueoutput.a(E, (short)this.cK());
            valueoutput.a(F, this.aV());
            valueoutput.a(K, this.bu);
            valueoutput.a(C, this.bt);
            if (includeAll) {
                valueoutput.a(w, UUIDUtil.a, this.cY());
                valueoutput.a("WorldUUIDLeast", ((WorldServer)this.aU).getWorld().getUID().getLeastSignificantBits());
                valueoutput.a("WorldUUIDMost", ((WorldServer)this.aU).getWorld().getUID().getMostSignificantBits());
            }
            valueoutput.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                valueoutput.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                valueoutput.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                valueoutput.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                valueoutput.a("Bukkit.MaxAirSupply", this.cJ());
            }
            valueoutput.a("Spigot.ticksLived", this.at);
            valueoutput.b(L, ComponentSerialization.a, this.as());
            if (this.dd()) {
                valueoutput.a("CustomNameVisible", this.dd());
            }
            if (this.bq()) {
                valueoutput.a(I, this.bq());
            }
            if (this.br()) {
                valueoutput.a(D, this.br());
            }
            if (this.bv) {
                valueoutput.a(J, true);
            }
            if ((i2 = this.cM()) > 0) {
                valueoutput.a("TicksFrozen", this.cM());
            }
            if (this.bE) {
                valueoutput.a("HasVisualFire", this.bE);
            }
            if (!this.bw.isEmpty()) {
                valueoutput.a("Tags", d, List.copyOf(this.bw));
            }
            if (!this.bM.a()) {
                valueoutput.a(y, CustomData.c, this.bM);
            }
            this.addAdditionalSaveData(valueoutput, includeAll);
            if (this.cr()) {
                ValueOutput.b valueoutput_b = valueoutput.b(x);
                for (Entity entity : this.dn()) {
                    ValueOutput valueoutput1;
                    if (entity.saveAsPassenger(valueoutput1 = valueoutput_b.a(), includeAll)) continue;
                    valueoutput_b.b();
                }
                if (valueoutput_b.c()) {
                    valueoutput.c(x);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(valueoutput);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void d(ValueInput valueinput) {
        try {
            Vec3D vec3d = valueinput.a(z, Vec3D.a).orElse(Vec3D.c);
            Vec3D vec3d1 = valueinput.a(A, Vec3D.a).orElse(Vec3D.c);
            Vec2F vec2f = valueinput.a(B, Vec2F.i).orElse(Vec2F.a);
            this.m(Math.abs(vec3d1.g) > 10.0 ? 0.0 : vec3d1.g, Math.abs(vec3d1.h) > 10.0 ? 0.0 : vec3d1.h, Math.abs(vec3d1.i) > 10.0 ? 0.0 : vec3d1.i);
            this.aF = true;
            double d0 = 3.0000512E7;
            this.n(MathHelper.a(vec3d.g, -3.0000512E7, 3.0000512E7), MathHelper.a(vec3d.h, -2.0E7, 2.0E7), MathHelper.a(vec3d.i, -3.0000512E7, 3.0000512E7));
            this.v(vec2f.j);
            this.w(vec2f.k);
            this.bP();
            this.r(this.ec());
            this.s(this.ec());
            this.an = valueinput.a(G, 0.0);
            this.bf = valueinput.a(H, (short)0);
            this.j(valueinput.a(E, this.cJ()));
            this.bc = valueinput.a(F, false);
            this.bu = valueinput.a(K, false);
            this.bt = valueinput.a(C, 0);
            valueinput.a(w, UUIDUtil.a).ifPresent(uuid -> {
                this.aH = uuid;
                this.aI = this.aH.toString();
            });
            if (!Double.isFinite(this.dP()) || !Double.isFinite(this.dR()) || !Double.isFinite(this.dV())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.ec()) || !Double.isFinite(this.ee())) throw new IllegalStateException("Entity has invalid rotation");
            this.aH();
            this.a(this.ec(), this.ee());
            this.b((IChatBaseComponent)valueinput.a(L, ComponentSerialization.a).orElse(null));
            this.p(valueinput.a("CustomNameVisible", false));
            this.f(valueinput.a(I, false));
            this.g(valueinput.a(D, false));
            this.k(valueinput.a(J, false));
            this.k(valueinput.a("TicksFrozen", 0));
            this.bE = valueinput.a("HasVisualFire", false);
            this.bM = valueinput.a(y, CustomData.c).orElse(CustomData.a);
            this.bw.clear();
            Optional<List<String>> optional = valueinput.a("Tags", d);
            Set<String> set = this.bw;
            Objects.requireNonNull(this.bw);
            optional.ifPresent(set::addAll);
            this.a(valueinput);
            if (this.bZ()) {
                this.aH();
            }
            if (this instanceof EntityLiving) {
                this.at = valueinput.a("Spigot.ticksLived", this.at);
            }
            this.persist = valueinput.a("Bukkit.persist", this.persist);
            this.visibleByDefault = valueinput.a("Bukkit.visibleByDefault", this.visibleByDefault);
            this.maxAirTicks = valueinput.a("Bukkit.MaxAirSupply", this.maxAirTicks);
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = valueinput.a("world", "");
                Optional<Long> most = valueinput.f("WorldUUIDMost");
                Optional<Long> least = valueinput.f("WorldUUIDLeast");
                if (most.isPresent() && least.isPresent()) {
                    UUID uid = new UUID(most.get(), least.get());
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                if (bworld == null) {
                    bworld = ((CraftServer)server).getServer().a(net.minecraft.world.level.World.h).getWorld();
                }
                ((EntityPlayer)this).a((net.minecraft.world.level.World)(bworld == null ? null : ((CraftWorld)bworld).getHandle()));
            }
            this.getBukkitEntity().readBukkitValues(valueinput);
            boolean bukkitInvisible = valueinput.a("Bukkit.invisible", false);
            if (!bukkitInvisible) return;
            this.l(bukkitInvisible);
            this.persistentInvisibility = bukkitInvisible;
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bZ() {
        return true;
    }

    public final @Nullable String ca() {
        EntityTypes<?> entitytypes = this.ay();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return !entitytypes.b() ? null : minecraftkey.toString();
    }

    protected void addAdditionalSaveData(ValueOutput valueoutput, boolean includeAll) {
        this.a(valueoutput);
    }

    protected abstract void a(ValueInput var1);

    protected abstract void a(ValueOutput var1);

    public @Nullable EntityItem a(WorldServer worldserver, IMaterial imaterial) {
        return this.a(worldserver, new ItemStack(imaterial), 0.0f);
    }

    public @Nullable EntityItem a(WorldServer worldserver, ItemStack itemstack) {
        return this.a(worldserver, itemstack, 0.0f);
    }

    public @Nullable EntityItem a(WorldServer worldserver, ItemStack itemstack, Vec3D vec3d) {
        if (itemstack.f()) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asBukkitCopy(itemstack));
            return null;
        }
        EntityItem entityitem = new EntityItem(worldserver, this.dP() + vec3d.g, this.dR() + vec3d.h, this.dV() + vec3d.i, itemstack);
        entityitem.i();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        worldserver.b(entityitem);
        return entityitem;
    }

    public @Nullable EntityItem a(WorldServer worldserver, ItemStack itemstack, float f2) {
        return this.a(worldserver, itemstack, new Vec3D(0.0, f2, 0.0));
    }

    public boolean cb() {
        return !this.eh();
    }

    public boolean cc() {
        if (this.ar) {
            return false;
        }
        float f2 = this.bz.a() * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.bV(), f2, 1.0E-6, f2);
        return BlockPosition.b(axisalignedbb).anyMatch(blockposition -> {
            IBlockData iblockdata = this.ao().a_((BlockPosition)blockposition);
            return !iblockdata.l() && iblockdata.j(this.ao(), (BlockPosition)blockposition) && VoxelShapes.c(iblockdata.g(this.ao(), (BlockPosition)blockposition).a((BaseBlockPosition)blockposition), VoxelShapes.a(axisalignedbb), OperatorBoolean.i);
        });
    }

    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack;
        List<Leashable> list;
        EntityLiving entityliving;
        Leashable leashable;
        Entity entity;
        if (!this.ao().B_() && entityhuman.gA() && (entity = this) instanceof Leashable && (leashable = (Leashable)((Object)entity)).aj_() && this.cb() && (!(this instanceof EntityLiving) || !(entityliving = (EntityLiving)this).e_()) && !(list = Leashable.a(this, (Leashable leashable1) -> leashable1.C() == entityhuman)).isEmpty()) {
            boolean flag = false;
            for (Leashable leashable12 : list) {
                if (!leashable12.b_(this)) continue;
                leashable12.a_(this, true);
                flag = true;
            }
            if (flag) {
                this.ao().a(GameEvent.u, this.dK(), GameEvent.a.a(entityhuman));
                this.a(SoundEffects.qc);
                return EnumInteractionResult.b.b();
            }
        }
        if ((itemstack = entityhuman.b(enumhand)).a(Items.tZ) && this.c(entityhuman)) {
            itemstack.a(1, (EntityLiving)entityhuman, enumhand);
            return EnumInteractionResult.a;
        }
        if (this instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)this;
            if (itemstack.a(Items.tZ) && entityinsentient.b_(entityhuman) && !entityhuman.gA() && this.a(entityhuman, enumhand, itemstack, entityinsentient)) {
                return EnumInteractionResult.a;
            }
        }
        if (this.cb() && this instanceof Leashable) {
            Leashable leashable2 = (Leashable)((Object)this);
            if (leashable2.C() == entityhuman) {
                if (!this.ao().B_()) {
                    if (CraftEventFactory.callPlayerUnleashEntityEvent(this, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).g.b(new PacketPlayOutAttachEntity(this, leashable2.C()));
                        return EnumInteractionResult.e;
                    }
                    if (entityhuman.gv()) {
                        leashable2.r();
                    } else {
                        leashable2.o();
                    }
                    this.a(GameEvent.r, (Entity)entityhuman);
                    this.a(SoundEffects.qb);
                }
                return EnumInteractionResult.a.b();
            }
            ItemStack itemstack1 = entityhuman.b(enumhand);
            if (itemstack1.a(Items.wZ) && !(leashable2.C() instanceof EntityHuman)) {
                if (this.ao().B_()) {
                    return EnumInteractionResult.c;
                }
                if (leashable2.b_(entityhuman)) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, entityhuman, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).resendItemInHands();
                        ((EntityPlayer)entityhuman).g.b(new PacketPlayOutAttachEntity(this, leashable2.C()));
                        return EnumInteractionResult.e;
                    }
                    if (leashable2.S_()) {
                        leashable2.o();
                    }
                    leashable2.a_(entityhuman, true);
                    this.a(SoundEffects.qc);
                    itemstack1.h(1);
                    return EnumInteractionResult.b;
                }
            }
        }
        return EnumInteractionResult.e;
    }

    public boolean c(@Nullable EntityHuman entityhuman) {
        net.minecraft.world.level.World world;
        boolean flag = this.dropAllLeashConnections(entityhuman, EntityUnleashEvent.UnleashReason.SHEAR);
        if (flag && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.a((Entity)null, this.dK(), SoundEffects.zy, entityhuman != null ? entityhuman.dB() : this.dB());
        }
        return flag;
    }

    public boolean d(@Nullable EntityHuman entityhuman) {
        return this.dropAllLeashConnections(entityhuman, EntityUnleashEvent.UnleashReason.UNKNOWN);
    }

    public boolean dropAllLeashConnections(@Nullable EntityHuman entityhuman, EntityUnleashEvent.UnleashReason reason) {
        Leashable leashable;
        List<Leashable> list = Leashable.c_(this);
        boolean flag = !list.isEmpty();
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).S_()) {
            this.ao().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), reason));
            leashable.o();
            flag = true;
        }
        for (Leashable leashable1 : list) {
            if (leashable1 instanceof Entity) {
                Entity entity2 = (Entity)((Object)leashable1);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)entity2.getBukkitEntity(), reason));
            }
            leashable1.o();
        }
        if (flag) {
            this.a(GameEvent.M, (Entity)entityhuman);
            return true;
        }
        return false;
    }

    private boolean a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack, EntityInsentient entityinsentient) {
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack1 = entityinsentient.a(enumitemslot);
            Equippable equippable = itemstack1.a(DataComponents.H);
            if (equippable == null || !equippable.k() || EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.F) && !entityhuman.ha()) continue;
            itemstack.a(1, (EntityLiving)entityhuman, enumhand.a());
            Vec3D vec3d = this.bz.d().a(EntityAttachment.a);
            entityinsentient.b(enumitemslot, ItemStack.l);
            this.a(GameEvent.M, (Entity)entityhuman);
            this.a(equippable.l().a());
            net.minecraft.world.level.World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.forceDrops = true;
                this.a(worldserver, itemstack1, vec3d);
                this.forceDrops = false;
                CriterionTriggers.V.a((EntityPlayer)entityhuman, itemstack1, entityinsentient);
            }
            return true;
        }
        return false;
    }

    public boolean i(Entity entity) {
        return entity.j(this) && !this.A(entity);
    }

    public boolean j(@Nullable Entity entity) {
        return false;
    }

    public void t() {
        this.k(Vec3D.c);
        this.g();
        if (this.cq()) {
            this.dz().k(this);
        }
    }

    public final void k(Entity entity) {
        if (this.z(entity)) {
            this.a(entity, Entity::a_);
        }
    }

    protected void a(Entity entity, MoveFunction entity_movefunction) {
        Vec3D vec3d = this.n(entity);
        Vec3D vec3d1 = entity.m(this);
        entity_movefunction.accept(entity, vec3d.g - vec3d1.g, vec3d.h - vec3d1.h, vec3d.i - vec3d1.i);
    }

    public void l(Entity entity) {
    }

    public Vec3D m(Entity entity) {
        return this.dH().b(EntityAttachment.b, 0, this.aZ);
    }

    public Vec3D n(Entity entity) {
        return this.dI().e(this.a(entity, this.bz, 1.0f));
    }

    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return Entity.a(this, entity, entitysize.d());
    }

    protected static Vec3D a(Entity entity, Entity entity1, EntityAttachments entityattachments) {
        int i2 = entity.dn().indexOf(entity1);
        return entityattachments.c(EntityAttachment.a, i2, entity.aZ);
    }

    public final boolean o(Entity entity) {
        return this.a(entity, false, true);
    }

    public boolean cd() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean flag, boolean flag1) {
        if (entity == this.aT) {
            return false;
        }
        if (!entity.cg()) {
            return false;
        }
        if (!(flag || this.ao().B_() || entity.aP.b())) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.aT != null) {
            if (entity1.aT == this) {
                return false;
            }
            entity1 = entity1.aT;
        }
        if (flag || this.p(entity) && entity.s(this)) {
            EntityMountEvent event;
            if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
                event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
                if (this.valid) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return false;
                }
            }
            event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
            if (this.cq()) {
                this.cf();
            }
            this.c(EntityPose.a);
            this.aT = entity;
            this.aT.q(this);
            if (flag1) {
                this.ao().a(this, GameEvent.s, this.aT.aV);
                entity.E().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.W.a((EntityPlayer)entity2));
            }
            return true;
        }
        return false;
    }

    protected boolean p(Entity entity) {
        return !this.cu() && this.X <= 0;
    }

    public void ce() {
        for (int i2 = this.aS.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.aS.get(i2)).cf();
        }
    }

    public void ad() {
        if (this.aT != null) {
            Entity entity = this.aT;
            this.aT = null;
            if (!entity.removePassenger(this)) {
                this.aT = entity;
                return;
            }
            RemovalReason entity_removalreason = this.ei();
            if (entity_removalreason == null || entity_removalreason.a()) {
                this.ao().a(this, GameEvent.q, entity.aV);
            }
        }
    }

    public void cf() {
        this.ad();
    }

    protected void q(Entity entity) {
        if (entity.dz() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.aS.isEmpty()) {
            this.aS = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.aS);
            if (!this.ao().B_() && entity instanceof EntityHuman && !(this.do() instanceof EntityHuman)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.aS = ImmutableList.copyOf((Collection)list);
        }
    }

    protected boolean removePassenger(Entity entity) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.dz() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.aS = this.aS.size() == 1 && this.aS.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.aS.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.X = 60;
        return true;
    }

    protected boolean s(Entity entity) {
        return this.aS.isEmpty();
    }

    protected boolean cg() {
        return true;
    }

    public final boolean ch() {
        return this.l_() != null && this.l_().d();
    }

    public final void d(Vec3D vec3d, float f2, float f1) {
        this.a(Optional.of(vec3d), Optional.of(Float.valueOf(f2)), Optional.of(Float.valueOf(f1)));
    }

    public final void e(float f2, float f1) {
        this.a(Optional.empty(), Optional.of(Float.valueOf(f2)), Optional.of(Float.valueOf(f1)));
    }

    public final void i(Vec3D vec3d) {
        this.a(Optional.of(vec3d), Optional.empty(), Optional.empty());
    }

    public final void a(Optional<Vec3D> optional, Optional<Float> optional1, Optional<Float> optional2) {
        InterpolationHandler interpolationhandler = this.l_();
        if (interpolationhandler != null) {
            interpolationhandler.a(optional.orElse(interpolationhandler.a()), optional1.orElse(Float.valueOf(interpolationhandler.b())).floatValue(), optional2.orElse(Float.valueOf(interpolationhandler.c())).floatValue());
        } else {
            optional.ifPresent(this::b);
            optional1.ifPresent(ofloat -> this.v(ofloat.floatValue() % 360.0f));
            optional2.ifPresent(ofloat -> this.w(ofloat.floatValue() % 360.0f));
        }
    }

    public @Nullable InterpolationHandler l_() {
        return null;
    }

    public void a(float f2, int i2) {
        this.r(f2);
    }

    public float ci() {
        return 0.0f;
    }

    public Vec3D cj() {
        return this.c(this.ee(), this.ec());
    }

    public Vec3D ck() {
        return this.c(this.ee(), this.cS());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.c;
        }
        EntityHuman entityhuman = (EntityHuman)entity;
        boolean flag = entityhuman.fy().a(item) && !entityhuman.fx().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.at().a() : entityhuman.at();
        return this.c(0.0f, this.ec() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).c(0.5);
    }

    public Vec2F cl() {
        return new Vec2F(this.ee(), this.ec());
    }

    public Vec3D cm() {
        return Vec3D.a(this.cl());
    }

    public void a(Portal portal, BlockPosition blockposition) {
        if (this.aO()) {
            this.aM();
        } else if (this.aG != null && this.aG.a(portal)) {
            if (!this.aG.e()) {
                this.aG.a(blockposition.j());
                this.aG.a(true);
            }
        } else {
            this.aG = new PortalProcessor(portal, blockposition.j());
        }
    }

    protected void cn() {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.O();
            if (this.aG != null) {
                if (this.aG.a(worldserver, this, this.o(false))) {
                    GameProfilerFiller gameprofilerfiller = Profiler.a();
                    gameprofilerfiller.a("portal");
                    this.aM();
                    TeleportTransition teleporttransition = this.aG.a(worldserver, this);
                    if (teleporttransition != null) {
                        WorldServer worldserver1 = teleporttransition.b();
                        if (this instanceof EntityPlayer && worldserver1 == null || worldserver1 != null && worldserver.a(worldserver1) && (worldserver1.aq() == worldserver.aq() || this.a((net.minecraft.world.level.World)worldserver, (net.minecraft.world.level.World)worldserver1))) {
                            this.b(teleporttransition);
                        }
                    }
                    gameprofilerfiller.c();
                } else if (this.aG.b()) {
                    this.aG = null;
                }
            }
        }
    }

    public int co() {
        Entity entity = this.do();
        return entity instanceof EntityPlayer ? entity.co() : 300;
    }

    public void j(Vec3D vec3d) {
        this.k(vec3d);
    }

    public void c(DamageSource damagesource) {
    }

    public void b(byte b0) {
        switch (b0) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void q(float f2) {
    }

    public boolean cp() {
        boolean flag = this.ao() != null && this.ao().B_();
        return !this.bx() && (this.bf > 0 || flag && this.i(0));
    }

    public boolean cq() {
        return this.dz() != null;
    }

    public boolean cr() {
        return !this.aS.isEmpty();
    }

    public boolean cs() {
        return this.ay().a(TagsEntity.q);
    }

    public boolean ct() {
        return !this.ay().a(TagsEntity.r);
    }

    public void h(boolean flag) {
        this.b(1, flag);
    }

    public boolean cu() {
        return this.i(1);
    }

    public boolean cv() {
        return this.cu();
    }

    public boolean cw() {
        return this.cu();
    }

    public boolean cx() {
        return this.cu();
    }

    public boolean cy() {
        return this.cu();
    }

    public boolean cz() {
        return this.d(EntityPose.f);
    }

    public boolean cA() {
        return this.i(3);
    }

    public void i(boolean flag) {
        this.b(3, flag);
    }

    public boolean cB() {
        return this.i(4);
    }

    public boolean cC() {
        return this.d(EntityPose.d);
    }

    public boolean cD() {
        return this.cC() && !this.by();
    }

    public void j(boolean flag) {
        if (this.valid && this.cB() != flag && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, flag).isCancelled()) {
            return;
        }
        this.b(4, flag);
    }

    public final boolean cE() {
        return this.bv;
    }

    public final void k(boolean flag) {
        this.bv = flag;
        this.b(6, this.cF());
    }

    public boolean cF() {
        return this.ao().B_() ? this.i(6) : this.bv;
    }

    public boolean cG() {
        return this.i(5);
    }

    public boolean e(EntityHuman entityhuman) {
        if (entityhuman.au()) {
            return false;
        }
        ScoreboardTeam scoreboardteambase = this.cI();
        return scoreboardteambase != null && entityhuman != null && entityhuman.cI() == scoreboardteambase && ((ScoreboardTeamBase)scoreboardteambase).j() ? false : this.cG();
    }

    public boolean cH() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
    }

    public @Nullable ScoreboardTeam cI() {
        return this.ao().ab().e(this.da());
    }

    public final boolean t(@Nullable Entity entity) {
        return entity == null ? false : this == entity || this.u(entity) || entity.u(this);
    }

    protected boolean u(Entity entity) {
        return this.a(entity.cI());
    }

    public boolean a(@Nullable ScoreboardTeamBase scoreboardteambase) {
        return this.cI() != null ? this.cI().a(scoreboardteambase) : false;
    }

    public void l(boolean flag) {
        if (!this.persistentInvisibility) {
            this.b(5, flag);
        }
    }

    public boolean i(int i2) {
        return (this.az.a(aA) & 1 << i2) != 0;
    }

    public void b(int i2, boolean flag) {
        byte b0 = this.az.a(aA);
        if (flag) {
            this.az.a(aA, (byte)(b0 | 1 << i2));
        } else {
            this.az.a(aA, (byte)(b0 & ~(1 << i2)));
        }
    }

    public int cJ() {
        return this.maxAirTicks;
    }

    public int cK() {
        return this.az.a(bl);
    }

    public void j(int i2) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cK() != i2) {
            this.az.markDirty(bl);
            return;
        }
        this.az.a(bl, event.getAmount());
    }

    public void cL() {
        this.k(0);
    }

    public int cM() {
        return this.az.a(bq);
    }

    public void k(int i2) {
        this.az.a(bq, i2);
    }

    public float cN() {
        int i2 = this.cP();
        return (float)Math.min(this.cM(), i2) / (float)i2;
    }

    public boolean cO() {
        return this.cM() >= this.cP();
    }

    public int cP() {
        return 140;
    }

    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        this.h(this.bf + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = entitylightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.bf == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.bx()) {
            return;
        }
        if (!this.a(worldserver, this.en().c().customEntityDamager(entitylightning), 5.0f)) {
            return;
        }
    }

    public void a(boolean flag, BlockPosition blockposition) {
        Entity.a(this, flag, blockposition);
    }

    protected static void a(Entity entity, boolean flag, BlockPosition blockposition) {
        Vec3D vec3d = entity.dN();
        double d0 = flag ? Math.max(-0.9, vec3d.h - 0.03) : Math.min(1.8, vec3d.h + 0.1);
        entity.m(vec3d.g, d0, vec3d.i);
        Entity.a(entity.aU, blockposition);
    }

    protected static void a(net.minecraft.world.level.World world, BlockPosition blockposition) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            for (int i2 = 0; i2 < 2; ++i2) {
                worldserver.a(Particles.aq, (double)blockposition.u() + world.y.j(), (double)(blockposition.v() + 1), (double)blockposition.w() + world.y.j(), 1, 0.0, 0.0, 0.0, 1.0);
                worldserver.a(Particles.d, (double)blockposition.u() + world.y.j(), (double)(blockposition.v() + 1), (double)blockposition.w() + world.y.j(), 1, 0.0, 0.01, 0.0, 0.2);
            }
        }
    }

    public void m(boolean flag) {
        Entity.a(this, flag);
    }

    protected static void a(Entity entity, boolean flag) {
        Vec3D vec3d = entity.dN();
        double d0 = flag ? Math.max(-0.3, vec3d.h - 0.03) : Math.min(0.7, vec3d.h + 0.06);
        entity.m(vec3d.g, d0, vec3d.i);
        entity.l();
    }

    public boolean a(WorldServer worldserver, EntityLiving entityliving, DamageSource damagesource) {
        return true;
    }

    public void cQ() {
        if (this.dN().b() > -0.5 && this.an > 1.0) {
            this.an = 1.0;
        }
    }

    public void l() {
        this.an = 0.0;
    }

    protected void k(double d0, double d1, double d2) {
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        Vec3D vec3d = new Vec3D(d0 - (double)blockposition.u(), d1 - (double)blockposition.v(), d2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.ao().a_(blockposition_mutableblockposition).m(this.ao(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.o());
            double d6 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.as.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dN().c(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.m(f1 * f2, vec3d1.h, vec3d1.i);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.m(vec3d1.g, f1 * f2, vec3d1.i);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.m(vec3d1.g, vec3d1.h, f1 * f2);
        }
    }

    public void a(IBlockData iblockdata, Vec3D vec3d) {
        this.l();
        this.ai = vec3d;
    }

    private static IChatBaseComponent a(IChatBaseComponent ichatbasecomponent) {
        IChatMutableComponent ichatmutablecomponent = ichatbasecomponent.e().b(ichatbasecomponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : ichatbasecomponent.c()) {
            ichatmutablecomponent.b(Entity.a(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent ap() {
        IChatBaseComponent ichatbasecomponent = this.as();
        return ichatbasecomponent != null ? Entity.a(ichatbasecomponent) : this.cR();
    }

    protected IChatBaseComponent cR() {
        return this.aP.h();
    }

    public boolean v(Entity entity) {
        return this == entity;
    }

    public float cS() {
        return 0.0f;
    }

    public void r(float f2) {
    }

    public void s(float f2) {
    }

    public boolean cT() {
        return true;
    }

    public boolean w(Entity entity) {
        return false;
    }

    public String toString() {
        String s2 = this.ao() == null ? "~NULL~" : this.ao().toString();
        return this.bd != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.aq(), this.aR, s2, this.dP(), this.dR(), this.dV(), this.bd}) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.aq(), this.aR, s2, this.dP(), this.dR(), this.dV());
    }

    public final boolean d(DamageSource damagesource) {
        return this.eh() || this.bu && !damagesource.a(DamageTypeTags.d) && !damagesource.h() || damagesource.a(DamageTypeTags.i) && this.bx() || damagesource.a(DamageTypeTags.m) && this.ay().a(TagsEntity.p);
    }

    public boolean cU() {
        return this.bu;
    }

    public void n(boolean flag) {
        this.bu = flag;
    }

    public void x(Entity entity) {
        this.b(entity.dP(), entity.dR(), entity.dV(), entity.ec(), entity.ee());
    }

    public void y(Entity entity) {
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.es(), b);){
            TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, entity.eo());
            entity.d(tagvalueoutput);
            this.d(TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)this.eo(), tagvalueoutput.b()));
        }
        this.bt = entity.bt;
        this.aG = entity.aG;
    }

    public @Nullable Entity b(TeleportTransition teleporttransition) {
        WorldServer worldserver = (WorldServer)this.ao();
        if (worldserver instanceof WorldServer) {
            WorldServer worldserver1 = worldserver;
            if (!this.eh()) {
                boolean flag;
                PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleporttransition), teleporttransition.i());
                Location to = CraftLocation.toBukkit(absolutePosition.a(), (World)teleporttransition.b().getWorld(), absolutePosition.c(), absolutePosition.d());
                EntityTeleportEvent teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                if (teleEvent.isCancelled()) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleporttransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), Vec3D.c, to.getYaw(), to.getPitch(), teleporttransition.g(), teleporttransition.h(), Set.of(), teleporttransition.j(), teleporttransition.cause());
                }
                boolean bl = flag = (worldserver = teleporttransition.b()).aq() != worldserver1.aq();
                if (!teleporttransition.h()) {
                    this.cf();
                }
                if (flag) {
                    return this.a(worldserver1, worldserver, teleporttransition);
                }
                return this.a(worldserver1, teleporttransition);
            }
        }
        return null;
    }

    private Entity a(WorldServer worldserver, TeleportTransition teleporttransition) {
        for (Entity entity : this.dn()) {
            entity.b(this.a(teleporttransition, entity));
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("teleportSameDimension");
        this.a(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        if (!teleporttransition.h()) {
            this.a(teleporttransition);
        }
        teleporttransition.j().onTransition(this);
        gameprofilerfiller.c();
        return this;
    }

    private @Nullable Entity a(WorldServer worldserver, WorldServer worldserver1, TeleportTransition teleporttransition) {
        List<Entity> list = this.dn();
        ArrayList<Entity> list1 = new ArrayList<Entity>(list.size());
        this.ce();
        for (Entity entity : list) {
            Entity entity1 = entity.b(this.a(teleporttransition, entity));
            if (entity1 == null) continue;
            list1.add(entity1);
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("teleportCrossDimension");
        Object entity2 = this.ay().a(worldserver1, EntitySpawnReason.s);
        if (entity2 == null) {
            gameprofilerfiller.c();
            return null;
        }
        ((Entity)entity2).y(this);
        this.cV();
        this.getBukkitEntity().setHandle((Entity)entity2);
        ((Entity)entity2).bukkitEntity = this.getBukkitEntity();
        ((Entity)entity2).a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        if (this.inWorld) {
            worldserver1.d((Entity)entity2);
        }
        for (Entity entity3 : list1) {
            entity3.a((Entity)entity2, true, false);
        }
        worldserver1.l();
        teleporttransition.j().onTransition((Entity)entity2);
        this.a(teleporttransition, worldserver);
        gameprofilerfiller.c();
        return entity2;
    }

    protected void a(TeleportTransition teleporttransition, WorldServer worldserver) {
        for (EntityPlayer entityplayer : List.copyOf(worldserver.E())) {
            if (entityplayer.N() != this) continue;
            entityplayer.a(teleporttransition);
            entityplayer.d((Entity)null);
        }
    }

    private TeleportTransition a(TeleportTransition teleporttransition, Entity entity) {
        float f2 = teleporttransition.e() + (teleporttransition.i().contains((Object)Relative.d) ? 0.0f : entity.ec() - this.ec());
        float f1 = teleporttransition.f() + (teleporttransition.i().contains((Object)Relative.e) ? 0.0f : entity.ee() - this.ee());
        Vec3D vec3d = entity.dI().d(this.dI());
        Vec3D vec3d1 = teleporttransition.c().b(teleporttransition.i().contains((Object)Relative.a) ? 0.0 : vec3d.a(), teleporttransition.i().contains((Object)Relative.b) ? 0.0 : vec3d.b(), teleporttransition.i().contains((Object)Relative.c) ? 0.0 : vec3d.c());
        return teleporttransition.a(vec3d1).a(f2, f1).a();
    }

    private void a(TeleportTransition teleporttransition) {
        EntityLiving entity = this.dl();
        for (Entity entity1 : this.dr()) {
            if (!(entity1 instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity1;
            if (entity != null && entityplayer.aA() == entity.aA()) {
                entityplayer.g.b(PacketPlayOutEntityTeleport.a(this.aA(), PositionMoveRotation.a(teleporttransition), teleporttransition.i(), this.bc));
                continue;
            }
            entityplayer.g.b(PacketPlayOutEntityTeleport.a(this.aA(), PositionMoveRotation.a(this), Set.of(), this.bc));
        }
    }

    public void a(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        this.a(PositionMoveRotation.a(this), positionmoverotation, set);
    }

    public void a(PositionMoveRotation positionmoverotation, PositionMoveRotation positionmoverotation1, Set<Relative> set) {
        PositionMoveRotation positionmoverotation2 = PositionMoveRotation.a(positionmoverotation, positionmoverotation1, set);
        this.n(positionmoverotation2.a().g, positionmoverotation2.a().h, positionmoverotation2.a().i);
        this.v(positionmoverotation2.c());
        this.r(positionmoverotation2.c());
        this.w(positionmoverotation2.d());
        this.aH();
        this.bP();
        this.k(positionmoverotation2.b());
        this.aY();
    }

    public void a(float f2, boolean flag, float f1, boolean flag1) {
        Set<Relative> set = Relative.a(flag, flag1);
        PositionMoveRotation positionmoverotation = PositionMoveRotation.a(this);
        PositionMoveRotation positionmoverotation1 = positionmoverotation.a(f2, f1);
        PositionMoveRotation positionmoverotation2 = PositionMoveRotation.a(positionmoverotation, positionmoverotation1, set);
        this.v(positionmoverotation2.c());
        this.r(positionmoverotation2.c());
        this.w(positionmoverotation2.d());
        this.bR();
    }

    public void f(BlockPosition blockposition) {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.p().b(TicketType.m, new ChunkCoordIntPair(blockposition), 3);
        }
    }

    protected void cV() {
        this.setRemoved(RemovalReason.e, null);
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            this.ao().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            leashable.r();
        }
        if ((entity = this) instanceof WaypointTransmitter) {
            WaypointTransmitter waypointtransmitter = (WaypointTransmitter)((Object)entity);
            net.minecraft.world.level.World world = this.aU;
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                worldserver.j().c(waypointtransmitter);
            }
        }
    }

    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return BlockPortalShape.a(blockutil_rectangle, enumdirection_enumaxis, this.dI(), this.a(this.aF()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.cb()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean o(boolean flag) {
        return (flag || !this.cq()) && this.cb();
    }

    public boolean a(net.minecraft.world.level.World world, net.minecraft.world.level.World world1) {
        if (world.getTypeKey() == WorldDimension.d && world1.getTypeKey() == WorldDimension.b) {
            for (Entity entity : this.dn()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.i) continue;
                return false;
            }
        }
        return true;
    }

    public float a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, float f2) {
        return f2;
    }

    public boolean a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, float f2) {
        return true;
    }

    public int cW() {
        return 3;
    }

    public boolean m_() {
        return false;
    }

    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Entity Type", () -> {
            String s2 = String.valueOf(EntityTypes.a(this.ay()));
            return s2 + " (" + this.getClass().getCanonicalName() + ")";
        });
        crashreportsystemdetails.a("Entity ID", this.aR);
        crashreportsystemdetails.a("Entity Name", () -> this.aq());
        crashreportsystemdetails.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dP(), this.dR(), this.dV()));
        crashreportsystemdetails.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.ao(), MathHelper.c(this.dP()), MathHelper.c(this.dR()), MathHelper.c(this.dV())));
        Vec3D vec3d = this.dN();
        crashreportsystemdetails.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.g, vec3d.h, vec3d.i));
        crashreportsystemdetails.a("Entity's Passengers", () -> this.dn().toString());
        crashreportsystemdetails.a("Entity's Vehicle", () -> String.valueOf(this.dz()));
    }

    public boolean cX() {
        return this.cp() && !this.au();
    }

    public void a(UUID uuid) {
        this.aH = uuid;
        this.aI = this.aH.toString();
    }

    @Override
    public UUID cY() {
        return this.aH;
    }

    public String cZ() {
        return this.aI;
    }

    @Override
    public String da() {
        return this.aI;
    }

    public boolean db() {
        return true;
    }

    public static double dc() {
        return aO;
    }

    public static void c(double d0) {
        aO = d0;
    }

    @Override
    public IChatBaseComponent R_() {
        return ScoreboardTeam.a(this.cI(), this.ap()).a(chatmodifier -> chatmodifier.a(this.di()).a(this.cZ()));
    }

    public void b(@Nullable IChatBaseComponent ichatbasecomponent) {
        this.az.a(bm, Optional.ofNullable(ichatbasecomponent));
    }

    @Override
    public @Nullable IChatBaseComponent as() {
        return this.az.a(bm).orElse(null);
    }

    @Override
    public boolean i_() {
        return this.az.a(bm).isPresent();
    }

    public void p(boolean flag) {
        this.az.a(bn, flag);
    }

    public boolean dd() {
        return this.az.a(bn);
    }

    public final boolean a(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag) {
        return this.teleportTo(worldserver, d0, d1, d2, set, f2, f1, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        Entity entity = this.b(new TeleportTransition(worldserver, new Vec3D(d0, d1, d2), Vec3D.c, f2, f1, set, TeleportTransition.a, cause));
        return entity != null;
    }

    public void l(double d0, double d1, double d2) {
        this.b(d0, d1, d2);
    }

    public void b(double d0, double d1, double d2) {
        if (this.ao() instanceof WorldServer) {
            this.b(d0, d1, d2, this.ec(), this.ee());
            this.D();
        }
    }

    private void D() {
        this.dp().forEach(entity -> {
            for (Entity entity1 : entity.aS) {
                entity.a(entity1, Entity::d);
            }
        });
    }

    public void c(double d0, double d1, double d2) {
        this.b(this.dP() + d0, this.dR() + d1, this.dV() + d2);
    }

    public boolean de() {
        return this.dd();
    }

    @Override
    public void a(List<DataWatcher.c<?>> list) {
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (aE.equals(datawatcherobject)) {
            this.j_();
        }
    }

    @Deprecated
    protected void df() {
        EntitySize entitysize;
        EntityPose entitypose = this.aF();
        this.bz = entitysize = this.a(entitypose);
        this.bA = entitysize.c();
    }

    public void j_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.bz;
        EntityPose entitypose = this.aF();
        this.bz = entitysize1 = this.a(entitypose);
        this.bA = entitysize1.c();
        this.aH();
        boolean bl = flag = entitysize1.a() <= 4.0f && entitysize1.b() <= 4.0f;
        if (!(this.aU.B_() || this.ay || this.ar || !flag || !(entitysize1.a() > entitysize.a()) && !(entitysize1.b() > entitysize.b()) || this instanceof EntityHuman)) {
            this.a(entitysize);
        }
    }

    public boolean a(EntitySize entitysize) {
        VoxelShape voxelshape1;
        Optional<Vec3D> optional1;
        double d1;
        double d0;
        EntitySize entitysize1 = this.a(this.aF());
        Vec3D vec3d = this.dI().b(0.0, (double)entitysize.b() / 2.0, 0.0);
        VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0 = (double)Math.max(0.0f, entitysize1.a() - entitysize.a()) + 1.0E-6, d1 = (double)Math.max(0.0f, entitysize1.b() - entitysize.b()) + 1.0E-6, d0));
        Optional<Vec3D> optional = this.aU.a(this, voxelshape, vec3d, (double)entitysize1.a(), (double)entitysize1.b(), (double)entitysize1.a());
        if (optional.isPresent()) {
            this.b(optional.get().b(0.0, (double)(-entitysize1.b()) / 2.0, 0.0));
            return true;
        }
        if (entitysize1.a() > entitysize.a() && entitysize1.b() > entitysize.b() && (optional1 = this.aU.a(this, voxelshape1 = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, 1.0E-6, d0)), vec3d, (double)entitysize1.a(), (double)entitysize.b(), (double)entitysize1.a())).isPresent()) {
            this.b(optional1.get().b(0.0, (double)(-entitysize.b()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection dg() {
        return EnumDirection.a(this.ec());
    }

    public EnumDirection dh() {
        return this.dg();
    }

    protected ChatHoverable di() {
        return new ChatHoverable.c(new ChatHoverable.b(this.ay(), this.cY(), this.ap()));
    }

    public boolean a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public final AxisAlignedBB dj() {
        return this.bb;
    }

    public final void a(AxisAlignedBB axisalignedbb) {
        double minX = axisalignedbb.a;
        double minY = axisalignedbb.b;
        double minZ = axisalignedbb.c;
        double maxX = axisalignedbb.d;
        double maxY = axisalignedbb.e;
        double maxZ = axisalignedbb.f;
        double len = axisalignedbb.d - axisalignedbb.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = axisalignedbb.e - axisalignedbb.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = axisalignedbb.f - axisalignedbb.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.bb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float e(EntityPose entitypose) {
        return this.a(entitypose).c();
    }

    public final float dk() {
        return this.bA;
    }

    @Override
    public @Nullable SlotAccess a_(int i2) {
        return null;
    }

    public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
        return EnumInteractionResult.e;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void d(EntityPlayer entityplayer) {
    }

    public void e(EntityPlayer entityplayer) {
    }

    public float a(EnumBlockRotation enumblockrotation) {
        float f2 = MathHelper.f(this.ec());
        return switch (enumblockrotation) {
            case EnumBlockRotation.c -> f2 + 180.0f;
            case EnumBlockRotation.d -> f2 + 270.0f;
            case EnumBlockRotation.b -> f2 + 90.0f;
            default -> f2;
        };
    }

    public float a(EnumBlockMirror enumblockmirror) {
        float f2 = MathHelper.f(this.ec());
        return switch (enumblockmirror) {
            case EnumBlockMirror.c -> -f2;
            case EnumBlockMirror.b -> 180.0f - f2;
            default -> f2;
        };
    }

    public ProjectileDeflection a(IProjectile iprojectile) {
        return this.ay().a(TagsEntity.s) ? ProjectileDeflection.b : ProjectileDeflection.a;
    }

    public @Nullable EntityLiving dl() {
        return null;
    }

    public final boolean dm() {
        return this.dl() != null;
    }

    public final List<Entity> dn() {
        return this.aS;
    }

    public @Nullable Entity do() {
        return this.aS.isEmpty() ? null : (Entity)this.aS.get(0);
    }

    public boolean z(Entity entity) {
        return this.aS.contains((Object)entity);
    }

    public boolean a(Predicate<Entity> predicate) {
        for (Entity entity : this.aS) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> E() {
        return this.aS.stream().flatMap(Entity::dp);
    }

    public Stream<Entity> dp() {
        return Stream.concat(Stream.of(this), this.E());
    }

    public Stream<Entity> dq() {
        return Stream.concat(this.aS.stream().flatMap(Entity::dq), Stream.of(this));
    }

    public Iterable<Entity> dr() {
        return () -> this.E().iterator();
    }

    public int ds() {
        return (int)this.E().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean dt() {
        return this.ds() == 1;
    }

    public Entity du() {
        Entity entity = this;
        while (entity.cq()) {
            entity = entity.dz();
        }
        return entity;
    }

    public boolean A(Entity entity) {
        return this.du() == entity.du();
    }

    public boolean B(Entity entity) {
        if (!entity.cq()) {
            return false;
        }
        Entity entity1 = entity.dz();
        return entity1 == this ? true : this.B(entity1);
    }

    public final boolean dv() {
        return this.aU.B_() ? this.dw() : !this.aa_();
    }

    protected boolean dw() {
        EntityLiving entityliving = this.dl();
        return entityliving != null && entityliving.dw();
    }

    public boolean aa_() {
        EntityLiving entityliving = this.dl();
        return entityliving != null && entityliving.aa_();
    }

    public boolean dx() {
        return this.dv();
    }

    public boolean dy() {
        return this.dv();
    }

    protected static Vec3D a(double d0, double d1, float f2) {
        double d2 = (d0 + d1 + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a((double)(f2 * ((float)Math.PI / 180)));
        float f22 = MathHelper.b((double)(f2 * ((float)Math.PI / 180)));
        float f3 = Math.max(Math.abs(f1), Math.abs(f22));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f22 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving entityliving) {
        return new Vec3D(this.dP(), this.dj().e, this.dV());
    }

    public @Nullable Entity dz() {
        return this.aT;
    }

    public @Nullable Entity dA() {
        return this.aT != null && this.aT.dl() == this ? this.aT : null;
    }

    public EnumPistonReaction n_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory dB() {
        return SoundCategory.g;
    }

    public int dC() {
        return 0;
    }

    public CommandListenerWrapper d(WorldServer worldserver) {
        return new CommandListenerWrapper(this.commandSource, this.dI(), this.cl(), worldserver, PermissionSet.g, this.aq(), this.R_(), worldserver.s(), this);
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        Vec3D vec3d1 = argumentanchor_anchor.a(this);
        double d0 = vec3d.g - vec3d1.g;
        double d1 = vec3d.h - vec3d1.h;
        double d2 = vec3d.i - vec3d1.i;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.w(MathHelper.f((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.v(MathHelper.f((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.r(this.ec());
        this.ac = this.ee();
        this.ab = this.ec();
    }

    public float t(float f2) {
        return MathHelper.h(f2, this.ab, this.aZ);
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        if (this.dD()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.dj().h(0.001);
        int i2 = MathHelper.c(axisalignedbb.a);
        int j2 = MathHelper.e(axisalignedbb.d);
        int k2 = MathHelper.c(axisalignedbb.b);
        int l2 = MathHelper.e(axisalignedbb.e);
        int i1 = MathHelper.c(axisalignedbb.c);
        int j1 = MathHelper.e(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.db();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.c;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = k2; i22 < l2; ++i22) {
                for (int j22 = i1; j22 < j1; ++j22) {
                    double d2;
                    blockposition_mutableblockposition.d(l1, i22, j22);
                    Fluid fluid = this.ao().b_(blockposition_mutableblockposition);
                    if (!fluid.a(tagkey) || !((d2 = (double)((float)i22 + fluid.a(this.ao(), blockposition_mutableblockposition))) >= axisalignedbb.b)) continue;
                    flag1 = true;
                    d1 = Math.max(d2 - axisalignedbb.b, d1);
                    if (flag) {
                        Vec3D vec3d1 = fluid.c(this.ao(), blockposition_mutableblockposition);
                        if (d1 < 0.4) {
                            vec3d1 = vec3d1.c(d1);
                        }
                        vec3d = vec3d.e(vec3d1);
                        ++k1;
                    }
                    if (tagkey != TagsFluid.b) continue;
                    this.lastLavaContact = blockposition_mutableblockposition.j();
                }
            }
        }
        if (vec3d.g() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.c(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.dN();
            vec3d = vec3d.c(d0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.g) < 0.003 && Math.abs(vec3d2.i) < 0.003 && vec3d.g() < 0.0045000000000000005) {
                vec3d = vec3d.d().c(0.0045000000000000005);
            }
            this.k(this.dN().e(vec3d));
        }
        this.av.put(tagkey, d1);
        return flag1;
    }

    public boolean dD() {
        AxisAlignedBB axisalignedbb = this.dj().g(1.0);
        int i2 = MathHelper.c(axisalignedbb.a);
        int j2 = MathHelper.e(axisalignedbb.d);
        int k2 = MathHelper.c(axisalignedbb.c);
        int l2 = MathHelper.e(axisalignedbb.f);
        return !this.ao().b(i2, k2, j2, l2);
    }

    public double b(TagKey<FluidType> tagkey) {
        return this.av.getDouble(tagkey);
    }

    public double dE() {
        return (double)this.dk() < 0.4 ? 0.0 : 0.4;
    }

    public final float dF() {
        return this.bz.a();
    }

    public final float dG() {
        return this.bz.b();
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity(this, entitytrackerentry);
    }

    public EntitySize a(EntityPose entitypose) {
        return this.aP.n();
    }

    public final EntityAttachments dH() {
        return this.bz.d();
    }

    @Override
    public Vec3D dI() {
        return this.aV;
    }

    public Vec3D dJ() {
        return this.dI();
    }

    @Override
    public BlockPosition dK() {
        return this.aW;
    }

    public IBlockData dL() {
        if (this.bH == null) {
            this.bH = this.ao().a_(this.dK());
        }
        return this.bH;
    }

    public ChunkCoordIntPair dM() {
        return this.aX;
    }

    public Vec3D dN() {
        return this.aY;
    }

    public void k(Vec3D vec3d) {
        if (vec3d.n()) {
            this.aY = vec3d;
        }
    }

    public void l(Vec3D vec3d) {
        if (vec3d.n()) {
            this.k(this.dN().e(vec3d));
        }
    }

    public void m(double d0, double d1, double d2) {
        this.k(new Vec3D(d0, d1, d2));
    }

    public final int dO() {
        return this.aW.u();
    }

    public final double dP() {
        return this.aV.g;
    }

    public double d(double d0) {
        return this.aV.g + (double)this.dF() * d0;
    }

    public double e(double d0) {
        return this.d((2.0 * this.as.j() - 1.0) * d0);
    }

    public final int dQ() {
        return this.aW.v();
    }

    public final double dR() {
        return this.aV.h;
    }

    public double f(double d0) {
        return this.aV.h + (double)this.dG() * d0;
    }

    public double dS() {
        return this.f(this.as.j());
    }

    public double dT() {
        return this.aV.h + (double)this.bA;
    }

    public final int dU() {
        return this.aW.w();
    }

    public final double dV() {
        return this.aV.i;
    }

    public double g(double d0) {
        return this.aV.i + (double)this.dF() * d0;
    }

    public double h(double d0) {
        return this.g((2.0 * this.as.j() - 1.0) * d0);
    }

    public final void n(double d0, double d1, double d2) {
        if (this.aV.g != d0 || this.aV.h != d1 || this.aV.i != d2) {
            net.minecraft.world.level.World world;
            this.aV = new Vec3D(d0, d1, d2);
            int i2 = MathHelper.c(d0);
            int j2 = MathHelper.c(d1);
            int k2 = MathHelper.c(d2);
            if (i2 != this.aW.u() || j2 != this.aW.v() || k2 != this.aW.w()) {
                this.aW = new BlockPosition(i2, j2, k2);
                this.bH = null;
                if (SectionPosition.a(i2) != this.aX.h || SectionPosition.a(k2) != this.aX.i) {
                    this.aX = new ChunkCoordIntPair(this.aW);
                }
            }
            this.br.a();
            if (!this.ay && (world = this.aU) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (!this.eh()) {
                    EntityPlayer entityplayer;
                    WaypointTransmitter waypointtransmitter;
                    if (this instanceof WaypointTransmitter && (waypointtransmitter = (WaypointTransmitter)((Object)this)).gx()) {
                        worldserver.j().b(waypointtransmitter);
                    }
                    if (this instanceof EntityPlayer && (entityplayer = (EntityPlayer)this).o() && entityplayer.g != null) {
                        worldserver.j().b(entityplayer);
                    }
                }
            }
        }
    }

    public void dW() {
    }

    public Vec3D[] dX() {
        return Leashable.a(this, 0.0, 0.5, 0.5, 0.0);
    }

    public boolean dY() {
        return false;
    }

    public void a(Leashable leashable) {
    }

    public void b(Leashable leashable) {
    }

    public Vec3D u(float f2) {
        return this.p(f2).b(0.0, (double)this.bA * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        int i2 = packetplayoutspawnentity.b();
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        this.e(d0, d1, d2);
        this.b(d0, d1, d2, packetplayoutspawnentity.l(), packetplayoutspawnentity.k());
        this.e(i2);
        this.a(packetplayoutspawnentity.e());
        this.k(packetplayoutspawnentity.j());
    }

    public @Nullable ItemStack dZ() {
        return null;
    }

    public void q(boolean flag) {
        this.aJ = flag;
    }

    public boolean ea() {
        return !this.ay().a(TagsEntity.l);
    }

    public boolean eb() {
        return this.cM() > 0;
    }

    public float ec() {
        return this.aZ;
    }

    @Override
    public float ed() {
        return this.ec();
    }

    public void v(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.b("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.aZ = f2;
        }
    }

    public float ee() {
        return this.ba;
    }

    public void w(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.b("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.ba = Math.clamp(f2 % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean ef() {
        return false;
    }

    public float eg() {
        return 0.0f;
    }

    public void a(@Nullable Entity entity) {
    }

    @Override
    public final boolean eh() {
        return this.bd != null;
    }

    public @Nullable RemovalReason ei() {
        return this.bd;
    }

    @Override
    public final void c(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        if (this.bd == null) {
            this.bd = entity_removalreason;
        }
        if (this.bd.a()) {
            this.cf();
        }
        this.dn().forEach(Entity::cf);
        this.br.a(entity_removalreason);
        this.b(entity_removalreason);
    }

    public void ej() {
        this.bd = null;
    }

    @Override
    public void a(EntityInLevelCallback entityinlevelcallback) {
        this.br = entityinlevelcallback;
    }

    @Override
    public boolean ek() {
        return this.bd != null && !this.bd.b() ? false : (this.cq() ? false : !this.cr() || !this.dt());
    }

    @Override
    public boolean el() {
        return false;
    }

    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        return true;
    }

    public boolean em() {
        return false;
    }

    @Override
    public net.minecraft.world.level.World ao() {
        return this.aU;
    }

    protected void a(net.minecraft.world.level.World world) {
        this.aU = world;
    }

    public DamageSources en() {
        return this.ao().as();
    }

    public IRegistryCustom eo() {
        return this.ao().J_();
    }

    protected void a(int i2, double d0, double d1, double d2, double d3, double d4) {
        double d5 = 1.0 / (double)i2;
        double d6 = MathHelper.d(d5, this.dP(), d0);
        double d7 = MathHelper.d(d5, this.dR(), d1);
        double d8 = MathHelper.d(d5, this.dV(), d2);
        float f2 = (float)MathHelper.e(d5, (double)this.ec(), d3);
        float f1 = (float)MathHelper.d(d5, (double)this.ee(), d4);
        this.a_(d6, d7, d8);
        this.a(f2, f1);
    }

    public RandomSource ep() {
        return this.as;
    }

    public Vec3D ag() {
        EntityLiving entityliving = this.dl();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            if (this.cb()) {
                return entityhuman.ag();
            }
        }
        return this.dN();
    }

    public Vec3D ah() {
        EntityLiving entityliving = this.dl();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            if (this.cb()) {
                return entityhuman.ah();
            }
        }
        return this.bF;
    }

    public @Nullable ItemStack eq() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> er() {
        return this.aP.j();
    }

    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.h);
        this.a(datacomponentgetter, DataComponents.b);
    }

    public final void c(ItemStack itemstack) {
        this.a(itemstack.a());
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return (T)(datacomponenttype == DataComponents.h ? Entity.c(datacomponenttype, this.as()) : (datacomponenttype == DataComponents.b ? Entity.c(datacomponenttype, this.bM) : null));
    }

    @Contract(value="_,!null->!null;_,_->_")
    protected static <T> @Nullable T c(DataComponentType<T> datacomponenttype, @Nullable Object object) {
        return (T)object;
    }

    public <T> void d(DataComponentType<T> datacomponenttype, T t0) {
        this.b(datacomponenttype, t0);
    }

    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.h) {
            this.b(Entity.c(DataComponents.h, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.b) {
            this.bM = Entity.c(DataComponents.b, t0);
            return true;
        }
        return false;
    }

    protected <T> boolean a(DataComponentGetter datacomponentgetter, DataComponentType<T> datacomponenttype) {
        T t0 = datacomponentgetter.a(datacomponenttype);
        return t0 != null ? this.b(datacomponenttype, t0) : false;
    }

    public ProblemReporter.f es() {
        return new a(this);
    }

    @Override
    public void a(WorldServer worldserver, DebugValueSource.a debugvaluesource_a) {
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    private record c(Vec3D a, Vec3D b, Optional<Vec3D> c) {
        public c(Vec3D vec3d, Vec3D vec3d1, Vec3D vec3d2) {
            this(vec3d, vec3d1, Optional.of(vec3d2));
        }

        public c(Vec3D vec3d, Vec3D vec3d1) {
            this(vec3d, vec3d1, Optional.empty());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "from;to;axisDependentOriginalMovement", "a", "b", "c"}, this, o2);
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private record a(Entity a) implements ProblemReporter.f
    {
        @Override
        public String get() {
            return this.a.toString();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "entity", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "entity", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "entity", "a"}, this, o2);
        }
    }
}

