/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugBrainDump;
import net.minecraft.util.debug.DebugGoalInfo;
import net.minecraft.util.debug.DebugPathInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int r = 1;
    private static final BaseBlockPosition e = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> cu = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float s = 0.15f;
    public static final float t = 0.1087f;
    public static final float cc = 3.0f;
    public static final float cd = 0.55f;
    public static final float ce = 0.5f;
    public static final float cf = 0.25f;
    public static final int cg = 2;
    private static final double cv = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean cw = false;
    private static final boolean cx = false;
    private static final boolean cy = false;
    private static final boolean cz = false;
    protected static final MinecraftKey ch = MinecraftKey.b("random_spawn_bonus");
    public static final String ci = "drop_chances";
    public static final String cj = "LeftHanded";
    public static final String ck = "CanPickUpLoot";
    public static final String cl = "NoAI";
    public int cm;
    protected int cn;
    protected ControllerLook co;
    protected ControllerMove cp;
    protected ControllerJump cq;
    private final EntityAIBodyControl cA;
    protected NavigationAbstract cr;
    public PathfinderGoalSelector cs;
    public PathfinderGoalSelector ct;
    private @Nullable EntityLiving cB;
    private final EntitySenses cC;
    private DropChances cD = DropChances.d;
    private boolean cE = false;
    private boolean cF = false;
    private final Map<PathType, Float> cG = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> cH = Optional.empty();
    public long cI;
    private @Nullable Leashable.a cJ;
    private BlockPosition cK = BlockPosition.c;
    private int cL = -1;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entitytypes, World world) {
        super((EntityTypes<? extends EntityLiving>)entitytypes, world);
        this.cs = new PathfinderGoalSelector();
        this.ct = new PathfinderGoalSelector();
        this.co = new ControllerLook(this);
        this.cp = new ControllerMove(this);
        this.cq = new ControllerJump(this);
        this.cA = this.I();
        this.cr = this.b(world);
        this.cC = new EntitySenses(this);
        if (world instanceof WorldServer) {
            this.D();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.cF = persistenceRequired;
    }

    protected void D() {
    }

    public static AttributeProvider.Builder E() {
        return EntityLiving.ex().a(GenericAttributes.o, 16.0);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean F() {
        return false;
    }

    public float a(PathType pathtype) {
        EntityInsentient entityinsentient1;
        Entity entity = this.dA();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).F() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.cG.get((Object)pathtype);
        return ofloat == null ? pathtype.a() : ofloat.floatValue();
    }

    public void a(PathType pathtype, float f2) {
        this.cG.put(pathtype, Float.valueOf(f2));
    }

    public void G() {
    }

    public void H() {
    }

    protected EntityAIBodyControl I() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook J() {
        return this.co;
    }

    public ControllerMove K() {
        Entity entity = this.dA();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.K();
        }
        return this.cp;
    }

    public ControllerJump L() {
        return this.cq;
    }

    public NavigationAbstract N() {
        Entity entity = this.dA();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.N();
        }
        return this.cr;
    }

    @Override
    public @Nullable EntityLiving dl() {
        Entity entity = this.do();
        if (!this.gG() && entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient1 = (EntityInsentient)entity;
            if (entity.ct()) {
                EntityInsentient entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses P() {
        return this.cC;
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.cB;
    }

    protected final @Nullable EntityLiving Q() {
        return this.ev().c(MemoryModuleType.p).orElse(null);
    }

    public void g(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.ag_() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.ag_() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.ag_().cb() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.ao().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.cB = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> entitytypes) {
        return entitytypes != EntityTypes.ah;
    }

    public boolean g(ItemStack itemstack) {
        return false;
    }

    public void R() {
        this.c(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, (byte)0);
    }

    public int S() {
        return 80;
    }

    public void T() {
        this.b(this.W());
    }

    @Override
    public void aJ() {
        super.aJ();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("mobBaseTick");
        if (this.cb() && this.as.a(1000) < this.cm++) {
            this.k();
            this.T();
        }
        gameprofilerfiller.c();
    }

    @Override
    protected void g(DamageSource damagesource) {
        this.k();
        super.g(damagesource);
    }

    private void k() {
        this.cm = -this.S();
    }

    @Override
    protected int f(WorldServer worldserver) {
        if (this.cn > 0) {
            int i2 = this.cn;
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                ItemStack itemstack;
                if (!enumitemslot.g() || (itemstack = this.a(enumitemslot)).f() || !(this.cD.b(enumitemslot) <= 1.0f)) continue;
                i2 += 1 + this.as.a(3);
            }
            return i2;
        }
        return this.cn;
    }

    public void U() {
        if (this.ao().B_()) {
            this.fu();
        } else {
            this.ao().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 20) {
            this.U();
        } else {
            super.b(b0);
        }
    }

    @Override
    public void g() {
        super.g();
        if (!this.ao().B_() && this.at % 5 == 0) {
            this.V();
        }
    }

    protected void V() {
        boolean flag = !(this.dl() instanceof EntityInsentient);
        boolean flag1 = !(this.dz() instanceof AbstractBoat);
        this.cs.a(PathfinderGoal.Type.a, flag);
        this.cs.a(PathfinderGoal.Type.c, flag && flag1);
        this.cs.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected void D(float f2) {
        this.cA.a();
    }

    protected @Nullable SoundEffect W() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.W();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a(ck, this.gn());
        valueoutput.a("PersistenceRequired", this.cF);
        if (!this.cD.equals(DropChances.d)) {
            valueoutput.a(ci, DropChances.e, this.cD);
        }
        this.a(valueoutput, this.cJ);
        if (this.gF()) {
            valueoutput.a("home_radius", this.cL);
            valueoutput.a("home_pos", BlockPosition.a, this.cK);
        }
        valueoutput.a(cj, this.gH());
        this.cH.ifPresent(resourcekey -> valueoutput.a("DeathLootTable", LootTable.a, resourcekey));
        if (this.cI != 0L) {
            valueoutput.a("DeathLootTableSeed", this.cI);
        }
        if (this.gG()) {
            valueoutput.a(cl, this.gG());
        }
        valueoutput.a("Bukkit.Aware", this.aware);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        boolean canPickUpLoot = valueinput.a(ck, false);
        if (EntityInsentient.isLevelAtLeast(valueinput, 1) || canPickUpLoot) {
            this.b_(canPickUpLoot);
        }
        boolean persistenceRequired = valueinput.a("PersistenceRequired", false);
        if (EntityInsentient.isLevelAtLeast(valueinput, 1) || persistenceRequired) {
            this.cF = persistenceRequired;
        }
        this.cD = valueinput.a(ci, DropChances.e).orElse(DropChances.d);
        this.b(valueinput);
        this.cL = valueinput.a("home_radius", -1);
        if (this.cL >= 0) {
            this.cK = valueinput.a("home_pos", BlockPosition.a).orElse(BlockPosition.c);
        }
        this.v(valueinput.a(cj, false));
        this.cH = valueinput.a("DeathLootTable", LootTable.a);
        this.cI = valueinput.a("DeathLootTableSeed", 0L);
        this.u(valueinput.a(cl, false));
        this.aware = valueinput.a("Bukkit.Aware", this.aware);
    }

    @Override
    protected void b(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.b(worldserver, damagesource, flag);
        this.cH = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> er() {
        return this.cH.isPresent() ? this.cH : super.er();
    }

    @Override
    public long fc() {
        return this.cI;
    }

    public void I(float f2) {
        this.bP = f2;
    }

    public void J(float f2) {
        this.bO = f2;
    }

    public void K(float f2) {
        this.bN = f2;
    }

    @Override
    public void C(float f2) {
        super.C(f2);
        this.I(f2);
    }

    public void X() {
        this.N().n();
        this.K(0.0f);
        this.J(0.0f);
        this.C(0.0f);
        this.m(0.0, 0.0, 0.0);
        this.gM();
    }

    @Override
    public void d_() {
        super.d_();
        if (this.ay().a(TagsEntity.e)) {
            this.p();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("looting");
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.gn() && this.cb() && !this.bJ && worldserver.U().a(GameRules.F).booleanValue()) {
                BaseBlockPosition baseblockposition = this.Z();
                for (EntityItem entityitem : this.ao().a(EntityItem.class, this.dj().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()))) {
                    if (entityitem.eh() || entityitem.e().f() || entityitem.n() || !this.c(worldserver, entityitem.e())) continue;
                    this.a(worldserver, entityitem);
                }
            }
        }
        gameprofilerfiller.c();
    }

    protected EnumItemSlot Y() {
        return EnumItemSlot.f;
    }

    private void p() {
        if (this.cb() && this.gL()) {
            EnumItemSlot enumitemslot = this.Y();
            ItemStack itemstack = this.a(enumitemslot);
            if (!itemstack.f()) {
                if (itemstack.m()) {
                    Item item = itemstack.h();
                    itemstack.b(itemstack.o() + this.as.a(2));
                    if (itemstack.o() >= itemstack.p()) {
                        this.a(item, enumitemslot);
                        this.a(enumitemslot, ItemStack.l);
                    }
                }
            } else {
                this.e(8.0f);
            }
        }
    }

    private boolean gL() {
        if (!this.ao().B_() && this.ao().c().a(EnvironmentAttributes.P, this.dI()).booleanValue()) {
            boolean flag;
            float f2 = this.bO();
            BlockPosition blockposition = BlockPosition.a(this.dP(), this.dT(), this.dV());
            boolean bl = flag = this.bA() || this.aJ || this.aK;
            if (f2 > 0.5f && this.as.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.ao().k(blockposition)) {
                return true;
            }
        }
        return false;
    }

    protected BaseBlockPosition Z() {
        return e;
    }

    protected void a(WorldServer worldserver, EntityItem entityitem) {
        ItemStack itemstack = entityitem.e();
        ItemStack itemstack1 = this.equipItemIfPossible(worldserver, itemstack.v(), entityitem);
        if (!itemstack1.f()) {
            this.a(entityitem);
            this.a((Entity)entityitem, itemstack1.N());
            itemstack.h(itemstack1.N());
            if (itemstack.f()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer worldserver, ItemStack itemstack) {
        return this.equipItemIfPossible(worldserver, itemstack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer worldserver, ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = this.f(itemstack);
        if (!this.a(itemstack, enumitemslot)) {
            return ItemStack.l;
        }
        ItemStack itemstack1 = this.a(enumitemslot);
        boolean flag = this.a(itemstack, itemstack1, enumitemslot);
        if (enumitemslot.f() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.a(enumitemslot);
            flag = itemstack1.f();
        }
        boolean bl = canPickup = flag && this.h(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.cD.b(enumitemslot);
            if (!itemstack1.f() && (double)Math.max(this.as.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.a(worldserver, itemstack1);
                this.forceDrops = false;
            }
            ItemStack itemstack2 = enumitemslot.a(itemstack);
            this.b(enumitemslot, itemstack2);
            return itemstack2;
        }
        return ItemStack.l;
    }

    protected void b(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.a(enumitemslot, itemstack);
        this.g(enumitemslot);
        this.cF = true;
    }

    protected boolean b_(EntityHuman entityhuman) {
        return !this.cr();
    }

    public void g(EnumItemSlot enumitemslot) {
        this.cD = this.cD.a(enumitemslot);
    }

    protected boolean a(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        return itemstack1.f() ? true : (enumitemslot.f() ? this.b(itemstack, itemstack1, enumitemslot) : (enumitemslot == EnumItemSlot.a ? this.c(itemstack, itemstack1, enumitemslot) : false));
    }

    private boolean b(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        if (EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.F)) {
            return false;
        }
        double d0 = this.a(itemstack, GenericAttributes.b, enumitemslot);
        double d1 = this.a(itemstack1, GenericAttributes.b, enumitemslot);
        double d2 = this.a(itemstack, GenericAttributes.c, enumitemslot);
        double d3 = this.a(itemstack1, GenericAttributes.c, enumitemslot);
        return d0 != d1 ? d0 > d1 : (d2 != d3 ? d2 > d3 : this.b(itemstack, itemstack1));
    }

    private boolean c(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        double d1;
        double d0;
        TagKey<Item> tagkey = this.aa();
        if (tagkey != null) {
            if (itemstack1.a(tagkey) && !itemstack.a(tagkey)) {
                return false;
            }
            if (!itemstack1.a(tagkey) && itemstack.a(tagkey)) {
                return true;
            }
        }
        return (d0 = this.a(itemstack, GenericAttributes.d, enumitemslot)) != (d1 = this.a(itemstack1, GenericAttributes.d, enumitemslot)) ? d0 > d1 : this.b(itemstack, itemstack1);
    }

    private double a(ItemStack itemstack, Holder<AttributeBase> holder, EnumItemSlot enumitemslot) {
        double d0 = this.fw().b(holder) ? this.j(holder) : 0.0;
        ItemAttributeModifiers itemattributemodifiers = itemstack.a(DataComponents.r, ItemAttributeModifiers.a);
        return itemattributemodifiers.a(holder, d0, enumitemslot);
    }

    public boolean b(ItemStack itemstack, ItemStack itemstack1) {
        int j2;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = itemstack1.a(DataComponents.o, ItemEnchantments.a).b();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = itemstack.a(DataComponents.o, ItemEnchantments.a).b();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int i2 = itemstack.o();
        return i2 != (j2 = itemstack1.o()) ? i2 < j2 : itemstack.c(DataComponents.h) && !itemstack1.c(DataComponents.h);
    }

    public boolean h(ItemStack itemstack) {
        return true;
    }

    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return this.h(itemstack);
    }

    public @Nullable TagKey<Item> aa() {
        return null;
    }

    public boolean i(double d0) {
        return true;
    }

    public boolean ab() {
        return this.cq();
    }

    @Override
    public void dW() {
        if (this.ao().av() == EnumDifficulty.a && !this.ay().s()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.gA() && !this.ab()) {
            EntityHuman entity = this.ao().a((Entity)this, -1.0);
            if (entity != null) {
                int i2;
                int j2;
                double d0 = entity.g(this);
                if (d0 > (double)(j2 = (i2 = this.ay().f().f()) * i2) && this.i(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                int k2 = this.ay().f().g();
                int l2 = k2 * k2;
                if (this.bK > 600 && this.as.a(800) == 0 && d0 > (double)l2 && this.i(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else if (d0 < (double)l2) {
                    this.bK = 0;
                }
            }
        } else {
            this.bK = 0;
        }
    }

    @Override
    protected final void fV() {
        ++this.bK;
        if (!this.aware) {
            return;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("sensing");
        this.cC.a();
        gameprofilerfiller.c();
        int i2 = this.at + this.aA();
        if (i2 % 2 != 0 && this.at > 1) {
            gameprofilerfiller.a("targetSelector");
            this.ct.a(false);
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.cs.a(false);
            gameprofilerfiller.c();
        } else {
            gameprofilerfiller.a("targetSelector");
            this.ct.a();
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.cs.a();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("navigation");
        this.cr.d();
        gameprofilerfiller.c();
        gameprofilerfiller.a("mob tick");
        this.a((WorldServer)this.ao());
        gameprofilerfiller.c();
        gameprofilerfiller.a("controls");
        gameprofilerfiller.a("move");
        this.cp.a();
        gameprofilerfiller.b("look");
        this.co.a();
        gameprofilerfiller.b("jump");
        this.cq.b();
        gameprofilerfiller.c();
        gameprofilerfiller.c();
    }

    protected void a(WorldServer worldserver) {
    }

    public int ac() {
        return 40;
    }

    public int ae() {
        return 75;
    }

    protected void af() {
        float f2 = this.ae();
        float f1 = this.cS();
        float f22 = MathHelper.f(this.bC - f1);
        float f3 = MathHelper.a(MathHelper.f(this.bC - f1), -f2, f2);
        float f4 = f1 + f22 - f3;
        this.r(f4);
    }

    public int ai() {
        return 10;
    }

    public void a(Entity entity, float f2, float f1) {
        double d2;
        double d0 = entity.dP() - this.dP();
        double d1 = entity.dV() - this.dV();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d2 = entityliving.dT() - this.dT();
        } else {
            d2 = (entity.dj().b + entity.dj().e) / 2.0 - this.dT();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f22 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.w(this.a(this.ee(), f3, f1));
        this.v(this.a(this.ec(), f22, f2));
    }

    private float a(float f2, float f1, float f22) {
        float f3 = MathHelper.f(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.e();
        return EntitySpawnReason.a(entityspawnreason) || generatoraccess.a_(blockposition1).a((IBlockAccess)generatoraccess, blockposition1, entitytypes);
    }

    public boolean a(GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason) {
        return true;
    }

    public boolean a(IWorldReader iworldreader) {
        return !iworldreader.d(this.dj()) && iworldreader.f(this);
    }

    public int aj() {
        return 4;
    }

    public boolean q(int i2) {
        return false;
    }

    @Override
    public int cW() {
        if (this.ag_() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eZ() - this.fq() * 0.33f);
        if ((i2 -= (3 - this.ao().av().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    public ItemStack ak() {
        return this.a(EnumItemSlot.g);
    }

    public boolean al() {
        return this.i(EnumItemSlot.h);
    }

    public boolean am() {
        return this.i(EnumItemSlot.g);
    }

    private boolean i(EnumItemSlot enumitemslot) {
        return this.d(enumitemslot) && this.a(this.a(enumitemslot), enumitemslot);
    }

    public void i(ItemStack itemstack) {
        this.b(EnumItemSlot.g, itemstack);
    }

    public IInventory h(final EnumItemSlot enumitemslot) {
        return new ContainerSingleItem(){
            public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
            private int maxStack = 99;

            @Override
            public ItemStack g() {
                return EntityInsentient.this.a(enumitemslot);
            }

            @Override
            public void b(ItemStack itemstack) {
                EntityInsentient.this.a(enumitemslot, itemstack);
                if (!itemstack.f()) {
                    EntityInsentient.this.g(enumitemslot);
                    EntityInsentient.this.gz();
                }
            }

            @Override
            public void e() {
            }

            @Override
            public boolean a(EntityHuman entityhuman) {
                return entityhuman.dz() == EntityInsentient.this || entityhuman.b((Entity)EntityInsentient.this, 4.0);
            }

            @Override
            public List<ItemStack> getContents() {
                return Arrays.asList(this.g());
            }

            @Override
            public void onOpen(CraftHumanEntity who) {
                this.transaction.add(who);
            }

            @Override
            public void onClose(CraftHumanEntity who) {
                this.transaction.remove(who);
            }

            @Override
            public List<HumanEntity> getViewers() {
                return this.transaction;
            }

            @Override
            public int ap_() {
                return this.maxStack;
            }

            @Override
            public void setMaxStackSize(int size) {
                this.maxStack = size;
            }

            @Override
            public InventoryHolder getOwner() {
                return (InventoryHolder)EntityInsentient.this.getBukkitEntity();
            }

            @Override
            public Location getLocation() {
                return EntityInsentient.this.getBukkitEntity().getLocation();
            }
        };
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            float f2 = this.cD.b(enumitemslot);
            if (f2 == 0.0f) continue;
            boolean flag1 = this.cD.c(enumitemslot);
            Entity entity = damagesource.d();
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                World world = this.ao();
                if (world instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world;
                    f2 = EnchantmentManager.a(worldserver1, entityliving, damagesource, f2);
                }
            }
            if (itemstack.f() || EnchantmentManager.a(itemstack, EnchantmentEffectComponents.E) || !flag && !flag1 || !(this.as.i() < f2)) continue;
            if (!flag1 && itemstack.m()) {
                itemstack.b(itemstack.p() - this.as.a(1 + this.as.a(Math.max(itemstack.p() - 3, 1))));
            }
            this.a(worldserver, itemstack);
            this.a(enumitemslot, ItemStack.l);
        }
    }

    public DropChances an() {
        return this.cD;
    }

    public void b(WorldServer worldserver) {
        this.a(worldserver, (ItemStack itemstack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer worldserver, Predicate<ItemStack> predicate) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.f()) continue;
            if (!predicate.test(itemstack)) {
                set.add(enumitemslot);
                continue;
            }
            if (!this.cD.c(enumitemslot)) continue;
            this.a(enumitemslot, ItemStack.l);
            this.a(worldserver, itemstack);
        }
        return set;
    }

    private LootParams h(WorldServer worldserver) {
        return new LootParams.a(worldserver).a(LootContextParameters.h, this.dI()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmenttable) {
        this.a(equipmenttable.a(), equipmenttable.b());
    }

    public void a(ResourceKey<LootTable> resourcekey, Map<EnumItemSlot, Float> map) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(resourcekey, this.h(worldserver), map);
        }
    }

    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.15f * difficultydamagescaler.d()) {
            int i2 = randomsource.a(3);
            int j2 = 1;
            while ((float)j2 <= 3.0f) {
                if (randomsource.i() < 0.1087f) {
                    ++i2;
                }
                ++j2;
            }
            float f2 = this.ao().av() == EnumDifficulty.d ? 0.1f : 0.25f;
            boolean flag = true;
            for (EnumItemSlot enumitemslot : cu) {
                Item item;
                ItemStack itemstack = this.a(enumitemslot);
                if (!flag && randomsource.i() < f2) break;
                flag = false;
                if (!itemstack.f() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    public static @Nullable Item a(EnumItemSlot enumitemslot, int i2) {
        switch (enumitemslot) {
            case f: {
                if (i2 == 0) {
                    return Items.re;
                }
                if (i2 == 1) {
                    return Items.ri;
                }
                if (i2 == 2) {
                    return Items.ry;
                }
                if (i2 == 3) {
                    return Items.rm;
                }
                if (i2 == 4) {
                    return Items.rq;
                }
                if (i2 == 5) {
                    return Items.ru;
                }
            }
            case e: {
                if (i2 == 0) {
                    return Items.rf;
                }
                if (i2 == 1) {
                    return Items.rj;
                }
                if (i2 == 2) {
                    return Items.rz;
                }
                if (i2 == 3) {
                    return Items.rn;
                }
                if (i2 == 4) {
                    return Items.rr;
                }
                if (i2 == 5) {
                    return Items.rv;
                }
            }
            case d: {
                if (i2 == 0) {
                    return Items.rg;
                }
                if (i2 == 1) {
                    return Items.rk;
                }
                if (i2 == 2) {
                    return Items.rA;
                }
                if (i2 == 3) {
                    return Items.ro;
                }
                if (i2 == 4) {
                    return Items.rs;
                }
                if (i2 == 5) {
                    return Items.rw;
                }
            }
            case c: {
                if (i2 == 0) {
                    return Items.rh;
                }
                if (i2 == 1) {
                    return Items.rl;
                }
                if (i2 == 2) {
                    return Items.rB;
                }
                if (i2 == 3) {
                    return Items.rp;
                }
                if (i2 == 4) {
                    return Items.rt;
                }
                if (i2 != 5) break;
                return Items.rx;
            }
        }
        return null;
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.b(worldaccess, randomsource, difficultydamagescaler);
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(worldaccess, randomsource, enumitemslot, difficultydamagescaler);
        }
    }

    protected void b(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, EnumItemSlot.a, randomsource, 0.25f, difficultydamagescaler);
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, EnumItemSlot enumitemslot, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, enumitemslot, randomsource, 0.5f, difficultydamagescaler);
    }

    private void a(WorldAccess worldaccess, EnumItemSlot enumitemslot, RandomSource randomsource, float f2, DifficultyDamageScaler difficultydamagescaler) {
        ItemStack itemstack = this.a(enumitemslot);
        if (!itemstack.f() && randomsource.i() < f2 * difficultydamagescaler.d()) {
            EnchantmentManager.a(itemstack, worldaccess.J_(), VanillaEnchantmentProviders.a, difficultydamagescaler, randomsource);
            this.a(enumitemslot, itemstack);
        }
    }

    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        AttributeModifiable attributemodifiable = Objects.requireNonNull(this.h(GenericAttributes.o));
        if (!attributemodifiable.b(ch)) {
            attributemodifiable.d(new AttributeModifier(ch, randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.v(randomsource.i() < 0.05f);
        return groupdataentity;
    }

    public void gz() {
        this.cF = true;
    }

    @Override
    public void a(EnumItemSlot enumitemslot, float f2) {
        this.cD = this.cD.a(enumitemslot, f2);
    }

    @Override
    public boolean gn() {
        return this.cE;
    }

    public void b_(boolean flag) {
        this.cE = flag;
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return this.gn();
    }

    public boolean gA() {
        return this.cF;
    }

    @Override
    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        if (!this.cb()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult enuminteractionresult = this.c(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        EnumInteractionResult enuminteractionresult1 = super.a(entityhuman, enumhand);
        if (enuminteractionresult1 != EnumInteractionResult.e) {
            return enuminteractionresult1;
        }
        enuminteractionresult = this.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.xa) && (enuminteractionresult = itemstack.a(entityhuman, (EntityLiving)this, enumhand)).a()) {
            return enuminteractionresult;
        }
        Item item = itemstack.h();
        if (item instanceof ItemMonsterEgg) {
            ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)item;
            if (this.ao() instanceof WorldServer) {
                Optional<EntityInsentient> optional = itemmonsteregg.a(entityhuman, this, this.ay(), (WorldServer)this.ao(), this.dI(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(entityhuman, (EntityInsentient)entityinsentient));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
    }

    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        int i2 = itemstack.N();
        UseRemainder useremainder = itemstack.a(DataComponents.A);
        itemstack.a(1, (EntityLiving)entityhuman);
        if (useremainder != null) {
            boolean flag = entityhuman.gv();
            Objects.requireNonNull(entityhuman);
            ItemStack itemstack1 = useremainder.a(itemstack, i2, flag, entityhuman::b);
            entityhuman.a(enumhand, itemstack1);
        }
    }

    public boolean gB() {
        return this.a(this.dK());
    }

    public boolean a(BlockPosition blockposition) {
        return this.cL == -1 ? true : this.cK.j(blockposition) < (double)(this.cL * this.cL);
    }

    public boolean a(Vec3D vec3d) {
        return this.cL == -1 ? true : this.cK.b(vec3d) < (double)(this.cL * this.cL);
    }

    public void a(BlockPosition blockposition, int i2) {
        this.cK = blockposition;
        this.cL = i2;
    }

    public BlockPosition gC() {
        return this.cK;
    }

    public int gD() {
        return this.cL;
    }

    public void gE() {
        this.cL = -1;
    }

    public boolean gF() {
        return this.cL != -1;
    }

    public <T extends EntityInsentient> @Nullable T a(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.a<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, entityspawnreason, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public <T extends EntityInsentient> @Nullable T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.eh()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.ao(), entityspawnreason);
        if (t0 == null) {
            return null;
        }
        conversionparams.a().a(this, t0, conversionparams);
        conversionparams_a.finalizeConversion(t0);
        World world = this.ao();
        if (transformReason == null) {
            return (T)t0;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        conversionparams.a().postConvert(this, t0, conversionparams);
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.addFreshEntity(t0, spawnReason);
        }
        if (conversionparams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)t0;
    }

    public <T extends EntityInsentient> @Nullable T a(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.a<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public <T extends EntityInsentient> @Nullable T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.convertTo(entitytypes, conversionparams, EntitySpawnReason.i, conversionparams_a, transformReason, spawnReason);
    }

    @Override
    public @Nullable Leashable.a T_() {
        return this.cJ;
    }

    private void gM() {
        if (this.cJ != null) {
            this.cJ.d = 0.0;
        }
    }

    @Override
    public void a(@Nullable Leashable.a leashable_a) {
        this.cJ = leashable_a;
    }

    @Override
    public void s() {
        if (this.T_() == null) {
            this.gE();
        }
    }

    @Override
    public void y() {
        Leashable.super.y();
        this.cs.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean aj_() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean flag, boolean flag1) {
        boolean flag2 = super.a(entity, flag, flag1);
        if (flag2 && this.S_()) {
            this.ao().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.o();
        }
        return flag2;
    }

    @Override
    public boolean dy() {
        return super.dy() && !this.gG();
    }

    public void u(boolean flag) {
        byte b0 = this.az.a(a);
        this.az.a(a, flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void v(boolean flag) {
        byte b0 = this.az.a(a);
        this.az.a(a, flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void w(boolean flag) {
        byte b0 = this.az.a(a);
        this.az.a(a, flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean gG() {
        return (this.az.a(a) & 1) != 0;
    }

    public boolean gH() {
        return (this.az.a(a) & 2) != 0;
    }

    public boolean gI() {
        return (this.az.a(a) & 4) != 0;
    }

    public void a_(boolean flag) {
    }

    @Override
    public EnumMainHand at() {
        return this.gH() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean h(EntityLiving entityliving) {
        double d1;
        double d0;
        AttackRange attackrange = this.fA().a(DataComponents.F);
        if (attackrange == null) {
            d0 = cv;
            d1 = 0.0;
        } else {
            d0 = attackrange.b(this);
            d1 = attackrange.a(this);
        }
        AxisAlignedBB axisalignedbb = entityliving.fh();
        return this.j(d0).c(axisalignedbb) && (d1 <= 0.0 || !this.j(d1).c(axisalignedbb));
    }

    protected AxisAlignedBB j(double d0) {
        AxisAlignedBB axisalignedbb;
        Entity entity = this.dz();
        if (entity != null) {
            AxisAlignedBB axisalignedbb1 = entity.dj();
            AxisAlignedBB axisalignedbb2 = this.dj();
            axisalignedbb = new AxisAlignedBB(Math.min(axisalignedbb2.a, axisalignedbb1.a), axisalignedbb2.b, Math.min(axisalignedbb2.c, axisalignedbb1.c), Math.max(axisalignedbb2.d, axisalignedbb1.d), axisalignedbb2.e, Math.max(axisalignedbb2.f, axisalignedbb1.f));
        } else {
            axisalignedbb = this.dj();
        }
        return axisalignedbb.c(d0, 0.0, d0);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        float f2 = (float)this.i(GenericAttributes.d);
        ItemStack itemstack = this.eq();
        DamageSource damagesource = itemstack.a((EntityLiving)this, () -> this.en().b(this));
        f2 = EnchantmentManager.a(worldserver, itemstack, entity, damagesource, f2);
        f2 += itemstack.h().a(entity, f2, damagesource);
        Vec3D vec3d = entity.dN();
        boolean flag = entity.a(worldserver, damagesource, f2);
        if (flag) {
            this.a(entity, this.b(entity, damagesource), vec3d);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                itemstack.a(entityliving, (EntityLiving)this);
            }
            EnchantmentManager.a(worldserver, entity, damagesource);
            this.C(entity);
            this.fN();
        }
        this.fi();
        return flag;
    }

    @Override
    protected void c(TagKey<FluidType> tagkey) {
        if (this.N().p()) {
            super.c(tagkey);
        } else {
            this.k(this.dN().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gJ() {
        this.d((PathfinderGoal pathfindergoal) -> true);
        this.ev().g();
    }

    public void d(Predicate<PathfinderGoal> predicate) {
        this.cs.a(predicate);
    }

    @Override
    protected void cV() {
        super.cV();
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.f()) continue;
            itemstack.e(0);
        }
    }

    @Override
    public @Nullable ItemStack dZ() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.ay());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }

    @Override
    protected void a(Holder<AttributeBase> holder) {
        super.a(holder);
        if (holder.a(GenericAttributes.o) || holder.a(GenericAttributes.G)) {
            this.N().f();
        }
    }

    @Override
    public void a(WorldServer worldserver, DebugValueSource.a debugvaluesource_a) {
        debugvaluesource_a.a(DebugSubscriptions.f, () -> {
            PathEntity pathentity = this.N().j();
            return pathentity != null && pathentity.k() != null ? new DebugPathInfo(pathentity.n(), this.N().q()) : null;
        });
        debugvaluesource_a.a(DebugSubscriptions.e, () -> {
            Set<PathfinderGoalWrapped> set = this.cs.b();
            ArrayList<DebugGoalInfo.a> list = new ArrayList<DebugGoalInfo.a>(set.size());
            set.forEach(pathfindergoalwrapped -> list.add(new DebugGoalInfo.a(pathfindergoalwrapped.i(), pathfindergoalwrapped.h(), pathfindergoalwrapped.k().getClass().getSimpleName())));
            return new DebugGoalInfo(list);
        });
        if (!this.ca.i()) {
            debugvaluesource_a.a(DebugSubscriptions.c, () -> DebugBrainDump.a(worldserver, this));
        }
    }

    public float gK() {
        return 1.0f;
    }
}

