/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    public static final String u = "attributes";
    public static final String aN = "sleeping_pos";
    public static final String aO = "equipment";
    public static final String aP = "Brain";
    public static final String aQ = "FallFlying";
    public static final String aR = "HurtTime";
    public static final String aS = "DeathTime";
    public static final String aT = "HurtByTimestamp";
    public static final String aU = "Health";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier e = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int aV = 98;
    public static final int aW = 100;
    public static final int aX = 105;
    public static final int aY = 106;
    public static final int aZ = 100;
    private static final int r = 40;
    public static final double ba = 0.003;
    public static final double bb = 0.08;
    public static final int bc = 20;
    protected static final float bd = 0.98f;
    private static final int s = 10;
    private static final int t = 2;
    public static final float be = 0.42f;
    protected static final float bf = 0.4f;
    protected static final int bg = 20;
    private static final double cc = 128.0;
    protected static final int bh = 1;
    protected static final int bi = 2;
    public static final int bj = 4;
    protected static final DataWatcherObject<Byte> bk = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> cd = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> ce = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> ci = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int cj = 15;
    protected static final EntitySize bl = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float bm = 0.5f;
    public static final float bn = 0.5f;
    private static final float ck = 0.04f;
    public static final Predicate<EntityLiving> bo = entityliving -> {
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            ItemStack itemstack = entityhuman.a(EnumItemSlot.f);
            return !itemstack.a(TagsItem.cP);
        }
        return true;
    };
    private static final Dynamic<?> cl = new Dynamic((DynamicOps)JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMapBase cm;
    public CombatTracker cn = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> co = Maps.newHashMap();
    private final Map<EnumItemSlot, ItemStack> cp = SystemUtils.a(EnumItemSlot.class, (K enumitemslot) -> ItemStack.l);
    public boolean bp;
    private boolean cq = false;
    public EnumHand bq;
    public int br;
    public int bs;
    public int bt;
    public int bu;
    public int bv;
    public int bw;
    public float bx;
    public float by;
    protected int bz;
    protected int bA;
    public final WalkAnimationState bB = new WalkAnimationState();
    public float bC;
    public float bD;
    public float bE;
    public float bF;
    public final ElytraAnimationState bG = new ElytraAnimationState(this);
    public @Nullable EntityReference<EntityHuman> bH;
    protected int bI;
    protected boolean bJ;
    protected int bK;
    public float bL;
    protected boolean bM;
    public float bN;
    public float bO;
    public float bP;
    protected InterpolationHandler bQ = new InterpolationHandler(this);
    protected double bR;
    protected int bS;
    public boolean cr = true;
    public @Nullable EntityReference<EntityLiving> cs;
    public int ct;
    private @Nullable EntityLiving cu;
    private int cv;
    private float cw;
    private int cx;
    private float cy;
    protected ItemStack bT;
    public int bU;
    protected int bV;
    private long cz;
    private BlockPosition cA;
    private Optional<BlockPosition> cB;
    private @Nullable DamageSource cC;
    private long cD;
    protected int bW;
    protected float bX;
    protected @Nullable ItemStack bY;
    protected @Nullable Object2LongMap<Entity> bZ;
    private float cE;
    private float cF;
    protected BehaviorController<?> ca;
    protected boolean cG;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> cH;
    public final EntityEquipment cb;
    private Waypoint.a cI;
    public int expToDrop;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public int invulnerableDuration = 20;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();

    @Override
    public float getBukkitYaw() {
        return this.cS();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bK;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entitytypes, net.minecraft.world.level.World world) {
        super(entitytypes, world);
        this.bT = ItemStack.l;
        this.cz = Integer.MIN_VALUE;
        this.cB = Optional.empty();
        this.cH = new EnumMap(EnumItemSlot.class);
        this.cI = new Waypoint.a();
        this.cm = new AttributeMapBase(AttributeDefaults.a(entitytypes));
        this.craftAttributes = new CraftAttributeMap(this.cm);
        this.az.a(cd, Float.valueOf((float)this.h(GenericAttributes.u).g()));
        this.cb = this.eu();
        this.W = true;
        this.aH();
        this.v(this.as.i() * ((float)Math.PI * 2));
        this.bE = this.ec();
        this.ca = this.a(cl);
    }

    @Override
    public @Nullable EntityLiving et() {
        return this;
    }

    @Contract(pure=true)
    protected EntityEquipment eu() {
        return new EntityEquipment();
    }

    public BehaviorController<?> ev() {
        return this.ca;
    }

    protected BehaviorController.b<?> ew() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.ew().a(dynamic);
    }

    @Override
    public void c(WorldServer worldserver) {
        this.a(worldserver, this.en().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entitytypes) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(bk, (byte)0);
        datawatcher_a.a(ce, List.of());
        datawatcher_a.a(cf, false);
        datawatcher_a.a(cg, 0);
        datawatcher_a.a(ch, 0);
        datawatcher_a.a(cd, Float.valueOf(1.0f));
        datawatcher_a.a(ci, Optional.empty());
    }

    public static AttributeProvider.Builder ex() {
        return AttributeProvider.a().a(GenericAttributes.u).a(GenericAttributes.r).a(GenericAttributes.x).a(GenericAttributes.b).a(GenericAttributes.c).a(GenericAttributes.t).a(GenericAttributes.D).a(GenericAttributes.A).a(GenericAttributes.p).a(GenericAttributes.z).a(GenericAttributes.m).a(GenericAttributes.q).a(GenericAttributes.y).a(GenericAttributes.i).a(GenericAttributes.k).a(GenericAttributes.H).a(GenericAttributes.w).a(GenericAttributes.e).a(GenericAttributes.j).a(GenericAttributes.I);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        net.minecraft.world.level.World world;
        if (!this.by()) {
            this.bH();
        }
        if ((world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (flag && this.an > 0.0) {
                this.b(worldserver, blockposition);
                double d1 = Math.max(0, MathHelper.c(this.i(this.an)));
                if (d1 > 0.0 && !iblockdata.l()) {
                    double d2 = this.dP();
                    double d3 = this.dR();
                    double d4 = this.dV();
                    BlockPosition blockposition1 = this.dK();
                    if (blockposition.u() != blockposition1.u() || blockposition.w() != blockposition1.w()) {
                        double d5 = d2 - (double)blockposition.u() - 0.5;
                        double d6 = d4 - (double)blockposition.w() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)blockposition.u() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)blockposition.w() + 0.5 + d6 / d7 * 0.5;
                    }
                    double d8 = Math.min((double)0.2f + d1 / 15.0, 2.5);
                    int i2 = (int)(150.0 * d8);
                    if (this instanceof EntityPlayer) {
                        worldserver.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, iblockdata), false, false, d2, d3, d4, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        worldserver.a(new ParticleParamBlock(Particles.b, iblockdata), d2, d3, d4, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(d0, flag, iblockdata, blockposition);
        if (flag) {
            this.cB = Optional.empty();
        }
    }

    public boolean ey() {
        return this.ay().a(TagsEntity.n);
    }

    public float b(float f2) {
        return MathHelper.h(f2, this.cF, this.cE);
    }

    public boolean ez() {
        return this.dN().b() < (double)1.0E-5f && this.bB();
    }

    @Override
    public void aJ() {
        EntityLiving entityliving;
        net.minecraft.world.level.World world;
        WorldServer worldserver;
        this.bx = this.by;
        if (this.ay) {
            this.gp().ifPresent(this::a);
        }
        if ((worldserver = (WorldServer)this.ao()) instanceof WorldServer) {
            WorldServer worldserver1 = worldserver;
            EnchantmentManager.b(worldserver1, this);
        }
        super.aJ();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("livingEntityBaseTick");
        if (this.cb() && (world = this.ao()) instanceof WorldServer) {
            double d1;
            double d0;
            worldserver = (WorldServer)world;
            boolean flag = this instanceof EntityHuman;
            if (this.cc()) {
                this.a(worldserver, this.en().g(), 1.0f);
            } else if (flag && !worldserver.w().a(this.dj()) && (d0 = worldserver.w().a(this) + worldserver.w().o()) < 0.0 && (d1 = worldserver.w().p()) > 0.0) {
                this.a(worldserver, this.en().x(), (float)Math.max(1, MathHelper.c(-d0 * d1)));
            }
            if (((Entity)this).a(TagsFluid.a) && !worldserver.a_(BlockPosition.a(this.dP(), this.dT(), this.dV())).a(Blocks.oa)) {
                boolean flag1;
                boolean bl = flag1 = !this.ey() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gL().a);
                if (flag1) {
                    this.j(this.l(this.cK()));
                    if (this.eA()) {
                        this.j(0);
                        worldserver.a((Entity)this, (byte)67);
                        this.a(worldserver, this.en().i(), 2.0f);
                    }
                } else if (this.cK() < this.cJ() && MobEffectUtil.d(this)) {
                    this.j(this.m(this.cK()));
                }
                if (this.cq() && this.dz() != null && this.dz().cs()) {
                    this.cf();
                }
            } else if (this.cK() < this.cJ()) {
                this.j(this.m(this.cK()));
            }
            BlockPosition blockposition = this.dK();
            if (!com.google.common.base.Objects.equal((Object)this.cA, (Object)blockposition)) {
                this.cA = blockposition;
                this.b(worldserver, blockposition);
            }
        }
        if (this.bu > 0) {
            --this.bu;
        }
        if (this.ax > 0 && !(this instanceof EntityPlayer)) {
            --this.ax;
        }
        if (this.fa() && this.ao().h(this)) {
            this.eH();
        }
        if (this.bI > 0) {
            --this.bI;
        } else {
            this.bH = null;
        }
        if (this.cu != null && !this.cu.cb()) {
            this.cu = null;
        }
        if ((entityliving = this.eK()) != null) {
            if (!entityliving.cb()) {
                this.a((EntityLiving)null);
            } else if (this.at - this.ct > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.eR();
        this.bF = this.bE;
        this.bD = this.bC;
        this.ab = this.ec();
        this.ac = this.ee();
        gameprofilerfiller.c();
    }

    protected boolean eA() {
        return this.cK() <= -20;
    }

    @Override
    protected float bi() {
        return MathHelper.h((float)this.i(GenericAttributes.w), super.bi(), 1.0f);
    }

    public float eB() {
        return 0.0f;
    }

    protected void eC() {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
        if (attributemodifiable != null && attributemodifiable.a(c) != null) {
            attributemodifiable.c(c);
        }
    }

    protected void eD() {
        int i2;
        if (!this.bJ().l() && (i2 = this.cM()) > 0) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.cN();
            attributemodifiable.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        EnchantmentManager.a(worldserver, this);
    }

    public boolean e_() {
        return false;
    }

    public float eE() {
        return this.e_() ? 0.5f : 1.0f;
    }

    public final float eF() {
        AttributeMapBase attributemapbase = this.fw();
        return attributemapbase == null ? 1.0f : this.c((float)attributemapbase.c(GenericAttributes.A));
    }

    protected float c(float f2) {
        return f2;
    }

    public boolean eG() {
        return true;
    }

    protected void eH() {
        ++this.bw;
        if (this.bw >= 20 && !this.ao().B_() && !this.eh()) {
            this.ao().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean eI() {
        return !this.e_();
    }

    protected boolean e(WorldServer worldserver) {
        return !this.e_() && worldserver.U().a(GameRules.D) != false;
    }

    protected int l(int i2) {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.y);
        double d0 = attributemodifiable != null ? attributemodifiable.g() : 0.0;
        return d0 > 0.0 && this.as.j() >= 1.0 / (d0 + 1.0) ? i2 : i2 - 1;
    }

    protected int m(int i2) {
        return Math.min(i2 + 4, this.cJ());
    }

    public final int a(WorldServer worldserver, @Nullable Entity entity) {
        return EnchantmentManager.a(worldserver, entity, (Entity)this, this.f(worldserver));
    }

    protected int f(WorldServer worldserver) {
        return 0;
    }

    protected boolean eJ() {
        return false;
    }

    public @Nullable EntityLiving eK() {
        return EntityReference.b(this.cs, this.ao());
    }

    public @Nullable EntityHuman eL() {
        return EntityReference.c(this.bH, this.ao());
    }

    @Override
    public EntityLiving f_() {
        return this.eK();
    }

    public int eM() {
        return this.ct;
    }

    public void a(EntityHuman entityhuman, int i2) {
        this.a(EntityReference.a(entityhuman), i2);
    }

    public void a(UUID uuid, int i2) {
        this.a(EntityReference.a(uuid), i2);
    }

    private void a(EntityReference<EntityHuman> entityreference, int i2) {
        this.bH = entityreference;
        this.bI = i2;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.cs = EntityReference.a(entityliving);
        this.ct = this.at;
    }

    public @Nullable EntityLiving eN() {
        return this.cu;
    }

    public int eO() {
        return this.cv;
    }

    public void C(Entity entity) {
        this.cu = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.cv = this.at;
    }

    public int eP() {
        return this.bK;
    }

    public void n(int i2) {
        this.bK = i2;
    }

    public boolean eQ() {
        return this.cq;
    }

    public void r(boolean flag) {
        this.cq = flag;
    }

    protected boolean b(EnumItemSlot enumitemslot) {
        return true;
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1) {
        this.onEquipItem(enumitemslot, itemstack, itemstack1, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        if (!(this.ao().B_() || this.au() || ItemStack.c(itemstack, itemstack1) || this.ay)) {
            Equippable equippable = itemstack1.a(DataComponents.H);
            if (!this.bq() && equippable != null && enumitemslot == equippable.b() && !silent) {
                this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), this.a(enumitemslot, itemstack1, equippable), this.dB(), 1.0f, 1.0f, this.as.g());
            }
            if (this.b(enumitemslot)) {
                this.c(equippable != null ? GameEvent.v : GameEvent.S);
            }
        }
    }

    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return equippable.c();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        net.minecraft.world.level.World world;
        if ((entity_removalreason == Entity.RemovalReason.a || entity_removalreason == Entity.RemovalReason.b) && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.ca.a();
    }

    @Override
    public void b(Entity.RemovalReason entity_removalreason) {
        super.b(entity_removalreason);
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.j().c(this);
        }
    }

    protected void a(WorldServer worldserver, Entity.RemovalReason entity_removalreason) {
        for (MobEffect mobeffect : this.eW()) {
            mobeffect.a(worldserver, this, entity_removalreason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.co.clear();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a(aU, this.eZ());
        valueoutput.a(aR, (short)this.bu);
        valueoutput.a(aT, this.ct);
        valueoutput.a(aS, (short)this.bw);
        valueoutput.a("AbsorptionAmount", this.fX());
        valueoutput.a(u, AttributeModifiable.a.b, this.fw().d());
        if (!this.co.isEmpty()) {
            valueoutput.a(b, MobEffect.d.listOf(), List.copyOf(this.co.values()));
        }
        valueoutput.a(aQ, this.gj());
        this.gp().ifPresent(blockposition -> valueoutput.a(aN, BlockPosition.a, blockposition));
        DataResult dataresult = this.ca.a(DynamicOpsNBT.a).map(nbtbase -> new Dynamic((DynamicOps)DynamicOpsNBT.a, nbtbase));
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(dynamic -> valueoutput.a(aP, Codec.PASSTHROUGH, dynamic));
        if (this.bH != null) {
            this.bH.a(valueoutput, "last_hurt_by_player");
            valueoutput.a("last_hurt_by_player_memory_time", this.bI);
        }
        if (this.cs != null) {
            this.cs.a(valueoutput, "last_hurt_by_mob");
            valueoutput.a("ticks_since_last_hurt_by_mob", this.at - this.ct);
        }
        if (!this.cb.a()) {
            valueoutput.a(aO, EntityEquipment.a, this.cb);
        }
        if (this.cI.a()) {
            valueoutput.a("locator_bar_icon", Waypoint.a.a, this.cI);
        }
    }

    public @Nullable EntityItem a(ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    public @Nullable EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (itemstack.f()) {
            return null;
        }
        if (this.ao().B_()) {
            this.a(EnumHand.a);
            return null;
        }
        EntityItem entityitem = this.b(itemstack, flag, flag1);
        if (entityitem != null) {
            if (callEvent && this instanceof EntityPlayer) {
                Player player = (Player)this.getBukkitEntity();
                Item drop = (Item)entityitem.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                    if (flag1 && (cur == null || cur.getAmount() == 0)) {
                        player.getInventory().setItemInHand(drop.getItemStack());
                    } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        cur.setAmount(cur.getAmount() + 1);
                        player.getInventory().setItemInHand(cur);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.ao().b(entityitem);
        }
        return entityitem;
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.G(valueinput.a("AbsorptionAmount", 0.0f));
        if (this.ao() != null && !this.ao().B_()) {
            Optional<List<AttributeModifiable.a>> optional = valueinput.a(u, AttributeModifiable.a.b);
            AttributeMapBase attributemapbase = this.fw();
            Objects.requireNonNull(attributemapbase);
            optional.ifPresent(attributemapbase::a);
        }
        List list = valueinput.a(b, MobEffect.d.listOf()).orElse(List.of());
        this.co.clear();
        for (MobEffect mobeffect : list) {
            this.co.put(mobeffect.c(), mobeffect);
            this.cr = true;
        }
        float maxHealth = valueinput.a("Bukkit.MaxHealth", -1.0f);
        if (maxHealth > 0.0f) {
            this.h(GenericAttributes.u).a(maxHealth);
        }
        this.x(valueinput.a(aU, this.fq()));
        this.bu = valueinput.a(aR, (short)0);
        this.bw = valueinput.a(aS, (short)0);
        this.ct = valueinput.a(aT, 0);
        valueinput.g("Team").ifPresent(s2 -> {
            boolean flag;
            Scoreboard scoreboard = this.ao().ab();
            ScoreboardTeam scoreboardteam = scoreboard.b((String)s2);
            boolean bl = flag = scoreboardteam != null && scoreboard.a(this.cZ(), scoreboardteam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", s2);
            }
        });
        this.b(7, valueinput.a(aQ, false));
        valueinput.a(aN, BlockPosition.a).ifPresentOrElse(blockposition -> {
            this.g((BlockPosition)blockposition);
            this.az.a(aE, EntityPose.c);
            if (!this.ay) {
                this.a((BlockPosition)blockposition);
            }
        }, this::gq);
        valueinput.a(aP, Codec.PASSTHROUGH).ifPresent(dynamic -> {
            this.ca = this.a((Dynamic<?>)dynamic);
        });
        this.bH = EntityReference.a(valueinput, "last_hurt_by_player");
        this.bI = valueinput.a("last_hurt_by_player_memory_time", 0);
        this.cs = EntityReference.a(valueinput, "last_hurt_by_mob");
        this.ct = valueinput.a("ticks_since_last_hurt_by_mob", 0) + this.at;
        this.cb.a(valueinput.a(aO, EntityEquipment.a).orElseGet(EntityEquipment::new));
        this.cI = valueinput.a("locator_bar_icon", Waypoint.a.a).orElseGet(Waypoint.a::new);
    }

    @Override
    public void aI() {
        super.aI();
        this.k();
    }

    protected void eR() {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Iterator<Holder<MobEffectList>> iterator = this.co.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder<MobEffectList> holder = iterator.next();
                    MobEffect mobeffect = this.co.get(holder);
                    if (!mobeffect.a(worldserver, this, () -> this.a(mobeffect, true, (Entity)null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.c(List.of(mobeffect));
                        continue;
                    }
                    if (mobeffect.d() % 600 != 0) continue;
                    this.a(mobeffect, false, (Entity)null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect e2 : this.effectsToProcess) {
                if (e2.effect != null) {
                    this.addEffect(e2.effect, e2.cause);
                    continue;
                }
                this.removeEffect(e2.type, e2.cause);
            }
            this.effectsToProcess.clear();
        } else {
            for (MobEffect mobeffect1 : this.co.values()) {
                mobeffect1.i();
            }
            List<ParticleParam> list = this.az.a(ce);
            if (!list.isEmpty()) {
                int j2;
                boolean flag = this.az.a(cf);
                int i2 = this.cG() ? 15 : 4;
                int n2 = j2 = flag ? 5 : 1;
                if (this.as.a(i2 * j2) == 0) {
                    this.ao().a(SystemUtils.a(list, this.as), this.e(0.5), this.dS(), this.h(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    private void k() {
        if (this.cr) {
            this.M();
            this.D();
            this.cr = false;
        }
    }

    protected void M() {
        if (this.co.isEmpty()) {
            this.eU();
            this.l(false);
        } else {
            this.l(this.d(MobEffects.n));
            this.p();
        }
    }

    private void p() {
        List<ParticleParam> list = this.co.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.az.a(ce, list);
        this.az.a(cf, EntityLiving.d(this.co.values()));
    }

    private void D() {
        boolean flag = this.cF();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double D(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.cx()) {
            d0 *= 0.8;
        }
        if (this.cG()) {
            float f2 = this.fB();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ay();
            if (entitytypes == EntityTypes.bn && itemstack.a(Items.wx) || entitytypes == EntityTypes.bW && itemstack.a(Items.wA) || entitytypes == EntityTypes.aZ && itemstack.a(Items.wD) || entitytypes == EntityTypes.ba && itemstack.a(Items.wD) || entitytypes == EntityTypes.I && itemstack.a(Items.wB)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving entityliving) {
        return entityliving instanceof EntityHuman && this.ao().av() == EnumDifficulty.a ? false : entityliving.eS();
    }

    public boolean eS() {
        return !this.cU() && this.eT();
    }

    public boolean eT() {
        return !this.au() && this.cb();
    }

    public static boolean d(Collection<MobEffect> collection) {
        for (MobEffect mobeffect : collection) {
            if (!mobeffect.g() || mobeffect.f()) continue;
            return false;
        }
        return true;
    }

    protected void eU() {
        this.az.a(ce, List.of());
    }

    public boolean eV() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.ao().B_()) {
            return false;
        }
        if (this.co.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.co.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eW() {
        return this.co.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eX() {
        return this.co;
    }

    public boolean d(Holder<MobEffectList> holder) {
        return this.co.containsKey(holder);
    }

    public @Nullable MobEffect e(Holder<MobEffectList> holder) {
        return this.co.get(holder);
    }

    public float a(Holder<MobEffectList> holder, float f2) {
        MobEffect mobeffect = this.e(holder);
        return mobeffect != null ? mobeffect.a(this, f2) : 0.0f;
    }

    public final boolean a(MobEffect mobeffect) {
        return this.b(mobeffect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return this.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        AsyncCatcher.catchOp("effect add");
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.b(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.co.get(mobeffect.c());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.co.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            flag = true;
            mobeffect.b(this);
        } else if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.a(this);
        return flag;
    }

    public boolean b(MobEffect mobeffect) {
        return this.ay().a(TagsEntity.H) ? !mobeffect.a(MobEffects.M) : (this.ay().a(TagsEntity.G) ? !mobeffect.a(MobEffects.L) : (!this.ay().a(TagsEntity.x) ? true : !mobeffect.a(MobEffects.j) && !mobeffect.a(MobEffects.s)));
    }

    public void c(MobEffect mobeffect, @Nullable Entity entity) {
        if (this.b(mobeffect)) {
            MobEffect mobeffect1 = this.co.put(mobeffect.c(), mobeffect);
            if (mobeffect1 == null) {
                this.a(mobeffect, entity);
            } else {
                mobeffect.d(mobeffect1);
                this.a(mobeffect, true, entity);
            }
        }
    }

    public boolean eY() {
        return this.ay().a(TagsEntity.y);
    }

    public final @Nullable MobEffect f(Holder<MobEffectList> holder) {
        return this.removeEffectNoUpdate(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public final @Nullable MobEffect removeEffectNoUpdate(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffect effect = this.co.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.co.remove(holder);
    }

    public boolean g(Holder<MobEffectList> holder) {
        return this.removeEffect(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.c(List.of(mobeffect));
            return true;
        }
        return false;
    }

    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        if (!this.ao().B_()) {
            this.cr = true;
            mobeffect.c().a().a(this.fw(), mobeffect.e());
            this.c(mobeffect);
        }
    }

    public void c(MobEffect mobeffect) {
        for (Entity entity : this.dn()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.g.b(new PacketPlayOutEntityEffect(this.aA(), mobeffect, false));
        }
    }

    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        if (!this.ao().B_()) {
            this.cr = true;
            if (flag) {
                MobEffectList mobeffectlist = mobeffect.c().a();
                mobeffectlist.a(this.fw());
                mobeffectlist.a(this.fw(), mobeffect.e());
                this.E();
            }
            this.c(mobeffect);
        }
    }

    protected void c(Collection<MobEffect> collection) {
        if (!this.ao().B_()) {
            this.cr = true;
            for (MobEffect mobeffect : collection) {
                mobeffect.c().a().a(this.fw());
                for (Entity entity : this.dn()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.g.b(new PacketPlayOutRemoveEntityEffect(this.aA(), mobeffect.c()));
                }
            }
            this.E();
        }
    }

    private void E() {
        Set<AttributeModifiable> set = this.fw().b();
        for (AttributeModifiable attributemodifiable : set) {
            this.a(attributemodifiable.a());
        }
        set.clear();
    }

    protected void a(Holder<AttributeBase> holder) {
        net.minecraft.world.level.World world;
        if (holder.a(GenericAttributes.u)) {
            float f2 = this.fq();
            if (this.eZ() > f2) {
                this.x(f2);
            }
        } else if (holder.a(GenericAttributes.t)) {
            float f1 = this.fr();
            if (this.fX() > f1) {
                this.F(f1);
            }
        } else if (holder.a(GenericAttributes.A)) {
            this.j_();
        } else if (holder.a(GenericAttributes.I) && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ServerWaypointManager serverwaypointmanager = worldserver.j();
            if (this.cm.c(holder) > 0.0) {
                serverwaypointmanager.a(this);
            } else {
                serverwaypointmanager.c(this);
            }
        }
    }

    public void d(float f2) {
        this.heal(f2, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        float f1 = this.eZ();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason);
            if (this.valid) {
                this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.x((float)((double)this.eZ() + event.getAmount()));
            }
        }
    }

    public float eZ() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.az.a(cd).floatValue();
    }

    public void x(float f2) {
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (f2 < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)f2 > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(f2);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.az.a(cd, Float.valueOf(MathHelper.a(f2, 0.0f, this.fq())));
    }

    public boolean fa() {
        return this.eZ() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity1;
        boolean flag2;
        boolean flag;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.eh() || this.bJ || this.eZ() <= 0.0f) {
            return false;
        }
        if (damagesource.a(DamageTypeTags.i) && this.d(MobEffects.l)) {
            return false;
        }
        if (this.gr()) {
            this.gs();
        }
        this.bK = 0;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f1 = f2;
        ItemStack itemstack = this.gb();
        EntityDamageEvent event = this.handleEntityDamage(damagesource, f2);
        f2 = 0.0f;
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        float f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
        boolean bl = flag = f22 > 0.0f;
        if (Float.isNaN(f2 -= f22) || Float.isInfinite(f2)) {
            f2 = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.ax > (float)this.invulnerableDuration / 2.0f && !damagesource.a(DamageTypeTags.e)) {
            if (f2 <= this.bL) {
                return false;
            }
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage() - this.bL, event)) {
                return false;
            }
            this.bL = f2;
            flag1 = false;
        } else {
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            this.bL = f2;
            this.ax = this.invulnerableDuration;
            this.bu = this.bv = 10;
        }
        this.e(damagesource);
        this.f(damagesource);
        if (flag1) {
            BlocksAttacks blocksattacks = itemstack.a(DataComponents.M);
            if (flag && blocksattacks != null) {
                blocksattacks.a(worldserver, this);
            } else {
                worldserver.a((Entity)this, damagesource);
            }
            if (!damagesource.a(DamageTypeTags.r) && !flag) {
                this.bT();
            }
            if (!damagesource.a(DamageTypeTags.z)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity = damagesource.c();
                if (entity instanceof IProjectile) {
                    IProjectile iprojectile = (IProjectile)entity;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.a(this, damagesource);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (damagesource.i() != null) {
                    d0 = damagesource.i().a() - this.dP();
                    d1 = damagesource.i().c() - this.dV();
                }
                this.knockback(0.4f, d0, d1, entity, entity == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (this.fa()) {
            if (!this.j(damagesource)) {
                if (flag1) {
                    this.b(this.fd());
                    this.i(damagesource);
                }
                this.a(damagesource);
            }
        } else if (flag1) {
            this.g(damagesource);
            this.i(damagesource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.cC = damagesource;
            this.cD = this.ao().au();
            for (MobEffect mobeffect : new LinkedList<MobEffect>(this.eW())) {
                mobeffect.a(worldserver, this, damagesource, f2);
            }
        }
        if (this instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this;
            CriterionTriggers.i.a(entityplayer, damagesource, f1, f2, flag);
            if (f22 > 0.0f && f22 < 3.4028235E37f) {
                entityplayer.a(StatisticList.M, Math.round(f22 * 10.0f));
            }
        }
        if ((entity1 = damagesource.d()) instanceof EntityPlayer) {
            EntityPlayer entityplayer1 = (EntityPlayer)entity1;
            CriterionTriggers.h.a(entityplayer1, this, damagesource, f1, f2, flag);
        }
        return flag2;
    }

    public float b(WorldServer worldserver, DamageSource damagesource, float f2) {
        return this.actuallyDoItemBlocking(worldserver, damagesource, this.calculateItemBlocking(damagesource, f2));
    }

    private float calculateItemBlocking(DamageSource damagesource, float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemstack = this.gh();
        if (itemstack == null) {
            return 0.0f;
        }
        BlocksAttacks blocksattacks = itemstack.a(DataComponents.M);
        if (blocksattacks != null) {
            Optional<TagKey<DamageType>> optional = blocksattacks.f();
            Objects.requireNonNull(damagesource);
            if (!optional.map(damagesource::a).orElse(false).booleanValue()) {
                double d0;
                EntityArrow entityarrow;
                Entity entity = damagesource.c();
                if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).x() > 0) {
                    return 0.0f;
                }
                Vec3D vec3d = damagesource.i();
                if (vec3d != null) {
                    Vec3D vec3d1 = this.c(0.0f, this.cS());
                    Vec3D vec3d2 = vec3d.d(this.dI());
                    vec3d2 = new Vec3D(vec3d2.g, 0.0, vec3d2.i).d();
                    d0 = Math.acos(vec3d2.b(vec3d1));
                } else {
                    d0 = 3.1415927410125732;
                }
                float f1 = blocksattacks.a(damagesource, f2, d0);
                return f1;
            }
        }
        return 0.0f;
    }

    private float actuallyDoItemBlocking(WorldServer worldserver, DamageSource damagesource, float f1) {
        BlocksAttacks blocksattacks;
        ItemStack itemstack = this.gh();
        if (itemstack != null && (blocksattacks = itemstack.a(DataComponents.M)) != null) {
            Entity entity1;
            blocksattacks.a(this.ao(), itemstack, this, this.ga(), f1);
            if (f1 > 0.0f && !damagesource.a(DamageTypeTags.j) && (entity1 = damagesource.c()) instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity1;
                this.a(worldserver, entityliving);
            }
            return f1;
        }
        return 0.0f;
    }

    private void i(DamageSource damagesource) {
        if (damagesource.a(DamageTypes.Q)) {
            SoundCategory soundcategory = this instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            this.ao().a((Entity)null, this.dI().g, this.dI().h, this.dI().i, SoundEffects.CP, soundcategory);
        }
    }

    protected void e(DamageSource damagesource) {
        Entity entity = damagesource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (!(damagesource.a(DamageTypeTags.q) || damagesource.a(DamageTypes.J) && this.ay().a(TagsEntity.F))) {
                this.a(entityliving);
            }
        }
    }

    protected @Nullable EntityHuman f(DamageSource damagesource) {
        EntityWolf entitywolf;
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            this.a(entityhuman, 100);
        } else if (entity instanceof EntityWolf && (entitywolf = (EntityWolf)entity).p()) {
            if (entitywolf.ae_() != null) {
                this.a(entitywolf.ae_().c(), 100);
            } else {
                this.bH = null;
                this.bI = 0;
            }
        }
        return EntityReference.c(this.bH, this.ao());
    }

    protected void a(WorldServer worldserver, EntityLiving entityliving) {
        entityliving.d(this);
    }

    protected void d(EntityLiving entityliving) {
        entityliving.knockback(0.5, entityliving.dP() - this.dP(), entityliving.dV() - this.dV(), this, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damagesource) {
        if (damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        DeathProtection deathprotection = null;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.l;
        for (EnumHand enumhand : EnumHand.values()) {
            itemstack1 = this.b(enumhand);
            deathprotection = itemstack1.a(DataComponents.L);
            if (deathprotection == null) continue;
            hand = enumhand;
            itemstack = itemstack1.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.f()) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(itemstack.h()));
                CriterionTriggers.C.a(entityplayer, itemstack);
                itemstack.a((Entity)this, GameEvent.C);
            }
            this.x(1.0f);
            deathprotection.a(itemstack, this);
            this.ao().a((Entity)this, (byte)35);
        }
        return deathprotection != null;
    }

    public @Nullable DamageSource fb() {
        if (this.ao().au() - this.cD > 40L) {
            this.cC = null;
        }
        return this.cC;
    }

    protected void g(DamageSource damagesource) {
        this.b(this.h(damagesource));
    }

    public void b(@Nullable SoundEffect soundeffect) {
        if (soundeffect != null) {
            this.a(soundeffect, this.fC(), this.fD());
        }
    }

    private void g(ItemStack itemstack) {
        if (!itemstack.f()) {
            Holder<SoundEffect> holder = itemstack.a(DataComponents.aB);
            if (holder != null && !this.bq()) {
                this.ao().a(this.dP(), this.dR(), this.dV(), holder.a(), this.dB(), 0.8f, 0.8f + this.ao().y.i() * 0.4f, false);
            }
            this.b(itemstack, 5);
        }
    }

    public void a(DamageSource damagesource) {
        if (!this.eh() && !this.bJ) {
            Entity entity = damagesource.d();
            EntityLiving entityliving = this.fp();
            if (entityliving != null) {
                entityliving.a((Entity)this, damagesource);
            }
            if (this.gr()) {
                this.gs();
            }
            this.gf();
            if (!this.ao().B_() && this.i_() && SpigotConfig.logNamedDeaths) {
                a.info("Named entity {} died: {}", (Object)this, (Object)this.fo().a().getString());
            }
            this.bJ = true;
            this.fo().c();
            net.minecraft.world.level.World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (entity == null || entity.a(worldserver, this, damagesource)) {
                    this.c(GameEvent.p);
                    this.b(worldserver, damagesource);
                    this.e(entityliving);
                }
                this.ao().a((Entity)this, (byte)3);
            }
            this.c(EntityPose.h);
        }
    }

    protected void e(@Nullable EntityLiving entityliving) {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            boolean flag = false;
            if (entityliving instanceof EntityWither) {
                if (worldserver.U().a(GameRules.F).booleanValue()) {
                    BlockPosition blockposition = this.dK();
                    IBlockData iblockdata = Blocks.cn.m();
                    if (this.ao().a_(blockposition).l() && iblockdata.a((IWorldReader)this.ao(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.ao(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.ao(), this.dP(), this.dR(), this.dV(), new ItemStack(Items.dJ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.ao().b(entityitem);
                }
            }
        }
    }

    protected void b(WorldServer worldserver, DamageSource damagesource) {
        boolean flag = this.bI > 0;
        this.g(worldserver);
        if (this.e(worldserver)) {
            this.b(worldserver, damagesource, flag);
            this.a(worldserver, damagesource, flag);
        }
        CraftEventFactory.callEntityDeathEvent(this, damagesource, this.drops);
        this.drops = new ArrayList();
        this.b(worldserver, damagesource.d());
    }

    protected void g(WorldServer worldserver) {
    }

    public int getExpReward(WorldServer worldserver, @Nullable Entity entity) {
        if (!this.ff() && (this.eJ() || this.bI > 0 && this.eI() && worldserver.U().a(GameRules.D).booleanValue())) {
            return this.a(worldserver, entity);
        }
        return 0;
    }

    protected void b(WorldServer worldserver, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.a(worldserver, this.dI(), this.expToDrop);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
    }

    public long fc() {
        return 0L;
    }

    protected float b(Entity entity, DamageSource damagesource) {
        float f2 = (float)this.i(GenericAttributes.e);
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return EnchantmentManager.d(worldserver, this.eq(), entity, damagesource, f2) / 2.0f;
        }
        return f2 / 2.0f;
    }

    protected void b(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        Optional<ResourceKey<LootTable>> optional = this.er();
        if (!optional.isEmpty()) {
            this.a(worldserver, damagesource, flag, optional.get());
        }
    }

    public void a(WorldServer worldserver, DamageSource damagesource, boolean flag, ResourceKey<LootTable> resourcekey) {
        this.a(worldserver, damagesource, flag, resourcekey, (ItemStack itemstack) -> this.a(worldserver, (ItemStack)itemstack));
    }

    public void a(WorldServer worldserver, DamageSource damagesource, boolean flag, ResourceKey<LootTable> resourcekey, Consumer<ItemStack> consumer) {
        LootTable loottable = worldserver.s().be().a(resourcekey);
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.a, this).a(LootContextParameters.h, this.dI()).a(LootContextParameters.e, damagesource).b(LootContextParameters.f, damagesource.d()).b(LootContextParameters.g, damagesource.c());
        EntityHuman entityhuman = this.eL();
        if (flag && entityhuman != null) {
            lootparams_a = lootparams_a.a(LootContextParameters.d, entityhuman).a(entityhuman.eB());
        }
        LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
        loottable.a(lootparams, this.fc(), consumer);
    }

    public boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, @Nullable Entity entity, ItemStack itemstack, BiConsumer<WorldServer, ItemStack> biconsumer) {
        return this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.c, this).b(LootContextParameters.b, entity).a(LootContextParameters.k, itemstack).a(LootContextParameterSets.t), biconsumer);
    }

    public boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, BiConsumer<WorldServer, ItemStack> biconsumer) {
        return this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.h, this.dI()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), biconsumer);
    }

    protected void a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, ItemStack itemstack, BiConsumer<WorldServer, ItemStack> biconsumer) {
        this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.h, this.dI()).a(LootContextParameters.a, this).a(LootContextParameters.k, itemstack).a(LootContextParameterSets.s), biconsumer);
    }

    protected boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, Function<LootParams.a, LootParams> function, BiConsumer<WorldServer, ItemStack> biconsumer) {
        LootParams lootparams;
        LootTable loottable = worldserver.s().be().a(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.a(lootparams = function.apply(new LootParams.a(worldserver)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> biconsumer.accept(worldserver, (ItemStack)itemstack));
            return true;
        }
        return false;
    }

    public void o(double d0, double d1, double d2) {
        this.knockback(d0, d1, d2, null, EntityKnockbackEvent.KnockbackCause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, Entity attacker, EntityKnockbackEvent.KnockbackCause cause) {
        d0 *= 1.0 - this.i(GenericAttributes.r);
        Vec3D vec3d = this.dN();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (this.as.j() - this.as.j()) * 0.01;
            d2 = (this.as.j() - this.as.j()) * 0.01;
        }
        Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).d().c(d0);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, cause, d0, vec3d1, vec3d.g / 2.0 - vec3d1.g, this.aV() ? Math.min(0.4, vec3d.h / 2.0 + d0) : vec3d.h, vec3d.i / 2.0 - vec3d1.i);
        if (event.isCancelled()) {
            return;
        }
        this.aF = true;
        this.m(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ());
    }

    public void a(double d0, double d1) {
    }

    protected @Nullable SoundEffect h(DamageSource damagesource) {
        return SoundEffects.lU;
    }

    protected @Nullable SoundEffect fd() {
        return SoundEffects.lP;
    }

    private SoundEffect q(int i2) {
        return i2 > 4 ? this.fj().b() : this.fj().a();
    }

    public void fe() {
        this.cG = true;
    }

    public boolean ff() {
        return this.cG;
    }

    public float fg() {
        return 0.0f;
    }

    protected AxisAlignedBB fh() {
        AxisAlignedBB axisalignedbb = this.dj();
        Entity entity = this.dz();
        if (entity != null) {
            Vec3D vec3d = entity.n(this);
            return axisalignedbb.b(Math.max(vec3d.h, axisalignedbb.b));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot enumitemslot) {
        return (Map)this.cH.computeIfAbsent(enumitemslot, enumitemslot1 -> new Reference2ObjectArrayMap());
    }

    public void fi() {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EnchantmentManager.a(worldserver, (Entity)this);
        }
    }

    public a fj() {
        return new a(SoundEffects.lV, SoundEffects.lN);
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.h(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.fd();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.q(fallHeight);
    }

    public Optional<BlockPosition> fk() {
        return this.cB;
    }

    public boolean fl() {
        if (this.au()) {
            return false;
        }
        BlockPosition blockposition = this.dK();
        IBlockData iblockdata = this.dL();
        if (this.gj() && iblockdata.a(TagsBlock.bn)) {
            return false;
        }
        if (iblockdata.a(TagsBlock.bd)) {
            this.cB = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.cB = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        if (!iblockdata.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData iblockdata1 = this.ao().a_(blockposition.e());
        return iblockdata1.a(Blocks.dm) && iblockdata1.c(BlockLadder.b) == iblockdata.c(BlockTrapdoor.f);
    }

    @Override
    public boolean cb() {
        return !this.eh() && this.eZ() > 0.0f;
    }

    public boolean a(EntityLiving entityliving, double d0, boolean flag, boolean flag1, double ... adouble) {
        Vec3D vec3d = entityliving.h(1.0f).d();
        for (double d1 : adouble) {
            Vec3D vec3d1 = new Vec3D(this.dP() - entityliving.dP(), d1 - entityliving.dT(), this.dV() - entityliving.dV());
            double d2 = vec3d1.g();
            vec3d1 = vec3d1.d();
            double d3 = vec3d.b(vec3d1);
            double d4 = flag ? d2 : 1.0;
            if (!(d3 > 1.0 - d0 / d4) || !entityliving.a(this, flag1 ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cW() {
        return this.y(0.0f);
    }

    protected final int y(float f2) {
        return MathHelper.b(f2 + 3.0f);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        boolean flag = super.a(d0, f2, damagesource);
        int i2 = this.a(d0, f2);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.ao(), damagesource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.fm();
            return true;
        }
        return flag;
    }

    protected int a(double d0, float f2) {
        if (this.ay().a(TagsEntity.p)) {
            return 0;
        }
        double d1 = this.i(d0);
        return MathHelper.c(d1 * (double)f2 * this.i(GenericAttributes.m));
    }

    private double i(double d0) {
        return d0 + 1.0E-6 - this.i(GenericAttributes.z);
    }

    protected void fm() {
        if (!this.bq()) {
            int i2 = MathHelper.c(this.dP());
            int j2 = MathHelper.c(this.dR() - (double)0.2f);
            int k2 = MathHelper.c(this.dV());
            IBlockData iblockdata = this.ao().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.l()) {
                SoundEffectType soundeffecttype = iblockdata.A();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void q(float f2) {
        this.bu = this.bv = 10;
    }

    public int fn() {
        return MathHelper.c(this.i(GenericAttributes.b));
    }

    protected void c(DamageSource damagesource, float f2) {
    }

    protected void d(DamageSource damagesource, float f2) {
    }

    protected void a(DamageSource damagesource, float f2, EnumItemSlot ... aenumitemslot) {
        if (f2 > 0.0f) {
            int i2 = (int)Math.max(1.0f, f2 / 4.0f);
            for (EnumItemSlot enumitemslot : aenumitemslot) {
                ItemStack itemstack = this.a(enumitemslot);
                Equippable equippable = itemstack.a(DataComponents.H);
                if (equippable == null || !equippable.i() || !itemstack.m() || !itemstack.a(damagesource)) continue;
                itemstack.a(i2, this, enumitemslot);
            }
        }
    }

    protected float e(DamageSource damagesource, float f2) {
        if (!damagesource.a(DamageTypeTags.b)) {
            f2 = CombatMath.a(this, f2, damagesource, this.fn(), (float)this.i(GenericAttributes.c));
        }
        return f2;
    }

    protected float f(DamageSource damagesource, float f2) {
        float f4;
        if (damagesource.a(DamageTypeTags.f)) {
            return f2;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (damagesource.a(DamageTypeTags.h)) {
            return f2;
        }
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f4 = EnchantmentManager.b(worldserver, this, damagesource);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            f2 = CombatMath.a(f2, f4);
        }
        return f2;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f2) {
        float originalDamage = f2;
        com.google.common.base.Function<Double, Double> freezing = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.o) && EntityLiving.this.ay().a(TagsEntity.m)) {
                    return -(f2 - f2 * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)f2)).floatValue();
        com.google.common.base.Function<Double, Double> hardHat = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.a(EnumItemSlot.f).f()) {
                    return -(f2 - f2 * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f2 += freezingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> blocking = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -((double)EntityLiving.this.calculateItemBlocking(damagesource, f2.floatValue()));
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
        com.google.common.base.Function<Double, Double> armor = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> resistance = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.d(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                    int i2 = (EntityLiving.this.e(MobEffects.k).e() + 1) * 5;
                    int j2 = 25 - i2;
                    float f1 = f2.floatValue() * (float)j2;
                    return -(f2 - (double)Math.max(f1 / 25.0f, 0.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
        com.google.common.base.Function<Double, Double> magic = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.f(damagesource, f2.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
        com.google.common.base.Function<Double, Double> absorption = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fX(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption);
    }

    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.a(worldserver, damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.d() instanceof EntityHuman) {
                ((EntityHuman)damagesource.d()).hf();
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.O, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.K, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                this.d(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.c(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.actuallyDoItemBlocking(worldserver, damagesource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.F(Math.max(this.fX() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.N, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.J, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.L, Math.round(f2 * 10.0f));
                    }
                }
                this.fo().a(damagesource, f2);
                this.x(this.eZ() - f2);
                if (!human) {
                    this.F(this.fX() - f2);
                }
                this.c(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damagesource, f2, originalDamage, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.M, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damagesource.d(), this, damagesource, f2, originalDamage, true);
                }
                return true;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker fo() {
        return this.cn;
    }

    public @Nullable EntityLiving fp() {
        return this.bH != null ? (EntityLiving)this.bH.a(this.ao(), EntityHuman.class) : (this.cs != null ? this.cs.a(this.ao(), EntityLiving.class) : null);
    }

    public final float fq() {
        return (float)this.i(GenericAttributes.u);
    }

    public final float fr() {
        return (float)this.i(GenericAttributes.t);
    }

    public final int fs() {
        return this.az.a(cg);
    }

    public final void o(int i2) {
        this.setArrowCount(i2, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.fs(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.az.a(cg, event.getNewAmount());
    }

    public final int ft() {
        return this.az.a(ch);
    }

    public final void p(int i2) {
        this.az.a(ch, i2);
    }

    private int F() {
        ItemStack itemstack = this.b(EnumHand.a);
        int i2 = itemstack.L().b();
        return MobEffectUtil.a(this) ? i2 - (1 + MobEffectUtil.b(this)) : (this.d(MobEffects.d) ? i2 + (1 + this.e(MobEffects.d).e()) * 2 : i2);
    }

    public void a(EnumHand enumhand) {
        this.a(enumhand, false);
    }

    public void a(EnumHand enumhand, boolean flag) {
        if (!this.bp || this.br >= this.F() / 2 || this.br < 0) {
            this.br = -1;
            this.bp = true;
            this.bq = enumhand;
            if (this.ao() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, enumhand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.ao()).p();
                if (flag) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damagesource) {
        this.bB.a(1.5f);
        this.ax = 20;
        this.bu = this.bv = 10;
        SoundEffect soundeffect = this.h(damagesource);
        if (soundeffect != null) {
            this.a(soundeffect, this.fC(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
        }
        this.cC = damagesource;
        this.cD = this.ao().au();
    }

    @Override
    public void b(byte b0) {
        switch (b0) {
            case 2: {
                this.H();
                break;
            }
            case 3: {
                SoundEffect soundeffect = this.fd();
                if (soundeffect != null) {
                    this.a(soundeffect, this.fC(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.x(0.0f);
                this.a(this.en().p());
                break;
            }
            case 46: {
                int i2 = 128;
                for (int j2 = 0; j2 < 128; ++j2) {
                    double d0 = (double)j2 / 127.0;
                    float f2 = (this.as.i() - 0.5f) * 0.2f;
                    float f1 = (this.as.i() - 0.5f) * 0.2f;
                    float f22 = (this.as.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.Y, this.dP()) + (this.as.j() - 0.5) * (double)this.dF() * 2.0;
                    double d2 = MathHelper.d(d0, this.Z, this.dR()) + this.as.j() * (double)this.dG();
                    double d3 = MathHelper.d(d0, this.aa, this.dV()) + (this.as.j() - 0.5) * (double)this.dF() * 2.0;
                    this.ao().a(Particles.ag, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.I();
                break;
            }
            case 60: {
                this.fu();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            case 67: {
                this.G();
                break;
            }
            case 68: {
                this.g(this.a(EnumItemSlot.h));
                break;
            }
            default: {
                super.b(b0);
            }
        }
    }

    public float z(float f2) {
        return this.cz < 0L ? 0.0f : (float)(this.ao().au() - this.cz) + f2;
    }

    public void fu() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d2 = this.as.k() * 0.02;
            double d3 = 10.0;
            this.ao().a(Particles.af, this.e(1.0) - d0 * 10.0, this.dS() - d1 * 10.0, this.h(1.0) - d2 * 10.0, d0, d1, d2);
        }
    }

    private void G() {
        Vec3D vec3d = this.dN();
        for (int i2 = 0; i2 < 8; ++i2) {
            double d0 = this.as.a(0.0, 1.0);
            double d1 = this.as.a(0.0, 1.0);
            double d2 = this.as.a(0.0, 1.0);
            this.ao().a(Particles.d, this.dP() + d0, this.dR() + d1, this.dV() + d2, vec3d.g, vec3d.h, vec3d.i);
        }
    }

    private void H() {
        if (this.ao().au() - this.cz > 10L) {
            this.cz = this.ao().au();
            KineticWeapon kineticweapon = this.bT.a(DataComponents.O);
            if (kineticweapon != null) {
                kineticweapon.c(this);
            }
        }
    }

    private void I() {
        ItemStack itemstack = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void aU() {
        this.a(this.en().o(), 4.0f);
    }

    protected void fv() {
        int i2 = this.F();
        if (this.bp) {
            ++this.br;
            if (this.br >= i2) {
                this.br = 0;
                this.bp = false;
            }
        } else {
            this.br = 0;
        }
        this.by = (float)this.br / (float)i2;
    }

    public @Nullable AttributeModifiable h(Holder<AttributeBase> holder) {
        return this.fw().a(holder);
    }

    public double i(Holder<AttributeBase> holder) {
        return this.fw().c(holder);
    }

    public double j(Holder<AttributeBase> holder) {
        return this.fw().d(holder);
    }

    public AttributeMapBase fw() {
        return this.cm;
    }

    public ItemStack fx() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fy() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack b(EnumMainHand enummainhand) {
        return this.at() == enummainhand ? this.fx() : this.fy();
    }

    @Override
    public ItemStack eq() {
        return this.fx();
    }

    public AttackRange fz() {
        AttackRange attackrange = this.fA().a(DataComponents.F);
        return attackrange != null ? attackrange : AttackRange.a(this);
    }

    public ItemStack fA() {
        return this.fZ() ? this.gb() : this.fx();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.fx()) || predicate.test(this.fy());
    }

    public ItemStack b(EnumHand enumhand) {
        if (enumhand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (enumhand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
    }

    public void a(EnumHand enumhand, ItemStack itemstack) {
        if (enumhand == EnumHand.a) {
            this.a(EnumItemSlot.a, itemstack);
        } else {
            if (enumhand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
            }
            this.a(EnumItemSlot.b, itemstack);
        }
    }

    public boolean d(EnumItemSlot enumitemslot) {
        return !this.a(enumitemslot).f();
    }

    public boolean e(EnumItemSlot enumitemslot) {
        return true;
    }

    public ItemStack a(EnumItemSlot enumitemslot) {
        return this.cb.a(enumitemslot);
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.onEquipItem(enumitemslot, this.cb.a(enumitemslot, itemstack), itemstack, silent);
    }

    public float fB() {
        int i2 = 0;
        int j2 = 0;
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            ItemStack itemstack = this.a(enumitemslot);
            if (!itemstack.f()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void i(boolean flag) {
        super.i(flag);
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
        attributemodifiable.c(e.a());
        if (flag) {
            attributemodifiable.b(e);
        }
    }

    protected float fC() {
        return 1.0f;
    }

    public float fD() {
        return this.e_() ? (this.as.i() - this.as.i()) * 0.2f + 1.5f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    protected boolean fE() {
        return this.fa();
    }

    @Override
    public void h(Entity entity) {
        if (!this.gr()) {
            super.h(entity);
        }
    }

    private void H(Entity entity) {
        Vec3D vec3d;
        if (this.eh()) {
            vec3d = this.dI();
        } else if (!entity.eh() && !this.ao().a_(entity.dK()).a(TagsBlock.aX)) {
            vec3d = entity.b(this);
        } else {
            boolean flag;
            double d0 = Math.max(this.dR(), entity.dR());
            vec3d = new Vec3D(this.dP(), d0, this.dV());
            boolean bl = flag = this.dF() <= 4.0f && this.dG() <= 4.0f;
            if (flag) {
                double d1 = (double)this.dG() / 2.0;
                Vec3D vec3d1 = vec3d.b(0.0, d1, 0.0);
                VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, this.dF(), this.dG(), this.dF()));
                vec3d = this.ao().a((Entity)this, voxelshape, vec3d1, (double)this.dF(), (double)this.dG(), (double)this.dF()).map(vec3d2 -> vec3d2.b(0.0, -d1, 0.0)).orElse(vec3d);
            }
        }
        this.l(vec3d.g, vec3d.h, vec3d.i);
    }

    @Override
    public boolean de() {
        return this.dd();
    }

    protected float fF() {
        return this.A(1.0f);
    }

    protected float A(float f2) {
        return (float)this.i(GenericAttributes.q) * f2 * this.bh() + this.fG();
    }

    public float fG() {
        return this.d(MobEffects.h) ? 0.1f * ((float)this.e(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void u() {
        float f2 = this.fF();
        if (f2 > 1.0E-5f) {
            Vec3D vec3d = this.dN();
            this.m(vec3d.g, Math.max((double)f2, vec3d.h), vec3d.i);
            if (this.cA()) {
                float f1 = this.ec() * ((float)Math.PI / 180);
                this.l(new Vec3D((double)(-MathHelper.a((double)f1)) * 0.2, 0.0, (double)MathHelper.b((double)f1) * 0.2));
            }
            this.aF = true;
        }
    }

    protected void fH() {
        this.k(this.dN().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> tagkey) {
        this.k(this.dN().b(0.0, 0.04f, 0.0));
    }

    protected float fI() {
        return 0.8f;
    }

    public boolean a(Fluid fluid) {
        return false;
    }

    @Override
    protected double bs() {
        return this.i(GenericAttributes.p);
    }

    protected double fJ() {
        boolean flag = this.dN().h <= 0.0;
        return flag && this.d(MobEffects.B) ? Math.min(this.bt(), 0.01) : this.bt();
    }

    public void m(Vec3D vec3d) {
        if (this.b(this.ao().b_(this.dK()))) {
            this.o(vec3d);
        } else if (this.gj()) {
            this.p(vec3d);
        } else {
            this.a(vec3d);
        }
    }

    protected boolean b(Fluid fluid) {
        return (this.by() || this.bN()) && this.eG() && !this.a(fluid);
    }

    protected void a(Vec3D vec3d, float f2) {
        this.a(vec3d, 0.02f, 0.02f, f2);
    }

    protected void a(Vec3D vec3d, float f2, float f1, float f22) {
        if (this.by()) {
            this.a(f2, vec3d);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c((double)0.8f));
        } else if (this.bN()) {
            this.a(f1, vec3d);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c(0.5));
        } else {
            this.a(f22, vec3d);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c((double)0.91f));
        }
    }

    private void a(Vec3D vec3d) {
        BlockPosition blockposition = this.bf();
        float f2 = this.aV() ? this.ao().a_(blockposition).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3d1 = this.b(vec3d, f2);
        double d0 = vec3d1.h;
        MobEffect mobeffect = this.e(MobEffects.y);
        d0 = mobeffect != null ? (d0 += (0.05 * (double)(mobeffect.e() + 1) - vec3d1.h) * 0.2) : (this.ao().B_() && !this.ao().H(blockposition) ? (this.dR() > (double)this.ao().K_() ? -0.1 : 0.0) : (d0 -= this.fJ()));
        if (this.eQ()) {
            this.m(vec3d1.g, d0, vec3d1.i);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.m(vec3d1.g * (double)f1, d0 * (double)f22, vec3d1.i * (double)f1);
        }
    }

    private void o(Vec3D vec3d) {
        boolean flag = this.dN().h <= 0.0;
        double d0 = this.dR();
        double d1 = this.fJ();
        if (this.by()) {
            this.a(vec3d, d1, flag, d0);
            this.J();
        } else {
            this.b(vec3d, d1, flag, d0);
        }
    }

    protected void a(Vec3D vec3d, double d0, boolean flag, double d1) {
        float f2 = this.cA() ? 0.9f : this.fI();
        float f1 = 0.02f;
        float f22 = (float)this.i(GenericAttributes.H);
        if (!this.aV()) {
            f22 *= 0.5f;
        }
        if (f22 > 0.0f) {
            f2 += (0.54600006f - f2) * f22;
            f1 += (this.fM() - f1) * f22;
        }
        if (this.d(MobEffects.D)) {
            f2 = 0.96f;
        }
        this.a(f1, vec3d);
        this.a(EnumMoveType.a, this.dN());
        Vec3D vec3d1 = this.dN();
        if (this.ad && this.fl()) {
            vec3d1 = new Vec3D(vec3d1.g, 0.2, vec3d1.i);
        }
        vec3d1 = vec3d1.d(f2, 0.8f, f2);
        this.k(this.a(d0, flag, vec3d1));
        this.j(d1);
    }

    private void b(Vec3D vec3d, double d0, boolean flag, double d1) {
        this.a(0.02f, vec3d);
        this.a(EnumMoveType.a, this.dN());
        if (this.b(TagsFluid.b) <= this.dE()) {
            this.k(this.dN().d(0.5, 0.8f, 0.5));
            Vec3D vec3d1 = this.a(d0, flag, this.dN());
            this.k(vec3d1);
        } else {
            this.k(this.dN().c(0.5));
        }
        if (d0 != 0.0) {
            this.k(this.dN().b(0.0, -d0 / 4.0, 0.0));
        }
        this.j(d1);
    }

    private void j(double d0) {
        Vec3D vec3d = this.dN();
        if (this.ad && this.f(vec3d.g, vec3d.h + (double)0.6f - this.dR() + d0, vec3d.i)) {
            this.m(vec3d.g, 0.3f, vec3d.i);
        }
    }

    private void J() {
        boolean flag = this.ay().a(TagsEntity.T);
        if (flag && this.cr() && this.b(TagsFluid.a) > this.dE()) {
            this.k(this.dN().b(0.0, 0.04f, 0.0));
        }
    }

    private void p(Vec3D vec3d) {
        if (this.fl()) {
            this.a(vec3d);
            this.fK();
        } else {
            Vec3D vec3d1 = this.dN();
            double d0 = vec3d1.i();
            this.k(this.q(vec3d1));
            this.a(EnumMoveType.a, this.dN());
            if (!this.ao().B_()) {
                double d1 = this.dN().i();
                this.c(d0, d1);
            }
        }
    }

    public void fK() {
        if (CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            return;
        }
        this.b(7, true);
        this.b(7, false);
    }

    private Vec3D q(Vec3D vec3d) {
        Vec3D vec3d1 = this.cj();
        float f2 = this.ee() * ((float)Math.PI / 180);
        double d0 = Math.sqrt(vec3d1.g * vec3d1.g + vec3d1.i * vec3d1.i);
        double d1 = vec3d.i();
        double d2 = this.fJ();
        double d3 = MathHelper.n(Math.cos(f2));
        vec3d = vec3d.b(0.0, d2 * (-1.0 + d3 * 0.75), 0.0);
        if (vec3d.h < 0.0 && d0 > 0.0) {
            double d4 = vec3d.h * -0.1 * d3;
            vec3d = vec3d.b(vec3d1.g * d4 / d0, d4, vec3d1.i * d4 / d0);
        }
        if (f2 < 0.0f && d0 > 0.0) {
            double d5 = d1 * (double)(-MathHelper.a((double)f2)) * 0.04;
            vec3d = vec3d.b(-vec3d1.g * d5 / d0, d5 * 3.2, -vec3d1.i * d5 / d0);
        }
        if (d0 > 0.0) {
            vec3d = vec3d.b((vec3d1.g / d0 * d1 - vec3d.g) * 0.1, 0.0, (vec3d1.i / d0 * d1 - vec3d.i) * 0.1);
        }
        return vec3d.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double d0, double d1) {
        double d2;
        float f2;
        if (this.ad && (f2 = (float)((d2 = d0 - d1) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.en().n(), f2);
        }
    }

    private void c(EntityHuman entityhuman, Vec3D vec3d) {
        Vec3D vec3d1 = this.b(entityhuman, vec3d);
        this.a(entityhuman, vec3d1);
        if (this.dx()) {
            this.C(this.f(entityhuman));
            this.m(vec3d1);
        } else {
            this.k(Vec3D.c);
        }
    }

    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
    }

    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return vec3d;
    }

    protected float f(EntityHuman entityhuman) {
        return this.fM();
    }

    public void s(boolean flag) {
        float f2 = (float)MathHelper.g(this.dP() - this.Y, flag ? this.dR() - this.Z : 0.0, this.dV() - this.aa);
        if (!this.cq() && this.cb()) {
            this.B(f2);
        } else {
            this.bB.a();
        }
    }

    protected void B(float f2) {
        float f1 = Math.min(f2 * 4.0f, 1.0f);
        this.bB.a(f1, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    private Vec3D b(Vec3D vec3d, float f2) {
        this.a(this.I(f2), vec3d);
        this.k(this.r(this.dN()));
        this.a(EnumMoveType.a, this.dN());
        Vec3D vec3d1 = this.dN();
        if ((this.ad || this.bM) && (this.fl() || this.aK && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.g, 0.2, vec3d1.i);
        }
        return vec3d1;
    }

    public Vec3D a(double d0, boolean flag, Vec3D vec3d) {
        if (d0 != 0.0 && !this.cA()) {
            double d1 = flag && Math.abs(vec3d.h - 0.005) >= 0.003 && Math.abs(vec3d.h - d0 / 16.0) < 0.003 ? -0.003 : vec3d.h - d0 / 16.0;
            return new Vec3D(vec3d.g, d1, vec3d.i);
        }
        return vec3d;
    }

    private Vec3D r(Vec3D vec3d) {
        if (this.fl()) {
            this.l();
            float f2 = 0.15f;
            double d0 = MathHelper.a(vec3d.g, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(vec3d.i, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(vec3d.h, (double)-0.15f);
            if (d2 < 0.0 && !this.dL().a(Blocks.oP) && this.gi() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            vec3d = new Vec3D(d0, d2, d1);
        }
        return vec3d;
    }

    private float I(float f2) {
        return this.aV() ? this.fM() * (0.21600002f / (f2 * f2 * f2)) : this.fL();
    }

    protected float fL() {
        return this.dl() instanceof EntityHuman ? this.fM() * 0.1f : 0.02f;
    }

    public float fM() {
        return this.cw;
    }

    public void C(float f2) {
        this.cw = f2;
    }

    public boolean c(WorldServer worldserver, Entity entity) {
        this.C(entity);
        return false;
    }

    public void a(Entity entity, float f2, Vec3D vec3d) {
        if (f2 > 0.0f && entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entityliving.knockback(f2, MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))), entity, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
            this.k(this.dN().d(0.6, 1.0, 0.6));
        }
    }

    protected void fN() {
    }

    @Override
    public void g() {
        SpigotTimings.timerEntityBaseTick.startTiming();
        super.g();
        this.N();
        this.P();
        if (!this.ao().B_()) {
            int j2;
            int i2 = this.fs();
            if (i2 > 0) {
                if (this.bs <= 0) {
                    this.bs = 20 * (30 - i2);
                }
                --this.bs;
                if (this.bs <= 0) {
                    this.o(i2 - 1);
                }
            }
            if ((j2 = this.ft()) > 0) {
                if (this.bt <= 0) {
                    this.bt = 20 * (30 - j2);
                }
                --this.bt;
                if (this.bt <= 0) {
                    this.p(j2 - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.at % 20 == 0) {
                this.fo().c();
            }
            if (!(!this.gr() || this.av() && this.Q())) {
                this.gs();
            }
        }
        if (!this.eh()) {
            SpigotTimings.timerEntityBaseTick.stopTiming();
            this.d_();
            SpigotTimings.timerEntityTickRest.startTiming();
        }
        double d0 = this.dP() - this.Y;
        double d1 = this.dV() - this.aa;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.bC;
        if (f2 > 0.0025000002f) {
            float f22 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f3 = MathHelper.c(MathHelper.f(this.ec()) - f22);
            f1 = 95.0f < f3 && f3 < 265.0f ? f22 - 180.0f : f22;
        }
        if (this.by > 0.0f) {
            f1 = this.ec();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("headTurn");
        this.D(f1);
        gameprofilerfiller.c();
        gameprofilerfiller.a("rangeChecks");
        while (this.ec() - this.ab < -180.0f) {
            this.ab -= 360.0f;
        }
        while (this.ec() - this.ab >= 180.0f) {
            this.ab += 360.0f;
        }
        while (this.bC - this.bD < -180.0f) {
            this.bD -= 360.0f;
        }
        while (this.bC - this.bD >= 180.0f) {
            this.bD += 360.0f;
        }
        while (this.ee() - this.ac < -180.0f) {
            this.ac -= 360.0f;
        }
        while (this.ee() - this.ac >= 180.0f) {
            this.ac += 360.0f;
        }
        while (this.bE - this.bF < -180.0f) {
            this.bF -= 360.0f;
        }
        while (this.bE - this.bF >= 180.0f) {
            this.bF += 360.0f;
        }
        gameprofilerfiller.c();
        this.bV = this.gj() ? ++this.bV : 0;
        if (this.gr()) {
            this.w(0.0f);
        }
        this.E();
        this.bG.a();
        SpigotTimings.timerEntityTickRest.stopTiming();
    }

    public boolean b(Entity entity, int i2) {
        return this.bZ == null ? false : (this.bZ.containsKey((Object)entity) ? this.ao().au() - this.bZ.getLong((Object)entity) < (long)i2 : false);
    }

    public void E(Entity entity) {
        if (this.bZ != null) {
            this.bZ.put((Object)entity, this.ao().au());
        }
    }

    public int c(Predicate<Entity> predicate) {
        return this.bZ == null ? 0 : (int)this.bZ.keySet().stream().filter(predicate).count();
    }

    public boolean a(EnumItemSlot enumitemslot, Entity entity, float f2, boolean flag, boolean flag1, boolean flag2) {
        net.minecraft.world.level.World world = this.ao();
        if (!(world instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)world;
        ItemStack itemstack = this.a(enumitemslot);
        DamageSource damagesource = itemstack.a(this, () -> this.en().b(this));
        float f1 = EnchantmentManager.a(worldserver, itemstack, entity, damagesource, f2);
        Vec3D vec3d = entity.dN();
        boolean flag3 = flag && entity.a(worldserver, damagesource, f1);
        boolean flag4 = flag1 | flag3;
        if (flag1) {
            this.a(entity, 0.4f + this.b(entity, damagesource), vec3d);
        }
        if (flag2 && entity.cq()) {
            flag4 = true;
            entity.cf();
        }
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            itemstack.a(entityliving, this);
        }
        if (flag3) {
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
        if (!flag4) {
            return false;
        }
        this.C(entity);
        this.fN();
        return true;
    }

    public void fO() {
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.L();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    private @Nullable Map<EnumItemSlot, ItemStack> L() {
        Map map = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.j) {
            ItemStack itemstack1;
            ItemStack itemstack = this.cp.get(enumItemSlot);
            if (!this.a(itemstack, itemstack1 = this.a(enumItemSlot))) continue;
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumItemSlot, itemstack1);
            AttributeMapBase attributemapbase = this.fw();
            if (itemstack.f()) continue;
            this.a(itemstack, enumItemSlot, attributemapbase);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot enumitemslot1 = (EnumItemSlot)entry.getKey();
                ItemStack itemstack2 = (ItemStack)entry.getValue();
                if (itemstack2.f() || itemstack2.q()) continue;
                itemstack2.a(enumitemslot1, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    AttributeModifiable attributemodifiable = this.cm.a((Holder<AttributeBase>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.c(attributemodifier.a());
                        attributemodifiable.b((AttributeModifier)attributemodifier);
                    }
                });
                net.minecraft.world.level.World world = this.ao();
                if (!(world instanceof WorldServer)) continue;
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, itemstack2, this, enumitemslot1);
            }
        }
        return map;
    }

    public boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return !ItemStack.a(itemstack1, itemstack);
    }

    private void a(Map<EnumItemSlot, ItemStack> map) {
        ItemStack itemstack = map.get(EnumItemSlot.a);
        ItemStack itemstack1 = map.get(EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.cp.get(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.cp.get(EnumItemSlot.a))) {
            ((WorldServer)this.ao()).p().b(this, new PacketPlayOutEntityStatus(this, 55));
            map.remove(EnumItemSlot.a);
            map.remove(EnumItemSlot.b);
            this.cp.put(EnumItemSlot.a, itemstack.v());
            this.cp.put(EnumItemSlot.b, itemstack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> map) {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.v();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            this.cp.put((EnumItemSlot)enumitemslot, itemstack1);
        });
        ((WorldServer)this.ao()).p().b(this, new PacketPlayOutEntityEquipment(this.aA(), list));
    }

    protected void D(float f2) {
        float f1 = MathHelper.f(f2 - this.bC);
        this.bC += f1 * 0.3f;
        float f22 = MathHelper.f(this.ec() - this.bC);
        float f3 = this.fP();
        if (Math.abs(f22) > f3) {
            this.bC += f22 - (float)MathHelper.m(f22) * f3;
        }
    }

    protected float fP() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void d_() {
        if (this.cx > 0) {
            --this.cx;
        }
        if (this.ch()) {
            this.l_().e();
        } else if (!this.dx()) {
            this.k(this.dN().c(0.98));
        }
        if (this.bS > 0) {
            this.a(this.bS, this.bR);
            --this.bS;
        }
        this.cb.a((Entity)this);
        vec3d = this.dN();
        d0 = vec3d.g;
        d1 = vec3d.h;
        d2 = vec3d.i;
        if (this.ay().equals(EntityTypes.cb)) {
            if (vec3d.j() < 9.0E-6) {
                d0 = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(vec3d.g) < 0.003) {
                d0 = 0.0;
            }
            if (Math.abs(vec3d.i) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(vec3d.h) < 0.003) {
            d1 = 0.0;
        }
        this.m(d0, d1, d2);
        gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("ai");
        SpigotTimings.timerEntityAI.startTiming();
        this.fQ();
        if (this.fE()) {
            this.bM = false;
            this.bN = 0.0f;
            this.bP = 0.0f;
        } else if (this.dy() && !this.ao().B_()) {
            gameprofilerfiller.a("newAi");
            this.fV();
            gameprofilerfiller.c();
        }
        SpigotTimings.timerEntityAI.stopTiming();
        gameprofilerfiller.c();
        gameprofilerfiller.a("jump");
        if (this.bM && this.eG()) {
            d3 = this.bN() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.by() != false && d3 > 0.0;
            d4 = this.dE();
            if (!flag || this.aV() && d3 <= d4) {
                if (!this.bN() || this.aV() && d3 <= d4) {
                    if ((this.aV() || flag && d3 <= d4) && this.cx == 0) {
                        this.u();
                        this.cx = 10;
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.cx = 0;
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("travel");
        if (this.gj()) {
            this.fT();
        }
        axisalignedbb = this.dj();
        vec3d1 = new Vec3D(this.bN, this.bO, this.bP);
        if (this.d(MobEffects.B) || this.d(MobEffects.y)) {
            this.l();
        }
        SpigotTimings.timerEntityAIMove.startTiming();
        entityliving = this.dl();
        if (!(entityliving instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.cb()) {
            this.c(entityhuman, vec3d1);
        } else if (this.dx() && this.dy()) {
            this.m(vec3d1);
        }
        SpigotTimings.timerEntityAIMove.stopTiming();
        if (!this.ao().B_() || this.dv()) {
            this.aW();
        }
        if (this.ao().B_()) {
            this.s(this instanceof EntityBird);
        }
        gameprofilerfiller.c();
        world = this.ao();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            gameprofilerfiller.a("freezing");
            if (!this.aJ || !this.ea()) {
                this.k(Math.max(0, this.cM() - 2));
            }
            this.eC();
            this.eD();
            if (this.at % 40 == 0 && this.cO() && this.ea()) {
                this.a(worldserver, this.en().v(), 1.0f);
            }
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("push");
        if (this.bW > 0) {
            --this.bW;
            this.a(axisalignedbb, this.dj());
        }
        SpigotTimings.timerEntityAICollision.startTiming();
        this.q();
        SpigotTimings.timerEntityAICollision.stopTiming();
        gameprofilerfiller.c();
        world = this.ao();
        if (world instanceof WorldServer) {
            worldserver1 = (WorldServer)world;
            if (this.fR() && this.bA()) {
                this.a(worldserver1, this.en().i(), 1.0f);
            }
        }
    }

    protected void fQ() {
        this.bN *= 0.98f;
        this.bP *= 0.98f;
    }

    public boolean fR() {
        return false;
    }

    public boolean fS() {
        return this.bM;
    }

    protected void fT() {
        this.cQ();
        if (!this.ao().B_()) {
            if (!this.fU()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bV + 1;
            if (i2 % 10 == 0) {
                int j2 = i2 / 10;
                if (j2 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.j.stream().filter(enumitemslot -> EntityLiving.b(this.a((EnumItemSlot)enumitemslot), enumitemslot)).toList();
                    EnumItemSlot enumitemslot2 = SystemUtils.a(list, this.as);
                    this.a(enumitemslot2).a(1, this, enumitemslot2);
                }
                this.c(GameEvent.n);
            }
        }
    }

    protected boolean fU() {
        if (!(this.aV() || this.cq() || this.d(MobEffects.y))) {
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                if (!EntityLiving.b(this.a(enumitemslot), enumitemslot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fV() {
    }

    protected void q() {
        List<Entity> list = this.ao().k(this, this.dj());
        if (!list.isEmpty()) {
            WorldServer worldserver;
            int i2;
            net.minecraft.world.level.World world = this.ao();
            if (world instanceof WorldServer && (i2 = (worldserver = (WorldServer)world).U().a(GameRules.A).intValue()) > 0 && list.size() > i2 - 1 && this.as.a(4) == 0) {
                int j2 = 0;
                for (Entity entity : list) {
                    if (entity.cq()) continue;
                    ++j2;
                }
                if (j2 > i2 - 1) {
                    this.a(worldserver, this.en().h(), 6.0f);
                }
            }
            for (Entity entity1 : list) {
                this.F(entity1);
            }
        }
    }

    protected void a(AxisAlignedBB axisalignedbb, AxisAlignedBB axisalignedbb1) {
        AxisAlignedBB axisalignedbb2 = axisalignedbb.b(axisalignedbb1);
        List<Entity> list = this.ao().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLiving)) continue;
                this.f((EntityLiving)entity);
                this.bW = 0;
                this.k(this.dN().c(-0.2));
                break;
            }
        } else if (this.ad) {
            this.bW = 0;
        }
        if (!this.ao().B_() && this.bW <= 0) {
            this.c(4, false);
            this.bX = 0.0f;
            this.bY = null;
        }
    }

    protected void F(Entity entity) {
        entity.h(this);
    }

    protected void f(EntityLiving entityliving) {
    }

    public boolean fW() {
        return (this.az.a(bk) & 4) != 0;
    }

    @Override
    public void cf() {
        Entity entity = this.dz();
        super.cf();
        if (entity != null && entity != this.dz() && !this.ao().B_()) {
            this.H(entity);
        }
    }

    @Override
    public void t() {
        super.t();
        this.l();
    }

    @Override
    public InterpolationHandler l_() {
        return this.bQ;
    }

    @Override
    public void a(float f2, int i2) {
        this.bR = f2;
        this.bS = i2;
    }

    public void t(boolean flag) {
        this.bM = flag;
    }

    public void a(EntityItem entityitem) {
        Entity entity = entityitem.p();
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.S.a((EntityPlayer)entity, entityitem.e(), this);
        }
    }

    public void a(Entity entity, int i2) {
        if (!entity.eh() && !this.ao().B_() && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.ao()).p().b(entity, new PacketPlayOutCollect(entity.aA(), this.aA(), i2));
        }
    }

    public boolean G(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dT());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption raytrace_blockcollisionoption, RayTrace.FluidCollisionOption raytrace_fluidcollisionoption, double d0) {
        if (entity.ao() != this.ao()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dP(), this.dT(), this.dV());
        Vec3D vec3d1 = new Vec3D(entity.dP(), d0, entity.dV());
        return vec3d1.f(vec3d) > 128.0 ? false : this.ao().a(new RayTrace(vec3d, vec3d1, raytrace_blockcollisionoption, raytrace_fluidcollisionoption, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float j(float f2) {
        return f2 == 1.0f ? this.bE : MathHelper.i(f2, this.bF, this.bE);
    }

    public float E(float f2) {
        float f1 = this.by - this.bx;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.bx + f1 * f2;
    }

    @Override
    public boolean bX() {
        return !this.eh() && this.collides;
    }

    @Override
    public boolean bY() {
        return this.cb() && !this.au() && !this.fl() && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bY() && this.collides != this.collidableExemptions.contains(entity.cY());
    }

    @Override
    public float cS() {
        return this.bE;
    }

    @Override
    public void r(float f2) {
        this.bE = f2;
    }

    @Override
    public void s(float f2) {
        this.bC = f2;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.n(super.a(enumdirection_enumaxis, blockutil_rectangle));
    }

    public static Vec3D n(Vec3D vec3d) {
        return new Vec3D(vec3d.g, vec3d.h, 0.0);
    }

    public float fX() {
        return this.cy;
    }

    public final void F(float f2) {
        this.G(MathHelper.a(f2, 0.0f, this.fr()));
    }

    protected void G(float f2) {
        this.cy = f2;
    }

    public void g_() {
    }

    public void P_() {
    }

    protected void fY() {
        this.cr = true;
    }

    public abstract EnumMainHand at();

    public boolean fZ() {
        return (this.az.a(bk) & 1) > 0;
    }

    public EnumHand ga() {
        return (this.az.a(bk) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    private void N() {
        if (this.fZ()) {
            if (ItemStack.b(this.b(this.ga()), this.bT)) {
                this.bT = this.b(this.ga());
                this.a_(this.bT);
            } else {
                this.gf();
            }
        }
    }

    private @Nullable EntityItem b(ItemStack itemstack, boolean flag, boolean flag1) {
        if (itemstack.f()) {
            return null;
        }
        double d0 = this.dT() - (double)0.3f;
        EntityItem entityitem = new EntityItem(this.ao(), this.dP(), d0, this.dV(), itemstack);
        entityitem.a(40);
        if (flag1) {
            entityitem.b((Entity)this);
        }
        if (flag) {
            float f2 = this.as.i() * 0.5f;
            float f1 = this.as.i() * ((float)Math.PI * 2);
            entityitem.m(-MathHelper.a((double)f1) * f2, 0.2f, MathHelper.b((double)f1) * f2);
        } else {
            float f2 = 0.3f;
            float f3 = MathHelper.a((double)(this.ee() * ((float)Math.PI / 180)));
            float f4 = MathHelper.b((double)(this.ee() * ((float)Math.PI / 180)));
            float f5 = MathHelper.a((double)(this.ec() * ((float)Math.PI / 180)));
            float f6 = MathHelper.b((double)(this.ec() * ((float)Math.PI / 180)));
            float f7 = this.as.i() * ((float)Math.PI * 2);
            float f8 = 0.02f * this.as.i();
            entityitem.m((double)(-f5 * f4 * 0.3f) + Math.cos(f7) * (double)f8, -f3 * 0.3f + 0.1f + (this.as.i() - this.as.i()) * 0.1f, (double)(f6 * f4 * 0.3f) + Math.sin(f7) * (double)f8);
        }
        return entityitem;
    }

    protected void a_(ItemStack itemstack) {
        itemstack.b(this.ao(), this, this.gc());
        if (--this.bU == 0 && !this.ao().B_() && !itemstack.x()) {
            this.Q_();
        }
    }

    private void P() {
        this.cF = this.cE;
        this.cE = this.cC() ? Math.min(1.0f, this.cE + 0.09f) : Math.max(0.0f, this.cE - 0.09f);
    }

    public void c(int i2, boolean flag) {
        int j2 = this.az.a(bk).byteValue();
        j2 = flag ? (j2 |= i2) : (j2 &= ~i2);
        this.az.a(bk, (byte)j2);
    }

    public void c(EnumHand enumhand) {
        ItemStack itemstack = this.b(enumhand);
        if (!itemstack.f() && !this.fZ()) {
            this.bT = itemstack;
            this.bU = itemstack.a(this);
            if (!this.ao().B_()) {
                this.c(1, true);
                this.c(2, enumhand == EnumHand.b);
                this.bT.a((Entity)this, GameEvent.D);
                if (this.bT.c(DataComponents.O)) {
                    this.bZ = new Object2LongOpenHashMap();
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (ci.equals(datawatcherobject)) {
            if (this.ao().B_()) {
                this.gp().ifPresent(this::a);
            }
        } else if (bk.equals(datawatcherobject) && this.ao().B_()) {
            if (this.fZ() && this.bT.f()) {
                this.bT = this.b(this.ga());
                if (!this.bT.f()) {
                    this.bU = this.bT.a(this);
                }
            } else if (!this.fZ() && !this.bT.f()) {
                this.bT = ItemStack.l;
                this.bU = 0;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.bF = this.bE;
        this.bD = this.bC = this.bE;
    }

    @Override
    public float t(float f2) {
        return MathHelper.h(f2, this.bD, this.bC);
    }

    public void b(ItemStack itemstack, int i2) {
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.as.i() - 0.5) * 0.1, (double)this.as.i() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.ee() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.ec() * ((float)Math.PI / 180));
            double d0 = (double)(-this.as.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.as.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.ee() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.ec() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dP(), this.dT(), this.dV());
            this.ao().a(new ParticleParamItem(Particles.V, itemstack), vec3d1.g, vec3d1.h, vec3d1.i, vec3d.g, vec3d.h + 0.05, vec3d.i);
        }
    }

    protected void Q_() {
        if (!this.ao().B_() || this.fZ()) {
            EnumHand enumhand = this.ga();
            if (!this.bT.equals(this.b(enumhand))) {
                this.ge();
            } else if (!this.bT.f() && this.fZ()) {
                ItemStack itemstack;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bT);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bT.a(DataComponents.z);
                        if (consumable != null) {
                            consumable.cancelUsingItem(entityPlayer, this.bT);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bT.a(this.ao(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.ao(), this);
                } else {
                    itemstack = this.bT.a(this.ao(), this);
                }
                if (itemstack != this.bT) {
                    this.a(enumhand, itemstack);
                }
                this.gf();
            }
        }
    }

    public void b(ItemStack itemstack) {
    }

    public ItemStack gb() {
        return this.bT;
    }

    public int gc() {
        return this.bU;
    }

    public int gd() {
        return this.fZ() ? this.bT.a(this) - this.gc() : 0;
    }

    public float H(float f2) {
        return !this.fZ() ? 0.0f : (float)this.gd() + f2;
    }

    public void ge() {
        ItemStack itemstack = this.b(this.ga());
        if (!this.bT.f() && ItemStack.b(itemstack, this.bT)) {
            this.bT = itemstack;
            this.bT.a(this.ao(), this, this.gc());
            if (this.bT.x()) {
                this.N();
            }
        }
        this.gf();
    }

    public void gf() {
        if (!this.ao().B_()) {
            boolean flag = this.fZ();
            this.bZ = null;
            this.c(1, false);
            if (flag) {
                this.bT.a((Entity)this, GameEvent.C);
            }
        }
        this.bT = ItemStack.l;
        this.bU = 0;
    }

    public boolean gg() {
        return this.gh() != null;
    }

    public @Nullable ItemStack gh() {
        int i2;
        if (!this.fZ()) {
            return null;
        }
        BlocksAttacks blocksattacks = this.bT.a(DataComponents.M);
        if (blocksattacks != null && (i2 = this.bT.h().a(this.bT, this) - this.bU) >= blocksattacks.a()) {
            return this.bT;
        }
        return null;
    }

    public boolean gi() {
        return this.cu();
    }

    public boolean gj() {
        return this.i(7);
    }

    @Override
    public boolean cC() {
        return super.cC() || !this.gj() && this.d(EntityPose.b);
    }

    public int gk() {
        return this.bV;
    }

    public boolean b(double d0, double d1, double d2, boolean flag) {
        return this.randomTeleport(d0, d1, d2, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dP();
        double d4 = this.dR();
        double d5 = this.dV();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.ao();
        if (world.H(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.K_()) {
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.a_(d0, d6, d2);
                if (world.g(this) && !world.d(this.dj())) {
                    flag1 = true;
                }
                this.a_(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.ao().getWorld(), d3, d4, d5), new Location((World)this.ao().getWorld(), d0, d6, d2));
                        this.ao().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).g.teleport(d0, d6, d2, this.ec(), this.ee(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        EntityCreature entitycreature = (EntityCreature)this;
        entitycreature.N().n();
        return Optional.of(true);
    }

    public boolean gl() {
        return !this.fa();
    }

    public boolean gm() {
        return true;
    }

    public void a(BlockPosition blockposition, boolean flag) {
    }

    public boolean gn() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose entitypose) {
        return entitypose == EntityPose.c ? bl : this.b(entitypose).a(this.eF());
    }

    protected EntitySize b(EntityPose entitypose) {
        return this.ay().n().a(this.eE());
    }

    public ImmutableList<EntityPose> go() {
        return ImmutableList.of((Object)EntityPose.a);
    }

    public AxisAlignedBB f(EntityPose entitypose) {
        EntitySize entitysize = this.a(entitypose);
        return new AxisAlignedBB(-entitysize.a() / 2.0f, 0.0, -entitysize.a() / 2.0f, entitysize.a() / 2.0f, entitysize.b(), entitysize.a() / 2.0f);
    }

    protected boolean g(EntityPose entitypose) {
        AxisAlignedBB axisalignedbb = this.a(entitypose).a(this.dI());
        return this.ao().b(this, axisalignedbb);
    }

    @Override
    public boolean o(boolean flag) {
        return super.o(flag) && !this.gr();
    }

    public Optional<BlockPosition> gp() {
        return this.az.a(ci);
    }

    public void g(BlockPosition blockposition) {
        this.az.a(ci, Optional.of(blockposition));
    }

    public void gq() {
        this.az.a(ci, Optional.empty());
    }

    public boolean gr() {
        return this.gp().isPresent();
    }

    public void b(BlockPosition blockposition) {
        IBlockData iblockdata;
        if (this.cq()) {
            this.cf();
        }
        if ((iblockdata = this.ao().a_(blockposition)).b() instanceof BlockBed) {
            this.ao().a(blockposition, (IBlockData)iblockdata.b(BlockBed.c, true), 3);
        }
        this.c(EntityPose.c);
        this.a(blockposition);
        this.g(blockposition);
        this.k(Vec3D.c);
        this.aF = true;
    }

    private void a(BlockPosition blockposition) {
        this.a_((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.6875, (double)blockposition.w() + 0.5);
    }

    private boolean Q() {
        return this.gp().map(blockposition -> this.ao().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void gs() {
        Optional<BlockPosition> optional = this.gp();
        net.minecraft.world.level.World world = this.ao();
        Objects.requireNonNull(world);
        optional.filter(world::H).ifPresent(blockposition -> {
            IBlockData iblockdata = this.ao().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = (EnumDirection)iblockdata.c(BlockBed.f);
                this.ao().a((BlockPosition)blockposition, (IBlockData)iblockdata.b(BlockBed.c, false), 3);
                Vec3D vec3d = BlockBed.a(this.ay(), (ICollisionAccess)this.ao(), blockposition, enumdirection, this.ec()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.d();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.g(MathHelper.d(vec3d1.i, vec3d1.g) * 57.2957763671875 - 90.0);
                this.a_(vec3d.g, vec3d.h, vec3d.i);
                this.v(f2);
                this.w(0.0f);
            }
        });
        Vec3D vec3d = this.dI();
        this.c(EntityPose.a);
        this.a_(vec3d.g, vec3d.h, vec3d.i);
        this.gq();
    }

    public @Nullable EnumDirection gt() {
        BlockPosition blockposition = this.gp().orElse(null);
        return blockposition != null ? BlockBed.a(this.ao(), blockposition) : null;
    }

    @Override
    public boolean cc() {
        return !this.gr() && super.cc();
    }

    public ItemStack d(ItemStack itemstack) {
        return ItemStack.l;
    }

    private static byte g(EnumItemSlot enumitemslot) {
        return switch (enumitemslot) {
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            case EnumItemSlot.h -> 68;
            default -> throw new MatchException(null, null);
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot enumitemslot) {
        this.ao().a((Entity)this, EntityLiving.g(enumitemslot));
        this.a(this.a(enumitemslot), enumitemslot, this.cm);
    }

    private void a(ItemStack itemstack, EnumItemSlot enumitemslot, AttributeMapBase attributemapbase) {
        itemstack.a(enumitemslot, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
            AttributeModifiable attributemodifiable = attributemapbase.a((Holder<AttributeBase>)holder);
            if (attributemodifiable != null) {
                attributemodifiable.e((AttributeModifier)attributemodifier);
            }
        });
        EnchantmentManager.a(itemstack, this, enumitemslot);
    }

    public final boolean e(ItemStack itemstack) {
        if (this.cb() && !this.au()) {
            Equippable equippable = itemstack.a(DataComponents.H);
            if (equippable != null && equippable.g()) {
                EnumItemSlot enumitemslot = equippable.b();
                return this.e(enumitemslot) && equippable.a(this.ay()) ? this.a(enumitemslot).f() && this.f(enumitemslot) : false;
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot enumitemslot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack itemstack) {
        Equippable equippable = itemstack.a(DataComponents.H);
        return equippable != null && this.e(equippable.b()) ? equippable.b() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack itemstack, EnumItemSlot enumitemslot) {
        Equippable equippable = itemstack.a(DataComponents.H);
        return equippable == null ? enumitemslot == EnumItemSlot.a && this.e(EnumItemSlot.a) : enumitemslot == equippable.b() && this.e(equippable.b()) && equippable.a(this.ay());
    }

    private static SlotAccess a(EntityLiving entityliving, EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.f && enumitemslot != EnumItemSlot.a && enumitemslot != EnumItemSlot.b ? SlotAccess.a(entityliving, enumitemslot, (ItemStack itemstack) -> itemstack.f() || entityliving.f((ItemStack)itemstack) == enumitemslot) : SlotAccess.a(entityliving, enumitemslot);
    }

    private static @Nullable EnumItemSlot r(int i2) {
        return i2 == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (i2 == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (i2 == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (i2 == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (i2 == 98 ? EnumItemSlot.a : (i2 == 99 ? EnumItemSlot.b : (i2 == 105 ? EnumItemSlot.g : (i2 == 106 ? EnumItemSlot.h : null)))))));
    }

    @Override
    public @Nullable SlotAccess a_(int i2) {
        EnumItemSlot enumitemslot = EntityLiving.r(i2);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(i2);
    }

    @Override
    public boolean ea() {
        if (this.au()) {
            return false;
        }
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (!this.a(enumitemslot).a(TagsItem.bM)) continue;
            return false;
        }
        return super.ea();
    }

    @Override
    public boolean cF() {
        return !this.ao().B_() && this.d(MobEffects.x) || super.cF();
    }

    @Override
    public float ed() {
        return this.bC;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        float f2 = packetplayoutspawnentity.l();
        float f1 = packetplayoutspawnentity.k();
        this.e(d0, d1, d2);
        this.bC = packetplayoutspawnentity.m();
        this.bE = packetplayoutspawnentity.m();
        this.bD = this.bC;
        this.bF = this.bE;
        this.e(packetplayoutspawnentity.b());
        this.a(packetplayoutspawnentity.e());
        this.a(d0, d1, d2, f2, f1);
        this.k(packetplayoutspawnentity.j());
    }

    public float gu() {
        ItemStack itemstack = this.eq();
        Weapon weapon = itemstack.a(DataComponents.E);
        return weapon != null && itemstack == this.fA() ? weapon.b() : 0.0f;
    }

    @Override
    public float eg() {
        float f2 = (float)this.i(GenericAttributes.D);
        return this.dl() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D n(Entity entity) {
        return this.dI().e(this.a(entity, this.a(this.aF()), this.eF() * this.eE()));
    }

    protected void a(int i2, double d0) {
        this.bE = (float)MathHelper.e(1.0 / (double)i2, (double)this.bE, d0);
    }

    @Override
    public void g(int i2) {
        super.g(MathHelper.e((double)i2 * this.i(GenericAttributes.i)));
    }

    public boolean gv() {
        return false;
    }

    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.d(damagesource) || EnchantmentManager.a(worldserver, this, damagesource);
    }

    public static boolean b(ItemStack itemstack, EnumItemSlot enumitemslot) {
        if (!itemstack.c(DataComponents.J)) {
            return false;
        }
        Equippable equippable = itemstack.a(DataComponents.H);
        return equippable != null && enumitemslot == equippable.b() && !itemstack.r();
    }

    @VisibleForTesting
    public int gw() {
        return this.bI;
    }

    @Override
    public boolean gx() {
        return this.i(GenericAttributes.I) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.c> f(EntityPlayer entityplayer) {
        if (!this.ay && entityplayer != this) {
            if (WaypointTransmitter.a(this, entityplayer)) {
                return Optional.empty();
            }
            Waypoint.a waypoint_a = this.cI.a(this);
            return WaypointTransmitter.b(this, entityplayer) ? Optional.of(new WaypointTransmitter.d(this, waypoint_a, entityplayer)) : (!WaypointTransmitter.a(this.dM(), entityplayer) ? Optional.of(new WaypointTransmitter.f(this, waypoint_a, entityplayer)) : Optional.of(new WaypointTransmitter.e(this, waypoint_a, entityplayer)));
        }
        return Optional.empty();
    }

    @Override
    public Waypoint.a gy() {
        return this.cI;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

