/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class RandomPositionGenerator {
    private static final int a = 10;

    public static BlockPosition a(RandomSource var0, int var1, int var2) {
        int var3 = var0.a(2 * var1 + 1) - var1;
        int var4 = var0.a(2 * var2 + 1) - var2;
        int var5 = var0.a(2 * var1 + 1) - var1;
        return new BlockPosition(var3, var4, var5);
    }

    public static @Nullable BlockPosition a(RandomSource var0, double var1, double var3, int var5, int var6, double var7, double var9, double var11) {
        double var13 = MathHelper.d(var9, var7) - 1.5707963705062866;
        double var15 = var13 + (double)(2.0f * var0.i() - 1.0f) * var11;
        double var17 = MathHelper.d(Math.sqrt(var0.j()), var1, var3) * (double)MathHelper.g;
        double var19 = -var17 * Math.sin(var15);
        double var21 = var17 * Math.cos(var15);
        if (Math.abs(var19) > var3 || Math.abs(var21) > var3) {
            return null;
        }
        int var23 = var0.a(2 * var5 + 1) - var5 + var6;
        return BlockPosition.a(var19, (double)var23, var21);
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition var0, int var1, Predicate<BlockPosition> var2) {
        if (var2.test(var0)) {
            BlockPosition.MutableBlockPosition var3 = var0.k().c(EnumDirection.b);
            while (var3.v() <= var1 && var2.test(var3)) {
                var3.c(EnumDirection.b);
            }
            return var3.j();
        }
        return var0;
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition var0, int var1, int var2, Predicate<BlockPosition> var3) {
        if (var1 < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + var1 + ", expected >= 0");
        }
        if (var3.test(var0)) {
            BlockPosition.MutableBlockPosition var4 = var0.k().c(EnumDirection.b);
            while (var4.v() <= var2 && var3.test(var4)) {
                var4.c(EnumDirection.b);
            }
            int var5 = var4.v();
            while (var4.v() <= var2 && var4.v() - var5 < var1) {
                var4.c(EnumDirection.b);
                if (!var3.test(var4)) continue;
                var4.c(EnumDirection.a);
                break;
            }
            return var4.j();
        }
        return var0;
    }

    public static @Nullable Vec3D a(EntityCreature var0, Supplier<@Nullable BlockPosition> var1) {
        return RandomPositionGenerator.a(var1, var0::c);
    }

    public static @Nullable Vec3D a(Supplier<@Nullable BlockPosition> var0, ToDoubleFunction<BlockPosition> var1) {
        double var2 = Double.NEGATIVE_INFINITY;
        BlockPosition var4 = null;
        for (int var5 = 0; var5 < 10; ++var5) {
            double var7;
            BlockPosition var6 = var0.get();
            if (var6 == null || !((var7 = var1.applyAsDouble(var6)) > var2)) continue;
            var2 = var7;
            var4 = var6;
        }
        return var4 != null ? Vec3D.c(var4) : null;
    }

    public static BlockPosition a(EntityCreature var0, double var1, RandomSource var3, BlockPosition var4) {
        double var5 = var4.u();
        double var7 = var4.w();
        if (var0.gF() && var1 > 1.0) {
            BlockPosition var9 = var0.gC();
            var5 = var0.dP() > (double)var9.u() ? (var5 -= var3.j() * var1 / 2.0) : (var5 += var3.j() * var1 / 2.0);
            var7 = var0.dV() > (double)var9.w() ? (var7 -= var3.j() * var1 / 2.0) : (var7 += var3.j() * var1 / 2.0);
        }
        return BlockPosition.a(var5 + var0.dP(), (double)var4.v() + var0.dR(), var7 + var0.dV());
    }
}

