/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.LightEngineGraphSection;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceSection;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileSection;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.jspecify.annotations.Nullable;

public class VillagePlace
extends RegionFileSection<VillagePlaceSection, VillagePlaceSection.a> {
    public static final int a = 6;
    public static final int b = 1;
    private final a d;
    private final LongSet e = new LongOpenHashSet();

    public VillagePlace(RegionStorageInfo var0, Path var1, DataFixer var2, boolean var3, IRegistryCustom var4, ChunkIOErrorReporter var5, LevelHeightAccessor var6) {
        super(new SimpleRegionStorage(var0, var1, var2, var3, DataFixTypes.t), VillagePlaceSection.a.a, VillagePlaceSection::a, VillagePlaceSection.a::a, VillagePlaceSection::new, var4, var5, var6);
        this.d = new a();
    }

    public @Nullable VillagePlaceRecord a(BlockPosition var0, Holder<VillagePlaceType> var1) {
        return ((VillagePlaceSection)this.f(SectionPosition.c(var0))).a(var0, var1);
    }

    public void a(BlockPosition var0) {
        this.d(SectionPosition.c(var0)).ifPresent(var1 -> var1.a(var0));
    }

    public long a(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var1, int var2, Occupancy var3) {
        return this.c(var0, var1, var2, var3).count();
    }

    public boolean a(ResourceKey<VillagePlaceType> var0, BlockPosition var12) {
        return this.a(var12, (Holder<VillagePlaceType> var1) -> var1.a(var0));
    }

    public Stream<VillagePlaceRecord> b(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var1, int var22, Occupancy var3) {
        int var4 = Math.floorDiv(var22, 16) + 1;
        return ChunkCoordIntPair.a(new ChunkCoordIntPair(var1), var4).flatMap(var2 -> this.a(var0, (ChunkCoordIntPair)var2, var3)).filter(var2 -> {
            BlockPosition var3 = var2.g();
            return Math.abs(var3.u() - var1.u()) <= var22 && Math.abs(var3.w() - var1.w()) <= var22;
        });
    }

    public Stream<VillagePlaceRecord> c(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var1, int var22, Occupancy var3) {
        int var4 = var22 * var22;
        return this.b(var0, var1, var22, var3).filter(var2 -> var2.g().j(var1) <= (double)var4);
    }

    @VisibleForDebug
    public Stream<VillagePlaceRecord> a(Predicate<Holder<VillagePlaceType>> var0, ChunkCoordIntPair var12, Occupancy var22) {
        return IntStream.rangeClosed(this.c.ay(), this.c.az()).boxed().map(var1 -> this.d(SectionPosition.a(var12, (int)var1).s())).filter(Optional::isPresent).flatMap(var2 -> ((VillagePlaceSection)var2.get()).a(var0, var22));
    }

    public Stream<BlockPosition> a(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var1, BlockPosition var2, int var3, Occupancy var4) {
        return this.c(var0, var2, var3, var4).map(VillagePlaceRecord::g).filter(var1);
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> b(Predicate<Holder<VillagePlaceType>> var02, Predicate<BlockPosition> var12, BlockPosition var2, int var3, Occupancy var4) {
        return this.c(var02, var2, var3, var4).filter(var1 -> var12.test(var1.g())).map(var0 -> Pair.of(var0.h(), (Object)var0.g()));
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> c(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var12, BlockPosition var2, int var3, Occupancy var4) {
        return this.b(var0, var12, var2, var3, var4).sorted(Comparator.comparingDouble(var1 -> ((BlockPosition)var1.getSecond()).j(var2)));
    }

    public Optional<BlockPosition> d(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var1, BlockPosition var2, int var3, Occupancy var4) {
        return this.a(var0, var1, var2, var3, var4).findFirst();
    }

    public Optional<BlockPosition> d(Predicate<Holder<VillagePlaceType>> var0, BlockPosition var12, int var2, Occupancy var3) {
        return this.c(var0, var12, var2, var3).map(VillagePlaceRecord::g).min(Comparator.comparingDouble(var1 -> var1.j(var12)));
    }

    public Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> e(Predicate<Holder<VillagePlaceType>> var02, BlockPosition var12, int var2, Occupancy var3) {
        return this.c(var02, var12, var2, var3).min(Comparator.comparingDouble(var1 -> var1.g().j(var12))).map(var0 -> Pair.of(var0.h(), (Object)var0.g()));
    }

    public Optional<BlockPosition> e(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var12, BlockPosition var2, int var3, Occupancy var4) {
        return this.c(var0, var2, var3, var4).map(VillagePlaceRecord::g).filter(var12).min(Comparator.comparingDouble(var1 -> var1.j(var2)));
    }

    public Optional<BlockPosition> a(Predicate<Holder<VillagePlaceType>> var02, BiPredicate<Holder<VillagePlaceType>, BlockPosition> var12, BlockPosition var2, int var3) {
        return this.c(var02, var2, var3, Occupancy.a).filter(var1 -> var12.test(var1.h(), var1.g())).findFirst().map(var0 -> {
            var0.c();
            return var0.g();
        });
    }

    public Optional<BlockPosition> a(Predicate<Holder<VillagePlaceType>> var0, Predicate<BlockPosition> var12, Occupancy var2, BlockPosition var3, int var4, RandomSource var5) {
        List<VillagePlaceRecord> var6 = SystemUtils.a(this.c(var0, var3, var4, var2), var5);
        return var6.stream().filter(var1 -> var12.test(var1.g())).findFirst().map(VillagePlaceRecord::g);
    }

    public boolean b(BlockPosition var0) {
        return this.d(SectionPosition.c(var0)).map(var1 -> var1.c(var0)).orElseThrow(() -> SystemUtils.b(new IllegalStateException("POI never registered at " + String.valueOf(var0))));
    }

    public boolean a(BlockPosition var0, Predicate<Holder<VillagePlaceType>> var1) {
        return this.d(SectionPosition.c(var0)).map(var2 -> var2.a(var0, var1)).orElse(false);
    }

    public Optional<Holder<VillagePlaceType>> c(BlockPosition var0) {
        return this.d(SectionPosition.c(var0)).flatMap(var1 -> var1.d(var0));
    }

    @VisibleForDebug
    public @Nullable DebugPoiInfo d(BlockPosition var0) {
        return this.d(SectionPosition.c(var0)).flatMap(var1 -> var1.e(var0)).orElse(null);
    }

    public int a(SectionPosition var0) {
        this.d.a();
        return this.d.c(var0.s());
    }

    boolean g(long var0) {
        Optional var2 = this.c(var0);
        if (var2 == null) {
            return false;
        }
        return var2.map(var02 -> var02.a((Holder<VillagePlaceType> var0) -> var0.a(PoiTypeTags.b), Occupancy.b).findAny().isPresent()).orElse(false);
    }

    @Override
    public void a(BooleanSupplier var0) {
        super.a(var0);
        this.d.a();
    }

    @Override
    protected void a(long var0) {
        super.a(var0);
        this.d.b(var0, this.d.b(var0), false);
    }

    @Override
    protected void b(long var0) {
        this.d.b(var0, this.d.b(var0), false);
    }

    public void a(SectionPosition var0, ChunkSection var1) {
        SystemUtils.a(this.d(var0.s()), (T var22) -> var22.a((BiConsumer<BlockPosition, Holder<VillagePlaceType>> var2) -> {
            if (VillagePlace.a(var1)) {
                this.a(var1, var0, (BiConsumer<BlockPosition, Holder<VillagePlaceType>>)var2);
            }
        }), () -> {
            if (VillagePlace.a(var1)) {
                VillagePlaceSection var2 = (VillagePlaceSection)this.f(var0.s());
                this.a(var1, var0, var2::a);
            }
        });
    }

    private static boolean a(ChunkSection var0) {
        return var0.a(PoiTypes::b);
    }

    private void a(ChunkSection var0, SectionPosition var1, BiConsumer<BlockPosition, Holder<VillagePlaceType>> var2) {
        var1.t().forEach(var22 -> {
            IBlockData var3 = var0.a(SectionPosition.b(var22.u()), SectionPosition.b(var22.v()), SectionPosition.b(var22.w()));
            PoiTypes.a(var3).ifPresent(var2 -> var2.accept((BlockPosition)var22, (Holder<VillagePlaceType>)var2));
        });
    }

    public void a(IWorldReader var02, BlockPosition var12, int var2) {
        SectionPosition.a(new ChunkCoordIntPair(var12), Math.floorDiv(var2, 16), this.c.ay(), this.c.az()).map(var0 -> Pair.of((Object)var0, this.d(var0.s()))).filter(var0 -> ((Optional)var0.getSecond()).map(VillagePlaceSection::b).orElse(false) == false).map(var0 -> ((SectionPosition)var0.getFirst()).r()).filter(var0 -> this.e.add(var0.b())).forEach(var1 -> var02.a(var1.h, var1.i, ChunkStatus.c));
    }

    final class a
    extends LightEngineGraphSection {
        private final Long2ByteMap b;

        protected a() {
            super(7, 16, 256);
            this.b = new Long2ByteOpenHashMap();
            this.b.defaultReturnValue((byte)7);
        }

        @Override
        protected int b(long var0) {
            return VillagePlace.this.g(var0) ? 0 : 7;
        }

        @Override
        protected int c(long var0) {
            return this.b.get(var0);
        }

        @Override
        protected void a(long var0, int var2) {
            if (var2 > 6) {
                this.b.remove(var0);
            } else {
                this.b.put(var0, (byte)var2);
            }
        }

        public void a() {
            super.b(Integer.MAX_VALUE);
        }
    }

    public static final class Occupancy
    extends Enum<Occupancy> {
        public static final /* enum */ Occupancy a = new Occupancy(VillagePlaceRecord::e);
        public static final /* enum */ Occupancy b = new Occupancy(VillagePlaceRecord::f);
        public static final /* enum */ Occupancy c = new Occupancy(var0 -> true);
        private final Predicate<? super VillagePlaceRecord> d;
        private static final /* synthetic */ Occupancy[] e;

        public static Occupancy[] values() {
            return (Occupancy[])e.clone();
        }

        public static Occupancy valueOf(String var0) {
            return Enum.valueOf(Occupancy.class, var0);
        }

        private Occupancy(Predicate var2) {
            this.d = var2;
        }

        public Predicate<? super VillagePlaceRecord> a() {
            return this.d;
        }

        private static /* synthetic */ Occupancy[] b() {
            return new Occupancy[]{a, b, c};
        }

        static {
            e = Occupancy.b();
        }
    }
}

