/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cy = 6000;
    private static final int cv = 0;
    public int cw = 0;
    public @Nullable EntityReference<EntityPlayer> cx;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gW() {
        return EntityInsentient.E().a(GenericAttributes.G, 10.0);
    }

    @Override
    protected void a(WorldServer worldserver) {
        if (this.Z_() != 0) {
            this.cw = 0;
        }
        super.a(worldserver);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.Z_() != 0) {
            this.cw = 0;
        }
        if (this.cw > 0) {
            --this.cw;
            if (this.cw % 10 == 0) {
                double d0 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d2 = this.as.k() * 0.02;
                this.ao().a(Particles.T, this.e(1.0), this.dS() + 0.5, this.h(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(worldserver, damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.hc();
        return true;
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.e()).a(Blocks.i) ? 10.0f : iworldreader.C(blockposition);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("InLove", this.cw);
        EntityReference.a(this.cx, valueoutput, "LoveCause");
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cw = valueinput.a("InLove", 0);
        this.cx = EntityReference.a(valueinput, "LoveCause");
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        boolean flag = EntitySpawnReason.b(entityspawnreason) || EntityAnimal.a(generatoraccess, blockposition);
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cl) && flag;
    }

    protected static boolean a(IBlockLightAccess iblocklightaccess, BlockPosition blockposition) {
        return iblocklightaccess.b(blockposition, 0) > 8;
    }

    @Override
    public int S() {
        return 120;
    }

    @Override
    public boolean i(double d0) {
        return false;
    }

    @Override
    protected int f(WorldServer worldserver) {
        return 1 + this.as.a(3);
    }

    public abstract boolean j(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (this.j(itemstack)) {
            int i2 = this.Z_();
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                if (i2 == 0 && this.gY()) {
                    this.a(entityhuman, enumhand, itemstack);
                    this.h(entityplayer);
                    this.gX();
                    return EnumInteractionResult.b;
                }
            }
            if (this.e_()) {
                this.a(entityhuman, enumhand, itemstack);
                this.a(EntityAnimal.d(-i2), true);
                this.gX();
                return EnumInteractionResult.a;
            }
            if (this.ao().B_()) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(entityhuman, enumhand);
    }

    protected void gX() {
    }

    public boolean gY() {
        return this.cw <= 0;
    }

    public void h(@Nullable EntityHuman entityhuman) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(entityhuman, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.cw = entityEnterLoveModeEvent.getTicksInLove();
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            this.cx = EntityReference.a(entityplayer);
        }
        this.breedItem = entityhuman.gK().h();
        this.ao().a((Entity)this, (byte)18);
    }

    public void r(int i2) {
        this.cw = i2;
    }

    public int gZ() {
        return this.cw;
    }

    public @Nullable EntityPlayer ha() {
        return EntityReference.a(this.cx, this.ao(), EntityPlayer.class);
    }

    public boolean hb() {
        return this.cw > 0;
    }

    public void hc() {
        this.cw = 0;
    }

    public boolean a(EntityAnimal entityanimal) {
        return entityanimal == this ? false : (entityanimal.getClass() != this.getClass() ? false : this.hb() && entityanimal.hb());
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        EntityAgeable entityageable = this.a(worldserver, (EntityAgeable)entityanimal);
        if (entityageable != null) {
            entityageable.a_(true);
            entityageable.b(this.dP(), this.dR(), this.dV(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.ha()).or(() -> Optional.ofNullable(entityanimal.ha())).orElse(null);
            int experience = this.ep().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, entityanimal, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, experience);
            worldserver.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable) {
        this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, this.ep().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        Optional.ofNullable(this.ha()).or(() -> Optional.ofNullable(entityanimal.ha())).ifPresent(entityplayer -> {
            entityplayer.a(StatisticList.R);
            CriterionTriggers.p.a((EntityPlayer)entityplayer, this, entityanimal, entityageable);
        });
        this.d_(6000);
        entityanimal.d_(6000);
        this.hc();
        entityanimal.hc();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.U().a(GameRules.D).booleanValue() && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dP(), this.dR(), this.dV(), experience));
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d2 = this.as.k() * 0.02;
                this.ao().a(Particles.T, this.e(1.0), this.dS() + 0.5, this.h(1.0), d0, d1, d2);
            }
        } else {
            super.b(b0);
        }
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        EnumDirection enumdirection = this.dh();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(entityliving);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dK();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EntityPose entitypose : entityliving.go()) {
            AxisAlignedBB axisalignedbb = entityliving.f(entitypose);
            for (int[] aint1 : aint) {
                blockposition_mutableblockposition.d(blockposition.u() + aint1[0], blockposition.v(), blockposition.w() + aint1[1]);
                double d0 = this.ao().m(blockposition_mutableblockposition);
                if (!DismountUtil.a(d0)) continue;
                Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                if (!DismountUtil.a(this.ao(), entityliving, axisalignedbb.c(vec3d))) continue;
                entityliving.c(entitypose);
                return vec3d;
            }
        }
        return super.b(entityliving);
    }
}

