/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.EasingType;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class Axolotl
extends EntityAnimal
implements Bucketable {
    public static final int cv = 200;
    private static final int cG = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> cw = ImmutableList.of(SensorType.c, SensorType.o, SensorType.f, SensorType.q, SensorType.r);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.L, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.O, MemoryModuleType.C, MemoryModuleType.P, MemoryModuleType.Q, MemoryModuleType.S, MemoryModuleType.V, MemoryModuleType.aa});
    private static final DataWatcherObject<Integer> cH = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cI = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cJ = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double cz = 20.0;
    public static final int cA = 1200;
    private static final int cK = 6000;
    public static final String cB = "Variant";
    private static final int cL = 1800;
    private static final int cM = 2400;
    private static final boolean cN = false;
    public final BinaryAnimator cC = new BinaryAnimator(10, EasingType.x);
    public final BinaryAnimator cD = new BinaryAnimator(10, EasingType.x);
    public final BinaryAnimator cE = new BinaryAnimator(10, EasingType.x);
    public final BinaryAnimator cF = new BinaryAnimator(10, EasingType.x);
    private static final int cO = 100;

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    public Axolotl(EntityTypes<? extends Axolotl> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.a(PathType.j, 0.0f);
        this.cp = new d(this);
        this.co = new c(this, 20);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cH, 0);
        datawatcher_a.a(cI, false);
        datawatcher_a.a(cJ, false);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a(cB, Variant.i, this.gP());
        valueoutput.a("FromBucket", this.a());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a(cB, Variant.i).orElse(Variant.f));
        this.a(valueinput.a("FromBucket", false));
    }

    @Override
    public void T() {
        if (!this.gQ()) {
            super.T();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        boolean flag = false;
        if (entityspawnreason == EntitySpawnReason.l) {
            return groupdataentity;
        }
        RandomSource randomsource = worldaccess.G_();
        if (groupdataentity instanceof b) {
            if (((b)groupdataentity).a() >= 2) {
                flag = true;
            }
        } else {
            groupdataentity = new b(Variant.a(randomsource), Variant.a(randomsource));
        }
        this.a(((b)groupdataentity).a(randomsource));
        if (flag) {
            this.d_(-24000);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public void aJ() {
        World world;
        int i2 = this.cK();
        super.aJ();
        if (!this.gG() && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, i2);
        }
        if (this.ao().B_()) {
            this.gS();
        }
    }

    private void gS() {
        a axolotl_a = this.gQ() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.a : (this.by() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.b : (this.aV() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.c : net.minecraft.world.entity.animal.axolotl.Axolotl$a.d));
        this.cC.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.a);
        this.cD.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.b);
        this.cE.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.c);
        boolean flag = this.bB.d() || this.ee() != this.ac || this.ec() != this.ab;
        this.cF.a(flag);
    }

    protected void a(WorldServer worldserver, int i2) {
        if (this.cb() && !this.bA()) {
            this.j(i2 - 1);
            if (this.eA()) {
                this.j(0);
                this.a(worldserver, this.en().t(), 2.0f);
            }
        } else {
            this.j(this.cJ());
        }
    }

    public void p() {
        int i2 = this.cK() + 1800;
        this.j(Math.min(i2, this.cJ()));
    }

    @Override
    public int cJ() {
        return this.maxAirTicks;
    }

    public Variant gP() {
        return Variant.a(this.az.a(cH));
    }

    public void a(Variant axolotl_variant) {
        this.az.a(cH, axolotl_variant.a());
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aW ? Axolotl.c(datacomponenttype, this.gP()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aW);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aW) {
            this.a(Axolotl.c(DataComponents.aW, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    private static boolean a(RandomSource randomsource) {
        return randomsource.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return iworldreader.f(this);
    }

    @Override
    public boolean db() {
        return false;
    }

    public void x(boolean flag) {
        this.az.a(cI, flag);
    }

    public boolean gQ() {
        return this.az.a(cI);
    }

    @Override
    public boolean a() {
        return this.az.a(cJ);
    }

    @Override
    public void a(boolean flag) {
        this.az.a(cJ, flag);
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        Axolotl axolotl = EntityTypes.j.a(worldserver, EntitySpawnReason.e);
        if (axolotl != null) {
            Variant axolotl_variant = Axolotl.a(this.as) ? Variant.b(this.as) : (this.as.h() ? this.gP() : ((Axolotl)entityageable).gP());
            axolotl.a(axolotl_variant);
            axolotl.gz();
        }
        return axolotl;
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.bh);
    }

    @Override
    public boolean aj_() {
        return true;
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("axolotlBrain");
        this.ev().a(worldserver, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        gameprofilerfiller.c();
        if (!this.gG()) {
            Optional<Integer> optional = this.ev().c(MemoryModuleType.O);
            this.x(optional.isPresent() && optional.get() > 0);
        }
    }

    public static AttributeProvider.Builder gR() {
        return EntityAnimal.gW().a(GenericAttributes.u, 14.0).a(GenericAttributes.x, 1.0).a(GenericAttributes.d, 2.0).a(GenericAttributes.D, 1.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new AmphibiousPathNavigation(this, world);
    }

    @Override
    public void fN() {
        this.a(SoundEffects.aN, 1.0f, 1.0f);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        float f1 = this.eZ();
        if (!this.gG() && this.ao().y.a(3) == 0 && ((float)this.ao().y.a(3) < f2 || f1 / this.fq() < 0.5f) && f2 < f1 && this.by() && (damagesource.d() != null || damagesource.c() != null) && !this.gQ()) {
            this.ca.a(MemoryModuleType.O, 200);
        }
        return super.a(worldserver, damagesource, f2);
    }

    @Override
    public int ac() {
        return 1;
    }

    @Override
    public int ae() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return Bucketable.a(entityhuman, enumhand, this).orElse(super.b(entityhuman, enumhand));
    }

    @Override
    public void a(ItemStack itemstack) {
        Bucketable.a((EntityInsentient)this, itemstack);
        itemstack.a(DataComponents.aW, (DataComponentGetter)this);
        CustomData.a(DataComponents.ag, itemstack, (NBTTagCompound nbttagcompound) -> {
            nbttagcompound.a("Age", this.Z_());
            BehaviorController<Axolotl> behaviorcontroller = this.ev();
            if (behaviorcontroller.a(MemoryModuleType.V)) {
                nbttagcompound.a("HuntingCooldown", behaviorcontroller.e(MemoryModuleType.V));
            }
        });
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        Bucketable.a((EntityInsentient)this, nbttagcompound);
        this.d_(nbttagcompound.b("Age", 0));
        nbttagcompound.f("HuntingCooldown").ifPresentOrElse(olong -> this.ev().a(MemoryModuleType.V, true, nbttagcompound.b("HuntingCooldown", 0L)), () -> this.ev().a(MemoryModuleType.V, Optional.empty()));
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.sv);
    }

    @Override
    public SoundEffect c() {
        return SoundEffects.dw;
    }

    @Override
    public boolean eS() {
        return !this.gQ() && super.eS();
    }

    public static void a(WorldServer worldserver, Axolotl axolotl, EntityLiving entityliving) {
        Entity entity;
        DamageSource damagesource;
        if (entityliving.fa() && (damagesource = entityliving.fb()) != null && (entity = damagesource.d()) != null && entity.ay() == EntityTypes.cb) {
            EntityHuman entityhuman = (EntityHuman)entity;
            List<EntityHuman> list = worldserver.a(EntityHuman.class, axolotl.dj().g(20.0));
            if (list.contains(entityhuman)) {
                axolotl.g(entityhuman);
            }
        }
    }

    public void g(EntityHuman entityhuman) {
        MobEffect mobeffect = entityhuman.e(MobEffects.j);
        if (mobeffect == null || mobeffect.a(2399)) {
            int i2 = mobeffect != null ? mobeffect.d() : 0;
            int j2 = Math.min(2400, 100 + i2);
            entityhuman.addEffect(new MobEffect(MobEffects.j, j2, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        entityhuman.g(MobEffects.d);
    }

    @Override
    public boolean ab() {
        return super.ab() || this.a();
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.aP;
    }

    @Override
    protected @Nullable SoundEffect fd() {
        return SoundEffects.aO;
    }

    @Override
    protected @Nullable SoundEffect W() {
        return this.by() ? SoundEffects.aR : SoundEffects.aQ;
    }

    @Override
    protected SoundEffect bl() {
        return SoundEffects.aS;
    }

    @Override
    protected SoundEffect bk() {
        return SoundEffects.aT;
    }

    protected BehaviorController.b<Axolotl> ew() {
        return BehaviorController.a(cx, cw);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.ew().a(dynamic));
    }

    public BehaviorController<Axolotl> ev() {
        return super.ev();
    }

    @Override
    protected void a(Vec3D vec3d, double d0, boolean flag, double d1) {
        this.a(this.fM(), vec3d);
        this.a(EnumMoveType.a, this.dN());
        this.k(this.dN().c(0.9));
    }

    @Override
    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        if (itemstack.a(Items.su)) {
            entityhuman.a(enumhand, ItemLiquidUtil.a(itemstack, entityhuman, new ItemStack(Items.sl)));
        } else {
            super.a(entityhuman, enumhand, itemstack);
        }
    }

    @Override
    public boolean i(double d0) {
        return !this.a() && !this.i_();
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> entitytypes, WorldAccess worldaccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return worldaccess.a_(blockposition.e()).a(TagsBlock.cn);
    }

    private static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public d(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.gQ()) {
                super.a();
            }
        }
    }

    private class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl axolotl2, int i2) {
            super(axolotl2, i2);
        }

        @Override
        public void a() {
            if (!Axolotl.this.gQ()) {
                super.a();
            }
        }
    }

    public static enum Variant implements INamable
    {
        a(0, "lucy", true),
        b(1, "wild", true),
        c(2, "gold", true),
        d(3, "cyan", true),
        e(4, "blue", false);

        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> g;
        public static final Codec<Variant> h;
        @Deprecated
        public static final Codec<Variant> i;
        private final int k;
        private final String l;
        private final boolean m;

        private Variant(int i2, String s2, boolean flag) {
            this.k = i2;
            this.l = s2;
            this.m = flag;
        }

        public int a() {
            return this.k;
        }

        public String b() {
            return this.l;
        }

        @Override
        public String c() {
            return this.l;
        }

        public static Variant a(int i2) {
            return j.apply(i2);
        }

        public static Variant a(RandomSource randomsource) {
            return Variant.a(randomsource, true);
        }

        public static Variant b(RandomSource randomsource) {
            return Variant.a(randomsource, false);
        }

        private static Variant a(RandomSource randomsource, boolean flag) {
            Variant[] aaxolotl_variant = (Variant[])Arrays.stream(Variant.values()).filter(axolotl_variant -> axolotl_variant.m == flag).toArray(Variant[]::new);
            return SystemUtils.a(aaxolotl_variant, randomsource);
        }

        static {
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            g = ByteBufCodecs.a(j, Variant::a);
            h = INamable.a(Variant::values);
            PrimitiveCodec primitivecodec = Codec.INT;
            IntFunction<Variant> intfunction = j;
            Objects.requireNonNull(intfunction);
            i = primitivecodec.xmap(intfunction::apply, Variant::a);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] a;

        public b(Variant ... aaxolotl_variant) {
            super(false);
            this.a = aaxolotl_variant;
        }

        public Variant a(RandomSource randomsource) {
            return this.a[randomsource.a(this.a.length)];
        }
    }

    public static enum a {
        a,
        b,
        c,
        d;

    }
}

