/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.cow;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public abstract class AbstractCow
extends EntityAnimal {
    private static final EntitySize cv = EntityTypes.G.n().a(0.5f).b(0.665f);

    public AbstractCow(EntityTypes<? extends AbstractCow> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 2.0));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.aE), false));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aE);
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 10.0).a(GenericAttributes.x, 0.2f);
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.hg;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.hi;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.hh;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.hk, 0.15f, 1.0f);
    }

    @Override
    protected float fC() {
        return 0.4f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.sk) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(entityhuman.ao(), entityhuman, this.dK(), this.dK(), null, itemstack, Items.sq, enumhand);
            if (event.isCancelled()) {
                return EnumInteractionResult.e;
            }
            entityhuman.a(SoundEffects.hj, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
            entityhuman.a(enumhand, itemstack1);
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.e_() ? cv : super.b(entitypose);
    }
}

