/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.fox;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import net.minecraft.world.entity.animal.fish.EntityFish;
import net.minecraft.world.entity.animal.fish.EntityFishSchool;
import net.minecraft.world.entity.animal.polarbear.EntityPolarBear;
import net.minecraft.world.entity.animal.rabbit.EntityRabbit;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityFox
extends EntityAnimal {
    private static final DataWatcherObject<Integer> cz = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cA = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int cB = 1;
    public static final int cv = 4;
    public static final int cw = 8;
    public static final int cx = 16;
    private static final int cC = 32;
    private static final int cD = 64;
    private static final int cE = 128;
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cF = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cG = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> cH = entityitem -> !entityitem.n() && entityitem.cb();
    private static final Predicate<Entity> cI = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.eN() != null && entityliving.eO() < entityliving.at + 600;
    };
    static final Predicate<Entity> cJ = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> cK = entity -> !entity.cx() && IEntitySelector.e.test((Entity)entity);
    private static final int cL = 600;
    private static final EntitySize cM = EntityTypes.ae.n().a(0.5f).b(0.2975f);
    private static final Codec<List<EntityReference<EntityLiving>>> cN = EntityReference.a().listOf();
    private static final boolean cO = false;
    private static final boolean cP = false;
    private static final boolean cQ = false;
    private PathfinderGoal cR;
    private PathfinderGoal cU;
    private PathfinderGoal cV;
    private float cW;
    private float cX;
    float cY;
    float cZ;
    private int da;

    public EntityFox(EntityTypes<? extends EntityFox> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.co = new k();
        this.cp = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.b_(true);
        this.N().a(32.0f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cF, Optional.empty());
        datawatcher_a.a(cG, Optional.empty());
        datawatcher_a.a(cz, Type.c.a());
        datawatcher_a.a(cA, (byte)0);
    }

    @Override
    protected void D() {
        this.cR = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, (entityliving, worldserver) -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cU = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.cv);
        this.cV = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, (entityliving, worldserver) -> entityliving instanceof EntityFishSchool);
        this.cs.a(0, new g());
        this.cs.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.ao()));
        this.cs.a(1, new b());
        this.cs.a(2, new n(2.2));
        this.cs.a(3, new e(this, 1.0));
        this.cs.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> cK.test((Entity)entityliving) && !this.j((EntityLiving)entityliving) && !this.hf()));
        this.cs.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).p() && !this.hf()));
        this.cs.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.hf()));
        this.cs.a(5, new u());
        this.cs.a(6, new o());
        this.cs.a(6, new s(1.25));
        this.cs.a(7, new l((double)1.2f, true));
        this.cs.a(7, new t());
        this.cs.a(8, new h(this, 1.25));
        this.cs.a(9, new q(32, 200));
        this.cs.a(10, new f((double)1.2f, 12, 1));
        this.cs.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.cs.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(11, new p());
        this.cs.a(12, new j(this, EntityHuman.class, 24.0f));
        this.cs.a(13, new r());
        this.ct.a(3, new a(EntityLiving.class, false, false, (entityliving, worldserver) -> cI.test(entityliving) && !this.j(entityliving)));
    }

    @Override
    public void d_() {
        if (!this.ao().B_() && this.cb() && this.dy()) {
            EntityLiving entityliving;
            ++this.da;
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (this.k(itemstack)) {
                if (this.da > 600) {
                    ItemStack itemstack1 = itemstack.a(this.ao(), (EntityLiving)this);
                    if (!itemstack1.f()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.da = 0;
                } else if (this.da > 560 && this.as.i() < 0.1f) {
                    this.gX();
                    this.ao().a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.ag_()) == null || !entityliving.cb()) {
                this.z(false);
                this.A(false);
            }
        }
        if (this.gr() || this.fE()) {
            this.bM = false;
            this.bN = 0.0f;
            this.bP = 0.0f;
        }
        super.d_();
        if (this.hf() && this.as.i() < 0.05f) {
            this.a(SoundEffects.kT, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fE() {
        return this.fa();
    }

    private boolean k(ItemStack itemstack) {
        return this.l(itemstack) && this.ag_() == null && this.aV() && !this.gr();
    }

    private boolean l(ItemStack itemstack) {
        return itemstack.c(DataComponents.y) && itemstack.c(DataComponents.z);
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.2f) {
            float f2 = randomsource.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.qb) : (f2 < 0.2f ? new ItemStack(Items.sD) : (f2 < 0.4f ? (randomsource.h() ? new ItemStack(Items.wQ) : new ItemStack(Items.wR)) : (f2 < 0.6f ? new ItemStack(Items.rc) : (f2 < 0.8f ? new ItemStack(Items.sp) : new ItemStack(Items.qZ)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 45) {
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (!itemstack.f()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.as.i() - 0.5) * 0.1, (double)this.as.i() * 0.1 + 0.1, 0.0).a(-this.ee() * ((float)Math.PI / 180)).b(-this.ec() * ((float)Math.PI / 180));
                    this.ao().a(new ParticleParamItem(Particles.V, itemstack), this.dP() + this.cj().g / 2.0, this.dR(), this.dV() + this.cj().i / 2.0, vec3d.g, vec3d.h + 0.05, vec3d.i);
                }
            }
        } else {
            super.b(b0);
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.3f).a(GenericAttributes.u, 10.0).a(GenericAttributes.d, 2.0).a(GenericAttributes.z, 5.0).a(GenericAttributes.o, 32.0);
    }

    public @Nullable EntityFox b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityFox entityfox = EntityTypes.ae.a(worldserver, EntitySpawnReason.e);
        if (entityfox != null) {
            entityfox.a(this.as.h() ? this.gP() : ((EntityFox)entityageable).gP());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.ct) && EntityFox.a(generatoraccess, blockposition);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        Holder<BiomeBase> holder = worldaccess.z(this.dK());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (groupdataentity instanceof i) {
            i entityfox_i = (i)groupdataentity;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            groupdataentity = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.d_(-24000);
        }
        if (worldaccess instanceof WorldServer) {
            this.gV();
        }
        this.a(worldaccess.G_(), difficultydamagescaler);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private void gV() {
        if (this.gP() == Type.a) {
            this.ct.a(4, this.cR);
            this.ct.a(4, this.cU);
            this.ct.a(6, this.cV);
        } else {
            this.ct.a(4, this.cV);
            this.ct.a(6, this.cR);
            this.ct.a(6, this.cU);
        }
    }

    @Override
    protected void gX() {
        this.a(SoundEffects.kX, 1.0f, 1.0f);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.e_() ? cM : super.b(entitypose);
    }

    public Type gP() {
        return Type.a(this.az.a(cz));
    }

    public void a(Type entityfox_type) {
        this.az.a(cz, entityfox_type.a());
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aG ? EntityFox.c(datacomponenttype, this.gP()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aG);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aG) {
            this.a(EntityFox.c(DataComponents.aG, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    Stream<EntityReference<EntityLiving>> hd() {
        return Stream.concat(this.az.a(cF).stream(), this.az.a(cG).stream());
    }

    void i(EntityLiving entityliving) {
        this.a(EntityReference.a(entityliving));
    }

    private void a(EntityReference<EntityLiving> entityreference) {
        if (this.az.a(cF).isPresent()) {
            this.az.a(cG, Optional.of(entityreference));
        } else {
            this.az.a(cF, Optional.of(entityreference));
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Trusted", cN, this.hd().toList());
        valueoutput.a("Sleeping", this.gr());
        valueoutput.a("Type", Type.d, this.gP());
        valueoutput.a("Sitting", this.gQ());
        valueoutput.a("Crouching", this.cz());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.he();
        valueinput.a("Trusted", cN).orElse(List.of()).forEach(this::a);
        this.D(valueinput.a("Sleeping", false));
        this.a(valueinput.a("Type", Type.d).orElse(Type.c));
        this.x(valueinput.a("Sitting", false));
        this.z(valueinput.a("Crouching", false));
        if (this.ao() instanceof WorldServer) {
            this.gV();
        }
    }

    private void he() {
        this.az.a(cF, Optional.empty());
        this.az.a(cG, Optional.empty());
    }

    public boolean gQ() {
        return this.s(1);
    }

    public void x(boolean flag) {
        this.d(1, flag);
    }

    public boolean gR() {
        return this.s(64);
    }

    void B(boolean flag) {
        this.d(64, flag);
    }

    boolean hf() {
        return this.s(128);
    }

    void C(boolean flag) {
        this.d(128, flag);
    }

    @Override
    public boolean gr() {
        return this.s(32);
    }

    public void D(boolean flag) {
        this.d(32, flag);
    }

    private void d(int i2, boolean flag) {
        if (flag) {
            this.az.a(cA, (byte)(this.az.a(cA) | i2));
        } else {
            this.az.a(cA, (byte)(this.az.a(cA) & ~i2));
        }
    }

    private boolean s(int i2) {
        return (this.az.a(cA) & i2) != 0;
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.a && this.gn();
    }

    @Override
    public boolean h(ItemStack itemstack) {
        ItemStack itemstack1 = this.a(EnumItemSlot.a);
        return itemstack1.f() || this.da > 0 && this.l(itemstack) && !this.l(itemstack1);
    }

    private void m(ItemStack itemstack) {
        if (!itemstack.f() && !this.ao().B_()) {
            EntityItem entityitem = new EntityItem(this.ao(), this.dP() + this.cj().g, this.dR() + 1.0, this.dV() + this.cj().i, itemstack);
            entityitem.a(40);
            entityitem.b((Entity)this);
            this.a(SoundEffects.lc, 1.0f, 1.0f);
            this.ao().b(entityitem);
        }
    }

    private void n(ItemStack itemstack) {
        EntityItem entityitem = new EntityItem(this.ao(), this.dP(), this.dR(), this.dV(), itemstack);
        this.ao().b(entityitem);
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        ItemStack itemstack = entityitem.e();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entityitem, itemstack.N() - 1, !this.h(itemstack)).isCancelled()) {
            itemstack = entityitem.e();
            int i2 = itemstack.N();
            if (i2 > 1) {
                this.n(itemstack.a(i2 - 1));
            }
            this.m(this.a(EnumItemSlot.a));
            this.a(entityitem);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.g(EnumItemSlot.a);
            this.a((Entity)entityitem, itemstack.N());
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            this.da = 0;
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.dy()) {
            boolean flag = this.by();
            if (flag || this.ag_() != null || this.ao().an()) {
                this.hg();
            }
            if (flag || this.gr()) {
                this.x(false);
            }
            if (this.gR() && this.ao().y.i() < 0.2f) {
                BlockPosition blockposition = this.dK();
                IBlockData iblockdata = this.ao().a_(blockposition);
                this.ao().c(2001, blockposition, Block.j(iblockdata));
            }
        }
        this.cX = this.cW;
        this.cW = this.gU() ? (this.cW += (1.0f - this.cW) * 0.4f) : (this.cW += (0.0f - this.cW) * 0.4f);
        this.cZ = this.cY;
        if (this.cz()) {
            this.cY += 0.2f;
            if (this.cY > 3.0f) {
                this.cY = 3.0f;
            }
        } else {
            this.cY = 0.0f;
        }
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aD);
    }

    @Override
    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
        ((EntityFox)entityinsentient).i(entityhuman);
    }

    public boolean gS() {
        return this.s(16);
    }

    public void y(boolean flag) {
        this.d(16, flag);
    }

    public boolean gT() {
        return this.cY == 3.0f;
    }

    public void z(boolean flag) {
        this.d(4, flag);
    }

    @Override
    public boolean cz() {
        return this.s(4);
    }

    public void A(boolean flag) {
        this.d(8, flag);
    }

    public boolean gU() {
        return this.s(8);
    }

    public float L(float f2) {
        return MathHelper.h(f2, this.cX, this.cW) * 0.11f * (float)Math.PI;
    }

    public float M(float f2) {
        return MathHelper.h(f2, this.cZ, this.cY);
    }

    @Override
    public void g(@Nullable EntityLiving entityliving) {
        if (this.hf() && entityliving == null) {
            this.C(false);
        }
        super.g(entityliving);
    }

    void hg() {
        this.D(false);
    }

    void hh() {
        this.A(false);
        this.z(false);
        this.x(false);
        this.D(false);
        this.C(false);
        this.B(false);
    }

    boolean hi() {
        return !this.gr() && !this.gQ() && !this.gR();
    }

    @Override
    public void T() {
        SoundEffect soundeffect = this.W();
        if (soundeffect == SoundEffects.kZ) {
            this.a(soundeffect, 2.0f, this.fD());
        } else {
            super.T();
        }
    }

    @Override
    protected @Nullable SoundEffect W() {
        List<Entity> list;
        if (this.gr()) {
            return SoundEffects.la;
        }
        if (!this.ao().ag() && this.as.i() < 0.1f && (list = this.ao().a(EntityHuman.class, this.dj().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.kZ;
        }
        return SoundEffects.kU;
    }

    @Override
    protected @Nullable SoundEffect h(DamageSource damagesource) {
        return SoundEffects.kY;
    }

    @Override
    protected @Nullable SoundEffect fd() {
        return SoundEffects.kW;
    }

    boolean j(EntityLiving entityliving) {
        return this.hd().anyMatch(entityreference -> entityreference.b(entityliving));
    }

    @Override
    protected void b(WorldServer worldserver, DamageSource damagesource) {
        ItemStack itemstack = this.a(EnumItemSlot.a);
        if (!itemstack.f()) {
            this.a(worldserver, itemstack);
            this.a(EnumItemSlot.a, ItemStack.l);
        }
        super.b(worldserver, damagesource);
    }

    public static boolean a(EntityFox entityfox, EntityLiving entityliving) {
        double d0 = entityliving.dV() - entityfox.dV();
        double d1 = entityliving.dP() - entityfox.dP();
        double d2 = d0 / d1;
        int i2 = 6;
        for (int j2 = 0; j2 < 6; ++j2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j2 / 6.0f) : d3 / d2;
            for (int k2 = 1; k2 < 4; ++k2) {
                if (entityfox.ao().a_(BlockPosition.a(entityfox.dP() + d4, entityfox.dR() + (double)k2, entityfox.dV() + d3)).v()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.55f * this.dk(), this.dF() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.gr()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gS() && !EntityFox.this.cz() && !EntityFox.this.gU() && !EntityFox.this.gR();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.hi()) {
                super.a();
            }
        }
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final Type c;
        public static final INamable.a<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final int g;
        private final String h;

        private Type(int i2, String s2) {
            this.g = i2;
            this.h = s2;
        }

        @Override
        public String c() {
            return this.h;
        }

        public int a() {
            return this.g;
        }

        public static Type a(int i2) {
            return f.apply(i2);
        }

        public static Type a(Holder<BiomeBase> holder) {
            return holder.a(BiomeTags.ao) ? b : a;
        }

        static {
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
            e = ByteBufCodecs.a(f, Type::a);
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.hh();
        }

        @Override
        public boolean b() {
            return EntityFox.this.by() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bN();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.gR();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.B(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.hf() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(EntityFox entityFox, double d0) {
            super(entityFox, d0);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).hh();
            ((EntityFox)this.c).hh();
            super.d();
        }

        @Override
        protected void g() {
            EntityFox entityfox = (EntityFox)this.a.a(this.b, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.ha();
                EntityPlayer entityplayer1 = this.c.ha();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.i(entityplayer);
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.i(entityplayer1);
                }
                entityfox.d_(-24000);
                entityfox.b(this.a.dP(), this.a.dR(), this.a.dV(), 0.0f, 0.0f);
                int experience = this.a.ep().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.R);
                    CriterionTriggers.p.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.d_(6000);
                this.c.d_(6000);
                this.a.hc();
                this.c.hc();
                this.b.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (this.b.U().a(GameRules.D).booleanValue() && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dP(), this.a.dR(), this.a.dV(), experience));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.gr()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.ag_();
            return entityliving != null && entityliving.cb() && cJ.test(entityliving) && EntityFox.this.g((Entity)entityliving) > 36.0 && !EntityFox.this.cz() && !EntityFox.this.gU() && !EntityFox.this.bM;
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.B(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.ag_();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.A(true);
                EntityFox.this.z(true);
                EntityFox.this.N().n();
                EntityFox.this.J().a(entityliving, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
            } else {
                EntityFox.this.A(false);
                EntityFox.this.z(false);
            }
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.ag_();
            if (entityliving != null) {
                EntityFox.this.J().a(entityliving, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
                if (EntityFox.this.g((Entity)entityliving) <= 36.0) {
                    EntityFox.this.A(true);
                    EntityFox.this.z(true);
                    EntityFox.this.N().n();
                } else {
                    EntityFox.this.N().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gT()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.ag_();
            if (entityliving != null && entityliving.cb()) {
                if (entityliving.dh() != entityliving.dg()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.N().a((Entity)entityliving, 0);
                    EntityFox.this.z(false);
                    EntityFox.this.A(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = EntityFox.this.ag_();
            if (entityliving != null && entityliving.cb()) {
                double d0 = EntityFox.this.dN().h;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.ee()) >= 15.0f || !EntityFox.this.aV()) && !EntityFox.this.gR();
            }
            return false;
        }

        @Override
        public boolean W_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.t(true);
            EntityFox.this.y(true);
            EntityFox.this.A(false);
            EntityLiving entityliving = EntityFox.this.ag_();
            if (entityliving != null) {
                EntityFox.this.J().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dP() - EntityFox.this.dP(), entityliving.dR() - EntityFox.this.dR(), entityliving.dV() - EntityFox.this.dV()).d();
                EntityFox.this.k(EntityFox.this.dN().b(vec3d.g * 0.8, 0.9, vec3d.i * 0.8));
            }
            EntityFox.this.N().n();
        }

        @Override
        public void e() {
            EntityFox.this.z(false);
            EntityFox.this.cY = 0.0f;
            EntityFox.this.cZ = 0.0f;
            EntityFox.this.A(false);
            EntityFox.this.y(false);
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.ag_();
            if (entityliving != null) {
                EntityFox.this.J().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gR()) {
                Vec3D vec3d = EntityFox.this.dN();
                if (vec3d.h * vec3d.h < (double)0.03f && EntityFox.this.ee() != 0.0f) {
                    EntityFox.this.w(MathHelper.i(0.2f, EntityFox.this.ee(), 0.0f));
                } else {
                    double d0 = vec3d.i();
                    double d1 = Math.signum(-vec3d.h) * Math.acos(d0 / vec3d.g()) * 57.2957763671875;
                    EntityFox.this.w((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.f((Entity)entityliving) <= 2.0f) {
                EntityFox.this.c(o.a(EntityFox.this.ao()), (Entity)entityliving);
            } else if (EntityFox.this.ee() > 0.0f && EntityFox.this.aV() && (float)EntityFox.this.dN().h != 0.0f && EntityFox.this.ao().a_(EntityFox.this.dK()).a(Blocks.ep)) {
                EntityFox.this.w(60.0f);
                EntityFox.this.g((EntityLiving)null);
                EntityFox.this.B(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.fox.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.gr() && this.a.ag_() == null) {
                if (EntityFox.this.ao().an() && EntityFox.this.ao().k(this.a.dK())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.dK();
                return EntityFox.this.ao().ag() && EntityFox.this.ao().k(blockposition) && !((WorldServer)EntityFox.this.ao()).e(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.hh();
            super.d();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving entityliving) {
            if (this.b(entityliving)) {
                this.h();
                this.a.c(l.a(this.a), (Entity)entityliving);
                EntityFox.this.a(SoundEffects.kV, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.gQ() && !EntityFox.this.gr() && !EntityFox.this.cz() && !EntityFox.this.gR() && super.b();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.fox.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.as.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bN == 0.0f && EntityFox.this.bO == 0.0f && EntityFox.this.bP == 0.0f ? this.k() || EntityFox.this.gr() : false;
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.ao().ag() && this.h() && !this.i() && !EntityFox.this.aJ;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.as.a(c);
            EntityFox.this.hh();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.z(false);
            EntityFox.this.A(false);
            EntityFox.this.t(false);
            EntityFox.this.D(true);
            EntityFox.this.N().n();
            EntityFox.this.K().a(EntityFox.this.dP(), EntityFox.this.dR(), EntityFox.this.dV(), 0.0);
        }
    }

    private static class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.d = entityfox;
        }

        @Override
        public boolean b() {
            return !this.d.hf() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.hf() && super.c();
        }

        @Override
        public void d() {
            this.d.hh();
            super.d();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void d() {
            EntityFox.this.hh();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.gr() && !EntityFox.this.gQ() && !EntityFox.this.hf() && EntityFox.this.ag_() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            IBlockData iblockdata = iworldreader.a_(blockposition);
            return iblockdata.a(Blocks.pg) && iblockdata.c(BlockSweetBerryBush.c) >= 2 || CaveVines.j_(iblockdata);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.as.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.lb, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (net.minecraft.world.entity.animal.fox.EntityFox$f.a(EntityFox.this.ao()).U().a(GameRules.F).booleanValue()) {
                IBlockData iblockdata = EntityFox.this.ao().a_(this.e);
                if (iblockdata.a(Blocks.pg)) {
                    this.b(iblockdata);
                } else if (CaveVines.j_(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData iblockdata) {
            CaveVines.a(EntityFox.this, iblockdata, EntityFox.this.ao(), this.e);
        }

        private void b(IBlockData iblockdata) {
            int i2 = iblockdata.c(BlockSweetBerryBush.c);
            iblockdata.b(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)iblockdata.b(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int j2 = 1 + EntityFox.this.ao().y.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.za));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.ao(), this.e, new ItemStack(Items.za, j2));
            }
            EntityFox.this.a(SoundEffects.CK, 1.0f, 1.0f);
            EntityFox.this.ao().a(this.e, (IBlockData)iblockdata.b(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.ao().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.gr() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.x(false);
            super.d();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).f()) {
                return false;
            }
            if (EntityFox.this.ag_() == null && EntityFox.this.eK() == null) {
                if (!EntityFox.this.hi()) {
                    return false;
                }
                if (EntityFox.this.ep().a(p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.ao().a(EntityItem.class, EntityFox.this.dj().c(8.0, 8.0, 8.0), cH);
                return !list.isEmpty() && EntityFox.this.a(EnumItemSlot.a).f();
            }
            return false;
        }

        @Override
        public void a() {
            List<EntityItem> list = EntityFox.this.ao().a(EntityItem.class, EntityFox.this.dj().c(8.0, 8.0, 8.0), cH);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f() && !list.isEmpty()) {
                EntityFox.this.N().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> list = EntityFox.this.ao().a(EntityItem.class, EntityFox.this.dj().c(8.0, 8.0, 8.0), cH);
            if (!list.isEmpty()) {
                EntityFox.this.N().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient entityinsentient, Class oclass, float f2) {
            super(entityinsentient, oclass, f2);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gR() && !EntityFox.this.gU();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.gR() && !EntityFox.this.gU();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.eK() == null && EntityFox.this.ep().i() < 0.02f && !EntityFox.this.gr() && EntityFox.this.ag_() == null && EntityFox.this.N().l() && !this.i() && !EntityFox.this.gS() && !EntityFox.this.cz();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.ep().a(3);
            EntityFox.this.x(true);
            EntityFox.this.N().n();
        }

        @Override
        public void e() {
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.J().a(EntityFox.this.dP() + this.c, EntityFox.this.dT(), EntityFox.this.dV() + this.d, EntityFox.this.ae(), EntityFox.this.ac());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.ep().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.ep().a(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        private @Nullable EntityLiving j;
        private @Nullable EntityLiving k;
        private int l;

        public a(Class oclass, @Nullable boolean flag, boolean flag1, PathfinderTargetCondition.a pathfindertargetcondition_a) {
            super(EntityFox.this, oclass, 10, flag, flag1, pathfindertargetcondition_a);
        }

        @Override
        public boolean b() {
            if (this.b > 0 && this.e.ep().a(this.b) != 0) {
                return false;
            }
            WorldServer worldserver = net.minecraft.world.entity.animal.fox.EntityFox$a.a(EntityFox.this.ao());
            for (EntityReference<EntityLiving> entityreference : EntityFox.this.hd().toList()) {
                EntityLiving entityliving = entityreference.a(worldserver, EntityLiving.class);
                if (entityliving == null) continue;
                this.k = entityliving;
                this.j = entityliving.eK();
                int i2 = entityliving.eM();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.eM();
            }
            EntityFox.this.a(SoundEffects.kT, 1.0f, 1.0f);
            EntityFox.this.C(true);
            EntityFox.this.hg();
            super.d();
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type entityfox_type) {
            super(false);
            this.a = entityfox_type;
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dP(), EntityFox.this.dj().e, EntityFox.this.dV());
            return !EntityFox.this.ao().k(blockposition) && EntityFox.this.c(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !net.minecraft.world.entity.animal.fox.EntityFox$d.a(EntityFox.this.ao()).a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.dj().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class c
    implements PathfinderTargetCondition.a {
        @Override
        public boolean test(EntityLiving entityliving, WorldServer worldserver) {
            if (entityliving instanceof EntityFox) {
                return false;
            }
            if (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster)) {
                EntityHuman entityhuman;
                if (entityliving instanceof EntityTameableAnimal) {
                    return !((EntityTameableAnimal)entityliving).p();
                }
                if (entityliving instanceof EntityHuman && ((entityhuman = (EntityHuman)entityliving).au() || entityhuman.ha())) {
                    return false;
                }
                if (EntityFox.this.j(entityliving)) {
                    return false;
                }
                return !entityliving.gr() && !entityliving.cx();
            }
            return true;
        }
    }
}

