/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.jspecify.annotations.Nullable;

public class Goat
extends EntityAnimal {
    public static final EntitySize cv = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cC = 2;
    private static final int cD = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> cw = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.aG, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.P, MemoryModuleType.L, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.aa});
    public static final int cz = 10;
    public static final double cA = 0.02;
    public static final double cB = (double)0.1f;
    private static final DataWatcherObject<Boolean> cE = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cF = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cG = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private static final boolean cH = false;
    private static final boolean cI = true;
    private static final boolean cJ = true;
    private boolean cK;
    private int cL;

    public Goat(EntityTypes<? extends Goat> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.N().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack p() {
        RandomSource randomsource = RandomSource.a(this.cY().hashCode());
        TagKey<Instrument> tagkey = this.hd() ? InstrumentTags.b : InstrumentTags.a;
        return this.ao().J_().f(Registries.bi).a(tagkey, randomsource).map(holder -> InstrumentItem.a(Items.yM, holder)).orElseGet(() -> new ItemStack(Items.yM));
    }

    protected BehaviorController.b<Goat> ew() {
        return BehaviorController.a(cx, cw);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.ew().a(dynamic));
    }

    public static AttributeProvider.Builder gP() {
        return EntityAnimal.gW().a(GenericAttributes.u, 10.0).a(GenericAttributes.x, 0.2f).a(GenericAttributes.d, 2.0);
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.h(GenericAttributes.d).a(1.0);
            this.gV();
        } else {
            this.h(GenericAttributes.d).a(2.0);
            this.gU();
        }
    }

    @Override
    protected int a(double d0, float f2) {
        return super.a(d0, f2) - 10;
    }

    @Override
    protected SoundEffect W() {
        return this.hd() ? SoundEffects.mL : SoundEffects.mC;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return this.hd() ? SoundEffects.mO : SoundEffects.mF;
    }

    @Override
    protected SoundEffect fd() {
        return this.hd() ? SoundEffects.mM : SoundEffects.mD;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.mT, 0.15f, 1.0f);
    }

    protected SoundEffect gQ() {
        return this.hd() ? SoundEffects.mQ : SoundEffects.mH;
    }

    public @Nullable Goat b(WorldServer worldserver, EntityAgeable entityageable) {
        Goat goat = EntityTypes.am.a(worldserver, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, worldserver.G_());
            EntityAgeable entityageable1 = worldserver.G_().h() ? this : entityageable;
            boolean flag = entityageable1 instanceof Goat && ((Goat)(goat1 = entityageable1)).hd() || !(worldserver.G_().j() >= 0.02);
            boolean flag1 = flag;
            goat.x(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> ev() {
        return super.ev();
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("goatBrain");
        this.ev().a(worldserver, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("goatActivityUpdate");
        GoatAi.a(this);
        gameprofilerfiller.c();
        super.a(worldserver);
    }

    @Override
    public int ae() {
        return 15;
    }

    @Override
    public void r(float f2) {
        int i2 = this.ae();
        float f1 = MathHelper.d(this.bC, f2);
        float f22 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.r(this.bC + f22);
    }

    @Override
    protected void gX() {
        this.ao().a((Entity)null, this, this.hd() ? SoundEffects.mN : SoundEffects.mE, SoundCategory.g, 1.0f, MathHelper.b(this.ao().y, 0.8f, 1.2f));
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aF);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.sk) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)entityhuman.ao(), entityhuman, this.dK(), this.dK(), null, itemstack, Items.sq, enumhand);
            if (event.isCancelled()) {
                return EnumInteractionResult.e;
            }
            entityhuman.a(this.gQ(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
            entityhuman.a(enumhand, itemstack1);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && this.j(itemstack)) {
            this.gX();
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        GoatAi.a(this, randomsource);
        this.x(randomsource.j() < 0.02);
        this.h();
        if (!this.e_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cF : cG;
            this.az.a(datawatcherobject, false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return entitypose == EntityPose.g ? cv.a(this.eE()) : super.b(entitypose);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsScreamingGoat", this.hd());
        valueoutput.a("HasLeftHorn", this.gR());
        valueoutput.a("HasRightHorn", this.gS());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("IsScreamingGoat", false));
        this.az.a(cF, valueinput.a("HasLeftHorn", true));
        this.az.a(cG, valueinput.a("HasRightHorn", true));
    }

    @Override
    public void b(byte b0) {
        if (b0 == 58) {
            this.cK = true;
        } else if (b0 == 59) {
            this.cK = false;
        } else {
            super.b(b0);
        }
    }

    @Override
    public void d_() {
        this.cL = this.cK ? ++this.cL : (this.cL -= 2);
        this.cL = MathHelper.a(this.cL, 0, 20);
        super.d_();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cE, false);
        datawatcher_a.a(cF, true);
        datawatcher_a.a(cG, true);
    }

    public boolean gR() {
        return this.az.a(cF);
    }

    public boolean gS() {
        return this.az.a(cG);
    }

    public boolean gT() {
        boolean flag = this.gR();
        boolean flag1 = this.gS();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? cG : (!flag1 ? cF : (this.as.h() ? cF : cG));
        this.az.a(datawatcherobject, false);
        Vec3D vec3d = this.dI();
        ItemStack itemstack = this.p();
        double d0 = MathHelper.b(this.as, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.as, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.as, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.ao(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        this.ao().b(entityitem);
        return true;
    }

    public void gU() {
        this.az.a(cF, true);
        this.az.a(cG, true);
    }

    public void gV() {
        this.az.a(cF, false);
        this.az.a(cG, false);
    }

    public boolean hd() {
        return this.az.a(cE);
    }

    public void x(boolean flag) {
        this.az.a(cE, flag);
    }

    public float he() {
        return (float)this.cL / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.co) && Goat.a(generatoraccess, blockposition);
    }
}

