/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.golem;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> d = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int e = 25;
    private static final boolean f = false;
    private int cv;
    private int cw;
    private static final UniformInt cx = TimeRange.a(20, 39);
    private long cy;
    private @Nullable EntityReference<EntityLiving> cz;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> entitytypes, World world) {
        super((EntityTypes<? extends EntityGolem>)entitytypes, world);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cs.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.cs.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.cs.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.cs.a(5, new PathfinderGoalOfferFlower(this));
        this.cs.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalDefendVillage(this));
        this.ct.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, (entityliving, worldserver) -> entityliving instanceof IMonster && !(entityliving instanceof EntityCreeper)));
        this.ct.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(d, (byte)0);
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.E().a(GenericAttributes.u, 100.0).a(GenericAttributes.x, 0.25).a(GenericAttributes.r, 1.0).a(GenericAttributes.d, 15.0).a(GenericAttributes.D, 1.0);
    }

    @Override
    protected int l(int i2) {
        return i2;
    }

    @Override
    protected void F(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.ep().a(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION, true);
        }
        super.F(entity);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.cv > 0) {
            --this.cv;
        }
        if (this.cw > 0) {
            --this.cw;
        }
        if (!this.ao().B_()) {
            this.a((WorldServer)this.ao(), true);
        }
    }

    @Override
    public boolean bL() {
        return this.dN().j() > 2.500000277905201E-7 && this.as.a(5) == 0;
    }

    @Override
    public boolean a(EntityTypes<?> entitytypes) {
        return this.gR() && entitytypes == EntityTypes.cb ? false : (entitytypes == EntityTypes.I ? false : super.a(entitytypes));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("PlayerCreated", this.gR());
        this.b_(valueoutput);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.y(valueinput.a("PlayerCreated", false));
        this.a(this.ao(), valueinput);
    }

    @Override
    public void c() {
        this.a(cx.a(this.as));
    }

    @Override
    public void b(long i2) {
        this.cy = i2;
    }

    @Override
    public long a() {
        return this.cy;
    }

    @Override
    public void a(@Nullable EntityReference<EntityLiving> entityreference) {
        this.cz = entityreference;
    }

    @Override
    public @Nullable EntityReference<EntityLiving> b() {
        return this.cz;
    }

    private float gS() {
        return (float)this.i(GenericAttributes.d);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        this.cv = 10;
        worldserver.a((Entity)this, (byte)4);
        float f2 = this.gS();
        float f1 = (int)f2 > 0 ? f2 / 2.0f + (float)this.as.a((int)f2) : f2;
        DamageSource damagesource = this.en().b(this);
        boolean flag = entity.a(worldserver, damagesource, f1);
        if (flag) {
            double d0;
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                d0 = entityliving.i(GenericAttributes.r);
            } else {
                d0 = 0.0;
            }
            double d1 = d0;
            double d2 = Math.max(0.0, 1.0 - d1);
            entity.k(entity.dN().b(0.0, (double)0.4f * d2, 0.0));
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
        this.a(SoundEffects.ps, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Crackiness.a crackiness_a = this.p();
        boolean flag = super.a(worldserver, damagesource, f2);
        if (flag && this.p() != crackiness_a) {
            this.a(SoundEffects.pt, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness.a p() {
        return Crackiness.a.a(this.eZ() / this.fq());
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.cv = 10;
            this.a(SoundEffects.ps, 1.0f, 1.0f);
        } else if (b0 == 11) {
            this.cw = 400;
        } else if (b0 == 34) {
            this.cw = 0;
        } else {
            super.b(b0);
        }
    }

    public int gP() {
        return this.cv;
    }

    public void x(boolean flag) {
        if (flag) {
            this.cw = 400;
            this.ao().a((Entity)this, (byte)11);
        } else {
            this.cw = 0;
            this.ao().a((Entity)this, (byte)34);
        }
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.pv;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.pu;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!itemstack.a(Items.qg)) {
            return EnumInteractionResult.e;
        }
        float f2 = this.eZ();
        this.d(25.0f);
        if (this.eZ() == f2) {
            return EnumInteractionResult.e;
        }
        float f1 = 1.0f + (this.as.i() - this.as.i()) * 0.2f;
        this.a(SoundEffects.pw, 1.0f, f1);
        itemstack.a(1, (EntityLiving)entityhuman);
        return EnumInteractionResult.a;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.px, 1.0f, 1.0f);
    }

    public int gQ() {
        return this.cw;
    }

    public boolean gR() {
        return (this.az.a(d) & 1) != 0;
    }

    public void y(boolean flag) {
        byte b0 = this.az.a(d);
        if (flag) {
            this.az.a(d, (byte)(b0 | 1));
        } else {
            this.az.a(d, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource damagesource) {
        super.a(damagesource);
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        BlockPosition blockposition = this.dK();
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata = iworldreader.a_(blockposition1);
        if (!iblockdata.b((IBlockAccess)iworldreader, blockposition1, this)) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData iblockdata1;
            BlockPosition blockposition2 = blockposition.b(i2);
            if (SpawnerCreature.a(iworldreader, blockposition2, iblockdata1 = iworldreader.a_(blockposition2), iblockdata1.y(), EntityTypes.au)) continue;
            return false;
        }
        return SpawnerCreature.a(iworldreader, blockposition, iworldreader.a_(blockposition), FluidTypes.a.g(), EntityTypes.au) && iworldreader.f(this);
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.875f * this.dk(), this.dF() * 0.4f);
    }
}

