/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.pig;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.entity.animal.pig.PigVariants;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityPig
extends EntityAnimal
implements ISteerable {
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<PigVariant>> cw = DataWatcher.a(EntityPig.class, DataWatcherRegistry.C);
    public final SaddleStorage cx;

    public EntityPig(EntityTypes<? extends EntityPig> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cx = new SaddleStorage(this.az, cv);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 1.25));
        this.cs.a(3, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(4, new PathfinderGoalTempt(this, 1.2, itemstack -> itemstack.a(Items.pn), false));
        this.cs.a(4, new PathfinderGoalTempt(this, 1.2, itemstack -> itemstack.a(TagsItem.ba), false));
        this.cs.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.cs.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 10.0).a(GenericAttributes.x, 0.25);
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.al() && (entity = this.do()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.pn)) {
            return entityhuman;
        }
        return super.dl();
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cv.equals(datawatcherobject) && this.ao().B_()) {
            this.cx.a();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cv, 0);
        datawatcher_a.a(cw, VariantUtils.a(this.eo(), PigVariants.d));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        VariantUtils.a(valueoutput, this.gP());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        VariantUtils.a(valueinput, Registries.bo).ifPresent(this::b);
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.wm;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.wo;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.wn;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.wq, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.j(entityhuman.b(enumhand));
        if (!flag && this.al() && !this.cr() && !entityhuman.gA()) {
            if (!this.ao().B_()) {
                entityhuman.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = entityhuman.b(enumhand);
            return this.a(itemstack, EnumItemSlot.h) ? itemstack.a(entityhuman, (EntityLiving)this, enumhand) : EnumInteractionResult.e;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean e(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.h ? super.e(enumitemslot) : this.cb() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.h || super.f(enumitemslot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EnumItemSlot.h ? SoundEffects.wp : super.a(enumitemslot, itemstack, equippable);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.av() != EnumDifficulty.a) {
            EntityPigZombie entitypigzombie = this.convertTo(EntityTypes.ca, ConversionParams.a(this, false, true), entitypigzombie1 -> {
                entitypigzombie1.a(this.ep(), worldserver.c(this.dK()));
                entitypigzombie1.gz();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, entitylightning, entitypigzombie).isCancelled()) {
                return;
            }
            worldserver.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (entitypigzombie == null) {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        super.a(entityhuman, vec3d);
        this.a(entityhuman.ec(), entityhuman.ee() * 0.5f);
        this.bC = this.bE = this.ec();
        this.ab = this.bE;
        this.cx.b();
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman entityhuman) {
        return (float)(this.i(GenericAttributes.x) * 0.225 * (double)this.cx.c());
    }

    @Override
    public boolean a() {
        return this.cx.a(this.ep());
    }

    public @Nullable EntityPig b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityPig entitypig = EntityTypes.aY.a(worldserver, EntitySpawnReason.e);
        if (entitypig != null && entityageable instanceof EntityPig) {
            EntityPig entitypig1 = (EntityPig)entityageable;
            entitypig.b(this.as.h() ? this.gP() : entitypig1.gP());
        }
        return entitypig;
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.ba);
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.6f * this.dk(), this.dF() * 0.4f);
    }

    public void b(Holder<PigVariant> holder) {
        this.az.a(cw, holder);
    }

    public Holder<PigVariant> gP() {
        return this.az.a(cw);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aO ? EntityPig.c(datacomponenttype, this.gP()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aO);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aO) {
            this.b(EntityPig.c(DataComponents.aO, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        VariantUtils.a(SpawnContext.a(worldaccess, this.dK()), Registries.bo).ifPresent(this::b);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }
}

