/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sheep;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sheep.SheepColorSpawnRules;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.jspecify.annotations.Nullable;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int cv = 40;
    private static final DataWatcherObject<Byte> cw = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final EnumColor cx = EnumColor.a;
    private static final boolean cz = false;
    private int cA;
    private PathfinderGoalEatTile cB;

    public EntitySheep(EntityTypes<? extends EntitySheep> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
    }

    @Override
    protected void D() {
        this.cB = new PathfinderGoalEatTile(this);
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 1.25));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.1, itemstack -> itemstack.a(TagsItem.aG), false));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.cs.a(5, this.cB);
        this.cs.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aG);
    }

    @Override
    protected void a(WorldServer worldserver) {
        this.cA = this.cB.h();
        super.a(worldserver);
    }

    @Override
    public void d_() {
        if (this.ao().B_()) {
            this.cA = Math.max(0, this.cA - 1);
        }
        super.d_();
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 8.0).a(GenericAttributes.x, 0.23f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cw, (byte)0);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 10) {
            this.cA = 40;
        } else {
            super.b(b0);
        }
    }

    public float L(float f2) {
        return this.cA <= 0 ? 0.0f : (this.cA >= 4 && this.cA <= 36 ? 1.0f : (this.cA < 4 ? ((float)this.cA - f2) / 4.0f : -((float)(this.cA - 40) - f2) / 4.0f));
    }

    public float M(float f2) {
        if (this.cA > 4 && this.cA <= 36) {
            float f1 = ((float)(this.cA - 4) - f2) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a((double)(f1 * 28.7f));
        }
        return this.cA > 0 ? 0.62831855f : this.k(f2) * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.tZ)) {
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (this.a()) {
                    if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                        return EnumInteractionResult.e;
                    }
                    this.a(worldserver, SoundCategory.h, itemstack);
                    this.a(GameEvent.M, (Entity)entityhuman);
                    itemstack.a(1, (EntityLiving)entityhuman, enumhand.a());
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.c;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    public void a(WorldServer worldserver, SoundCategory soundcategory, ItemStack itemstack) {
        worldserver.a((Entity)null, this, SoundEffects.zw, soundcategory, 1.0f, 1.0f);
        this.a(worldserver, LootTables.bb, itemstack, (WorldServer worldserver1, ItemStack itemstack1) -> {
            for (int i2 = 0; i2 < itemstack1.N(); ++i2) {
                this.forceDrops = true;
                EntityItem entityitem = this.a((WorldServer)worldserver1, itemstack1.c(1), 1.0f);
                this.forceDrops = false;
                if (entityitem == null) continue;
                entityitem.k(entityitem.dN().b((this.as.i() - this.as.i()) * 0.1f, this.as.i() * 0.05f, (this.as.i() - this.as.i()) * 0.1f));
            }
        });
        this.x(true);
    }

    @Override
    public boolean a() {
        return this.cb() && !this.gQ() && !this.e_();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Sheared", this.gQ());
        valueoutput.a("Color", EnumColor.s, this.gP());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("Sheared", false));
        this.a(valueinput.a("Color", EnumColor.s).orElse(cx));
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.zt;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.zv;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.zu;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.zx, 0.15f, 1.0f);
    }

    public EnumColor gP() {
        return EnumColor.a(this.az.a(cw) & 0xF);
    }

    public void a(EnumColor enumcolor) {
        byte b0 = this.az.a(cw);
        this.az.a(cw, (byte)(b0 & 0xF0 | enumcolor.a() & 0xF));
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aZ ? EntitySheep.c(datacomponenttype, this.gP()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aZ);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aZ) {
            this.a(EntitySheep.c(DataComponents.aZ, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    public boolean gQ() {
        return (this.az.a(cw) & 0x10) != 0;
    }

    public void x(boolean flag) {
        byte b0 = this.az.a(cw);
        if (flag) {
            this.az.a(cw, (byte)(b0 | 0x10));
        } else {
            this.az.a(cw, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(WorldAccess worldaccess, BlockPosition blockposition) {
        Holder<BiomeBase> holder = worldaccess.z(blockposition);
        return SheepColorSpawnRules.a(holder, worldaccess.G_());
    }

    public @Nullable EntitySheep b(WorldServer worldserver, EntityAgeable entityageable) {
        EntitySheep entitysheep = EntityTypes.bj.a(worldserver, EntitySpawnReason.e);
        if (entitysheep != null) {
            EnumColor enumcolor = this.gP();
            EnumColor enumcolor1 = ((EntitySheep)entityageable).gP();
            entitysheep.a(EnumColor.a(worldserver, enumcolor, enumcolor1));
        }
        return entitysheep;
    }

    @Override
    public void R() {
        SheepRegrowWoolEvent event = new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity());
        this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        super.R();
        this.x(false);
        if (this.e_()) {
            this.c_(60);
        }
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.a(EntitySheep.a(worldaccess, this.dK()));
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }
}

