/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> cB = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cC = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Long> cD = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Holder<WolfVariant>> cE = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<Holder<WolfSoundVariant>> cF = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.A);
    public static final PathfinderTargetCondition.a cz = (entityliving, worldserver) -> {
        EntityTypes<?> entitytypes = entityliving.ay();
        return entitytypes == EntityTypes.bj || entitytypes == EntityTypes.bg || entitytypes == EntityTypes.ae;
    };
    private static final float cG = 8.0f;
    private static final float cH = 40.0f;
    private static final float cI = 0.125f;
    public static final float cA = 0.62831855f;
    private static final EnumColor cJ = EnumColor.o;
    private float cK;
    private float cL;
    public boolean cM;
    private boolean cN;
    private float cO;
    private float cP;
    private static final UniformInt cQ = TimeRange.a(20, 39);
    private @Nullable EntityReference<EntityLiving> cR;

    public EntityWolf(EntityTypes<? extends EntityWolf> entitytypes, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)entitytypes, world);
        this.a(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.cs.a(2, new PathfinderGoalSit(this));
        this.cs.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.cs.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.cs.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cs.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.cs.a(7, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.cs.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(10, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.ct.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.ct.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.ct.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.ct.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, cz));
        this.ct.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.cv));
        this.ct.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.ct.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey hd() {
        WolfVariant wolfvariant = this.hi().a();
        return this.p() ? wolfvariant.b().b().b() : (this.ab_() ? wolfvariant.b().c().b() : wolfvariant.b().a().b());
    }

    public Holder<WolfVariant> hi() {
        return this.az.a(cE);
    }

    public void b(Holder<WolfVariant> holder) {
        this.az.a(cE, holder);
    }

    private Holder<WolfSoundVariant> hj() {
        return this.az.a(cF);
    }

    private void k(Holder<WolfSoundVariant> holder) {
        this.az.a(cF, holder);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aD ? EntityWolf.c(datacomponenttype, this.hi()) : (datacomponenttype == DataComponents.aE ? EntityWolf.c(datacomponenttype, this.hj()) : (datacomponenttype == DataComponents.aF ? EntityWolf.c(datacomponenttype, this.hg()) : super.a(datacomponenttype)));
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aD);
        this.a(datacomponentgetter, DataComponents.aE);
        this.a(datacomponentgetter, DataComponents.aF);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aD) {
            this.b(EntityWolf.c(DataComponents.aD, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.aE) {
            this.k(EntityWolf.c(DataComponents.aE, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.aF) {
            this.a(EntityWolf.c(DataComponents.aF, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    public static AttributeProvider.Builder he() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.3f).a(GenericAttributes.u, 8.0).a(GenericAttributes.d, 4.0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        IRegistry<WolfSoundVariant> iregistry = this.eo().f(Registries.bC);
        datawatcher_a.a(cE, VariantUtils.a(this.eo(), WolfVariants.j));
        DataWatcherObject<Holder<WolfSoundVariant>> datawatcherobject = cF;
        Optional optional = iregistry.a(WolfSoundVariants.a);
        Objects.requireNonNull(iregistry);
        datawatcher_a.a(datawatcherobject, (Holder)optional.or(iregistry::a).orElseThrow());
        datawatcher_a.a(cB, false);
        datawatcher_a.a(cC, cJ.a());
        datawatcher_a.a(cD, -1L);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Gg, 0.15f, 1.0f);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("CollarColor", EnumColor.s, this.hg());
        VariantUtils.a(valueoutput, this.hi());
        this.b_(valueoutput);
        this.hj().e().ifPresent(resourcekey -> valueoutput.a("sound_variant", ResourceKey.a(Registries.bC), resourcekey));
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        VariantUtils.a(valueinput, Registries.bB).ifPresent(this::b);
        this.a(valueinput.a("CollarColor", EnumColor.s).orElse(cJ));
        this.a(this.ao(), valueinput);
        valueinput.a("sound_variant", ResourceKey.a(Registries.bC)).flatMap(resourcekey -> this.eo().f(Registries.bC).a((ResourceKey)resourcekey)).ifPresent(this::k);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (groupdataentity instanceof b) {
            b entitywolf_b = (b)groupdataentity;
            this.b(entitywolf_b.a);
        } else {
            Optional optional = VariantUtils.a(SpawnContext.a(worldaccess, this.dK()), Registries.bB);
            if (optional.isPresent()) {
                this.b(optional.get());
                groupdataentity = new b(optional.get());
            }
        }
        this.k(WolfSoundVariants.a(this.eo(), worldaccess.G_()));
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected SoundEffect W() {
        return this.ab_() ? this.hj().a().c().a() : (this.as.a(3) == 0 ? (this.p() && this.eZ() < 20.0f ? this.hj().a().f().a() : this.hj().a().e().a()) : this.hj().a().a().a());
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return this.i(damagesource) ? SoundEffects.Gd : this.hj().a().d().a();
    }

    @Override
    protected SoundEffect fd() {
        return this.hj().a().b().a();
    }

    @Override
    protected float fC() {
        return 0.4f;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.ao().B_() && this.cM && !this.cN && !this.gL() && this.aV()) {
            this.cN = true;
            this.cO = 0.0f;
            this.cP = 0.0f;
            this.ao().a((Entity)this, (byte)8);
        }
        if (!this.ao().B_()) {
            this.a((WorldServer)this.ao(), true);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.cb()) {
            this.cL = this.cK;
            this.cK = this.hh() ? (this.cK += (1.0f - this.cK) * 0.4f) : (this.cK += (0.0f - this.cK) * 0.4f);
            if (this.bA()) {
                this.cM = true;
                if (this.cN && !this.ao().B_()) {
                    this.ao().a((Entity)this, (byte)56);
                    this.hk();
                }
            } else if ((this.cM || this.cN) && this.cN) {
                if (this.cO == 0.0f) {
                    this.a(SoundEffects.Gf, this.fC(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.u);
                }
                this.cP = this.cO;
                this.cO += 0.05f;
                if (this.cP >= 2.0f) {
                    this.cM = false;
                    this.cN = false;
                    this.cP = 0.0f;
                    this.cO = 0.0f;
                }
                if (this.cO > 0.4f) {
                    float f2 = (float)this.dR();
                    int i2 = (int)(MathHelper.a((double)((this.cO - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3D vec3d = this.dN();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.as.i() * 2.0f - 1.0f) * this.dF() * 0.5f;
                        float f22 = (this.as.i() * 2.0f - 1.0f) * this.dF() * 0.5f;
                        this.ao().a(Particles.aq, this.dP() + (double)f1, (double)(f2 + 0.8f), this.dV() + (double)f22, vec3d.g, vec3d.h, vec3d.i);
                    }
                }
            }
        }
    }

    private void hk() {
        this.cN = false;
        this.cO = 0.0f;
        this.cP = 0.0f;
    }

    @Override
    public void a(DamageSource damagesource) {
        this.cM = false;
        this.cN = false;
        this.cP = 0.0f;
        this.cO = 0.0f;
        super.a(damagesource);
    }

    public float L(float f2) {
        return !this.cM ? 1.0f : Math.min(0.75f + MathHelper.h(f2, this.cP, this.cO) / 2.0f * 0.25f, 1.0f);
    }

    public float M(float f2) {
        return MathHelper.h(f2, this.cP, this.cO);
    }

    public float N(float f2) {
        return MathHelper.h(f2, this.cL, this.cK) * 0.15f * (float)Math.PI;
    }

    @Override
    public int ac() {
        return this.gQ() ? 20 : super.ac();
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.a(worldserver, damagesource, f2);
        if (!result) {
            return result;
        }
        this.z(false);
        return result;
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.i(damagesource)) {
            return super.actuallyHurt(worldserver, damagesource, f2, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack itemstack = this.ak();
        int i2 = itemstack.o();
        int j2 = itemstack.p();
        itemstack.a(MathHelper.d(f2), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(i2, j2) != Crackiness.b.a(this.ak())) {
            this.a(SoundEffects.Gc);
            worldserver.a(new ParticleParamItem(Particles.V, Items.pR.m()), this.dP(), this.dR() + 1.0, this.dV(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return false;
    }

    private boolean i(DamageSource damagesource) {
        return this.ak().a(Items.pS) && !damagesource.a(DamageTypeTags.C);
    }

    @Override
    protected void gP() {
        if (this.p()) {
            this.h(GenericAttributes.u).a(40.0);
            this.x(this.fq());
        } else {
            this.h(GenericAttributes.u).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.g);
    }

    @Override
    protected boolean b_(EntityHuman entityhuman) {
        return this.j(entityhuman);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        Item item = itemstack.h();
        if (this.p()) {
            if (this.j(itemstack) && this.eZ() < this.fq()) {
                this.a(entityhuman, enumhand, itemstack);
                FoodInfo foodinfo = itemstack.a(DataComponents.y);
                float f2 = foodinfo != null ? (float)foodinfo.a() : 1.0f;
                this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a;
            }
            if (item instanceof ItemDye) {
                ItemDye itemdye = (ItemDye)item;
                if (this.j(entityhuman)) {
                    EnumColor enumcolor = itemdye.a();
                    if (enumcolor != this.hg()) {
                        this.a(enumcolor);
                        itemstack.a(1, (EntityLiving)entityhuman);
                        return EnumInteractionResult.a;
                    }
                    return super.b(entityhuman, enumhand);
                }
            }
            if (this.a(itemstack, EnumItemSlot.g) && !this.am() && this.j(entityhuman) && !this.e_()) {
                this.i(itemstack.c(1));
                itemstack.a(1, (EntityLiving)entityhuman);
                return EnumInteractionResult.a;
            }
            if (this.gQ() && this.am() && this.j(entityhuman) && this.ak().n() && this.ak().c(itemstack)) {
                itemstack.h(1);
                this.a(SoundEffects.Ge);
                ItemStack itemstack1 = this.ak();
                int i2 = (int)((float)itemstack1.p() * 0.125f);
                itemstack1.b(Math.max(0, itemstack1.o() - i2));
                return EnumInteractionResult.a;
            }
            EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
            if (!enuminteractionresult.a() && this.j(entityhuman)) {
                this.z(!this.gR());
                this.bM = false;
                this.cr.n();
                this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                return EnumInteractionResult.a.b();
            }
            return enuminteractionresult;
        }
        if (!this.ao().B_() && itemstack.a(Items.tD) && !this.ab_()) {
            itemstack.a(1, (EntityLiving)entityhuman);
            this.i(entityhuman);
            return EnumInteractionResult.b;
        }
        return super.b(entityhuman, enumhand);
    }

    private void i(EntityHuman entityhuman) {
        if (this.as.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
            this.g(entityhuman);
            this.cr.n();
            this.g((EntityLiving)null);
            this.z(true);
            this.ao().a((Entity)this, (byte)7);
        } else {
            this.ao().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 8) {
            this.cN = true;
            this.cO = 0.0f;
            this.cP = 0.0f;
        } else if (b0 == 56) {
            this.hk();
        } else {
            super.b(b0);
        }
    }

    public float hf() {
        if (this.ab_()) {
            return 1.5393804f;
        }
        if (this.p()) {
            float f2 = this.fq();
            float f1 = (f2 - this.eZ()) / f2;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aH);
    }

    @Override
    public int aj() {
        return 8;
    }

    @Override
    public long a() {
        return this.az.a(cD);
    }

    @Override
    public void b(long i2) {
        this.az.a(cD, i2);
    }

    @Override
    public void c() {
        this.a(cQ.a(this.as));
    }

    @Override
    public @Nullable EntityReference<EntityLiving> b() {
        return this.cR;
    }

    @Override
    public void a(@Nullable EntityReference<EntityLiving> entityreference) {
        this.cR = entityreference;
    }

    public EnumColor hg() {
        return EnumColor.a(this.az.a(cC));
    }

    public void a(EnumColor enumcolor) {
        this.az.a(cC, enumcolor.a());
    }

    public @Nullable EntityWolf b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityWolf entitywolf = EntityTypes.bU.a(worldserver, EntitySpawnReason.e);
        if (entitywolf != null && entityageable instanceof EntityWolf) {
            EntityWolf entitywolf1 = (EntityWolf)entityageable;
            if (this.as.h()) {
                entitywolf.b(this.hi());
            } else {
                entitywolf.b(entitywolf1.hi());
            }
            if (this.p()) {
                entitywolf.b(this.ae_());
                entitywolf.a(true, true);
                EnumColor enumcolor = this.hg();
                EnumColor enumcolor1 = entitywolf1.hg();
                entitywolf.a(EnumColor.a(worldserver, enumcolor, enumcolor1));
            }
            entitywolf.k(WolfSoundVariants.a(this.eo(), this.as));
        }
        return entitywolf;
    }

    public void A(boolean flag) {
        this.az.a(cB, flag);
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        if (entityanimal == this) {
            return false;
        }
        if (!this.p()) {
            return false;
        }
        if (!(entityanimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)entityanimal;
        return !entitywolf.p() ? false : (entitywolf.gQ() ? false : this.hb() && entitywolf.hb());
    }

    public boolean hh() {
        return this.az.a(cB);
    }

    @Override
    public boolean a(EntityLiving entityliving, EntityLiving entityliving1) {
        if (!(entityliving instanceof EntityCreeper || entityliving instanceof EntityGhast || entityliving instanceof EntityArmorStand)) {
            EntityTameableAnimal entitytameableanimal;
            EntityHorseAbstract entityhorseabstract;
            if (entityliving instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)entityliving;
                return !entitywolf.p() || entitywolf.U_() != entityliving1;
            }
            if (entityliving instanceof EntityHuman) {
                EntityHuman entityhuman1;
                EntityHuman entityhuman = (EntityHuman)entityliving;
                if (entityliving1 instanceof EntityHuman && !(entityhuman1 = (EntityHuman)entityliving1).a(entityhuman)) {
                    return false;
                }
            }
            if (entityliving instanceof EntityHorseAbstract && (entityhorseabstract = (EntityHorseAbstract)entityliving).hn()) {
                return false;
            }
            if (entityliving instanceof EntityTameableAnimal && (entitytameableanimal = (EntityTameableAnimal)entityliving).p()) {
                boolean flag = false;
                return flag;
            }
            boolean flag = true;
            return flag;
        }
        return false;
    }

    @Override
    public boolean aj_() {
        return !this.ab_();
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.6f * this.dk(), this.dF() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cu) && EntityWolf.a(generatoraccess, blockposition);
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama ? !this.j.p() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama entityllama) {
            return entityllama.gT() >= EntityWolf.this.as.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.g((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.g((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> holder) {
            super(false);
            this.a = holder;
        }
    }
}

