/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger cx = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> a = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition cy = PathfinderTargetCondition.a().a(64.0);
    private static final int cz = 200;
    private static final int cA = 400;
    private static final float cB = 0.25f;
    private static final String cC = "DragonDeathTime";
    private static final String cD = "DragonPhase";
    private static final int cE = 0;
    public final DragonFlightHistory b = new DragonFlightHistory();
    public final EntityComplexPart[] cF;
    public final EntityComplexPart c;
    private final EntityComplexPart cG;
    private final EntityComplexPart cH;
    private final EntityComplexPart cI;
    private final EntityComplexPart cJ;
    private final EntityComplexPart cK;
    private final EntityComplexPart cL;
    private final EntityComplexPart cM;
    public float d;
    public float e;
    public boolean f;
    public int cu = 0;
    public float cv;
    public @Nullable EntityEnderCrystal cw;
    private @Nullable EnderDragonBattle cN;
    private BlockPosition cO = BlockPosition.c;
    private final DragonControllerManager cP;
    private int cQ = 100;
    private float cR;
    private final PathPoint[] cU = new PathPoint[24];
    private final int[] cV = new int[24];
    private final Path cW = new Path();
    private final Explosion explosionSource;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.T, world);
        this.c = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cG = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.cH = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.cI = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cJ = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cK = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cL = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cM = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cF = new EntityComplexPart[]{this.c, this.cG, this.cH, this.cI, this.cJ, this.cK, this.cL, this.cM};
        this.x(this.fq());
        this.ar = true;
        this.cP = new DragonControllerManager(this);
        this.explosionSource = new ServerExplosion(world.getMinecraftWorld(), this, null, null, new Vec3D(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.Effect.b);
    }

    public void a(EnderDragonBattle enderdragonbattle) {
        this.cN = enderdragonbattle;
    }

    public void c(BlockPosition blockposition) {
        this.cO = blockposition;
    }

    public BlockPosition k() {
        return this.cO;
    }

    public static AttributeProvider.Builder p() {
        return EntityInsentient.E().a(GenericAttributes.u, 200.0).a(GenericAttributes.j, 16.0);
    }

    @Override
    public boolean bp() {
        float f2 = MathHelper.b((double)(this.e * ((float)Math.PI * 2)));
        float f1 = MathHelper.b((double)(this.d * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void bo() {
        if (this.ao().B_() && !this.bq()) {
            this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.jL, this.dB(), 5.0f, 0.8f + this.as.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, DragonControllerPhase.k.b());
    }

    @Override
    public void d_() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        this.bd();
        if (this.ao().B_()) {
            this.x(this.eZ());
            if (!this.bq() && !this.cP.a().a() && --this.cQ < 0) {
                this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.jM, this.dB(), 2.5f, 0.8f + this.as.i() * 0.3f, false);
                this.cQ = 200 + this.as.a(200);
            }
        }
        if (this.cN == null && (world = this.ao()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).K()) != null && this.cY().equals(enderdragonbattle.i())) {
            this.cN = enderdragonbattle;
        }
        this.d = this.e;
        if (this.fa()) {
            float f2 = (this.as.i() - 0.5f) * 8.0f;
            float f1 = (this.as.i() - 0.5f) * 4.0f;
            float f22 = (this.as.i() - 0.5f) * 8.0f;
            this.ao().a(Particles.x, this.dP() + (double)f2, this.dR() + 2.0 + (double)f1, this.dV() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.gQ();
            Vec3D vec3d = this.dN();
            float f3 = 0.2f / ((float)vec3d.i() * 10.0f + 1.0f);
            this.e = this.cP.a().a() ? (this.e += 0.1f) : (this.f ? (this.e += f3 * 0.5f) : (this.e += (f3 *= (float)Math.pow(2.0, vec3d.h))));
            this.v(MathHelper.f(this.ec()));
            if (this.gG()) {
                this.e = 0.5f;
            } else {
                this.b.a(this.dR(), this.ec());
                World world1 = this.ao();
                if (world1 instanceof WorldServer) {
                    Vec3D vec3d1;
                    WorldServer worldserver1 = (WorldServer)world1;
                    IDragonController idragoncontroller = this.cP.a();
                    idragoncontroller.a(worldserver1);
                    if (this.cP.a() != idragoncontroller) {
                        idragoncontroller = this.cP.a();
                        idragoncontroller.a(worldserver1);
                    }
                    if ((vec3d1 = idragoncontroller.f()) != null && idragoncontroller.h() != DragonControllerPhase.k) {
                        double d0 = vec3d1.g - this.dP();
                        double d1 = vec3d1.h - this.dR();
                        double d2 = vec3d1.i - this.dV();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f4 = idragoncontroller.e();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = MathHelper.a(d1 / d4, (double)(-f4), (double)f4);
                        }
                        this.k(this.dN().b(0.0, d1 * 0.01, 0.0));
                        this.v(MathHelper.f(this.ec()));
                        Vec3D vec3d2 = vec3d1.a(this.dP(), this.dR(), this.dV()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), this.dN().h, -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180)))).d();
                        float f5 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            float f6 = MathHelper.a(MathHelper.f(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.ec()), -50.0f, 50.0f);
                            this.cv *= 0.8f;
                            this.cv += f6 * idragoncontroller.g();
                            this.v(this.ec() + this.cv * 0.1f);
                        }
                        float f7 = (float)(2.0 / (d3 + 1.0));
                        float f8 = 0.06f;
                        this.a(0.06f * (f5 * f7 + (1.0f - f7)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.f) {
                            this.a(EnumMoveType.a, this.dN().c((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dN());
                        }
                        Vec3D vec3d4 = this.dN().d();
                        double d5 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.k(this.dN().d(d5, 0.91f, d5));
                    }
                } else {
                    this.bQ.e();
                    this.cP.a().b();
                }
                if (!this.ao().B_()) {
                    this.aW();
                }
                this.bC = this.ec();
                Vec3D[] avec3d = new Vec3D[this.cF.length];
                for (int i2 = 0; i2 < this.cF.length; ++i2) {
                    avec3d[i2] = new Vec3D(this.cF[i2].dP(), this.cF[i2].dR(), this.cF[i2].dV());
                }
                float f9 = (float)(this.b.a(5).a() - this.b.a(10).a()) * 10.0f * ((float)Math.PI / 180);
                float f10 = MathHelper.b((double)f9);
                float f11 = MathHelper.a((double)f9);
                float f12 = this.ec() * ((float)Math.PI / 180);
                float f13 = MathHelper.a((double)f12);
                float f14 = MathHelper.b((double)f12);
                this.a(this.cH, (double)(f13 * 0.5f), 0.0, (double)(-f14 * 0.5f));
                this.a(this.cL, (double)(f14 * 4.5f), 2.0, (double)(f13 * 4.5f));
                this.a(this.cM, (double)(f14 * -4.5f), 2.0, (double)(f13 * -4.5f));
                World world2 = this.ao();
                if (world2 instanceof WorldServer) {
                    WorldServer worldserver2 = (WorldServer)world2;
                    if (this.bu == 0) {
                        this.a(worldserver2, worldserver2.a((Entity)this, this.cL.dj().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.a(worldserver2, worldserver2.a((Entity)this, this.cM.dj().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.c.dj().g(1.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.cG.dj().g(1.0), IEntitySelector.e));
                    }
                }
                float f15 = MathHelper.a((double)(this.ec() * ((float)Math.PI / 180) - this.cv * 0.01f));
                float f16 = MathHelper.b((double)(this.ec() * ((float)Math.PI / 180) - this.cv * 0.01f));
                float f17 = this.gP();
                this.a(this.c, (double)(f15 * 6.5f * f10), (double)(f17 + f11 * 6.5f), (double)(-f16 * 6.5f * f10));
                this.a(this.cG, (double)(f15 * 5.5f * f10), (double)(f17 + f11 * 5.5f), (double)(-f16 * 5.5f * f10));
                DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
                for (int j2 = 0; j2 < 3; ++j2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (j2 == 0) {
                        entitycomplexpart = this.cI;
                    }
                    if (j2 == 1) {
                        entitycomplexpart = this.cJ;
                    }
                    if (j2 == 2) {
                        entitycomplexpart = this.cK;
                    }
                    DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(12 + j2 * 2);
                    float f18 = this.ec() * ((float)Math.PI / 180) + this.k((double)(dragonflighthistory_a1.b() - dragonflighthistory_a.b())) * ((float)Math.PI / 180);
                    float f19 = MathHelper.a((double)f18);
                    float f20 = MathHelper.b((double)f18);
                    float f21 = 1.5f;
                    float f22 = (float)(j2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f13 * 1.5f + f19 * f22) * f10), dragonflighthistory_a1.a() - dragonflighthistory_a.a() - (double)((f22 + 1.5f) * f11) + 1.5, (double)((f14 * 1.5f + f20 * f22) * f10));
                }
                World world3 = this.ao();
                if (world3 instanceof WorldServer) {
                    WorldServer worldserver3 = (WorldServer)world3;
                    this.f = this.a(worldserver3, this.c.dj()) | this.a(worldserver3, this.cG.dj()) | this.a(worldserver3, this.cH.dj());
                    if (this.cN != null) {
                        this.cN.b(this);
                    }
                }
                for (int k2 = 0; k2 < this.cF.length; ++k2) {
                    this.cF[k2].Y = avec3d[k2].g;
                    this.cF[k2].Z = avec3d[k2].h;
                    this.cF[k2].aa = avec3d[k2].i;
                    this.cF[k2].ao = avec3d[k2].g;
                    this.cF[k2].ap = avec3d[k2].h;
                    this.cF[k2].aq = avec3d[k2].i;
                }
            }
        }
    }

    private void a(EntityComplexPart entitycomplexpart, double d0, double d1, double d2) {
        entitycomplexpart.a_(this.dP() + d0, this.dR() + d1, this.dV() + d2);
    }

    private float gP() {
        if (this.cP.a().a()) {
            return -1.0f;
        }
        DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
        DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(0);
        return (float)(dragonflighthistory_a.a() - dragonflighthistory_a1.a());
    }

    private void gQ() {
        if (this.cw != null) {
            if (this.cw.eh()) {
                this.cw = null;
            } else if (this.at % 10 == 0 && this.eZ() < this.fq()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.x((float)((double)this.eZ() + event.getAmount()));
                }
            }
        }
        if (this.as.a(10) == 0) {
            List<EntityEnderCrystal> list = this.ao().a(EntityEnderCrystal.class, this.dj().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.g(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.cw = entityendercrystal;
        }
    }

    private void a(WorldServer worldserver, List<Entity> list) {
        double d0 = (this.cH.dj().a + this.cH.dj().d) / 2.0;
        double d1 = (this.cH.dj().c + this.cH.dj().f) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            double d2 = entity.dP() - d0;
            double d3 = entity.dV() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.i(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.cP.a().a() || entityliving.eM() >= entity.at - 2) continue;
            DamageSource damagesource = this.en().b(this);
            entity.a(worldserver, damagesource, 5.0f);
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private void b(WorldServer worldserver, List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damagesource = this.en().b(this);
            entity.a(worldserver, damagesource, 10.0f);
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private float k(double d0) {
        return (float)MathHelper.g(d0);
    }

    private boolean a(WorldServer worldserver, AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.c(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.b);
        int k2 = MathHelper.c(axisalignedbb.c);
        int l2 = MathHelper.c(axisalignedbb.d);
        int i1 = MathHelper.c(axisalignedbb.e);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = worldserver.a_(blockposition);
                    if (iblockdata.l() || iblockdata.a(TagsBlock.aR)) continue;
                    if (worldserver.U().a(GameRules.F).booleanValue() && !iblockdata.a(TagsBlock.aQ)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(worldserver, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.b());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.ao().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().x() ? this.ao().c_(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.ao()).a(LootContextParameters.h, Vec3D.b(blockposition)).a(LootContextParameters.k, ItemStack.l).a(LootContextParameters.l, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.j, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.ao(), blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.ao(), blockposition, ItemStack.l, false);
                }
                nmsBlock.a((WorldServer)this.ao(), blockposition, this.explosionSource);
                this.ao().a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.as.a(l2 - i2 + 1), j2 + this.as.a(i1 - j2 + 1), k2 + this.as.a(j1 - k2 + 1));
            worldserver.c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(WorldServer worldserver, EntityComplexPart entitycomplexpart, DamageSource damagesource, float f2) {
        if (this.cP.a().h() == DragonControllerPhase.j) {
            return false;
        }
        f2 = this.cP.a().a(damagesource, f2);
        if (entitycomplexpart != this.c) {
            f2 = f2 / 4.0f + Math.min(f2, 1.0f);
        }
        if (f2 < 0.01f) {
            return false;
        }
        if (damagesource.d() instanceof EntityHuman || damagesource.a(DamageTypeTags.y)) {
            float f1 = this.eZ();
            this.d(worldserver, damagesource, f2);
            if (this.fa() && !this.cP.a().a()) {
                this.x(1.0f);
                this.cP.a(DragonControllerPhase.j);
            }
            if (this.cP.a().a()) {
                this.cR = this.cR + f1 - this.eZ();
                if (this.cR > 0.25f * this.fq()) {
                    this.cR = 0.0f;
                    this.cP.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        return this.a(worldserver, this.cH, damagesource, f2);
    }

    protected void d(WorldServer worldserver, DamageSource damagesource, float f2) {
        super.a(worldserver, damagesource, f2);
    }

    @Override
    public void c(WorldServer worldserver) {
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
        if (this.cN != null) {
            this.cN.b(this);
            this.cN.a(this);
        }
    }

    @Override
    public int getExpReward(WorldServer worldserver, Entity entity) {
        boolean flag = worldserver.U().a(GameRules.D);
        int short0 = 500;
        if (this.cN != null && !this.cN.f()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void eH() {
        World world1;
        if (this.cN != null) {
            this.cN.b(this);
        }
        ++this.cu;
        if (this.cu >= 180 && this.cu <= 200) {
            float f2 = (this.as.i() - 0.5f) * 8.0f;
            float f1 = (this.as.i() - 0.5f) * 4.0f;
            float f22 = (this.as.i() - 0.5f) * 8.0f;
            this.ao().a(Particles.w, this.dP() + (double)f2, this.dR() + 2.0 + (double)f1, this.dV() + (double)f22, 0.0, 0.0, 0.0);
        }
        int i2 = this.expToDrop;
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.cu > 150 && this.cu % 5 == 0) {
                EntityExperienceOrb.a(worldserver, this.dI(), MathHelper.b((float)i2 * 0.08f));
            }
            if (this.cu == 1 && !this.bq()) {
                int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : worldserver.s().aj().k) {
                    double deltaX = this.dP() - player.dP();
                    double deltaZ = this.dV() - player.dV();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (worldserver.spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(worldserver.spigotConfig.dragonDeathSoundRadius * worldserver.spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dP() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dV() + deltaZ / deltaLength * (double)viewDistance;
                        player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dR(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dP(), (int)this.dR(), (int)this.dV()), 0, true));
                }
            }
        }
        Vec3D vec3d = new Vec3D(0.0, 0.1f, 0.0);
        this.a(EnumMoveType.a, vec3d);
        for (EntityComplexPart entitycomplexpart : this.cF) {
            entitycomplexpart.bP();
            entitycomplexpart.b(entitycomplexpart.dI().e(vec3d));
        }
        if (this.cu == 200 && (world1 = this.ao()) instanceof WorldServer) {
            WorldServer worldserver1 = (WorldServer)world1;
            EntityExperienceOrb.a(worldserver1, this.dI(), MathHelper.b((float)i2 * 0.2f));
            if (this.cN != null) {
                this.cN.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            this.c(GameEvent.p);
        }
    }

    public int gL() {
        if (this.cU[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.b(60.0f * MathHelper.b((double)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2))));
                    l2 = MathHelper.b(60.0f * MathHelper.a((double)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2))));
                } else if (i2 < 20) {
                    int i1 = i2 - 12;
                    k2 = MathHelper.b(40.0f * MathHelper.b((double)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1))));
                    l2 = MathHelper.b(40.0f * MathHelper.a((double)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1))));
                    j2 += 10;
                } else {
                    int j1 = i2 - 20;
                    k2 = MathHelper.b(20.0f * MathHelper.b((double)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1))));
                    l2 = MathHelper.b(20.0f * MathHelper.a((double)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1))));
                }
                int k1 = Math.max(73, this.ao().a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cU[i2] = new PathPoint(k2, k1, l2);
            }
            this.cV[0] = 6146;
            this.cV[1] = 8197;
            this.cV[2] = 8202;
            this.cV[3] = 16404;
            this.cV[4] = 32808;
            this.cV[5] = 32848;
            this.cV[6] = 65696;
            this.cV[7] = 131392;
            this.cV[8] = 131712;
            this.cV[9] = 263424;
            this.cV[10] = 526848;
            this.cV[11] = 525313;
            this.cV[12] = 1581057;
            this.cV[13] = 3166214;
            this.cV[14] = 2138120;
            this.cV[15] = 6373424;
            this.cV[16] = 4358208;
            this.cV[17] = 12910976;
            this.cV[18] = 9044480;
            this.cV[19] = 9706496;
            this.cV[20] = 15216640;
            this.cV[21] = 0xD0E000;
            this.cV[22] = 11763712;
            this.cV[23] = 0x7E0000;
        }
        return this.p(this.dP(), this.dR(), this.dV());
    }

    public int p(double d0, double d1, double d2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.c(d0), MathHelper.c(d1), MathHelper.c(d2));
        int j2 = 0;
        if (this.cN == null || this.cN.e() == 0) {
            j2 = 12;
        }
        for (int k2 = j2; k2 < 24; ++k2) {
            float f1;
            if (this.cU[k2] == null || !((f1 = this.cU[k2].c(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = k2;
        }
        return i2;
    }

    public @Nullable PathEntity a(int i2, int j2, @Nullable PathPoint pathpoint) {
        for (int k2 = 0; k2 < 24; ++k2) {
            PathPoint pathpoint1 = this.cU[k2];
            pathpoint1.i = false;
            pathpoint1.g = 0.0f;
            pathpoint1.e = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cU[i2];
        PathPoint pathpoint3 = this.cU[j2];
        pathpoint2.e = 0.0f;
        pathpoint2.g = pathpoint2.f = pathpoint2.a(pathpoint3);
        this.cW.a();
        this.cW.a(pathpoint2);
        PathPoint pathpoint4 = pathpoint2;
        int l2 = 0;
        if (this.cN == null || this.cN.e() == 0) {
            l2 = 12;
        }
        while (!this.cW.e()) {
            PathPoint pathpoint5 = this.cW.c();
            if (pathpoint5.equals(pathpoint3)) {
                if (pathpoint != null) {
                    pathpoint.h = pathpoint3;
                    pathpoint3 = pathpoint;
                }
                return this.a(pathpoint2, pathpoint3);
            }
            if (pathpoint5.a(pathpoint3) < pathpoint4.a(pathpoint3)) {
                pathpoint4 = pathpoint5;
            }
            pathpoint5.i = true;
            int i1 = 0;
            for (int j1 = 0; j1 < 24; ++j1) {
                if (this.cU[j1] != pathpoint5) continue;
                i1 = j1;
                break;
            }
            for (int k1 = l2; k1 < 24; ++k1) {
                if ((this.cV[i1] & 1 << k1) <= 0) continue;
                PathPoint pathpoint6 = this.cU[k1];
                if (pathpoint6.i) continue;
                float f2 = pathpoint5.e + pathpoint5.a(pathpoint6);
                if (pathpoint6.c() && !(f2 < pathpoint6.e)) continue;
                pathpoint6.h = pathpoint5;
                pathpoint6.e = f2;
                pathpoint6.f = pathpoint6.a(pathpoint3);
                if (pathpoint6.c()) {
                    this.cW.a(pathpoint6, pathpoint6.e + pathpoint6.f);
                    continue;
                }
                pathpoint6.g = pathpoint6.e + pathpoint6.f;
                this.cW.a(pathpoint6);
            }
        }
        if (pathpoint4 == pathpoint2) {
            return null;
        }
        cx.debug("Failed to find path from {} to {}", (Object)i2, (Object)j2);
        if (pathpoint != null) {
            pathpoint.h = pathpoint4;
            pathpoint4 = pathpoint;
        }
        return this.a(pathpoint2, pathpoint4);
    }

    private PathEntity a(PathPoint pathpoint, PathPoint pathpoint1) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = pathpoint1;
        list.add(0, pathpoint1);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(pathpoint1.a, pathpoint1.b, pathpoint1.c), true);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a(cD, this.cP.a().h().b());
        valueoutput.a(cC, this.cu);
        valueoutput.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        valueinput.e(cD).ifPresent(integer -> this.cP.a(DragonControllerPhase.a(integer)));
        this.cu = valueinput.a(cC, 0);
        this.expToDrop = valueinput.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void dW() {
    }

    public EntityComplexPart[] gM() {
        return this.cF;
    }

    @Override
    public boolean bX() {
        return false;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.jI;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.jN;
    }

    @Override
    protected float fC() {
        return 5.0f;
    }

    public Vec3D L(float f2) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cP.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.h();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f1 = this.ee();
                float f22 = 1.5f;
                this.w(-45.0f);
                vec3d = this.h(f2);
                this.w(f1);
            } else {
                vec3d = this.h(f2);
            }
        } else {
            BlockPosition blockposition = this.ao().a(HeightMap.Type.f, WorldGenEndTrophy.a(this.cO));
            float f3 = Math.max((float)Math.sqrt(blockposition.b(this.dI())) / 4.0f, 1.0f);
            float f4 = 6.0f / f3;
            float f5 = this.ee();
            float f6 = 1.5f;
            this.w(-f4 * 1.5f * 5.0f);
            vec3d = this.h(f2);
            this.w(f5);
        }
        return vec3d;
    }

    public void a(WorldServer worldserver, EntityEnderCrystal entityendercrystal, BlockPosition blockposition, DamageSource damagesource) {
        EntityHuman entityhuman1;
        Entity entity = damagesource.d();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : worldserver.a(cy, (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        if (entityendercrystal == this.cw) {
            this.a(worldserver, this.c, this.en().d(entityendercrystal, entityhuman), 10.0f);
        }
        this.cP.a().a(entityendercrystal, blockposition, damagesource, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (a.equals(datawatcherobject) && this.ao().B_()) {
            this.cP.a(DragonControllerPhase.a(this.aD().a(a)));
        }
        super.a(datawatcherobject);
    }

    public DragonControllerManager gN() {
        return this.cP;
    }

    public @Nullable EnderDragonBattle gO() {
        return this.cN;
    }

    @Override
    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean flag) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        EntityComplexPart[] aentitycomplexpart = this.gM();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packetplayoutspawnentity.b() + 1);
        }
    }

    @Override
    public boolean c(EntityLiving entityliving) {
        return entityliving.eS();
    }

    @Override
    protected float c(float f2) {
        return 1.0f;
    }
}

