/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.WindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jspecify.annotations.Nullable;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> d = ImmutableList.of(a, b, c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int f = 220;
    private static final int cv = 0;
    private final float[] cw = new float[2];
    private final float[] cx = new float[2];
    private final float[] cy = new float[2];
    private final float[] cz = new float[2];
    private final int[] cA = new int[2];
    private final int[] cB = new int[2];
    private int cC;
    public final BossBattleServer cD = (BossBattleServer)new BossBattleServer(this.R_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final PathfinderTargetCondition.a cE = (entityliving, worldserver) -> !entityliving.ay().a(TagsEntity.z) && entityliving.gm();
    private static final PathfinderTargetCondition cF = PathfinderTargetCondition.a().a(20.0).a(cE);

    public EntityWither(EntityTypes<? extends EntityWither> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.cp = new ControllerMoveFlying(this, 10, false);
        this.x(this.fq());
        this.cn = 50;
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.e(false);
        navigationflying.a(true);
        return navigationflying;
    }

    @Override
    protected void D() {
        this.cs.a(0, new a());
        this.cs.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.cs.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(7, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cE));
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, 0);
        datawatcher_a.a(b, 0);
        datawatcher_a.a(c, 0);
        datawatcher_a.a(e, 0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Invul", this.gR());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("Invul", 0));
        if (this.i_()) {
            this.cD.a(this.R_());
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent ichatbasecomponent) {
        super.b(ichatbasecomponent);
        this.cD.a(this.R_());
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.FR;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.FU;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.FT;
    }

    @Override
    public void d_() {
        Entity entity;
        Vec3D vec3d = this.dN().d(1.0, 0.6, 1.0);
        if (!this.ao().B_() && this.b(0) > 0 && (entity = this.ao().a(this.b(0))) != null) {
            double d0 = vec3d.h;
            if (this.dR() < entity.dR() || !this.gS() && this.dR() < entity.dR() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.g, d0, vec3d.i);
            Vec3D vec3d1 = new Vec3D(entity.dP() - this.dP(), 0.0, entity.dV() - this.dV());
            if (vec3d1.j() > 9.0) {
                Vec3D vec3d2 = vec3d1.d();
                vec3d = vec3d.b(vec3d2.g * 0.3 - vec3d.g * 0.6, 0.0, vec3d2.i * 0.3 - vec3d.i * 0.6);
            }
        }
        this.k(vec3d);
        if (vec3d.j() > 0.05) {
            this.v((float)MathHelper.d(vec3d.i, vec3d.g) * 57.295776f - 90.0f);
        }
        super.d_();
        for (int i2 = 0; i2 < 2; ++i2) {
            this.cz[i2] = this.cx[i2];
            this.cy[i2] = this.cw[i2];
        }
        for (int j2 = 0; j2 < 2; ++j2) {
            int k2 = this.b(j2 + 1);
            Entity entity1 = null;
            if (k2 > 0) {
                entity1 = this.ao().a(k2);
            }
            if (entity1 != null) {
                double d1 = this.d(j2 + 1);
                double d2 = this.r(j2 + 1);
                double d3 = this.s(j2 + 1);
                double d4 = entity1.dP() - d1;
                double d5 = entity1.dT() - d2;
                double d6 = entity1.dV() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.d(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d5, d7) * 57.2957763671875));
                this.cw[j2] = this.a(this.cw[j2], f1, 40.0f);
                this.cx[j2] = this.a(this.cx[j2], f2, 10.0f);
                continue;
            }
            this.cx[j2] = this.a(this.cx[j2], this.bC, 10.0f);
        }
        boolean flag = this.gS();
        for (int l2 = 0; l2 < 3; ++l2) {
            double d8 = this.d(l2);
            double d9 = this.r(l2);
            double d10 = this.s(l2);
            float f2 = 0.3f * this.eF();
            this.ao().a(Particles.ai, d8 + this.as.k() * (double)f2, d9 + this.as.k() * (double)f2, d10 + this.as.k() * (double)f2, 0.0, 0.0, 0.0);
            if (!flag || this.ao().y.a(4) != 0) continue;
            this.ao().a(ColorParticleOption.a(Particles.v, 0.7f, 0.7f, 0.5f), d8 + this.as.k() * (double)f2, d9 + this.as.k() * (double)f2, d10 + this.as.k() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.gR() > 0) {
            float f3 = 3.3f * this.eF();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.ao().a(ColorParticleOption.a(Particles.v, 0.7f, 0.7f, 0.9f), this.dP() + this.as.k(), this.dR() + (double)(this.as.i() * f3), this.dV() + this.as.k(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void a(WorldServer worldserver) {
        if (this.gR() > 0) {
            int i2 = this.gR() - 1;
            this.cD.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    worldserver.a((Entity)this, this.dP(), this.dT(), this.dV(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.bq()) {
                    int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : MinecraftServer.getServer().aj().k) {
                        double deltaX = this.dP() - player.dP();
                        double deltaZ = this.dV() - player.dV();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        if (worldserver.spigotConfig.witherSpawnSoundRadius > 0 && distanceSquared > (double)(worldserver.spigotConfig.witherSpawnSoundRadius * worldserver.spigotConfig.witherSpawnSoundRadius)) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dP() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dV() + deltaZ / deltaLength * (double)viewDistance;
                            player.g.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dR(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.g.b(new PacketPlayOutWorldEvent(1023, this.dK(), 0, true));
                    }
                }
            }
            this.a(i2);
            if (this.at % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            super.a(worldserver);
            for (int j2 = 1; j2 < 3; ++j2) {
                EntityLiving entityliving1;
                int i1;
                if (this.at < this.cA[j2 - 1]) continue;
                this.cA[j2 - 1] = this.at + 10 + this.as.a(10);
                if (worldserver.av() == EnumDifficulty.c || worldserver.av() == EnumDifficulty.d) {
                    int k2 = j2 - 1;
                    int l2 = this.cB[j2 - 1];
                    this.cB[k2] = this.cB[j2 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.a(this.as, this.dP() - 10.0, this.dP() + 10.0);
                        double d1 = MathHelper.a(this.as, this.dR() - 5.0, this.dR() + 5.0);
                        double d2 = MathHelper.a(this.as, this.dV() - 10.0, this.dV() + 10.0);
                        this.a(j2 + 1, d0, d1, d2, true);
                        this.cB[j2 - 1] = 0;
                    }
                }
                if ((i1 = this.b(j2)) > 0) {
                    EntityLiving entityliving = (EntityLiving)worldserver.a(i1);
                    if (entityliving != null && this.c(entityliving) && this.g((Entity)entityliving) <= 900.0 && this.G(entityliving)) {
                        this.a(j2 + 1, entityliving);
                        this.cA[j2 - 1] = this.at + 40 + this.as.a(20);
                        this.cB[j2 - 1] = 0;
                        continue;
                    }
                    this.a(j2, 0);
                    continue;
                }
                List<EntityLiving> list = worldserver.a(EntityLiving.class, cF, this, this.dj().c(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.as.a(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(j2, entityliving1.aA());
            }
            if (this.ag_() != null) {
                this.a(0, this.ag_().aA());
            } else {
                this.a(0, 0);
            }
            if (this.cC > 0) {
                --this.cC;
                if (this.cC == 0 && worldserver.U().a(GameRules.F).booleanValue()) {
                    boolean flag = false;
                    int j1 = MathHelper.b(this.dF() / 2.0f + 1.0f);
                    int k1 = MathHelper.b(this.dG());
                    for (BlockPosition blockposition : BlockPosition.b(this.dO() - j1, this.dQ(), this.dU() - j1, this.dO() + j1, this.dQ() + k1, this.dU() + j1)) {
                        IBlockData iblockdata = worldserver.a_(blockposition);
                        if (!EntityWither.c(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.m())) continue;
                        flag = worldserver.a(blockposition, true, this) || flag;
                    }
                    if (flag) {
                        worldserver.a((Entity)null, 1022, this.dK(), 0);
                    }
                }
            }
            if (this.at % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cD.a(this.eZ() / this.fq());
        }
    }

    public static boolean c(IBlockData iblockdata) {
        return !iblockdata.l() && !iblockdata.a(TagsBlock.aS);
    }

    public void k() {
        this.a(220);
        this.cD.a(0.0f);
        this.x(this.fq() / 3.0f);
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
    }

    @Override
    public void d(EntityPlayer entityplayer) {
        super.d(entityplayer);
        this.cD.a(entityplayer);
    }

    @Override
    public void e(EntityPlayer entityplayer) {
        super.e(entityplayer);
        this.cD.b(entityplayer);
    }

    private double d(int i2) {
        if (i2 <= 0) {
            return this.dP();
        }
        float f2 = (this.bC + (float)(180 * (i2 - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.b((double)f2);
        return this.dP() + (double)f1 * 1.3 * (double)this.eF();
    }

    private double r(int i2) {
        float f2 = i2 <= 0 ? 3.0f : 2.2f;
        return this.dR() + (double)(f2 * this.eF());
    }

    private double s(int i2) {
        if (i2 <= 0) {
            return this.dV();
        }
        float f2 = (this.bC + (float)(180 * (i2 - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.a((double)f2);
        return this.dV() + (double)f1 * 1.3 * (double)this.eF();
    }

    private float a(float f2, float f1, float f22) {
        float f3 = MathHelper.f(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    private void a(int i2, EntityLiving entityliving) {
        this.a(i2, entityliving.dP(), entityliving.dR() + (double)entityliving.dk() * 0.5, entityliving.dV(), i2 == 0 && this.as.i() < 0.001f);
    }

    private void a(int i2, double d0, double d1, double d2, boolean flag) {
        if (!this.bq()) {
            this.ao().a((Entity)null, 1024, this.dK(), 0);
        }
        double d3 = this.d(i2);
        double d4 = this.r(i2);
        double d5 = this.s(i2);
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        Vec3D vec3d = new Vec3D(d6, d7, d8);
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.ao(), this, vec3d.d());
        entitywitherskull.d(this);
        if (flag) {
            entitywitherskull.b(true);
        }
        entitywitherskull.a_(d3, d4, d5);
        this.ao().b(entitywitherskull);
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        this.a(0, entityliving);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (!damagesource.a(DamageTypeTags.t) && !(damagesource.d() instanceof EntityWither)) {
            Entity entity;
            if (this.gR() > 0 && !damagesource.a(DamageTypeTags.d)) {
                return false;
            }
            if (this.gS() && ((entity = damagesource.c()) instanceof EntityArrow || entity instanceof WindCharge)) {
                return false;
            }
            Entity entity1 = damagesource.d();
            if (entity1 != null && entity1.ay().a(TagsEntity.z)) {
                return false;
            }
            if (this.cC <= 0) {
                this.cC = 20;
            }
            int i2 = 0;
            while (i2 < this.cB.length) {
                int n2 = i2++;
                this.cB[n2] = this.cB[n2] + 3;
            }
            return super.a(worldserver, damagesource, f2);
        }
        return false;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        EntityItem entityitem = this.a(worldserver, Items.wE);
        if (entityitem != null) {
            entityitem.r();
        }
    }

    @Override
    public void dW() {
        if (this.ao().av() == EnumDifficulty.a && !this.ay().s()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.bK = 0;
        }
    }

    @Override
    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gW().a(GenericAttributes.u, 300.0).a(GenericAttributes.x, 0.6f).a(GenericAttributes.n, 0.6f).a(GenericAttributes.o, 40.0).a(GenericAttributes.b, 4.0);
    }

    public float[] gP() {
        return this.cx;
    }

    public float[] gQ() {
        return this.cw;
    }

    public int gR() {
        return this.az.a(e);
    }

    public void a(int i2) {
        this.az.a(e, i2);
    }

    public int b(int i2) {
        return this.az.a(d.get(i2));
    }

    public void a(int i2, int j2) {
        this.az.a(d.get(i2), j2);
    }

    public boolean gS() {
        return this.eZ() <= this.fq() / 2.0f;
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean flag) {
        return false;
    }

    @Override
    public boolean b(MobEffect mobeffect) {
        return mobeffect.a(MobEffects.t) ? false : super.b(mobeffect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityWither.this.gR() > 0;
        }
    }
}

