/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Collection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.animal.feline.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jspecify.annotations.Nullable;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final boolean d = false;
    private static final boolean e = false;
    private static final short f = 30;
    private static final byte cv = 3;
    private int cw;
    public int cx;
    public int cy = 30;
    public int cz = 3;
    private boolean cA;
    public Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(2, new PathfinderGoalSwell(this));
        this.cs.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.cs.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.cs.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(6, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ct.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.x, 0.25);
    }

    @Override
    public int cW() {
        return this.ag_() == null ? this.y(0.0f) : this.y(this.eZ() - 1.0f);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        boolean flag = super.a(d0, f2, damagesource);
        this.cx += (int)(d0 * 1.5);
        if (this.cx > this.cy - 5) {
            this.cx = this.cy - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, -1);
        datawatcher_a.a(b, false);
        datawatcher_a.a(c, false);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("powered", this.p());
        valueoutput.a("Fuse", (short)this.cy);
        valueoutput.a("ExplosionRadius", (byte)this.cz);
        valueoutput.a("ignited", this.gQ());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.az.a(b, valueinput.a("powered", false));
        this.cy = valueinput.a("Fuse", (short)30);
        this.cz = valueinput.a("ExplosionRadius", (byte)3);
        if (valueinput.a("ignited", false)) {
            this.gR();
        }
    }

    @Override
    public void g() {
        if (this.cb()) {
            int i2;
            this.cw = this.cx;
            if (this.gQ()) {
                this.a(1);
            }
            if ((i2 = this.gP()) > 0 && this.cx == 0) {
                this.a(SoundEffects.hI, 1.0f, 0.5f);
                this.c(GameEvent.I);
            }
            this.cx += i2;
            if (this.cx < 0) {
                this.cx = 0;
            }
            if (this.cx >= this.cy) {
                this.cx = this.cy;
                this.gS();
            }
        }
        super.g();
    }

    @Override
    public void g(@Nullable EntityLiving entityliving) {
        if (!(entityliving instanceof Goat)) {
            super.g(entityliving);
        }
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.hH;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.hG;
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving, DamageSource damagesource) {
        if (this.e(worldserver) && this.p() && !this.cA) {
            entityliving.a(worldserver, damagesource, false, LootTables.bd, (ItemStack itemstack) -> {
                entityliving.a(worldserver, (ItemStack)itemstack);
                this.cA = true;
            });
        }
        return super.a(worldserver, entityliving, damagesource);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        return true;
    }

    public boolean p() {
        return this.az.a(b);
    }

    public float L(float f2) {
        return MathHelper.h(f2, this.cw, this.cx) / (float)(this.cy - 2);
    }

    public int gP() {
        return this.az.a(a);
    }

    public void a(int i2) {
        this.az.a(a, i2);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        super.a(worldserver, entitylightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, entitylightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.az.a(b, true);
    }

    public void setPowered(boolean powered) {
        this.az.a(b, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(TagsItem.bP)) {
            SoundEffect soundeffect = itemstack.a(Items.wi) ? SoundEffects.kx : SoundEffects.kN;
            this.ao().a((Entity)entityhuman, this.dP(), this.dR(), this.dV(), soundeffect, this.dB(), 1.0f, this.as.i() * 0.4f + 0.8f);
            if (!this.ao().B_()) {
                this.entityIgniter = entityhuman;
                this.gR();
                if (itemstack.p() == 0) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, (EntityLiving)entityhuman, enumhand.a());
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    public void gS() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            float f2 = this.p() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.cz * f2, false);
            if (!event.isCancelled()) {
                this.bJ = true;
                worldserver.a((Entity)this, Explosion.a(this.ao(), this).customCausingEntityDamager(this.entityIgniter), null, this.dP(), this.dR(), this.dV(), event.getRadius(), event.getFire(), World.a.c);
                this.gT();
                this.a(worldserver, Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.cx = 0;
            }
        }
    }

    private void gT() {
        Collection<MobEffect> collection = this.eW();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.ao(), this.dP(), this.dR(), this.dV());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.c(-0.5f);
            entityareaeffectcloud.d(10);
            entityareaeffectcloud.a(300);
            entityareaeffectcloud.b(0.25f);
            entityareaeffectcloud.d(-entityareaeffectcloud.c() / (float)entityareaeffectcloud.h());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.ao().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean gQ() {
        return this.az.a(c);
    }

    public void gR() {
        this.az.a(c, true);
    }
}

