/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final int cA = 40;
    private static final float cB = 0.3f;
    private static final int cC = 1;
    private static final float cD = 0.6f;
    private static final int cE = 6;
    private static final float cF = 0.5f;
    private static final boolean cG = false;
    private static final int cH = 0;
    private static final boolean cI = false;
    public static final int cv = 300;
    private int cJ;
    public int cK = 0;
    public boolean cL = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> cw = ImmutableList.of(SensorType.c, SensorType.d, SensorType.o, SensorType.n);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.aB, (Object[])new MemoryModuleType[]{MemoryModuleType.A, MemoryModuleType.aD, MemoryModuleType.aE, MemoryModuleType.aA, MemoryModuleType.L, MemoryModuleType.aH, MemoryModuleType.aI, MemoryModuleType.aa});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cn = 5;
    }

    @VisibleForTesting
    public void s(int i2) {
        this.cK = i2;
    }

    @Override
    public boolean aj_() {
        return true;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gW().a(GenericAttributes.u, 40.0).a(GenericAttributes.x, 0.3f).a(GenericAttributes.r, 0.6f).a(GenericAttributes.e, 1.0).a(GenericAttributes.d, 6.0);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            this.cJ = 10;
            this.ao().a((Entity)this, (byte)4);
            this.b(SoundEffects.oo);
            HoglinAI.a(this, entityliving);
            return IOglin.a(worldserver, this, entityliving);
        }
        return false;
    }

    @Override
    protected void d(EntityLiving entityliving) {
        if (this.gP()) {
            IOglin.a(this, entityliving);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity;
        boolean flag = super.a(worldserver, damagesource, f2);
        if (flag && (entity = damagesource.d()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            HoglinAI.a(worldserver, this, entityliving);
        }
        return flag;
    }

    protected BehaviorController.b<EntityHoglin> ew() {
        return BehaviorController.a(cx, cw);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.ew().a(dynamic));
    }

    public BehaviorController<EntityHoglin> ev() {
        return super.ev();
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("hoglinBrain");
        this.ev().a(worldserver, this);
        gameprofilerfiller.c();
        HoglinAI.a(this);
        if (this.gR()) {
            ++this.cK;
            if (this.cK > 300) {
                this.b(SoundEffects.op);
                this.gT();
            }
        } else {
            this.cK = 0;
        }
    }

    @Override
    public void d_() {
        if (this.cJ > 0) {
            --this.cJ;
        }
        super.d_();
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.cn = 3;
            this.h(GenericAttributes.d).a(0.5);
        } else {
            this.cn = 5;
            this.h(GenericAttributes.d).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !generatoraccess.a_(blockposition.e()).a(Blocks.lG);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (worldaccess.G_().i() < 0.2f) {
            this.a_(true);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean i(double d0) {
        return true;
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return HoglinAI.a(this, blockposition) ? -1.0f : (iworldreader.a_(blockposition.e()).a(Blocks.pu) ? 10.0f : 0.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.gz();
        }
        return enuminteractionresult;
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.cJ = 10;
            this.b(SoundEffects.oo);
        } else {
            super.b(b0);
        }
    }

    @Override
    public int gQ() {
        return this.cJ;
    }

    @Override
    public boolean eI() {
        return true;
    }

    @Override
    protected int f(WorldServer worldserver) {
        return this.cn;
    }

    private void gT() {
        this.convertTo(EntityTypes.bV, ConversionParams.a(this, true, false), entityzoglin -> entityzoglin.a(new MobEffect(MobEffects.i, 200, 0)), EntityTransformEvent.TransformReason.PIGLIN_ZOMBIFIED, CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aU);
    }

    public boolean gP() {
        return !this.e_();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cz, false);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsImmuneToZombification", this.gU());
        valueoutput.a("TimeInOverworld", this.cK);
        valueoutput.a("CannotBeHunted", this.cL);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("IsImmuneToZombification", false));
        this.cK = valueinput.a("TimeInOverworld", 0);
        this.y(valueinput.a("CannotBeHunted", false));
    }

    public void x(boolean flag) {
        this.aD().a(cz, flag);
    }

    public boolean gU() {
        return this.aD().a(cz);
    }

    public boolean gR() {
        return !this.gU() && !this.gG() && this.ao().c().a(EnvironmentAttributes.J, this.dI()) != false;
    }

    private void y(boolean flag) {
        this.cL = flag;
    }

    public boolean gS() {
        return this.gP() && !this.cL;
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        EntityHoglin entityhoglin = EntityTypes.ao.a(worldserver, EntitySpawnReason.e);
        if (entityhoglin != null) {
            entityhoglin.gz();
        }
        return entityhoglin;
    }

    @Override
    public boolean gY() {
        return !HoglinAI.c(this) && super.gY();
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect W() {
        return this.ao().B_() ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.or;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.oq;
    }

    @Override
    protected SoundEffect bk() {
        return SoundEffects.oX;
    }

    @Override
    protected SoundEffect bl() {
        return SoundEffects.oW;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.ot, 0.15f, 1.0f);
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }
}

