/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cw = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey cy = MinecraftKey.b("baby");
    private static final AttributeModifier cz = new AttributeModifier(cy, 0.2f, AttributeModifier.Operation.b);
    private static final int cA = 16;
    private static final float cB = 0.35f;
    private static final int cC = 5;
    private static final float cD = 0.1f;
    private static final int cE = 3;
    private static final float cF = 0.2f;
    private static final EntitySize cG = EntityTypes.aZ.n().a(0.5f).b(0.97f);
    private static final double cH = 0.5;
    private static final boolean cI = false;
    private static final boolean cJ = false;
    public final InventorySubcontainer cK = new InventorySubcontainer(8);
    public boolean cL = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> e = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.w, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.az, MemoryModuleType.ay, MemoryModuleType.M, MemoryModuleType.ba, MemoryModuleType.y, MemoryModuleType.z, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.u, MemoryModuleType.am, MemoryModuleType.an, MemoryModuleType.A, MemoryModuleType.ao, MemoryModuleType.ap, MemoryModuleType.ar, MemoryModuleType.aq, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.as, MemoryModuleType.aw, MemoryModuleType.N, MemoryModuleType.aC, MemoryModuleType.t, MemoryModuleType.aD, MemoryModuleType.aE, MemoryModuleType.av, MemoryModuleType.ax, MemoryModuleType.aF, MemoryModuleType.aG, MemoryModuleType.aH, MemoryModuleType.ah, MemoryModuleType.ai, MemoryModuleType.aj, MemoryModuleType.ak, MemoryModuleType.al});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> entitytypes, World world) {
        super(entitytypes, world);
        this.cn = 5;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsBaby", this.e_());
        valueoutput.a("CannotHunt", this.cL);
        this.a_(valueoutput);
        ValueOutput.a barterList = valueoutput.a("Bukkit.BarterList", Codec.STRING);
        this.allowedBarterItems.stream().map(BuiltInRegistries.h::b).map(MinecraftKey::toString).forEach(barterList::a);
        ValueOutput.a interestList = valueoutput.a("Bukkit.InterestList", Codec.STRING);
        this.interestItems.stream().map(BuiltInRegistries.h::b).map(MinecraftKey::toString).forEach(interestList::a);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a_(valueinput.a("IsBaby", false));
        this.z(valueinput.a("CannotHunt", false));
        this.a_(valueinput);
        valueinput.b("Bukkit.BarterList", Codec.STRING).ifPresent(list -> {
            this.allowedBarterItems = list.b().map(MinecraftKey::c).map(BuiltInRegistries.h::a).collect(Collectors.toCollection(HashSet::new));
        });
        valueinput.b("Bukkit.InterestList", Codec.STRING).ifPresent(list -> {
            this.interestItems = list.b().map(MinecraftKey::c).map(BuiltInRegistries.h::a).collect(Collectors.toCollection(HashSet::new));
        });
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer gP() {
        return this.cK;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        this.cK.g().forEach(itemstack -> this.a(worldserver, (ItemStack)itemstack));
    }

    protected ItemStack j(ItemStack itemstack) {
        return this.cK.b(itemstack);
    }

    protected boolean k(ItemStack itemstack) {
        return this.cK.c(itemstack);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cv, false);
        datawatcher_a.a(cw, false);
        datawatcher_a.a(cx, false);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (cv.equals(datawatcherobject)) {
            this.j_();
        }
    }

    public static AttributeProvider.Builder gX() {
        return EntityMonster.gW().a(GenericAttributes.u, 16.0).a(GenericAttributes.x, 0.35f).a(GenericAttributes.d, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !generatoraccess.a_(blockposition.e()).a(Blocks.lG);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        if (entityspawnreason != EntitySpawnReason.d) {
            if (randomsource.i() < 0.2f) {
                this.a_(true);
            } else if (this.gR()) {
                this.a(EnumItemSlot.a, this.gZ());
            }
        }
        PiglinAI.a(this, worldaccess.G_());
        this.a(randomsource, difficultydamagescaler);
        this.a(worldaccess, randomsource, difficultydamagescaler);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean i(double d0) {
        return !this.gA();
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (this.gR()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.ry), randomsource);
            this.a(EnumItemSlot.e, new ItemStack(Items.rz), randomsource);
            this.a(EnumItemSlot.d, new ItemStack(Items.rA), randomsource);
            this.a(EnumItemSlot.c, new ItemStack(Items.rB), randomsource);
        }
    }

    private void a(EnumItemSlot enumitemslot, ItemStack itemstack, RandomSource randomsource) {
        if (randomsource.i() < 0.1f) {
            this.a(enumitemslot, itemstack);
        }
    }

    protected BehaviorController.b<EntityPiglin> ew() {
        return BehaviorController.a(e, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.ew().a(dynamic));
    }

    public BehaviorController<EntityPiglin> ev() {
        return super.ev();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return PiglinAI.a(worldserver, this, entityhuman, enumhand);
        }
        boolean flag = PiglinAI.b(this, entityhuman.b(enumhand)) && this.gS() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.e_() ? cG : super.b(entitypose);
    }

    @Override
    public void a_(boolean flag) {
        this.aD().a(cv, flag);
        if (!this.ao().B_()) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
            attributemodifiable.c(cz.a());
            if (flag) {
                attributemodifiable.b(cz);
            }
        }
    }

    @Override
    public boolean e_() {
        return this.aD().a(cv);
    }

    private void z(boolean flag) {
        this.cL = flag;
    }

    @Override
    protected boolean k() {
        return !this.cL;
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("piglinBrain");
        this.ev().a(worldserver, this);
        gameprofilerfiller.c();
        PiglinAI.a(this);
        super.a(worldserver);
    }

    @Override
    protected int f(WorldServer worldserver) {
        return this.cn;
    }

    @Override
    protected void h(WorldServer worldserver) {
        PiglinAI.a(worldserver, this);
        this.cK.g().forEach(itemstack -> this.a(worldserver, (ItemStack)itemstack));
        super.h(worldserver);
    }

    private ItemStack gZ() {
        return (double)this.as.i() < 0.5 ? new ItemStack(Items.yz) : new ItemStack(this.as.a(10) == 0 ? Items.xM : Items.qC);
    }

    @Override
    public @Nullable TagKey<Item> aa() {
        return this.e_() ? null : TagsItem.cp;
    }

    private boolean ha() {
        return this.az.a(cw);
    }

    @Override
    public void b(boolean flag) {
        this.az.a(cw, flag);
    }

    @Override
    public void a() {
        this.bK = 0;
    }

    @Override
    public EntityPiglinArmPose gS() {
        return this.gY() ? EntityPiglinArmPose.e : (PiglinAI.a(this.fy()) ? EntityPiglinArmPose.d : (this.gI() && this.gT() ? EntityPiglinArmPose.a : (this.ha() ? EntityPiglinArmPose.c : (this.b(Items.yz) && ItemCrossbow.g(this.eq()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean gY() {
        return this.az.a(cx);
    }

    public void y(boolean flag) {
        this.az.a(cx, flag);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity;
        boolean flag = super.a(worldserver, damagesource, f2);
        if (flag && (entity = damagesource.d()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            PiglinAI.a(worldserver, this, entityliving);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean g(ItemStack itemstack) {
        return itemstack.h() == Items.yz || itemstack.c(DataComponents.O);
    }

    protected void l(ItemStack itemstack) {
        this.b(EnumItemSlot.a, itemstack);
    }

    protected void m(ItemStack itemstack) {
        if (itemstack.a(PiglinAI.c) || this.allowedBarterItems.contains(itemstack.h())) {
            this.a(EnumItemSlot.b, itemstack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, itemstack);
        }
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return worldserver.U().a(GameRules.F) != false && this.gn() && PiglinAI.a(this, itemstack);
    }

    protected boolean n(ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.f(itemstack);
        ItemStack itemstack1 = this.a(enumitemslot);
        return this.a(itemstack, itemstack1, enumitemslot);
    }

    @Override
    protected boolean a(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        boolean flag1;
        if (EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.F)) {
            return false;
        }
        TagKey<Item> tagkey = this.aa();
        boolean flag = PiglinAI.isLovedItem(itemstack, this) || tagkey != null && itemstack.a(tagkey);
        boolean bl = flag1 = PiglinAI.isLovedItem(itemstack1, this) || tagkey != null && itemstack1.a(tagkey);
        return flag && !flag1 ? true : (!flag && flag1 ? false : super.a(itemstack, itemstack1, enumitemslot));
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        this.a(entityitem);
        PiglinAI.a(worldserver, this, entityitem);
    }

    @Override
    public boolean a(Entity entity, boolean flag, boolean flag1) {
        if (this.e_() && entity.ay() == EntityTypes.ao) {
            entity = this.c(entity, 3);
        }
        return super.a(entity, flag, flag1);
    }

    private Entity c(Entity entity, int i2) {
        List<Entity> list = entity.dn();
        return i2 != 1 && !list.isEmpty() ? this.c(list.getFirst(), i2 - 1) : entity;
    }

    @Override
    protected @Nullable SoundEffect W() {
        return this.ao().B_() ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.wx;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.wv;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.wz, 0.15f, 1.0f);
    }

    @Override
    protected void gU() {
        this.b(SoundEffects.wA);
    }
}

