/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.skeleton;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpecialDates;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int c = 20;
    private static final int d = 40;
    protected static final int a = 50;
    protected static final int b = 70;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> e = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack f = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void e() {
            super.e();
            EntitySkeletonAbstract.this.w(false);
        }

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.w(true);
        }
    };

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.gP();
    }

    @Override
    protected void D() {
        this.cs.a(2, new PathfinderGoalRestrictSun(this));
        this.cs.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.cs.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(6, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.cv));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.x, 0.25);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.p(), 0.15f, 1.0f);
    }

    abstract SoundEffect p();

    @Override
    public void t() {
        super.t();
        Entity entity = this.dA();
        if (entity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)entity;
            this.bC = entitycreature.bC;
        }
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        this.a(EnumItemSlot.a, new ItemStack(Items.pW));
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        groupdataentity = super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        RandomSource randomsource = worldaccess.G_();
        this.a(randomsource, difficultydamagescaler);
        this.a(worldaccess, randomsource, difficultydamagescaler);
        this.gP();
        this.b_(randomsource.i() < 0.55f * difficultydamagescaler.d());
        if (this.a(EnumItemSlot.f).f() && SpecialDates.b() && randomsource.i() < 0.25f) {
            this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.eK : Blocks.eJ));
            this.a(EnumItemSlot.f, 0.0f);
        }
        return groupdataentity;
    }

    public void gP() {
        if (this.ao() != null && !this.ao().B_()) {
            this.cs.a(this.f);
            this.cs.a(this.e);
            ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.pW));
            if (itemstack.a(Items.pW)) {
                int i2 = this.gQ();
                if (this.ao().av() != EnumDifficulty.d) {
                    i2 = this.gR();
                }
                this.e.c(i2);
                this.cs.a(4, this.e);
            } else {
                this.cs.a(4, this.f);
            }
        }
    }

    protected int gQ() {
        return 20;
    }

    protected int gR() {
        return 40;
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.pW));
        ItemStack itemstack1 = this.d(itemstack);
        EntityArrow entityarrow = this.a(itemstack1, f2, itemstack);
        double d0 = entityliving.dP() - this.dP();
        double d1 = entityliving.f(0.3333333333333333) - entityarrow.dR();
        double d2 = entityliving.dV() - this.dV();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.fx(), null, entityarrow, EnumHand.a, 0.8f, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == entityarrow.getBukkitEntity()) {
                IProjectile.a(entityarrow, worldserver, itemstack1, d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - worldserver.av().a() * 4);
            }
        }
        this.a(SoundEffects.Au, 1.0f, 1.0f / (this.ep().i() * 0.4f + 0.8f));
    }

    protected EntityArrow a(ItemStack itemstack, float f2, @Nullable ItemStack itemstack1) {
        return ProjectileHelper.a(this, itemstack, f2, itemstack1);
    }

    @Override
    public boolean g(ItemStack itemstack) {
        return itemstack.h() == Items.pW;
    }

    @Override
    public TagKey<Item> aa() {
        return TagsItem.cn;
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.gP();
    }

    @Override
    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        super.onEquipItem(enumitemslot, itemstack, itemstack1, silent);
        if (!this.ao().B_()) {
            this.gP();
        }
    }

    public boolean gS() {
        return this.cO();
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return itemstack.a(TagsItem.cf) ? false : super.c(worldserver, itemstack);
    }
}

