/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.spider;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.skeleton.EntitySkeleton;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class EntitySpider
extends EntityMonster {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntitySpider.class, DataWatcherRegistry.a);
    private static final float b = 0.1f;

    public EntitySpider(EntityTypes<? extends EntitySpider> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(2, new PathfinderGoalAvoidTarget<Armadillo>(this, Armadillo.class, 6.0f, 1.0, 1.2, entityliving -> !((Armadillo)entityliving).gP()));
        this.cs.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.cs.a(4, new PathfinderGoalSpiderMeleeAttack(this));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(6, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(2, new PathfinderGoalSpiderNearestAttackableTarget<EntityHuman>(this, EntityHuman.class));
        this.ct.a(3, new PathfinderGoalSpiderNearestAttackableTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationSpider(this, world);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, (byte)0);
    }

    @Override
    public void g() {
        super.g();
        if (!this.ao().B_()) {
            this.x(this.ad);
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gW().a(GenericAttributes.u, 16.0).a(GenericAttributes.x, 0.3f);
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.Cd;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.Cf;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.Ce;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Cg, 0.15f, 1.0f);
    }

    @Override
    public boolean fl() {
        return this.gP();
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
        if (!iblockdata.a(Blocks.bz)) {
            super.a(iblockdata, vec3d);
        }
    }

    @Override
    public boolean b(MobEffect mobeffect) {
        return mobeffect.a(MobEffects.s) ? false : super.b(mobeffect);
    }

    public boolean gP() {
        return (this.az.a(a) & 1) != 0;
    }

    public void x(boolean flag) {
        byte b0 = this.az.a(a);
        b0 = flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.az.a(a, b0);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        EntitySkeleton entityskeleton;
        groupdataentity = super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        RandomSource randomsource = worldaccess.G_();
        if (randomsource.a(100) == 0 && (entityskeleton = EntityTypes.bn.a(this.ao(), EntitySpawnReason.g)) != null) {
            entityskeleton.b(this.dP(), this.dR(), this.dV(), this.ec(), 0.0f);
            entityskeleton.a(worldaccess, difficultydamagescaler, entityspawnreason, (GroupDataEntity)null);
            entityskeleton.a((Entity)this, false, false);
        }
        if (groupdataentity == null) {
            groupdataentity = new GroupDataSpider();
            if (worldaccess.av() == EnumDifficulty.d && randomsource.i() < 0.1f * difficultydamagescaler.d()) {
                ((GroupDataSpider)groupdataentity).a(randomsource);
            }
        }
        if (groupdataentity instanceof GroupDataSpider) {
            GroupDataSpider entityspider_groupdataspider = (GroupDataSpider)groupdataentity;
            Holder<MobEffectList> holder = entityspider_groupdataspider.a;
            if (holder != null) {
                this.addEffect(new MobEffect(holder, -1), EntityPotionEffectEvent.Cause.SPIDER_SPAWN);
            }
        }
        return groupdataentity;
    }

    @Override
    public Vec3D m(Entity entity) {
        return entity.dF() <= this.dF() ? new Vec3D(0.0, 0.3125 * (double)this.eF(), 0.0) : super.m(entity);
    }

    private static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntitySpider entityspider) {
            super(entityspider, 1.0, true);
        }

        @Override
        public boolean b() {
            return super.b() && !this.a.cr();
        }

        @Override
        public boolean c() {
            float f2 = this.a.bO();
            if (f2 >= 0.5f && this.a.ep().a(100) == 0) {
                this.a.g((EntityLiving)null);
                return false;
            }
            return super.c();
        }
    }

    private static class PathfinderGoalSpiderNearestAttackableTarget<T extends EntityLiving>
    extends PathfinderGoalNearestAttackableTarget<T> {
        public PathfinderGoalSpiderNearestAttackableTarget(EntitySpider entityspider, Class<T> oclass) {
            super((EntityInsentient)entityspider, oclass, true);
        }

        @Override
        public boolean b() {
            float f2 = this.e.bO();
            return f2 >= 0.5f ? false : super.b();
        }
    }

    public static class GroupDataSpider
    implements GroupDataEntity {
        public @Nullable Holder<MobEffectList> a;

        public void a(RandomSource randomsource) {
            int i2 = randomsource.a(5);
            if (i2 <= 1) {
                this.a = MobEffects.a;
            } else if (i2 <= 2) {
                this.a = MobEffects.e;
            } else if (i2 <= 3) {
                this.a = MobEffects.j;
            } else if (i2 <= 4) {
                this.a = MobEffects.n;
            }
        }
    }
}

