/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final int cv = 40;
    private static final int cw = 200;
    private static final int cx = 500;
    private static final float cy = 0.3f;
    private static final float cz = 1.0f;
    private static final float cA = 1.5f;
    private static final int cB = 30;
    private static final int cC = 24;
    private static final DataWatcherObject<Integer> cD = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int cE = 200;
    private static final int cF = 260;
    private static final int cG = 20;
    private static final int cH = 120;
    private static final int cI = 20;
    private static final int cJ = 35;
    private static final int cK = 10;
    private static final int cL = 20;
    private static final int cM = 100;
    private static final int cN = 20;
    private static final int cO = 30;
    private static final float cP = 4.5f;
    private static final float cQ = 0.7f;
    private static final int cR = 30;
    private int cU;
    private int cV;
    private int cW;
    private int cX;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState f = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cY = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cZ = new a();
    private VibrationSystem.a da = new VibrationSystem.a();
    AngerManagement db = new AngerManagement(this::H, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> entitytypes, World world) {
        super(entitytypes, world);
        this.cn = 5;
        this.N().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, this.d(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (packetplayoutspawnentity.n() == 1) {
            this.c(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return super.a(iworldreader) && iworldreader.a((Entity)this, this.ay().n().a(this.dI()));
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.gU() && !damagesource.a(DamageTypeTags.d) ? true : super.a(worldserver, damagesource);
    }

    boolean gU() {
        return this.d(EntityPose.o) || this.d(EntityPose.n);
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public float gu() {
        return 5.0f;
    }

    @Override
    protected float bj() {
        return this.al + 0.55f;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.u, 500.0).a(GenericAttributes.x, 0.3f).a(GenericAttributes.r, 1.0).a(GenericAttributes.e, 1.5).a(GenericAttributes.d, 30.0).a(GenericAttributes.o, 24.0);
    }

    @Override
    public boolean bw() {
        return true;
    }

    @Override
    protected float fC() {
        return 4.0f;
    }

    @Override
    protected @Nullable SoundEffect W() {
        return !this.d(EntityPose.l) && !this.gU() ? this.gP().b() : null;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.Fg;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.Fc;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Fq, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        worldserver.a((Entity)this, (byte)4);
        this.a(SoundEffects.Fb, 10.0f, this.fD());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(worldserver, entity);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cD, 0);
    }

    public int p() {
        return this.az.a(cD);
    }

    private void gX() {
        this.az.a(cD, this.ha());
    }

    @Override
    public void g() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.da, this.cZ);
            if (this.gA() || this.ab()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.g();
        if (this.ao().B_()) {
            if (this.at % this.gY() == 0) {
                this.cW = 10;
                if (!this.bq()) {
                    this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.Ff, this.dB(), 5.0f, this.fD(), false);
                }
            }
            this.cV = this.cU;
            if (this.cU > 0) {
                --this.cU;
            }
            this.cX = this.cW;
            if (this.cW > 0) {
                --this.cW;
            }
            switch (this.aF()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("wardenBrain");
        this.ev().a(worldserver, this);
        gameprofilerfiller.c();
        super.a(worldserver);
        if ((this.at + this.aA()) % 120 == 0) {
            Warden.a(worldserver, this.dI(), this, 20);
        }
        if (this.at % 20 == 0) {
            this.db.a(worldserver, this::H);
            this.gX();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.a.a();
            this.e.a(this.at);
        } else if (b0 == 61) {
            this.cU = 10;
        } else if (b0 == 62) {
            this.f.a(this.at);
        } else {
            super.b(b0);
        }
    }

    private int gY() {
        float f2 = (float)this.p() / (float)AngerLevel.c.a();
        return 40 - MathHelper.b(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float L(float f2) {
        return MathHelper.h(f2, this.cV, this.cU) / 10.0f;
    }

    public float M(float f2) {
        return MathHelper.h(f2, this.cX, this.cW) / 10.0f;
    }

    private void a(AnimationState animationstate) {
        if ((float)animationstate.a((float)this.at) < 4500.0f) {
            RandomSource randomsource = this.ep();
            IBlockData iblockdata = this.bK();
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dP() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dR();
                    double d2 = this.dV() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.ao().a(new ParticleParamBlock(Particles.b, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (aE.equals(datawatcherobject)) {
            switch (this.aF()) {
                case n: {
                    this.c.a(this.at);
                    break;
                }
                case o: {
                    this.d.a(this.at);
                    break;
                }
                case l: {
                    this.a.a(this.at);
                    break;
                }
                case m: {
                    this.b.a(this.at);
                }
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gU();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> ev() {
        return super.ev();
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            biconsumer.accept(this.cY, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean H(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.ao() == entity.ao() && IEntitySelector.e.test(entity) && !this.t(entity) && entityliving.ay() != EntityTypes.h && entityliving.ay() != EntityTypes.bO && !entityliving.cU() && !entityliving.fa() && this.ao().w().a(entityliving.dj())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer worldserver, Vec3D vec3d, @Nullable Entity entity, int i2) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(worldserver, entity, vec3d, i2, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("anger", AngerManagement.a(this::H), this.db);
        valueoutput.a("listener", VibrationSystem.a.a, this.da);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.db = valueinput.a("anger", AngerManagement.a(this::H)).orElseGet(() -> new AngerManagement(this::H, Collections.emptyList()));
        this.gX();
        this.da = valueinput.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
    }

    private void gZ() {
        if (!this.d(EntityPose.l)) {
            this.a(this.gP().c(), 10.0f, this.fD());
        }
    }

    public AngerLevel gP() {
        return AngerLevel.a(this.ha());
    }

    private int ha() {
        return this.db.b(this.ag_());
    }

    public void I(Entity entity) {
        this.db.a(entity);
    }

    public void J(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int i2, boolean flag) {
        if (!this.gG() && this.H(entity)) {
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.ag_() instanceof EntityHuman);
            int j2 = this.db.a(entity, i2);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.ev().b(MemoryModuleType.p);
            }
            if (flag) {
                this.gZ();
            }
        }
    }

    public Optional<EntityLiving> gQ() {
        return this.gP().d() ? this.db.a() : Optional.empty();
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }

    @Override
    public boolean i(double d0) {
        return false;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.ev().a(MemoryModuleType.aP, Unit.a, 1200L);
        if (entityspawnreason == EntitySpawnReason.k) {
            this.c(EntityPose.n);
            this.ev().a(MemoryModuleType.aN, Unit.a, WardenAi.a);
            this.a(SoundEffects.EY, 5.0f, 1.0f);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean flag = super.a(worldserver, damagesource, f2);
        if (!this.gG() && !this.gU()) {
            Entity entity = damagesource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.ca.c(MemoryModuleType.p).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (damagesource.b() || this.a((Entity)entityliving, 5.0)) {
                    this.i(entityliving);
                }
            }
        }
        return flag;
    }

    public void i(EntityLiving entityliving) {
        this.ev().b(MemoryModuleType.aJ);
        this.ev().a(MemoryModuleType.p, entityliving);
        this.ev().b(MemoryModuleType.F);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        EntitySize entitysize = super.b(entitypose);
        return this.gU() ? EntitySize.c(entitysize.a(), 1.0f) : entitysize;
    }

    @Override
    public boolean bY() {
        return !this.gU() && super.bY();
    }

    @Override
    protected void F(Entity entity) {
        if (!this.gG() && !this.ev().a(MemoryModuleType.aS)) {
            this.ev().a(MemoryModuleType.aS, Unit.a, 20L);
            this.J(entity);
            WardenAi.a(this, entity.dK());
        }
        super.F(entity);
    }

    @VisibleForTesting
    public AngerManagement gR() {
        return this.db;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, this, world){

            @Override
            protected Pathfinder a(int i2) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, i2){

                    @Override
                    protected float a(PathPoint pathpoint, PathPoint pathpoint1) {
                        return pathpoint.b(pathpoint1);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gS() {
        return this.da;
    }

    @Override
    public VibrationSystem.d gT() {
        return this.cZ;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.dk());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, GameEvent.a gameevent_a) {
            if (!(Warden.this.gG() || Warden.this.fa() || Warden.this.ev().a(MemoryModuleType.aT) || Warden.this.gU() || !worldserver.w().a(blockposition))) {
                EntityLiving entityliving;
                Entity entity = gameevent_a.a();
                if (entity instanceof EntityLiving && !Warden.this.H(entityliving = (EntityLiving)entity)) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, @Nullable Entity entity, @Nullable Entity entity1, float f2) {
            if (!Warden.this.fa()) {
                Warden.this.ca.a(MemoryModuleType.aT, Unit.a, 40L);
                worldserver.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.Fr, 5.0f, Warden.this.fD());
                BlockPosition blockposition1 = blockposition;
                if (entity1 != null) {
                    if (Warden.this.a(entity1, 30.0)) {
                        if (Warden.this.ev().a(MemoryModuleType.aL)) {
                            if (Warden.this.H(entity1)) {
                                blockposition1 = entity1.dK();
                            }
                            Warden.this.J(entity1);
                        } else {
                            Warden.this.a(entity1, 10, true);
                        }
                    }
                    Warden.this.ev().a(MemoryModuleType.aL, Unit.a, 100L);
                } else {
                    Warden.this.J(entity);
                }
                if (!Warden.this.gP().d()) {
                    Optional<EntityLiving> optional = Warden.this.db.a();
                    if (entity1 != null || optional.isEmpty() || optional.get() == entity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

