/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.entity.npc.villager.VillagerDataHolder;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    public static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> f = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int cv = 3600;
    private static final int cw = 6000;
    private static final int cx = 14;
    private static final int cy = 4;
    private static final int cz = -1;
    private static final int cA = 0;
    private static final Set<EntitySpawnReason> cB = EnumSet.of(EntitySpawnReason.r, new EntitySpawnReason[]{EntitySpawnReason.s, EntitySpawnReason.i, EntitySpawnReason.m, EntitySpawnReason.c, EntitySpawnReason.q});
    public int cC;
    public @Nullable UUID cD;
    private @Nullable Reputation cE;
    private @Nullable MerchantRecipeList cF;
    private int cG = 0;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> entitytypes, World world) {
        super((EntityTypes<? extends EntityZombie>)entitytypes, world);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, false);
        datawatcher_a.a(f, this.hb());
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("VillagerData", VillagerData.c, this.gZ());
        valueoutput.b("Offers", MerchantRecipeList.a, this.cF);
        valueoutput.b("Gossips", Reputation.a, this.cE);
        valueoutput.a("ConversionTime", this.gS() ? this.cC : -1);
        valueoutput.b("ConversionPlayer", UUIDUtil.a, this.cD);
        valueoutput.a("Xp", this.cG);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.az.a(f, valueinput.a("VillagerData", VillagerData.c).orElseGet(this::hb));
        this.cF = valueinput.a("Offers", MerchantRecipeList.a).orElse(null);
        this.cE = valueinput.a("Gossips", Reputation.a).orElse(null);
        int i2 = valueinput.a("ConversionTime", -1);
        if (i2 != -1) {
            UUID uuid = valueinput.a("ConversionPlayer", UUIDUtil.a).orElse(null);
            this.b(uuid, i2);
        } else {
            this.aD().a(a, false);
            this.cC = -1;
        }
        this.cG = valueinput.a("Xp", 0);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (!cB.contains((Object)entityspawnreason)) {
            this.a(this.gZ().a(worldaccess.J_(), VillagerType.a(worldaccess.z(this.dK()))));
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private VillagerData hb() {
        Optional optional = BuiltInRegistries.y.a(this.as);
        VillagerData villagerdata = EntityVillager.gX();
        if (optional.isPresent()) {
            villagerdata = villagerdata.b(optional.get());
        }
        return villagerdata;
    }

    @Override
    public void g() {
        if (!this.ao().B_() && this.cb() && this.gS()) {
            int i2 = this.hc();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cC -= (i2 *= elapsedTicks);
            if (this.cC <= 0) {
                this.i((WorldServer)this.ao());
            }
        }
        super.g();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.rK)) {
            if (this.d(MobEffects.r)) {
                itemstack.a(1, (EntityLiving)entityhuman);
                if (!this.ao().B_()) {
                    this.b(entityhuman.cY(), this.as.a(2401) + 3600);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    protected boolean gR() {
        return false;
    }

    @Override
    public boolean i(double d0) {
        return !this.gS() && this.cG == 0;
    }

    public boolean gS() {
        return this.aD().a(a);
    }

    public void b(@Nullable UUID uuid, int i2) {
        this.cD = uuid;
        this.cC = i2;
        this.aD().a(a, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, i2, Math.min(this.ao().av().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        this.ao().a((Entity)this, (byte)16);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 16) {
            if (!this.bq()) {
                this.ao().a(this.dP(), this.dT(), this.dV(), SoundEffects.Hn, this.dB(), 1.0f + this.as.i(), this.as.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(b0);
        }
    }

    private void i(WorldServer worldserver) {
        EntityVillager converted = this.convertTo(EntityTypes.bL, ConversionParams.a(this, false, false), entityvillager -> {
            EntityHuman entityhuman;
            this.forceDrops = false;
            for (EnumItemSlot enumitemslot : this.a(worldserver, (ItemStack itemstack) -> !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.F))) {
                SlotAccess slotaccess = entityvillager.a_(enumitemslot.b() + 300);
                if (slotaccess == null) continue;
                slotaccess.a(this.a(enumitemslot));
            }
            entityvillager.a(this.gZ());
            if (this.cE != null) {
                entityvillager.a(this.cE);
            }
            if (this.cF != null) {
                entityvillager.b(this.cF.a());
            }
            entityvillager.s(this.cG);
            entityvillager.a((WorldAccess)worldserver, worldserver.c(entityvillager.dK()), EntitySpawnReason.i, (GroupDataEntity)null);
            entityvillager.i(worldserver);
            if (this.cD != null && (entityhuman = worldserver.c(this.cD)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)entityhuman, this, (EntityVillager)entityvillager);
                worldserver.a(ReputationEvent.a, (Entity)entityhuman, (ReputationHandler)((Object)entityvillager));
            }
            entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.bq()) {
                worldserver.a((Entity)null, 1027, this.dK(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void d(int i2) {
        this.cC = i2;
    }

    private int hc() {
        int i2 = 1;
        if (this.as.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dP() - 4; k2 < (int)this.dP() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.dR() - 4; l2 < (int)this.dR() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dV() - 4; i1 < (int)this.dV() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.ao().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.fC) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.as.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float fD() {
        return this.e_() ? (this.as.i() - this.as.i()) * 0.2f + 2.0f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.Hl;
    }

    @Override
    public SoundEffect h(DamageSource damagesource) {
        return SoundEffects.Hp;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Ho;
    }

    @Override
    public SoundEffect gP() {
        return SoundEffects.Hq;
    }

    public void a(MerchantRecipeList merchantrecipelist) {
        this.cF = merchantrecipelist;
    }

    public void a(Reputation reputation) {
        this.cE = reputation;
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gZ();
        if (!villagerdata1.b().equals(villagerdata.b())) {
            this.cF = null;
        }
        this.az.a(f, villagerdata);
    }

    @Override
    public VillagerData gZ() {
        return this.az.a(f);
    }

    public int ha() {
        return this.cG;
    }

    public void r(int i2) {
        this.cG = i2;
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aC ? EntityZombieVillager.c(datacomponenttype, this.gZ().a()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aC);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aC) {
            Holder<VillagerType> holder = EntityZombieVillager.c(DataComponents.aC, t0);
            this.a(this.gZ().a(holder));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

