/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.villager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> cx = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int cv = 300;
    private static final int cy = 8;
    private @Nullable EntityHuman cz;
    protected @Nullable MerchantRecipeList cw;
    private final InventorySubcontainer cA = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    public int p() {
        return this.az.a(cx);
    }

    public void r(int i2) {
        this.az.a(cx, i2);
    }

    @Override
    public int d() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cx, 0);
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman) {
        this.cz = entityhuman;
    }

    @Override
    public @Nullable EntityHuman a() {
        return this.cz;
    }

    public boolean gQ() {
        return this.cz != null;
    }

    @Override
    public MerchantRecipeList b() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.cw == null) {
                this.cw = new MerchantRecipeList();
                this.h(worldserver);
            }
            return this.cw;
        }
        throw new IllegalStateException("Cannot load Villager offers on the client");
    }

    @Override
    public void a(@Nullable MerchantRecipeList merchantrecipelist) {
    }

    @Override
    public void a(int i2) {
    }

    @Override
    public void a(MerchantRecipe merchantrecipe) {
        merchantrecipe.l();
        this.cm = -this.S();
        this.b(merchantrecipe);
        if (this.cz instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.cz, this, merchantrecipe.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean e() {
        return true;
    }

    @Override
    public void a(ItemStack itemstack) {
        if (!this.ao().B_() && this.cm > -this.S() + 20) {
            this.cm = -this.S();
            this.b(this.x(!itemstack.f()));
        }
    }

    @Override
    public SoundEffect f() {
        return SoundEffects.Eq;
    }

    protected SoundEffect x(boolean flag) {
        return flag ? SoundEffects.Eq : SoundEffects.Eo;
    }

    public void gR() {
        this.b(SoundEffects.El);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        MerchantRecipeList merchantrecipelist;
        super.a(valueoutput);
        if (!this.ao().B_() && !(merchantrecipelist = this.b()).isEmpty()) {
            valueoutput.a("Offers", MerchantRecipeList.a, merchantrecipelist);
        }
        this.a_(valueoutput);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cw = valueinput.a("Offers", MerchantRecipeList.a).orElse(null);
        this.a_(valueinput);
    }

    @Override
    public @Nullable Entity b(TeleportTransition teleporttransition) {
        this.gS();
        return super.b(teleporttransition);
    }

    protected void gS() {
        this.a((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damagesource) {
        super.a(damagesource);
        this.gS();
    }

    protected void a(ParticleParam particleparam) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d2 = this.as.k() * 0.02;
            this.ao().a(particleparam, this.e(1.0), this.dS() + 1.0, this.h(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean aj_() {
        return false;
    }

    @Override
    public InventorySubcontainer gP() {
        return this.cA;
    }

    @Override
    public @Nullable SlotAccess a_(int i2) {
        int j2 = i2 - 300;
        return j2 >= 0 && j2 < this.cA.b() ? this.cA.a_(j2) : super.a_(i2);
    }

    protected abstract void h(WorldServer var1);

    protected void a(WorldServer worldserver, MerchantRecipeList merchantrecipelist, VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption, int i2) {
        ArrayList arraylist = Lists.newArrayList((Object[])avillagertrades_imerchantrecipeoption);
        int j2 = 0;
        while (j2 < i2 && !arraylist.isEmpty()) {
            MerchantRecipe merchantrecipe = ((VillagerTrades.IMerchantRecipeOption)arraylist.remove(this.as.a(arraylist.size()))).a(worldserver, this, this.as);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                merchantrecipelist.add(CraftMerchantRecipe.fromBukkit(event.getRecipe()).toMinecraft());
            }
            ++j2;
        }
    }

    @Override
    public Vec3D u(float f2) {
        float f1 = MathHelper.h(f2, this.bD, this.bC) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.dj().c() - 1.0, 0.2);
        return this.p(f2).e(vec3d.b(-f1));
    }

    @Override
    public boolean c() {
        return this.ao().B_();
    }

    @Override
    public boolean b(EntityHuman entityhuman) {
        return this.a() == entityhuman && this.cb() && entityhuman.b((Entity)this, 4.0);
    }
}

