/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    private static final DataWatcherObject<OptionalInt> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.u);
    public static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    private static final int e = 0;
    private static final int f = 0;
    private static final boolean g = false;
    public int h = 0;
    public int i = 0;
    public @Nullable EntityLiving j;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    public EntityFireworks(World world, double d0, double d1, double d2, ItemStack itemstack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.ad, world);
        this.h = 0;
        this.a_(d0, d1, d2);
        this.az.a(b, itemstack.v());
        int i2 = 1;
        Fireworks fireworks = itemstack.a(DataComponents.aq);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.m(this.as.a(0.0, 0.002297), 0.05, this.as.a(0.0, 0.002297));
        this.i = 10 * i2 + this.as.a(6) + this.as.a(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack);
        this.d(entity);
    }

    public EntityFireworks(World world, ItemStack itemstack, EntityLiving entityliving) {
        this(world, entityliving, entityliving.dP(), entityliving.dR(), entityliving.dV(), itemstack);
        this.az.a(c, OptionalInt.of(entityliving.aA()));
        this.j = entityliving;
    }

    public EntityFireworks(World world, ItemStack itemstack, double d0, double d1, double d2, boolean flag) {
        this(world, d0, d1, d2, itemstack);
        this.az.a(d, flag);
    }

    public EntityFireworks(World world, ItemStack itemstack, Entity entity, double d0, double d1, double d2, boolean flag) {
        this(world, itemstack, d0, d1, d2, flag);
        this.d(entity);
    }

    @Override
    public void inactiveTick() {
        World world;
        ++this.h;
        if (this.h > this.i && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.inactiveTick();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(b, EntityFireworks.s());
        datawatcher_a.a(c, OptionalInt.empty());
        datawatcher_a.a(d, false);
    }

    @Override
    public boolean a(double d0) {
        return d0 < 4096.0 && !this.k();
    }

    @Override
    public boolean j(double d0, double d1, double d2) {
        return super.j(d0, d1, d2) && !this.k();
    }

    @Override
    public void g() {
        World world;
        MovingObjectPosition movingobjectposition;
        super.g();
        if (this.k()) {
            if (this.j == null) {
                this.az.a(c).ifPresent(i2 -> {
                    Entity entity = this.ao().a(i2);
                    if (entity instanceof EntityLiving) {
                        this.j = (EntityLiving)entity;
                    }
                });
            }
            if (this.j != null) {
                Vec3D vec3d;
                if (this.j.gj()) {
                    Vec3D vec3d1 = this.j.cj();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d2 = this.j.dN();
                    this.j.k(vec3d2.b(vec3d1.g * 0.1 + (vec3d1.g * 1.5 - vec3d2.g) * 0.5, vec3d1.h * 0.1 + (vec3d1.h * 1.5 - vec3d2.h) * 0.5, vec3d1.i * 0.1 + (vec3d1.i * 1.5 - vec3d2.i) * 0.5));
                    vec3d = this.j.a(Items.wG);
                } else {
                    vec3d = Vec3D.c;
                }
                this.a_(this.j.dP() + vec3d.g, this.j.dR() + vec3d.h, this.j.dV() + vec3d.i);
                this.k(this.j.dN());
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.f()) {
                double d2 = this.ad ? 1.0 : 1.15;
                this.k(this.dN().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d3 = this.dN();
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, vec3d3);
            this.aW();
            this.k(vec3d3);
        }
        if (!this.ar && this.cb() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
            this.aF = true;
        }
        this.q();
        if (this.h == 0 && !this.bq()) {
            this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), SoundEffects.kD, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.h;
        if (this.ao().B_() && this.h % 2 < 2) {
            this.ao().a(Particles.E, this.dP(), this.dR(), this.dV(), this.as.k() * 0.05, -this.dN().h * 0.5, this.as.k() * 0.05);
        }
        if (this.h > this.i && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    private void b(WorldServer worldserver) {
        worldserver.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.p());
        this.e(worldserver);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = new BlockPosition(movingobjectpositionblock.b());
        this.ao().a_(blockposition).a(this.ao(), blockposition, this, InsideBlockEffectApplier.a, true);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.i() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.a(movingobjectpositionblock);
    }

    private boolean i() {
        return !this.r().isEmpty();
    }

    private void e(WorldServer worldserver) {
        float f2 = 0.0f;
        List<FireworkExplosion> list = this.r();
        if (!list.isEmpty()) {
            f2 = 5.0f + (float)(list.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.j != null) {
                this.j.a(worldserver, this.en().a(this, this.p()), 5.0f + (float)(list.size() * 2));
            }
            double d0 = 5.0;
            Vec3D vec3d = this.dI();
            for (EntityLiving entityliving : this.ao().a(EntityLiving.class, this.dj().g(5.0))) {
                if (entityliving == this.j || !(this.g(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dP(), entityliving.f(0.5 * (double)i2), entityliving.dV());
                    MovingObjectPositionBlock movingobjectposition = this.ao().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (((MovingObjectPosition)movingobjectposition).d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(entityliving)) / 5.0);
                entityliving.a(worldserver, this.en().a(this, this.p()), f1);
            }
        }
    }

    private boolean k() {
        return this.az.a(c).isPresent();
    }

    public boolean f() {
        return this.az.a(d);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 17 && this.ao().B_()) {
            Vec3D vec3d = this.dN();
            this.ao().a(this.dP(), this.dR(), this.dV(), vec3d.g, vec3d.h, vec3d.i, this.r());
        }
        super.b(b0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Life", this.h);
        valueoutput.a("LifeTime", this.i);
        valueoutput.a("FireworksItem", ItemStack.b, this.e());
        valueoutput.a("ShotAtAngle", this.az.a(d));
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.h = valueinput.a("Life", 0);
        this.i = valueinput.a("LifeTime", 0);
        this.az.a(b, valueinput.a("FireworksItem", ItemStack.b).orElse(EntityFireworks.s()));
        this.az.a(d, valueinput.a("ShotAtAngle", false));
    }

    private List<FireworkExplosion> r() {
        ItemStack itemstack = this.az.a(b);
        Fireworks fireworks = itemstack.a(DataComponents.aq);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack e() {
        return this.az.a(b);
    }

    @Override
    public boolean cT() {
        return false;
    }

    private static ItemStack s() {
        return new ItemStack(Items.wG);
    }

    @Override
    public DoubleDoubleImmutablePair a(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = entityliving.dI().g - this.dI().g;
        double d1 = entityliving.dI().i - this.dI().i;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

