/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger b = LogUtils.getLogger();
    private final RandomSource c = RandomSource.a();
    private boolean d;
    private int e;
    private static final int f = 10;
    public static final DataWatcherObject<Integer> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int i;
    private int j;
    public int k;
    public int l;
    private float m;
    private boolean n = true;
    public @Nullable Entity o;
    public HookState p = HookState.a;
    private final int q;
    private final int r;
    private final InterpolationHandler s = new InterpolationHandler(this);
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world, int i2, int j2) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
        this.q = Math.max(0, i2);
        this.r = Math.max(0, j2);
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> entitytypes, World world) {
        this(entitytypes, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman entityhuman, World world, int i2, int j2) {
        this(EntityTypes.cc, world, i2, j2);
        this.d((Entity)entityhuman);
        float f2 = entityhuman.ee();
        float f1 = entityhuman.ec();
        float f22 = MathHelper.b((double)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.a((double)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.b((double)(-f2 * ((float)Math.PI / 180)));
        float f5 = MathHelper.a((double)(-f2 * ((float)Math.PI / 180)));
        double d0 = entityhuman.dP() - (double)f3 * 0.3;
        double d1 = entityhuman.dT();
        double d2 = entityhuman.dV() - (double)f22 * 0.3;
        this.b(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.a(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.g();
        vec3d = vec3d.d(0.6 / d3 + this.as.a(0.5, 0.0103365), 0.6 / d3 + this.as.a(0.5, 0.0103365), 0.6 / d3 + this.as.a(0.5, 0.0103365));
        this.k(vec3d);
        this.v((float)(MathHelper.d(vec3d.g, vec3d.i) * 57.2957763671875));
        this.w((float)(MathHelper.d(vec3d.h, vec3d.i()) * 57.2957763671875));
        this.ab = this.ec();
        this.ac = this.ee();
    }

    @Override
    public InterpolationHandler l_() {
        return this.s;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(g, 0);
        datawatcher_a.a(h, false);
    }

    @Override
    protected boolean ah_() {
        return true;
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (g.equals(datawatcherobject)) {
            int i2 = this.aD().a(g);
            Entity entity = this.o = i2 > 0 ? this.ao().a(i2 - 1) : null;
        }
        if (h.equals(datawatcherobject)) {
            this.d = this.aD().a(h);
            if (this.d) {
                this.m(this.dN().g, -0.4f * MathHelper.a(this.c, 0.6f, 1.0f), this.dN().i);
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(double d0) {
        double d1 = 64.0;
        return d0 < 4096.0;
    }

    @Override
    public void g() {
        this.c.b(this.cY().getLeastSignificantBits() ^ this.ao().au());
        this.l_().e();
        super.g();
        EntityHuman entityhuman = this.i();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.ao().B_() || !this.a(entityhuman)) {
            boolean flag;
            if (this.aV()) {
                ++this.i;
                if (this.i >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.i = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.dK();
            Fluid fluid = this.ao().b_(blockposition);
            if (fluid.a(TagsFluid.a)) {
                f2 = fluid.a(this.ao(), blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.p == HookState.a) {
                if (this.o != null) {
                    this.k(Vec3D.c);
                    this.p = HookState.b;
                    return;
                }
                if (flag) {
                    this.k(this.dN().d(0.3, 0.2, 0.3));
                    this.p = HookState.c;
                    return;
                }
                this.r();
            } else {
                if (this.p == HookState.b) {
                    if (this.o != null) {
                        if (!this.o.eh() && this.o.av() && this.o.ao().aq() == this.ao().aq()) {
                            this.a_(this.o.dP(), this.o.f(0.8), this.o.dV());
                        } else {
                            this.C(null);
                            this.p = HookState.a;
                        }
                    }
                    return;
                }
                if (this.p == HookState.c) {
                    Vec3D vec3d = this.dN();
                    double d0 = this.dR() + vec3d.h - (double)blockposition.v() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.m(vec3d.g * 0.9, vec3d.h - d0 * (double)this.as.i() * 0.2, vec3d.i * 0.9);
                    if (this.j <= 0 && this.l <= 0) {
                        this.n = true;
                    } else {
                        boolean bl2 = this.n = this.n && this.e < 10 && this.b(blockposition);
                    }
                    if (flag) {
                        this.e = Math.max(0, this.e - 1);
                        if (this.d) {
                            this.k(this.dN().b(0.0, -0.1 * (double)this.c.i() * (double)this.c.i(), 0.0));
                        }
                        if (!this.ao().B_()) {
                            this.a(blockposition);
                        }
                    } else {
                        this.e = Math.min(10, this.e + 1);
                    }
                }
            }
            if (!fluid.a(TagsFluid.a) && !this.aV() && this.o == null) {
                this.k(this.dN().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dN());
            this.aW();
            this.q();
            if (this.p == HookState.a && (this.aV() || this.ad)) {
                this.k(Vec3D.c);
            }
            double d1 = 0.92;
            this.k(this.dN().c(0.92));
            this.aH();
        }
    }

    private boolean a(EntityHuman entityhuman) {
        if (entityhuman.av()) {
            ItemStack itemstack = entityhuman.fx();
            ItemStack itemstack1 = entityhuman.fy();
            boolean flag = itemstack.a(Items.sZ);
            boolean flag1 = itemstack1.a(Items.sZ);
            if ((flag || flag1) && this.g(entityhuman) <= 1024.0) {
                return false;
            }
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void r() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
    }

    @Override
    protected boolean b(Entity entity) {
        return super.b(entity) || entity.cb() && entity instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        if (!this.ao().B_()) {
            this.C(movingobjectpositionentity.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        this.k(this.dN().d().c(movingobjectpositionblock.a(this)));
    }

    public void C(@Nullable Entity entity) {
        this.o = entity;
        this.aD().a(g, entity == null ? 0 : entity.aA() + 1);
    }

    private void a(BlockPosition blockposition) {
        WorldServer worldserver = (WorldServer)this.ao();
        int i2 = 1;
        BlockPosition blockposition1 = blockposition.d();
        if (this.rainInfluenced && this.as.i() < 0.25f && this.ao().v(blockposition1)) {
            ++i2;
        }
        if (this.skyInfluenced && this.as.i() < 0.5f && !this.ao().k(blockposition1)) {
            --i2;
        }
        if (this.j > 0) {
            --this.j;
            if (this.j <= 0) {
                this.k = 0;
                this.l = 0;
                this.aD().a(h, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.i().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.l > 0) {
            this.l -= i2;
            if (this.l > 0) {
                double d2;
                double d1;
                this.m += (float)this.as.a(0.0, 9.188);
                float f2 = this.m * ((float)Math.PI / 180);
                float f1 = MathHelper.a((double)f2);
                float f22 = MathHelper.b((double)f2);
                double d0 = this.dP() + (double)(f1 * (float)this.l * 0.1f);
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.c(this.dR()) + 1.0f)) - 1.0, d2 = this.dV() + (double)(f22 * (float)this.l * 0.1f)));
                if (iblockdata.a(Blocks.J)) {
                    if (this.as.i() < 0.15f) {
                        worldserver.a(Particles.d, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.a(Particles.F, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.a(Particles.F, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.i().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.a(SoundEffects.kL, 0.25f, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
                double d3 = this.dR() + 0.5;
                worldserver.a(Particles.d, this.dP(), d3, this.dV(), (int)(1.0f + this.dF() * 20.0f), (double)this.dF(), 0.0, (double)this.dF(), (double)0.2f);
                worldserver.a(Particles.F, this.dP(), d3, this.dV(), (int)(1.0f + this.dF() * 20.0f), (double)this.dF(), 0.0, (double)this.dF(), (double)0.2f);
                this.j = MathHelper.a(this.as, 20, 40);
                this.aD().a(h, true);
            }
        } else if (this.k > 0) {
            this.k -= i2;
            float f5 = 0.15f;
            if (this.k < 20) {
                f5 += (float)(20 - this.k) * 0.05f;
            } else if (this.k < 40) {
                f5 += (float)(40 - this.k) * 0.02f;
            } else if (this.k < 60) {
                f5 += (float)(60 - this.k) * 0.01f;
            }
            if (this.as.i() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.a(this.as, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.a(this.as, 25.0f, 60.0f);
                double d4 = this.dP() + (double)(MathHelper.a((double)f6) * f7) * 0.1;
                IBlockData iblockdata1 = worldserver.a_(BlockPosition.a(d4, (d5 = (double)((float)MathHelper.c(this.dR()) + 1.0f)) - 1.0, d6 = this.dV() + (double)(MathHelper.b((double)f6) * f7) * 0.1));
                if (iblockdata1.a(Blocks.J)) {
                    worldserver.a(Particles.aq, d4, d5, d6, 2 + this.as.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.k <= 0) {
                this.m = MathHelper.a(this.as, this.minLureAngle, this.maxLureAngle);
                this.l = MathHelper.a(this.as, this.minLureTime, this.maxLureTime);
            }
        } else {
            this.k = MathHelper.a(this.as, this.minWaitTime, this.maxWaitTime);
            this.k -= this.applyLure ? this.r : 0;
        }
    }

    private boolean b(BlockPosition blockposition) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.a(blockposition.b(-2, i2, -2), blockposition.b(2, i2, 2));
            switch (entityfishinghook_waterposition1.ordinal()) {
                case 0: {
                    if (entityfishinghook_waterposition != WaterPosition.c) break;
                    return false;
                }
                case 1: {
                    if (entityfishinghook_waterposition != WaterPosition.a) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition a(BlockPosition blockposition, BlockPosition blockposition1) {
        return BlockPosition.d(blockposition, blockposition1).map(this::c).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition blockposition) {
        IBlockData iblockdata = this.ao().a_(blockposition);
        if (!iblockdata.l() && !iblockdata.a(Blocks.fV)) {
            Fluid fluid = iblockdata.y();
            return fluid.a(TagsFluid.a) && fluid.b() && iblockdata.g(this.ao(), blockposition).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean f() {
        return this.n;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
    }

    @Override
    protected void a(ValueInput valueinput) {
    }

    public int a(ItemStack itemstack) {
        EntityHuman entityhuman = this.i();
        if (!this.ao().B_() && entityhuman != null && !this.a(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.o != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.o.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                this.c(this.o);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, itemstack, this, Collections.emptyList());
                this.ao().a((Entity)this, (byte)31);
                i2 = this.o instanceof EntityItem ? 3 : 5;
            } else if (this.j > 0) {
                LootParams lootparams = new LootParams.a((WorldServer)this.ao()).a(LootContextParameters.h, this.dI()).a(LootContextParameters.k, itemstack).a(LootContextParameters.a, this).a((float)this.q + entityhuman.eB()).a(LootContextParameterSets.f);
                LootTable loottable = this.ao().s().be().a(LootTables.am);
                ObjectArrayList<ItemStack> list = loottable.a(lootparams);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, itemstack, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    EntityItem entityitem = new EntityItem(this.ao(), this.dP(), this.dR(), this.dV(), itemstack1);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)entityitem.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.as.a(6) + 1);
                    this.ao().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.dP() - this.dP();
                    double d1 = entityhuman.dR() - this.dR();
                    double d2 = entityhuman.dV() - this.dV();
                    double d3 = 0.1;
                    entityitem.m(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.ao().b(entityitem);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.ao().b(new EntityExperienceOrb(entityhuman.ao(), entityhuman.dP(), entityhuman.dR() + 0.5, entityhuman.dV() + 0.5, playerFishEvent2.getExpToDrop()));
                    }
                    if (!itemstack1.a(TagsItem.bo)) continue;
                    entityhuman.a(StatisticList.T, 1);
                }
                i2 = 1;
            }
            if (this.aV()) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.IN_GROUND);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.REEL_IN);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte b0) {
        EntityHuman entityhuman;
        Entity entity;
        if (b0 == 31 && this.ao().B_() && (entity = this.o) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).gH()) {
            this.c(this.o);
        }
        super.b(b0);
    }

    public void c(Entity entity) {
        Entity entity1 = this.p();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.dP() - this.dP(), entity1.dR() - this.dR(), entity1.dV() - this.dV()).c(0.1);
            entity.k(entity.dN().e(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void aE() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void d(@Nullable Entity entity) {
        super.d(entity);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook entityfishinghook) {
        EntityHuman entityhuman = this.i();
        if (entityhuman != null) {
            entityhuman.cx = entityfishinghook;
        }
    }

    public @Nullable EntityHuman i() {
        EntityHuman entityhuman1;
        Entity entity = this.p();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        return entityhuman;
    }

    public @Nullable Entity k() {
        return this.o;
    }

    @Override
    public boolean o(boolean flag) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? this.aA() : entity.aA());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (this.i() == null) {
            int i2 = packetplayoutspawnentity.n();
            b.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.ao().a(i2), (Object)i2);
            this.discard(null);
        }
    }

    public static enum HookState {
        a,
        b,
        c;

    }

    private static enum WaterPosition {
        a,
        b,
        c;

    }
}

