/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityShulkerBullet
extends IProjectile {
    private static final double b = 0.15;
    private @Nullable EntityReference<Entity> c;
    private @Nullable EnumDirection d;
    private int e;
    private double f;
    private double g;
    private double h;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
        this.ar = true;
    }

    public EntityShulkerBullet(World world, EntityLiving entityliving, Entity entity, EnumDirection.EnumAxis enumdirection_enumaxis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.bl, world);
        this.d(entityliving);
        Vec3D vec3d = entityliving.dj().f();
        this.b(vec3d.g, vec3d.h, vec3d.i, this.ec(), this.ee());
        this.c = EntityReference.a(entity);
        this.d = EnumDirection.b;
        this.a(enumdirection_enumaxis, entity);
        this.projectileSource = (LivingEntity)entityliving.getBukkitEntity();
    }

    public Entity getTarget() {
        return EntityReference.a(this.c, this.ao(), Entity.class);
    }

    public void setTarget(Entity e2) {
        this.c = e2 != null ? EntityReference.a(e2) : null;
        this.d = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a, e2);
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        if (this.c != null) {
            valueoutput.a("Target", UUIDUtil.a, this.c.c());
        }
        valueoutput.b("Dir", EnumDirection.k, this.d);
        valueoutput.a("Steps", this.e);
        valueoutput.a("TXD", this.f);
        valueoutput.a("TYD", this.g);
        valueoutput.a("TZD", this.h);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.e = valueinput.a("Steps", 0);
        this.f = valueinput.a("TXD", 0.0);
        this.g = valueinput.a("TYD", 0.0);
        this.h = valueinput.a("TZD", 0.0);
        this.d = valueinput.a("Dir", EnumDirection.k).orElse(null);
        this.c = EntityReference.a(valueinput, "Target");
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
    }

    private @Nullable EnumDirection f() {
        return this.d;
    }

    private void a(@Nullable EnumDirection enumdirection) {
        this.d = enumdirection;
    }

    private void a(@Nullable EnumDirection.EnumAxis enumdirection_enumaxis, @Nullable Entity entity) {
        BlockPosition blockposition;
        double d0 = 0.5;
        if (entity == null) {
            blockposition = this.dK().e();
        } else {
            d0 = (double)entity.dG() * 0.5;
            blockposition = BlockPosition.a(entity.dP(), entity.dR() + d0, entity.dV());
        }
        double d1 = (double)blockposition.u() + 0.5;
        double d2 = (double)blockposition.v() + d0;
        double d3 = (double)blockposition.w() + 0.5;
        EnumDirection enumdirection = null;
        if (!blockposition.a(this.dI(), 2.0)) {
            BlockPosition blockposition1 = this.dK();
            ArrayList list = Lists.newArrayList();
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.a) {
                if (blockposition1.u() < blockposition.u() && this.ao().A(blockposition1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockposition1.u() > blockposition.u() && this.ao().A(blockposition1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.b) {
                if (blockposition1.v() < blockposition.v() && this.ao().A(blockposition1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockposition1.v() > blockposition.v() && this.ao().A(blockposition1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.c) {
                if (blockposition1.w() < blockposition.w() && this.ao().A(blockposition1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockposition1.w() > blockposition.w() && this.ao().A(blockposition1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            enumdirection = EnumDirection.b(this.as);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.ao().A(blockposition1.a(enumdirection)) && i2 > 0; --i2) {
                    enumdirection = EnumDirection.b(this.as);
                }
            } else {
                enumdirection = (EnumDirection)list.get(this.as.a(list.size()));
            }
            d1 = this.dP() + (double)enumdirection.j();
            d2 = this.dR() + (double)enumdirection.k();
            d3 = this.dV() + (double)enumdirection.l();
        }
        this.a(enumdirection);
        double d4 = d1 - this.dP();
        double d5 = d2 - this.dR();
        double d6 = d3 - this.dV();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 == 0.0) {
            this.f = 0.0;
            this.g = 0.0;
            this.h = 0.0;
        } else {
            this.f = d4 / d7 * 0.15;
            this.g = d5 / d7 * 0.15;
            this.h = d6 / d7 * 0.15;
        }
        this.aF = true;
        this.e = 10 + this.as.a(5) * 10;
    }

    @Override
    public void dW() {
        if (this.ao().av() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double bs() {
        return 0.04;
    }

    @Override
    public void g() {
        super.g();
        Entity entity = !this.ao().B_() ? EntityReference.a(this.c, this.ao()) : null;
        MovingObjectPosition movingobjectposition = null;
        if (!this.ao().B_()) {
            if (entity == null) {
                this.c = null;
            }
            if (entity == null || !entity.cb() || entity instanceof EntityHuman && entity.au()) {
                this.bu();
            } else {
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                this.h = MathHelper.a(this.h * 1.025, -1.0, 1.0);
                Vec3D vec3d = this.dN();
                this.k(vec3d.b((this.f - vec3d.g) * 0.2, (this.g - vec3d.h) * 0.2, (this.h - vec3d.i) * 0.2));
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        }
        Vec3D vec3d1 = this.dN();
        this.b(this.dI().e(vec3d1));
        this.aW();
        if (this.aG != null && this.aG.e()) {
            this.cn();
        }
        if (movingobjectposition != null && this.cb() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
        }
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.ao().B_()) {
            this.ao().a(Particles.u, this.dP() - vec3d1.g, this.dR() - vec3d1.h + 0.15, this.dV() - vec3d1.i, 0.0, 0.0, 0.0);
        } else if (entity != null) {
            if (this.e > 0) {
                --this.e;
                if (this.e == 0) {
                    this.a(this.d == null ? null : this.d.o(), entity);
                }
            }
            if (this.d != null) {
                BlockPosition blockposition = this.dK();
                EnumDirection.EnumAxis enumdirection_enumaxis = this.d.o();
                if (this.ao().a(blockposition.a(this.d), this)) {
                    this.a(enumdirection_enumaxis, entity);
                } else {
                    BlockPosition blockposition1 = entity.dK();
                    if (enumdirection_enumaxis == EnumDirection.EnumAxis.a && blockposition.u() == blockposition1.u() || enumdirection_enumaxis == EnumDirection.EnumAxis.c && blockposition.w() == blockposition1.w() || enumdirection_enumaxis == EnumDirection.EnumAxis.b && blockposition.v() == blockposition1.v()) {
                        this.a(enumdirection_enumaxis, entity);
                    }
                }
            }
        }
    }

    @Override
    protected boolean ba() {
        return !this.eh();
    }

    @Override
    protected boolean b(Entity entity) {
        return super.b(entity) && !entity.ar;
    }

    @Override
    public boolean cp() {
        return false;
    }

    @Override
    public boolean a(double d0) {
        return d0 < 16384.0;
    }

    @Override
    public float bO() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.a();
        Entity entity1 = this.p();
        EntityLiving entityliving = entity1 instanceof EntityLiving ? (EntityLiving)entity1 : null;
        DamageSource damagesource = this.en().a((Entity)this, entityliving);
        boolean flag = entity.b(damagesource, 4.0f);
        if (flag) {
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                entityliving1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        ((WorldServer)this.ao()).a(Particles.x, this.dP(), this.dR(), this.dV(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.zV, 1.0f, 1.0f);
    }

    private void i() {
        this.destroy(null);
    }

    private void destroy(EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.ao().a(GameEvent.o, this.dI(), GameEvent.a.a(this));
    }

    @Override
    protected void b(MovingObjectPosition movingobjectposition) {
        super.b(movingobjectposition);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bX() {
        return true;
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, false)) {
            return false;
        }
        this.a(SoundEffects.zW, 1.0f, 1.0f);
        worldserver.a(Particles.g, this.dP(), this.dR(), this.dV(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy(EntityRemoveEvent.Cause.DEATH);
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.k(packetplayoutspawnentity.j());
    }
}

