/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jspecify.annotations.Nullable;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    private static final boolean b = false;
    private static final boolean c = false;
    protected @Nullable EntityReference<Entity> a;
    private boolean d = false;
    private boolean e;
    private boolean f = false;
    private @Nullable Entity g;
    private boolean hitCancelled = false;

    protected IProjectile(EntityTypes<? extends IProjectile> entitytypes, World world) {
        super(entitytypes, world);
    }

    protected void a(@Nullable EntityReference<Entity> entityreference) {
        this.a = entityreference;
    }

    public void d(@Nullable Entity entity) {
        this.a(EntityReference.a(entity));
        this.projectileSource = entity != null && entity.getBukkitEntity() instanceof ProjectileSource ? (ProjectileSource)entity.getBukkitEntity() : null;
    }

    @Override
    public @Nullable Entity p() {
        return EntityReference.a(this.a, this.ao());
    }

    public Entity m() {
        return (Entity)MoreObjects.firstNonNull((Object)this.p(), (Object)this);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        EntityReference.a(this.a, valueoutput, "Owner");
        if (this.d) {
            valueoutput.a("LeftOwner", true);
        }
        valueoutput.a("HasBeenShot", this.f);
    }

    protected boolean e(Entity entity) {
        return this.a != null && this.a.b(entity);
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.a(EntityReference.a(valueinput, "Owner"));
        this.d = valueinput.a("LeftOwner", false);
        this.f = valueinput.a("HasBeenShot", false);
    }

    @Override
    public void y(Entity entity) {
        super.y(entity);
        if (entity instanceof IProjectile) {
            IProjectile iprojectile = (IProjectile)entity;
            this.a = iprojectile.a;
        }
    }

    @Override
    public void g() {
        if (!this.f) {
            this.a(GameEvent.K, this.p());
            this.f = true;
        }
        this.n();
        super.g();
        this.e = false;
    }

    protected void n() {
        if (!this.d && !this.e) {
            this.d = this.f();
            this.e = true;
        }
    }

    private boolean f() {
        Entity entity = this.p();
        if (entity != null) {
            AxisAlignedBB axisalignedbb = this.dj().b(this.dN()).g(1.0);
            return entity.du().dp().filter(IEntitySelector.h).noneMatch(entity1 -> axisalignedbb.c(entity1.dj()));
        }
        return true;
    }

    public Vec3D c(double d0, double d1, double d2, float f2, float f1) {
        return new Vec3D(d0, d1, d2).d().b(this.as.a(0.0, 0.0172275 * (double)f1), this.as.a(0.0, 0.0172275 * (double)f1), this.as.a(0.0, 0.0172275 * (double)f1)).c((double)f2);
    }

    public void d(double d0, double d1, double d2, float f2, float f1) {
        Vec3D vec3d = this.c(d0, d1, d2, f2, f1);
        this.k(vec3d);
        this.aF = true;
        double d3 = vec3d.i();
        this.v((float)(MathHelper.d(vec3d.g, vec3d.i) * 57.2957763671875));
        this.w((float)(MathHelper.d(vec3d.h, d3) * 57.2957763671875));
        this.ab = this.ec();
        this.ac = this.ee();
    }

    public void a(Entity entity, float f2, float f1, float f22, float f3, float f4) {
        float f5 = -MathHelper.a((double)(f1 * ((float)Math.PI / 180))) * MathHelper.b((double)(f2 * ((float)Math.PI / 180)));
        float f6 = -MathHelper.a((double)((f2 + f22) * ((float)Math.PI / 180)));
        float f7 = MathHelper.b((double)(f1 * ((float)Math.PI / 180))) * MathHelper.b((double)(f2 * ((float)Math.PI / 180)));
        this.d(f5, f6, f7, f3, f4);
        Vec3D vec3d = entity.ag();
        this.k(this.dN().b(vec3d.g, entity.aV() ? 0.0 : vec3d.h, vec3d.i));
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        double d0 = flag ? -0.03 : 0.1;
        this.k(this.dN().b(0.0, d0, 0.0));
        IProjectile.a(this.ao(), blockposition);
    }

    @Override
    public void m(boolean flag) {
        double d0 = flag ? -0.03 : 0.06;
        this.k(this.dN().b(0.0, d0, 0.0));
        this.l();
    }

    public static <T extends IProjectile> T a(a<T> iprojectile_a, WorldServer worldserver, ItemStack itemstack, EntityLiving entityliving, float f2, float f1, float f22) {
        return (T)IProjectile.a(iprojectile_a.create(worldserver, entityliving, itemstack), worldserver, itemstack, iprojectile -> iprojectile.a(entityliving, entityliving.ee(), entityliving.ec(), f2, f1, f22));
    }

    public static <T extends IProjectile> T a(a<T> iprojectile_a, WorldServer worldserver, ItemStack itemstack, EntityLiving entityliving, double d0, double d1, double d2, float f2, float f1) {
        return (T)IProjectile.a(iprojectile_a.create(worldserver, entityliving, itemstack), worldserver, itemstack, iprojectile -> iprojectile.d(d0, d1, d2, f2, f1));
    }

    public static <T extends IProjectile> T a(T t0, WorldServer worldserver, ItemStack itemstack, double d0, double d1, double d2, float f2, float f1) {
        return (T)IProjectile.a(t0, worldserver, itemstack, iprojectile -> t0.d(d0, d1, d2, f2, f1));
    }

    public static <T extends IProjectile> T a(T t0, WorldServer worldserver, ItemStack itemstack) {
        return (T)IProjectile.a(t0, worldserver, itemstack, iprojectile -> {});
    }

    public static <T extends IProjectile> T a(T t0, WorldServer worldserver, ItemStack itemstack, Consumer<T> consumer) {
        consumer.accept(t0);
        if (worldserver.b(t0)) {
            t0.b(worldserver, itemstack);
        }
        return t0;
    }

    public void b(WorldServer worldserver, ItemStack itemstack) {
        EntityArrow entityarrow;
        ItemStack itemstack1;
        EnchantmentManager.a(worldserver, itemstack, this, (Item item) -> {});
        IProjectile iProjectile = this;
        if (iProjectile instanceof EntityArrow && (itemstack1 = (entityarrow = (EntityArrow)iProjectile).eq()) != null && !itemstack1.f() && !itemstack.h().equals(itemstack1.h())) {
            Objects.requireNonNull(entityarrow);
            EnchantmentManager.a(worldserver, itemstack1, this, entityarrow::b);
        }
    }

    protected ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.d() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            return this.a(movingobjectposition);
        }
        return ProjectileDeflection.a;
    }

    protected ProjectileDeflection a(MovingObjectPosition movingobjectposition) {
        ProjectileDeflection projectiledeflection1;
        MovingObjectPositionBlock movingobjectpositionblock;
        if (movingobjectposition.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition;
            Entity entity = movingobjectpositionentity.a();
            ProjectileDeflection projectiledeflection = entity.a(this);
            if (projectiledeflection != ProjectileDeflection.a) {
                if (entity != this.g && this.a(projectiledeflection, entity, this.a, false)) {
                    this.g = entity;
                }
                return projectiledeflection;
            }
        } else if (this.ah_() && movingobjectposition instanceof MovingObjectPositionBlock && (movingobjectpositionblock = (MovingObjectPositionBlock)movingobjectposition).f() && this.a(projectiledeflection1 = ProjectileDeflection.b, (Entity)null, this.a, false)) {
            this.k(this.dN().c(0.2));
            return projectiledeflection1;
        }
        this.b(movingobjectposition);
        return ProjectileDeflection.a;
    }

    protected boolean ah_() {
        return false;
    }

    public boolean a(ProjectileDeflection projectiledeflection, @Nullable Entity entity, @Nullable EntityReference<Entity> entityreference, boolean flag) {
        projectiledeflection.deflect(this, entity, this.as);
        if (!this.ao().B_()) {
            this.a(entityreference);
            this.a(flag);
        }
        return true;
    }

    protected void a(boolean flag) {
    }

    protected void b(Item item) {
    }

    protected void b(MovingObjectPosition movingobjectposition) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = movingobjectposition.d();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition;
            Entity entity = movingobjectpositionentity.a();
            if (entity.ay().a(TagsEntity.I) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                iprojectile.a(ProjectileDeflection.c, this.p(), this.a, true);
            }
            this.a(movingobjectpositionentity);
            this.ao().a(GameEvent.J, movingobjectposition.g(), GameEvent.a.a(this, null));
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock movingobjectpositionblock = (MovingObjectPositionBlock)movingobjectposition;
            this.a(movingobjectpositionblock);
            BlockPosition blockposition = movingobjectpositionblock.b();
            this.ao().a(GameEvent.J, blockposition, GameEvent.a.a(this, this.ao().a_(blockposition)));
        }
    }

    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
    }

    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.ao().a_(movingobjectpositionblock.b());
        iblockdata.a(this.ao(), iblockdata, movingobjectpositionblock, this);
    }

    protected boolean b(Entity entity) {
        if (!entity.bW()) {
            return false;
        }
        Entity entity1 = this.p();
        return entity1 == null || this.d || !entity1.A(entity);
    }

    protected void q() {
        Vec3D vec3d = this.dN();
        double d0 = vec3d.i();
        this.w(IProjectile.f(this.ac, (float)(MathHelper.d(vec3d.h, d0) * 57.2957763671875)));
        this.v(IProjectile.f(this.ab, (float)(MathHelper.d(vec3d.g, vec3d.i) * 57.2957763671875)));
    }

    protected static float f(float f2, float f1) {
        while (f1 - f2 < -180.0f) {
            f2 -= 360.0f;
        }
        while (f1 - f2 >= 180.0f) {
            f2 += 360.0f;
        }
        return MathHelper.h(0.2f, f2, f1);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? 0 : entity.aA());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        Entity entity = this.ao().a(packetplayoutspawnentity.n());
        if (entity != null) {
            this.d(entity);
        }
    }

    @Override
    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        Entity entity = this.p();
        return entity instanceof EntityHuman ? entity.c(worldserver, blockposition) : entity == null || worldserver.U().a(GameRules.F) != false;
    }

    public boolean a(WorldServer worldserver) {
        return this.ay().a(TagsEntity.h) && worldserver.U().a(GameRules.L) != false;
    }

    @Override
    public boolean bX() {
        return this.ay().a(TagsEntity.I);
    }

    @Override
    public float ci() {
        return this.bX() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair a(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = this.dN().g;
        double d1 = this.dN().i;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }

    @Override
    public int co() {
        return 2;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!this.d(damagesource)) {
            this.bT();
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends IProjectile> {
        public T create(WorldServer var1, EntityLiving var2, ItemStack var3);
    }
}

