/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.arrow;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.projectile.arrow.EntityThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftItem;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntityArrow
extends IProjectile {
    private static final double e = 2.0;
    private static final int f = 7;
    private static final float g = 0.6f;
    private static final float h = 0.99f;
    private static final short i = 0;
    private static final byte j = 0;
    private static final boolean k = false;
    private static final boolean l = false;
    private static final byte m = 0;
    private static final DataWatcherObject<Byte> n = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> o = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> p = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.k);
    private static final int q = 1;
    private static final int r = 2;
    private @Nullable IBlockData s;
    protected int b;
    public PickupStatus c = PickupStatus.a;
    public int d = 0;
    public int t = 0;
    public double u = 2.0;
    private SoundEffect aN = this.k();
    private @Nullable IntOpenHashSet aO;
    private @Nullable List<Entity> aP;
    public ItemStack aQ = this.u();
    public @Nullable ItemStack aR = null;

    @Override
    public void inactiveTick() {
        if (this.f()) {
            ++this.t;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, d0, d1, d2, world, itemstack, itemstack1, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1, @Nullable EntityLiving ownerEntity) {
        this(entitytypes, world);
        this.d(ownerEntity);
        this.aQ = itemstack.v();
        this.c(itemstack);
        Unit unit = itemstack.e(DataComponents.x);
        if (unit != null) {
            this.c = PickupStatus.c;
        }
        this.a_(d0, d1, d2);
        if (itemstack1 != null && world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack1.f()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.aR = itemstack1.v();
            int i2 = EnchantmentManager.a(worldserver, itemstack1, this.aQ);
            if (i2 > 0) {
                this.a((byte)i2);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, EntityLiving entityliving, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, entityliving.dP(), entityliving.dT() - (double)0.1f, entityliving.dV(), world, itemstack, itemstack1, entityliving);
    }

    public void b(SoundEffect soundeffect) {
        this.aN = soundeffect;
    }

    @Override
    public boolean a(double d0) {
        double d1 = this.dj().a() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * EntityArrow.dc()) * d1;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(n, (byte)0);
        datawatcher_a.a(o, (byte)0);
        datawatcher_a.a(p, false);
    }

    @Override
    public void d(double d0, double d1, double d2, float f2, float f1) {
        super.d(d0, d1, d2, f2, f1);
        this.t = 0;
    }

    @Override
    public void j(Vec3D vec3d) {
        super.j(vec3d);
        this.t = 0;
        if (this.f() && vec3d.h() > 0.0) {
            this.b(false);
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (!this.ay && this.d <= 0 && datawatcherobject.equals(p) && this.f()) {
            this.d = 7;
        }
    }

    @Override
    public void g() {
        VoxelShape voxelshape;
        boolean flag = !this.z();
        Vec3D vec3d = this.dN();
        BlockPosition blockposition = this.dK();
        IBlockData iblockdata = this.ao().a_(blockposition);
        if (!iblockdata.l() && flag && !(voxelshape = iblockdata.g(this.ao(), blockposition)).c()) {
            Vec3D vec3d1 = this.dI();
            for (AxisAlignedBB axisalignedbb : voxelshape.e()) {
                if (!axisalignedbb.a(blockposition).d(vec3d1)) continue;
                this.k(Vec3D.c);
                this.b(true);
                break;
            }
        }
        if (this.d > 0) {
            --this.d;
        }
        if (this.bA()) {
            this.aT();
        }
        if (this.f() && flag) {
            if (!this.ao().B_()) {
                if (this.s != iblockdata && this.A()) {
                    this.B();
                } else {
                    this.i();
                }
            }
            ++this.b;
            if (this.cb()) {
                this.aW();
            }
            if (!this.ao().B_()) {
                this.d(this.aS() > 0);
            }
        } else {
            this.b = 0;
            Vec3D vec3d2 = this.dI();
            if (this.by()) {
                this.b(this.y());
                this.a(vec3d2);
            }
            if (this.w()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.ao().a(Particles.g, vec3d2.g + vec3d.g * (double)i2 / 4.0, vec3d2.h + vec3d.h * (double)i2 / 4.0, vec3d2.i + vec3d.i * (double)i2 / 4.0, -vec3d.g, -vec3d.h + 0.2, -vec3d.i);
                }
            }
            float f2 = !flag ? (float)(MathHelper.d(-vec3d.g, -vec3d.i) * 57.2957763671875) : (float)(MathHelper.d(vec3d.g, vec3d.i) * 57.2957763671875);
            float f1 = (float)(MathHelper.d(vec3d.h, vec3d.i()) * 57.2957763671875);
            this.w(EntityArrow.f(this.ee(), f1));
            this.v(EntityArrow.f(this.ec(), f2));
            this.n();
            if (flag) {
                MovingObjectPositionBlock movingobjectpositionblock = this.ao().b(new RayTrace(vec3d2, vec3d2.e(vec3d), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                this.b(movingobjectpositionblock);
            } else {
                this.b(vec3d2.e(vec3d));
                this.aW();
            }
            if (!this.by()) {
                this.b(0.99f);
            }
            if (flag && !this.f()) {
                this.bu();
            }
            super.g();
        }
    }

    private void b(MovingObjectPositionBlock movingobjectpositionblock) {
        while (this.cb()) {
            Vec3D vec3d = this.dI();
            ArrayList<MovingObjectPositionEntity> arraylist = new ArrayList<MovingObjectPositionEntity>(this.c(vec3d, movingobjectpositionblock.g()));
            arraylist.sort(Comparator.comparingDouble(movingobjectpositionentity -> vec3d.g(movingobjectpositionentity.a().dI())));
            MovingObjectPositionEntity movingobjectpositionentity2 = arraylist.isEmpty() ? null : arraylist.getFirst();
            Vec3D vec3d1 = ((MovingObjectPosition)Objects.requireNonNullElse(movingobjectpositionentity2, movingobjectpositionblock)).g();
            this.b(vec3d1);
            this.a(vec3d, vec3d1);
            if (this.aG != null && this.aG.e()) {
                this.cn();
            }
            if (arraylist.isEmpty()) {
                if (!this.cb() || movingobjectpositionblock.d() == MovingObjectPosition.EnumMovingObjectType.a) break;
                this.preHitTargetOrDeflectSelf(movingobjectpositionblock);
                this.aF = true;
                break;
            }
            if (!this.cb() || this.ar) continue;
            ProjectileDeflection projectiledeflection = this.a((Collection<MovingObjectPositionEntity>)arraylist);
            this.aF = true;
            if (this.x() > 0 && projectiledeflection == ProjectileDeflection.a) continue;
        }
    }

    private ProjectileDeflection a(Collection<MovingObjectPositionEntity> collection) {
        for (MovingObjectPositionEntity movingobjectpositionentity : collection) {
            ProjectileDeflection projectiledeflection = this.preHitTargetOrDeflectSelf(movingobjectpositionentity);
            if (this.cb() && projectiledeflection == ProjectileDeflection.a) continue;
            return projectiledeflection;
        }
        return ProjectileDeflection.a;
    }

    private void b(float f2) {
        Vec3D vec3d = this.dN();
        this.k(vec3d.c((double)f2));
    }

    private void a(Vec3D vec3d) {
        Vec3D vec3d1 = this.dN();
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = 0.25f;
            this.ao().a(Particles.d, vec3d.g - vec3d1.g * 0.25, vec3d.h - vec3d1.h * 0.25, vec3d.i - vec3d1.i * 0.25, vec3d1.g, vec3d1.h, vec3d1.i);
        }
    }

    @Override
    protected double bs() {
        return 0.05;
    }

    private boolean A() {
        return this.f() && this.ao().b(new AxisAlignedBB(this.dI(), this.dI()).g(0.06));
    }

    private void B() {
        this.b(false);
        Vec3D vec3d = this.dN();
        this.k(vec3d.d(this.as.i() * 0.2f, this.as.i() * 0.2f, this.as.i() * 0.2f));
        this.t = 0;
    }

    public boolean f() {
        return this.az.a(p);
    }

    protected void b(boolean flag) {
        this.az.a(p, flag);
    }

    @Override
    public boolean db() {
        return !this.f();
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        super.a(enummovetype, vec3d);
        if (enummovetype != EnumMoveType.a && this.A()) {
            this.B();
        }
    }

    protected void i() {
        ++this.t;
        if (this.t >= (this instanceof EntityThrownTrident ? this.ao().spigotConfig.tridentDespawnRate : this.ao().spigotConfig.arrowDespawnRate)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void C() {
        if (this.aP != null) {
            this.aP.clear();
        }
        if (this.aO != null) {
            this.aO.clear();
        }
    }

    @Override
    public void b(Item item) {
        this.aR = null;
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        if (!this.f()) {
            super.a(flag, blockposition);
        }
    }

    @Override
    public void m(boolean flag) {
        if (!this.f()) {
            super.m(flag);
        }
    }

    @Override
    public void i(double d0, double d1, double d2) {
        if (!this.f()) {
            super.i(d0, d1, d2);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        World world;
        super.a(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.a();
        float f2 = (float)this.dN().g();
        double d0 = this.u;
        Entity entity1 = this.p();
        DamageSource damagesource = this.en().a(this, entity1 != null ? entity1 : this);
        if (this.eq() != null && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            d0 = EnchantmentManager.a(worldserver, this.eq(), entity, damagesource, (float)d0);
        }
        int i2 = MathHelper.e(MathHelper.a((double)f2 * d0, 0.0, 2.147483647E9));
        if (this.x() > 0) {
            if (this.aO == null) {
                this.aO = new IntOpenHashSet(5);
            }
            if (this.aP == null) {
                this.aP = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.aO.size() >= this.x() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.aO.add(entity.aA());
        }
        if (this.w()) {
            long j2 = this.as.a(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if (entity1 instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity1;
            entityliving.C(entity);
        }
        boolean flag = entity.ay() == EntityTypes.R;
        int k2 = entity.aS();
        if (this.cp() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.b(damagesource, (float)i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                if (!this.ao().B_() && this.x() <= 0) {
                    entityliving1.o(entityliving1.fs() + 1);
                }
                this.b(entityliving1, damagesource);
                World world1 = this.ao();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    EnchantmentManager.a(worldserver1, (Entity)entityliving1, damagesource, this.eq());
                }
                this.a(entityliving1);
                if (entityliving1 instanceof EntityHuman && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (!this.bq() && entityliving1 != entityplayer) {
                        entityplayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                    }
                }
                if (!entity.cb() && this.aP != null) {
                    this.aP.add(entityliving1);
                }
                if (!this.ao().B_() && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer1 = (EntityPlayer)entity1;
                    if (this.aP != null) {
                        CriterionTriggers.I.a(entityplayer1, this.aP, this.aR);
                    } else if (!entity.cb()) {
                        CriterionTriggers.I.a(entityplayer1, List.of(entity), this.aR);
                    }
                }
            }
            this.a(this.aN, 1.0f, 1.2f / (this.as.i() * 0.2f + 0.9f));
            if (this.x() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(k2);
            this.a(ProjectileDeflection.b, entity, this.a, false);
            this.k(this.dN().c(0.2));
            World world2 = this.ao();
            if (world2 instanceof WorldServer) {
                WorldServer worldserver2 = (WorldServer)world2;
                if (this.dN().h() < 1.0E-7) {
                    if (this.c == PickupStatus.b) {
                        this.a(worldserver2, this.s(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void b(EntityLiving entityliving, DamageSource damagesource) {
        float f2;
        World world;
        if (this.aR != null && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f2 = EnchantmentManager.d(worldserver, this.aR, entityliving, damagesource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d0 = f2;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - entityliving.i(GenericAttributes.r));
            Vec3D vec3d = this.dN().d(1.0, 0.0, 1.0).d().c(d0 * 0.6 * d1);
            if (vec3d.h() > 0.0) {
                entityliving.i(vec3d.g, 0.1, vec3d.i);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        this.s = this.ao().a_(movingobjectpositionblock.b());
        super.a(movingobjectpositionblock);
        ItemStack itemstack = this.eq();
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack != null) {
                this.a(worldserver, movingobjectpositionblock, itemstack);
            }
        }
        Vec3D vec3d = this.dN();
        Vec3D vec3d1 = new Vec3D(Math.signum(vec3d.g), Math.signum(vec3d.h), Math.signum(vec3d.i));
        Vec3D vec3d2 = vec3d1.c((double)0.05f);
        this.b(this.dI().d(vec3d2));
        this.k(Vec3D.c);
        this.a(this.r(), 1.0f, 1.2f / (this.as.i() * 0.2f + 0.9f));
        this.b(true);
        this.d = 7;
        this.r(false);
        this.a((byte)0);
        this.b(SoundEffects.aH);
        this.C();
    }

    protected void a(WorldServer worldserver, MovingObjectPositionBlock movingobjectpositionblock, ItemStack itemstack) {
        EntityLiving entityliving1;
        Vec3D vec3d = movingobjectpositionblock.b().a(movingobjectpositionblock.g());
        Entity entity = this.p();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        EnchantmentManager.a(worldserver, itemstack, entityliving, this, (EnumItemSlot)null, vec3d, worldserver.a_(movingobjectpositionblock.b()), item -> {
            this.aR = null;
        });
    }

    @Override
    public @Nullable ItemStack eq() {
        return this.aR;
    }

    protected SoundEffect k() {
        return SoundEffects.aH;
    }

    protected final SoundEffect r() {
        return this.aN;
    }

    protected void a(EntityLiving entityliving) {
    }

    protected @Nullable MovingObjectPositionEntity b(Vec3D vec3d, Vec3D vec3d1) {
        return ProjectileHelper.a(this.ao(), this, vec3d, vec3d1, this.dj().b(this.dN()).g(1.0), this::b);
    }

    protected Collection<MovingObjectPositionEntity> c(Vec3D vec3d, Vec3D vec3d1) {
        return ProjectileHelper.a(this.ao(), (Entity)this, vec3d, vec3d1, this.dj().b(this.dN()).g(1.0), this::b, false);
    }

    @Override
    protected boolean b(Entity entity) {
        EntityHuman entityhuman;
        Entity entity1;
        if (entity instanceof EntityHuman && (entity1 = this.p()) instanceof EntityHuman && !(entityhuman = (EntityHuman)entity1).a((EntityHuman)entity)) {
            return false;
        }
        return super.b(entity) && (this.aO == null || !this.aO.contains(entity.aA()));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("life", (short)this.t);
        valueoutput.b("inBlockState", IBlockData.a, this.s);
        valueoutput.a("shake", (byte)this.d);
        valueoutput.a("inGround", this.f());
        valueoutput.a("pickup", PickupStatus.d, this.c);
        valueoutput.a("damage", this.u);
        valueoutput.a("crit", this.w());
        valueoutput.a("PierceLevel", this.x());
        valueoutput.a("SoundEvent", BuiltInRegistries.b.q(), this.aN);
        valueoutput.a("item", ItemStack.b, this.aQ);
        valueoutput.b("weapon", ItemStack.b, this.aR);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.t = valueinput.a("life", (short)0);
        this.s = valueinput.a("inBlockState", IBlockData.a).orElse(null);
        this.d = valueinput.a("shake", (byte)0) & 0xFF;
        this.b(valueinput.a("inGround", false));
        this.u = valueinput.a("damage", 2.0);
        this.c = valueinput.a("pickup", PickupStatus.d).orElse(PickupStatus.a);
        this.r(valueinput.a("crit", false));
        this.a(valueinput.a("PierceLevel", (byte)0));
        this.aN = valueinput.a("SoundEvent", BuiltInRegistries.b.q()).orElse(this.k());
        this.a(valueinput.a("item", ItemStack.b).orElse(this.u()));
        this.aR = valueinput.a("weapon", ItemStack.b).orElse(null);
    }

    @Override
    public void d(@Nullable Entity entity) {
        super.d(entity);
        Entity entity1 = entity;
        boolean b0 = false;
        PickupStatus entityarrow_pickupstatus = this.c;
        Entity entity2 = entity1;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
            case 0: {
                EntityHuman entityhuman = (EntityHuman)entity2;
                if (this.c != PickupStatus.a) {
                    b0 = true;
                    break;
                }
                entityarrow_pickupstatus = PickupStatus.b;
                break;
            }
            case 1: {
                OminousItemSpawner ominousitemspawner = (OminousItemSpawner)entity2;
                entityarrow_pickupstatus = PickupStatus.a;
                break;
            }
            default: {
                entityarrow_pickupstatus = this.c;
                break;
            }
        }
        this.c = entityarrow_pickupstatus;
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (!this.ao().B_() && (this.f() || this.z()) && this.d <= 0) {
            ItemStack itemstack = this.s();
            if (this.c == PickupStatus.b && !itemstack.f() && entityhuman.gK().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.ao(), this.dP(), this.dR(), this.dV(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)new CraftItem(this.ao().getCraftServer(), item), (AbstractArrow)this.getBukkitEntity());
                this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.e();
            }
            if (this.c == PickupStatus.b && entityhuman.gK().g(itemstack) || this.c == PickupStatus.c && entityhuman.gL().d) {
                entityhuman.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman entityhuman) {
        return switch (this.c.ordinal()) {
            case 0 -> false;
            case 1 -> entityhuman.gK().g(this.s());
            case 2 -> entityhuman.gv();
            default -> throw new MatchException(null, null);
        };
    }

    protected ItemStack s() {
        return this.aQ.v();
    }

    protected abstract ItemStack u();

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.a;
    }

    public ItemStack v() {
        return this.aQ;
    }

    public void i(double d0) {
        this.u = d0;
    }

    @Override
    public boolean cT() {
        return this.ay().a(TagsEntity.I);
    }

    public void r(boolean flag) {
        this.a(1, flag);
    }

    public void a(byte b0) {
        this.az.a(o, b0);
    }

    private void a(int i2, boolean flag) {
        byte b0 = this.az.a(n);
        if (flag) {
            this.az.a(n, (byte)(b0 | i2));
        } else {
            this.az.a(n, (byte)(b0 & ~i2));
        }
    }

    protected void a(ItemStack itemstack) {
        this.aQ = !itemstack.f() ? itemstack : this.u();
    }

    public boolean w() {
        byte b0 = this.az.a(n);
        return (b0 & 1) != 0;
    }

    public byte x() {
        return this.az.a(o);
    }

    public void a(float f2) {
        this.i((double)(f2 * 2.0f) + this.as.a((double)this.ao().av().a() * 0.11, 0.57425));
    }

    protected float y() {
        return 0.6f;
    }

    public void s(boolean flag) {
        this.ar = flag;
        this.a(2, flag);
    }

    public boolean z() {
        return !this.ao().B_() ? this.ar : (this.az.a(n) & 2) != 0;
    }

    @Override
    public boolean bX() {
        return super.bX() && !this.f();
    }

    @Override
    public @Nullable SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::v, this::a) : super.a_(i2);
    }

    @Override
    protected boolean ah_() {
        return true;
    }

    public static enum PickupStatus {
        a,
        b,
        c;

        public static final Codec<PickupStatus> d;

        public static PickupStatus a(int i2) {
            if (i2 < 0 || i2 > PickupStatus.values().length) {
                i2 = 0;
            }
            return PickupStatus.values()[i2];
        }

        static {
            d = Codec.BYTE.xmap(PickupStatus::a, entityarrow_pickupstatus -> (byte)entityarrow_pickupstatus.ordinal());
        }
    }
}

