/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class ThrownSplashPotion
extends EntityPotion {
    public ThrownSplashPotion(EntityTypes<? extends ThrownSplashPotion> entitytypes, World world) {
        super((EntityTypes<? extends EntityPotion>)entitytypes, world);
    }

    public ThrownSplashPotion(World world, EntityLiving entityliving, ItemStack itemstack) {
        super(EntityTypes.bd, world, entityliving, itemstack);
    }

    public ThrownSplashPotion(World world, double d0, double d1, double d2, ItemStack itemstack) {
        super(EntityTypes.bd, world, d0, d1, d2, itemstack);
    }

    @Override
    protected Item f() {
        return Items.xD;
    }

    @Override
    public void a(WorldServer worldserver, ItemStack itemstack, MovingObjectPosition movingobjectposition) {
        PotionSplashEvent event;
        double d1;
        PotionContents potioncontents = itemstack.a(DataComponents.Y, PotionContents.a);
        float f2 = itemstack.a(DataComponents.Z, Float.valueOf(1.0f)).floatValue();
        Iterable<MobEffect> iterable = potioncontents.a();
        AxisAlignedBB axisalignedbb = this.dj().c(movingobjectposition.g().d(this.dI()));
        AxisAlignedBB axisalignedbb1 = axisalignedbb.c(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.ao().a(EntityLiving.class, axisalignedbb1);
        float f1 = ProjectileHelper.a(this);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list.isEmpty()) {
            Entity entity = this.m();
            for (EntityLiving entityliving : list) {
                double d0;
                if (!entityliving.gl() || !((d0 = axisalignedbb.d(entityliving.dj().g(f1))) < 16.0)) continue;
                d1 = 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, movingobjectposition, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.m();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                EntityLiving entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffect mobeffect : iterable) {
                    MobEffectList mobeffectlist;
                    Holder<MobEffectList> holder = mobeffect.c();
                    if (!this.ao().getWorld().getPVP() && this.p() instanceof EntityPlayer && entityliving instanceof EntityPlayer && entityliving != this.p() && ((mobeffectlist = holder.a()) == MobEffects.b || mobeffectlist == MobEffects.d || mobeffectlist == MobEffects.g || mobeffectlist == MobEffects.o || mobeffectlist == MobEffects.q || mobeffectlist == MobEffects.r || mobeffectlist == MobEffects.s)) continue;
                    if (holder.a().a()) {
                        holder.a().a(worldserver, this, this.p(), entityliving, mobeffect.e(), d1);
                        continue;
                    }
                    int i2 = mobeffect.a(j2 -> (int)(d1 * (double)j2 * (double)f2 + 0.5));
                    MobEffect mobeffect1 = new MobEffect(holder, i2, mobeffect.e(), mobeffect.f(), mobeffect.g());
                    if (mobeffect1.a(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }
}

