/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle.minecart;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.wanderingtrader.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.MinecartBehavior;
import net.minecraft.world.entity.vehicle.minecart.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.minecart.OldMinecartBehavior;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;

public abstract class EntityMinecartAbstract
extends VehicleEntity {
    private static final Vec3D e = new Vec3D(0.0, 0.0, 0.0);
    private static final DataWatcherObject<Optional<IBlockData>> f = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Integer> g = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> h = ImmutableMap.of((Object)EntityPose.a, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)EntityPose.f, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)EntityPose.d, (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float d = 0.95f;
    private static final boolean i = false;
    private boolean j;
    private boolean k = false;
    private final MinecartBehavior l;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> m = Maps.newEnumMap((Map)((Map)SystemUtils.a(() -> {
        BaseBlockPosition baseblockposition = EnumDirection.e.q();
        BaseBlockPosition baseblockposition1 = EnumDirection.f.q();
        BaseBlockPosition baseblockposition2 = EnumDirection.c.q();
        BaseBlockPosition baseblockposition3 = EnumDirection.d.q();
        BaseBlockPosition baseblockposition4 = baseblockposition.p();
        BaseBlockPosition baseblockposition5 = baseblockposition1.p();
        BaseBlockPosition baseblockposition6 = baseblockposition2.p();
        BaseBlockPosition baseblockposition7 = baseblockposition3.p();
        return ImmutableMap.of((Object)BlockPropertyTrackPosition.a, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition3), (Object)BlockPropertyTrackPosition.b, (Object)Pair.of((Object)baseblockposition, (Object)baseblockposition1), (Object)BlockPropertyTrackPosition.c, (Object)Pair.of((Object)baseblockposition4, (Object)baseblockposition1), (Object)BlockPropertyTrackPosition.d, (Object)Pair.of((Object)baseblockposition, (Object)baseblockposition5), (Object)BlockPropertyTrackPosition.e, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition7), (Object)BlockPropertyTrackPosition.f, (Object)Pair.of((Object)baseblockposition6, (Object)baseblockposition3), (Object)BlockPropertyTrackPosition.g, (Object)Pair.of((Object)baseblockposition3, (Object)baseblockposition1), (Object)BlockPropertyTrackPosition.h, (Object)Pair.of((Object)baseblockposition3, (Object)baseblockposition), (Object)BlockPropertyTrackPosition.i, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition), (Object)BlockPropertyTrackPosition.j, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    })));
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public Double maxSpeed;
    public double powRailAccelMult = 1.0;

    protected EntityMinecartAbstract(EntityTypes<?> entitytypes, World world) {
        super(entitytypes, world);
        this.W = true;
        this.l = EntityMinecartAbstract.b(world) ? new NewMinecartBehavior(this) : new OldMinecartBehavior(this);
    }

    protected EntityMinecartAbstract(EntityTypes<?> entitytypes, World world, double d0, double d1, double d2) {
        this(entitytypes, world);
        this.o(d0, d1, d2);
    }

    public void o(double d0, double d1, double d2) {
        this.a_(d0, d1, d2);
        this.Y = d0;
        this.Z = d1;
        this.aa = d2;
    }

    public static <T extends EntityMinecartAbstract> @Nullable T a(World world, double d0, double d1, double d2, EntityTypes<T> entitytypes, EntitySpawnReason entityspawnreason, ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        EntityMinecartAbstract t0 = (EntityMinecartAbstract)entitytypes.a(world, entityspawnreason);
        if (t0 != null) {
            t0.o(d0, d1, d2);
            EntityTypes.a(world, itemstack, entityhuman).accept(t0);
            MinecartBehavior minecartbehavior = t0.q();
            if (minecartbehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                BlockPosition blockposition = t0.s();
                IBlockData iblockdata = world.a_(blockposition);
                newminecartbehavior.a(blockposition, iblockdata, true);
            }
        }
        return (T)t0;
    }

    public MinecartBehavior q() {
        return this.l;
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(f, Optional.empty());
        datawatcher_a.a(g, this.y());
    }

    @Override
    public boolean i(Entity entity) {
        return AbstractBoat.a((Entity)this, entity);
    }

    @Override
    public boolean bY() {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.n(super.a(enumdirection_enumaxis, blockutil_rectangle));
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        boolean flag = entity instanceof EntityVillager || entity instanceof EntityVillagerTrader;
        return flag ? e : super.a(entity, entitysize, f2);
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        EnumDirection enumdirection = this.dh();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(entityliving);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dK();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = entityliving.go();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = entityliving.a(entitypose);
            float f2 = Math.min(entitysize.a(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)h.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                for (int[] aint1 : aint) {
                    blockposition_mutableblockposition.d(blockposition.u() + aint1[0], blockposition.v() + i2, blockposition.w() + aint1[1]);
                    double d0 = this.ao().a(DismountUtil.a((IBlockAccess)this.ao(), (BlockPosition)blockposition_mutableblockposition), () -> DismountUtil.a((IBlockAccess)this.ao(), blockposition_mutableblockposition.e()));
                    if (!DismountUtil.a(d0)) continue;
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.b(), f2);
                    Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                    if (!DismountUtil.a(this.ao(), entityliving, axisalignedbb.c(vec3d))) continue;
                    entityliving.c(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.dj().e;
        blockposition_mutableblockposition.b((double)blockposition.u(), d1, (double)blockposition.w());
        for (EntityPose entitypose1 : immutablelist) {
            int j2;
            double d3;
            double d2 = entityliving.a(entitypose1).b();
            if (!(d1 + d2 <= (d3 = DismountUtil.a(blockposition_mutableblockposition, j2 = MathHelper.e(d1 - (double)blockposition_mutableblockposition.v() + d2), (BlockPosition blockposition1) -> this.ao().a_((BlockPosition)blockposition1).g(this.ao(), (BlockPosition)blockposition1))))) continue;
            entityliving.c(entitypose1);
            break;
        }
        return super.b(entityliving);
    }

    @Override
    protected float bi() {
        IBlockData iblockdata = this.ao().a_(this.dK());
        return iblockdata.a(TagsBlock.L) ? 1.0f : super.bi();
    }

    @Override
    public void q(float f2) {
        this.l(-this.n());
        this.d(10);
        this.a(this.f() + this.f() * 10.0f);
    }

    @Override
    public boolean bX() {
        return !this.eh();
    }

    public static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition blockpropertytrackposition) {
        return m.get(blockpropertytrackposition);
    }

    @Override
    public EnumDirection dh() {
        return this.l.l();
    }

    @Override
    protected double bs() {
        return this.by() ? 0.005 : 0.04;
    }

    @Override
    public void g() {
        double prevX = this.dP();
        double prevY = this.dR();
        double prevZ = this.dV();
        float prevYaw = this.ec();
        float prevPitch = this.ee();
        if (this.m() > 0) {
            this.d(this.m() - 1);
        }
        if (this.f() > 0.0f) {
            this.a(this.f() - 1.0f);
        }
        this.aL();
        this.aK();
        this.l.b();
        CraftWorld bworld = this.ao().getWorld();
        Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
        Location to = CraftLocation.toBukkit(this.dI(), (org.bukkit.World)bworld, this.ec(), this.ee());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        this.ao().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (!from.equals((Object)to)) {
            this.ao().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
        }
        this.bG();
        if (this.bN()) {
            this.aP();
            this.aQ();
            this.an *= 0.5;
        }
        this.ay = false;
    }

    public boolean r() {
        return this.ay;
    }

    public BlockPosition s() {
        int i2 = MathHelper.c(this.dP());
        int j2 = MathHelper.c(this.dR());
        int k2 = MathHelper.c(this.dV());
        if (EntityMinecartAbstract.b(this.ao())) {
            double d0 = this.dR() - 0.1 - (double)1.0E-5f;
            if (this.ao().a_(BlockPosition.a((double)i2, d0, (double)k2)).a(TagsBlock.L)) {
                j2 = MathHelper.c(d0);
            }
        } else if (this.ao().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.L)) {
            --j2;
        }
        return new BlockPosition(i2, j2, k2);
    }

    protected double a(WorldServer worldserver) {
        return this.l.b(worldserver);
    }

    public void a(WorldServer worldserver, int i2, int j2, int k2, boolean flag) {
    }

    @Override
    public void a(int i2, double d0, double d1, double d2, double d3, double d4) {
        super.a(i2, d0, d1, d2, d3, d4);
    }

    @Override
    public void bu() {
        super.bu();
    }

    @Override
    public void aH() {
        super.aH();
    }

    @Override
    public boolean bG() {
        return super.bG();
    }

    @Override
    public Vec3D ag() {
        return this.l.d(super.ag());
    }

    @Override
    public InterpolationHandler l_() {
        return this.l.a();
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.l.a(this.dN());
    }

    @Override
    public void j(Vec3D vec3d) {
        this.l.a(vec3d);
    }

    protected void b(WorldServer worldserver) {
        this.l.a(worldserver);
    }

    protected void e(WorldServer worldserver) {
        double d0 = this.a(worldserver);
        Vec3D vec3d = this.dN();
        this.m(MathHelper.a(vec3d.g, -d0, d0), vec3d.h, MathHelper.a(vec3d.i, -d0, d0));
        if (this.aV()) {
            this.k(new Vec3D(this.dN().g * this.derailedX, this.dN().h * this.derailedY, this.dN().i * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.dN());
        if (!this.aV()) {
            this.k(new Vec3D(this.dN().g * this.flyingX, this.dN().h * this.flyingY, this.dN().i * this.flyingZ));
        }
    }

    protected double a(BlockPosition blockposition, BlockPropertyTrackPosition blockpropertytrackposition, double d0) {
        return this.l.a(blockposition, blockpropertytrackposition, d0);
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (EntityMinecartAbstract.b(this.ao())) {
            Vec3D vec3d1 = this.dI().e(vec3d);
            super.a(enummovetype, vec3d);
            boolean flag = this.l.d();
            if (flag) {
                super.a(enummovetype, vec3d1.d(this.dI()));
            }
            if (enummovetype.equals((Object)EnumMoveType.c)) {
                this.j = false;
            }
        } else {
            super.a(enummovetype, vec3d);
            this.aW();
        }
    }

    @Override
    public void aW() {
        if (EntityMinecartAbstract.b(this.ao())) {
            super.aW();
        } else {
            this.a(this.dI(), this.dI());
            this.aY();
        }
    }

    @Override
    public boolean cH() {
        return this.j;
    }

    public void a(boolean flag) {
        this.j = flag;
    }

    public boolean u() {
        return this.k;
    }

    public void b(boolean flag) {
        this.k = flag;
    }

    public Vec3D a(BlockPosition blockposition) {
        IBlockData iblockdata = this.ao().a_(blockposition);
        if (iblockdata.a(Blocks.bw) && iblockdata.c(BlockPoweredRail.d).booleanValue()) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).c());
            if (blockpropertytrackposition == BlockPropertyTrackPosition.b) {
                if (this.b(blockposition.h())) {
                    return new Vec3D(1.0, 0.0, 0.0);
                }
                if (this.b(blockposition.i())) {
                    return new Vec3D(-1.0, 0.0, 0.0);
                }
            } else if (blockpropertytrackposition == BlockPropertyTrackPosition.a) {
                if (this.b(blockposition.f())) {
                    return new Vec3D(0.0, 0.0, 1.0);
                }
                if (this.b(blockposition.g())) {
                    return new Vec3D(0.0, 0.0, -1.0);
                }
            }
            return Vec3D.c;
        }
        return Vec3D.c;
    }

    public boolean b(BlockPosition blockposition) {
        return this.ao().a_(blockposition).d(this.ao(), blockposition);
    }

    protected Vec3D a(Vec3D vec3d) {
        double d0 = this.l.m();
        Vec3D vec3d1 = vec3d.d(d0, 0.0, d0);
        if (this.by()) {
            vec3d1 = vec3d1.c((double)0.95f);
        }
        return vec3d1;
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.a(valueinput.a("DisplayState", IBlockData.a));
        this.m(valueinput.a("DisplayOffset", this.y()));
        this.k = valueinput.a("FlippedRotation", false);
        this.ay = valueinput.a("HasTicked", false);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        this.B().ifPresent(iblockdata -> valueoutput.a("DisplayState", IBlockData.a, iblockdata));
        int i2 = this.x();
        if (i2 != this.y()) {
            valueoutput.a("DisplayOffset", i2);
        }
        valueoutput.a("FlippedRotation", this.k);
        valueoutput.a("HasTicked", this.ay);
    }

    @Override
    public void h(Entity entity) {
        if (!(this.ao().B_() || entity.ar || this.ar || this.z(entity))) {
            double d1;
            VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            this.ao().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
            if (collisionEvent.isCancelled()) {
                return;
            }
            double d0 = entity.dP() - this.dP();
            double d2 = d0 * d0 + (d1 = entity.dV() - this.dV()) * d1;
            if (d2 >= (double)1.0E-4f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= 0.5;
                d1 *= 0.5;
                if (entity instanceof EntityMinecartAbstract) {
                    EntityMinecartAbstract entityminecartabstract = (EntityMinecartAbstract)entity;
                    this.a(entityminecartabstract, d0, d1);
                } else {
                    this.i(-d0, 0.0, -d1);
                    entity.i(d0 / 4.0, 0.0, d1 / 4.0);
                }
            }
        }
    }

    private void a(EntityMinecartAbstract entityminecartabstract, double d0, double d1) {
        double d3;
        double d2;
        if (EntityMinecartAbstract.b(this.ao())) {
            d2 = this.dN().g;
            d3 = this.dN().i;
        } else {
            d2 = entityminecartabstract.dP() - this.dP();
            d3 = entityminecartabstract.dV() - this.dV();
        }
        Vec3D vec3d = new Vec3D(d2, 0.0, d3).d();
        Vec3D vec3d1 = new Vec3D(MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))), 0.0, MathHelper.a((double)(this.ec() * ((float)Math.PI / 180)))).d();
        double d4 = Math.abs(vec3d.b(vec3d1));
        if (d4 >= (double)0.8f || EntityMinecartAbstract.b(this.ao())) {
            Vec3D vec3d2 = this.dN();
            Vec3D vec3d3 = entityminecartabstract.dN();
            if (entityminecartabstract.A() && !this.A()) {
                this.k(vec3d2.d(0.2, 1.0, 0.2));
                this.i(vec3d3.g - d0, 0.0, vec3d3.i - d1);
                entityminecartabstract.k(vec3d3.d(0.95, 1.0, 0.95));
            } else if (!entityminecartabstract.A() && this.A()) {
                entityminecartabstract.k(vec3d3.d(0.2, 1.0, 0.2));
                entityminecartabstract.i(vec3d2.g + d0, 0.0, vec3d2.i + d1);
                this.k(vec3d2.d(0.95, 1.0, 0.95));
            } else {
                double d5 = (vec3d3.g + vec3d2.g) / 2.0;
                double d6 = (vec3d3.i + vec3d2.i) / 2.0;
                this.k(vec3d2.d(0.2, 1.0, 0.2));
                this.i(d5 - d0, 0.0, d6 - d1);
                entityminecartabstract.k(vec3d3.d(0.2, 1.0, 0.2));
                entityminecartabstract.i(d5 + d0, 0.0, d6 + d1);
            }
        }
    }

    public IBlockData v() {
        return this.B().orElseGet(this::w);
    }

    private Optional<IBlockData> B() {
        return this.aD().a(f);
    }

    public IBlockData w() {
        return Blocks.a.m();
    }

    public int x() {
        return this.aD().a(g);
    }

    public int y() {
        return 6;
    }

    public void a(Optional<IBlockData> optional) {
        this.aD().a(f, optional);
    }

    public void m(int i2) {
        this.aD().a(g, i2);
    }

    public static boolean b(World world) {
        return world.Q().b(FeatureFlags.d);
    }

    @Override
    public abstract ItemStack dZ();

    public boolean z() {
        return false;
    }

    public boolean A() {
        return false;
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }
}

