/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class ItemEnderEye
extends Item {
    public ItemEnderEye(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext itemactioncontext) {
        BlockPosition blockposition;
        World world = itemactioncontext.q();
        IBlockData iblockdata = world.a_(blockposition = itemactioncontext.a());
        if (iblockdata.a(Blocks.gn) && !iblockdata.c(BlockEnderPortalFrame.c).booleanValue()) {
            if (world.B_()) {
                return EnumInteractionResult.a;
            }
            IBlockData iblockdata1 = (IBlockData)iblockdata.b(BlockEnderPortalFrame.c, true);
            Block.a(iblockdata, iblockdata1, world, blockposition);
            world.a(blockposition, iblockdata1, 2);
            world.b(blockposition, Blocks.gn);
            itemactioncontext.n().h(1);
            world.c(1503, blockposition, 0);
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection = BlockEnderPortalFrame.b().a(world, blockposition);
            if (shapedetector_shapedetectorcollection != null) {
                BlockPosition blockposition1 = shapedetector_shapedetectorcollection.a().b(-3, 0, -3);
                for (int i2 = 0; i2 < 3; ++i2) {
                    for (int j2 = 0; j2 < 3; ++j2) {
                        BlockPosition blockposition2 = blockposition1.b(i2, 0, j2);
                        world.a(blockposition2, true, (Entity)null);
                        world.a(blockposition2, Blocks.gm.m(), 2);
                    }
                }
                int viewDistance = world.getCraftServer().getViewDistance() * 16;
                BlockPosition soundPos = blockposition1.b(1, 0, 1);
                for (EntityPlayer player : world.s().aj().k) {
                    double deltaX = (double)soundPos.u() - player.dP();
                    double deltaZ = (double)soundPos.w() - player.dV();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (world.spigotConfig.endPortalSoundRadius > 0 && distanceSquared > (double)(world.spigotConfig.endPortalSoundRadius * world.spigotConfig.endPortalSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dP() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dV() + deltaZ / deltaLength * (double)viewDistance;
                        player.g.b(new PacketPlayOutWorldEvent(1038, new BlockPosition((int)relativeX, soundPos.v(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.g.b(new PacketPlayOutWorldEvent(1038, soundPos, 0, true));
                }
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    public int a(ItemStack itemstack, EntityLiving entityliving) {
        return 0;
    }

    @Override
    public EnumInteractionResult a(World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemEnderEye.a(world, entityhuman, RayTrace.FluidCollisionOption.a);
        if (movingobjectpositionblock.d() == MovingObjectPosition.EnumMovingObjectType.b && world.a_(movingobjectpositionblock.b()).a(Blocks.gn)) {
            return EnumInteractionResult.e;
        }
        entityhuman.c(enumhand);
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            BlockPosition blockposition = worldserver.a(StructureTags.a, entityhuman.dK(), 100, false);
            if (blockposition == null) {
                return EnumInteractionResult.c;
            }
            EntityEnderSignal entityendersignal = new EntityEnderSignal(world, entityhuman.dP(), entityhuman.f(0.5), entityhuman.dV());
            entityendersignal.a(itemstack);
            entityendersignal.a(Vec3D.a(blockposition));
            world.a(GameEvent.K, entityendersignal.dI(), GameEvent.a.a(entityhuman));
            if (!world.b(entityendersignal)) {
                return EnumInteractionResult.d;
            }
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                CriterionTriggers.n.a(entityplayer, blockposition);
            }
            float f2 = MathHelper.h(world.y.i(), 0.33f, 0.5f);
            world.a((Entity)null, entityhuman.dP(), entityhuman.dR(), entityhuman.dV(), SoundEffects.jQ, SoundCategory.g, 1.0f, f2);
            itemstack.a(1, (EntityLiving)entityhuman);
            entityhuman.b(StatisticList.c.b(this));
        }
        return EnumInteractionResult.b;
    }
}

