/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<?>, ItemMonsterEgg> a = Maps.newIdentityHashMap();

    public ItemMonsterEgg(Item.Info item_info) {
        super(item_info);
        TypedEntityData<EntityTypes<?>> typedentitydata = this.f().a(DataComponents.af);
        if (typedentitydata != null) {
            a.put(typedentitydata.a(), this);
        }
    }

    @Override
    public EnumInteractionResult a(ItemActionContext itemactioncontext) {
        World world = itemactioncontext.q();
        if (!(world instanceof WorldServer)) {
            return EnumInteractionResult.a;
        }
        WorldServer worldserver = (WorldServer)world;
        ItemStack itemstack = itemactioncontext.n();
        BlockPosition blockposition = itemactioncontext.a();
        EnumDirection enumdirection = itemactioncontext.k();
        IBlockData iblockdata = world.a_(blockposition);
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)tileentity);
            EntityTypes<?> entitytypes = this.g(itemstack);
            if (entitytypes == null) {
                return EnumInteractionResult.d;
            }
            if (!worldserver.Z()) {
                EntityHuman entityhuman = itemactioncontext.o();
                if (entityhuman instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                    entityplayer.a(IChatBaseComponent.c("advMode.notEnabled.spawner"));
                }
                return EnumInteractionResult.d;
            }
            spawner.a(entitytypes, world.G_());
            world.a(blockposition, iblockdata, iblockdata, 3);
            world.a((Entity)itemactioncontext.o(), GameEvent.c, blockposition);
            itemstack.h(1);
            return EnumInteractionResult.a;
        }
        BlockPosition blockposition1 = iblockdata.g(world, blockposition).c() ? blockposition : blockposition.a(enumdirection);
        return this.a((EntityLiving)itemactioncontext.o(), itemstack, world, blockposition1, true, !Objects.equals(blockposition, blockposition1) && enumdirection == EnumDirection.b);
    }

    private EnumInteractionResult a(@Nullable EntityLiving entityliving, ItemStack itemstack, World world, BlockPosition blockposition, boolean flag, boolean flag1) {
        EntityTypes<?> entitytypes = this.g(itemstack);
        if (entitytypes == null) {
            return EnumInteractionResult.d;
        }
        if (!entitytypes.s() && world.av() == EnumDifficulty.a) {
            return EnumInteractionResult.d;
        }
        if (entitytypes.a((WorldServer)world, itemstack, entityliving, blockposition, EntitySpawnReason.m, flag, flag1) != null) {
            itemstack.a(1, entityliving);
            world.a((Entity)entityliving, GameEvent.t, blockposition);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public EnumInteractionResult a(World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemMonsterEgg.a(world, entityhuman, RayTrace.FluidCollisionOption.b);
        if (movingobjectpositionblock.d() != MovingObjectPosition.EnumMovingObjectType.b) {
            return EnumInteractionResult.e;
        }
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            BlockPosition blockposition = movingobjectpositionblock.b();
            if (!(world.a_(blockposition).b() instanceof BlockFluids)) {
                return EnumInteractionResult.e;
            }
            if (world.a((Entity)entityhuman, blockposition) && entityhuman.a(blockposition, movingobjectpositionblock.c(), itemstack)) {
                EnumInteractionResult enuminteractionresult = this.a((EntityLiving)entityhuman, itemstack, world, blockposition, false, false);
                if (enuminteractionresult == EnumInteractionResult.a) {
                    entityhuman.b(StatisticList.c.b(this));
                }
                return enuminteractionresult;
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.a;
    }

    public boolean a(ItemStack itemstack, EntityTypes<?> entitytypes) {
        return Objects.equals(this.g(itemstack), entitytypes);
    }

    public static @Nullable ItemMonsterEgg a(@Nullable EntityTypes<?> entitytypes) {
        return a.get(entitytypes);
    }

    public static Iterable<ItemMonsterEgg> a() {
        return Iterables.unmodifiableIterable(a.values());
    }

    public @Nullable EntityTypes<?> g(ItemStack itemstack) {
        TypedEntityData<EntityTypes<?>> typedentitydata = itemstack.a(DataComponents.af);
        return typedentitydata != null ? typedentitydata.a() : null;
    }

    @Override
    public FeatureFlagSet k() {
        return Optional.ofNullable(this.f().a(DataComponents.af)).map(TypedEntityData::a).map(EntityTypes::k).orElseGet(FeatureFlagSet::a);
    }

    public Optional<EntityInsentient> a(EntityHuman entityhuman, EntityInsentient entityinsentient, EntityTypes<? extends EntityInsentient> entitytypes, WorldServer worldserver, Vec3D vec3d, ItemStack itemstack) {
        if (!this.a(itemstack, entitytypes)) {
            return Optional.empty();
        }
        EntityInsentient entityinsentient1 = entityinsentient instanceof EntityAgeable ? ((EntityAgeable)entityinsentient).a(worldserver, (EntityAgeable)entityinsentient) : entitytypes.a(worldserver, EntitySpawnReason.m);
        if (entityinsentient1 == null) {
            return Optional.empty();
        }
        entityinsentient1.a_(true);
        if (!entityinsentient1.e_()) {
            return Optional.empty();
        }
        entityinsentient1.b(vec3d.a(), vec3d.b(), vec3d.c(), 0.0f, 0.0f);
        entityinsentient1.c(itemstack);
        worldserver.addFreshEntityWithPassengers(entityinsentient1, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        itemstack.a(1, (EntityLiving)entityhuman);
        return Optional.of(entityinsentient1);
    }

    @Override
    public boolean a(ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        TypedEntityData<EntityTypes<?>> typedentitydata;
        if (entityhuman != null && entityhuman.I().hasPermission(Permissions.b) && (typedentitydata = itemstack.a(DataComponents.af)) != null) {
            return typedentitydata.a().t();
        }
        return false;
    }
}

