/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public interface IBlockAccess
extends LevelHeightAccessor {
    public @Nullable TileEntity c_(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> a(BlockPosition blockposition, TileEntityTypes<T> tileentitytypes) {
        TileEntity tileentity = this.c_(blockposition);
        return tileentity != null && tileentity.s() == tileentitytypes ? Optional.of(tileentity) : Optional.empty();
    }

    public IBlockData a_(BlockPosition var1);

    public Fluid b_(BlockPosition var1);

    default public int l(BlockPosition blockposition) {
        return this.a_(blockposition).k();
    }

    default public Stream<IBlockData> a(AxisAlignedBB axisalignedbb) {
        return BlockPosition.b(axisalignedbb).map(this::a_);
    }

    default public MovingObjectPositionBlock a(ClipBlockStateContext clipblockstatecontext) {
        return IBlockAccess.a(clipblockstatecontext.b(), clipblockstatecontext.a(), clipblockstatecontext, (clipblockstatecontext1, blockposition) -> {
            IBlockData iblockdata = this.a_((BlockPosition)blockposition);
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return clipblockstatecontext1.c().test(iblockdata) ? new MovingObjectPositionBlock(clipblockstatecontext1.a(), EnumDirection.a(vec3d.g, vec3d.h, vec3d.i), BlockPosition.a(clipblockstatecontext1.a()), false) : null;
        }, clipblockstatecontext1 -> {
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return MovingObjectPositionBlock.a(clipblockstatecontext1.a(), EnumDirection.a(vec3d.g, vec3d.h, vec3d.i), BlockPosition.a(clipblockstatecontext1.a()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace raytrace1, BlockPosition blockposition) {
        IBlockData iblockdata = this.a_(blockposition);
        Fluid fluid = this.b_(blockposition);
        Vec3D vec3d = raytrace1.b();
        Vec3D vec3d1 = raytrace1.a();
        VoxelShape voxelshape = raytrace1.a(iblockdata, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock = this.a(vec3d, vec3d1, blockposition, voxelshape, iblockdata);
        VoxelShape voxelshape1 = raytrace1.a(fluid, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock1 = voxelshape1.a(vec3d, vec3d1, blockposition);
        double d0 = movingobjectpositionblock == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock.g());
        double d1 = movingobjectpositionblock1 == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock1.g());
        return d0 <= d1 ? movingobjectpositionblock : movingobjectpositionblock1;
    }

    default public MovingObjectPositionBlock a(RayTrace raytrace) {
        return IBlockAccess.a(raytrace.b(), raytrace.a(), raytrace, (raytrace1, blockposition) -> this.clip((RayTrace)raytrace1, (BlockPosition)blockposition), raytrace1 -> {
            Vec3D vec3d = raytrace1.b().d(raytrace1.a());
            return MovingObjectPositionBlock.a(raytrace1.a(), EnumDirection.a(vec3d.g, vec3d.h, vec3d.i), BlockPosition.a(raytrace1.a()));
        });
    }

    default public @Nullable MovingObjectPositionBlock a(Vec3D vec3d, Vec3D vec3d1, BlockPosition blockposition, VoxelShape voxelshape, IBlockData iblockdata) {
        MovingObjectPositionBlock movingobjectpositionblock1;
        MovingObjectPositionBlock movingobjectpositionblock = voxelshape.a(vec3d, vec3d1, blockposition);
        if (movingobjectpositionblock != null && (movingobjectpositionblock1 = iblockdata.i(this, blockposition).a(vec3d, vec3d1, blockposition)) != null && movingobjectpositionblock1.g().d(vec3d).h() < movingobjectpositionblock.g().d(vec3d).h()) {
            return movingobjectpositionblock.a(movingobjectpositionblock1.c());
        }
        return movingobjectpositionblock;
    }

    default public double a(VoxelShape voxelshape, Supplier<VoxelShape> supplier) {
        if (!voxelshape.c()) {
            return voxelshape.c(EnumDirection.EnumAxis.b);
        }
        double d0 = supplier.get().c(EnumDirection.EnumAxis.b);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double m(BlockPosition blockposition) {
        return this.a(this.a_(blockposition).g(this, blockposition), () -> {
            BlockPosition blockposition1 = blockposition.e();
            return this.a_(blockposition1).g(this, blockposition1);
        });
    }

    public static <T, C> T a(Vec3D vec3d, Vec3D vec3d1, C c0, BiFunction<C, BlockPosition, @Nullable T> bifunction, Function<C, T> function) {
        int k2;
        int j2;
        if (vec3d.equals(vec3d1)) {
            return function.apply(c0);
        }
        double d0 = MathHelper.d(-1.0E-7, vec3d1.g, vec3d.g);
        double d1 = MathHelper.d(-1.0E-7, vec3d1.h, vec3d.h);
        double d2 = MathHelper.d(-1.0E-7, vec3d1.i, vec3d.i);
        double d3 = MathHelper.d(-1.0E-7, vec3d.g, vec3d1.g);
        double d4 = MathHelper.d(-1.0E-7, vec3d.h, vec3d1.h);
        double d5 = MathHelper.d(-1.0E-7, vec3d.i, vec3d1.i);
        int i2 = MathHelper.c(d3);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i2, j2 = MathHelper.c(d4), k2 = MathHelper.c(d5));
        T t0 = bifunction.apply(c0, blockposition_mutableblockposition);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l2 = MathHelper.m(d6);
        int i1 = MathHelper.m(d7);
        int j1 = MathHelper.m(d8);
        double d9 = l2 == 0 ? Double.MAX_VALUE : (double)l2 / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l2 > 0 ? 1.0 - MathHelper.h(d3) : MathHelper.h(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - MathHelper.h(d4) : MathHelper.h(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - MathHelper.h(d5) : MathHelper.h(d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i2 += l2;
                    d12 += d9;
                } else {
                    k2 += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j2 += i1;
                d13 += d10;
            } else {
                k2 += j1;
                d14 += d11;
            }
            if ((t1 = bifunction.apply(c0, blockposition_mutableblockposition.d(i2, j2, k2))) == null) continue;
            return t1;
        }
        return function.apply(c0);
    }

    public static boolean a(Vec3D vec3d, Vec3D vec3d1, AxisAlignedBB axisalignedbb, a iblockaccess_a) {
        Vec3D vec3d2 = vec3d1.d(vec3d);
        if (vec3d2.h() < (double)MathHelper.j(1.0E-5f)) {
            for (BlockPosition blockposition : BlockPosition.a(axisalignedbb)) {
                if (iblockaccess_a.visit(blockposition, 0)) continue;
                return false;
            }
            return true;
        }
        LongOpenHashSet longset = new LongOpenHashSet();
        for (BlockPosition blockposition1 : BlockPosition.a(axisalignedbb.c(vec3d2.c(-1.0)), vec3d2)) {
            if (!iblockaccess_a.visit(blockposition1, 0)) {
                return false;
            }
            longset.add(blockposition1.a());
        }
        int i2 = IBlockAccess.a((LongSet)longset, vec3d2, axisalignedbb, iblockaccess_a);
        if (i2 < 0) {
            return false;
        }
        for (BlockPosition blockposition2 : BlockPosition.a(axisalignedbb, vec3d2)) {
            if (!longset.add(blockposition2.a()) || iblockaccess_a.visit(blockposition2, i2 + 1)) continue;
            return false;
        }
        return true;
    }

    private static int a(LongSet longset, Vec3D vec3d, AxisAlignedBB axisalignedbb, a iblockaccess_a) {
        double d0 = axisalignedbb.b();
        double d1 = axisalignedbb.c();
        double d2 = axisalignedbb.d();
        BaseBlockPosition baseblockposition = IBlockAccess.a(vec3d);
        Vec3D vec3d1 = axisalignedbb.f();
        Vec3D vec3d2 = new Vec3D(vec3d1.a() + d0 * 0.5 * (double)baseblockposition.u(), vec3d1.b() + d1 * 0.5 * (double)baseblockposition.v(), vec3d1.c() + d2 * 0.5 * (double)baseblockposition.w());
        Vec3D vec3d3 = vec3d2.d(vec3d);
        int i2 = MathHelper.c(vec3d3.g);
        int j2 = MathHelper.c(vec3d3.h);
        int k2 = MathHelper.c(vec3d3.i);
        int l2 = MathHelper.m(vec3d.g);
        int i1 = MathHelper.m(vec3d.h);
        int j1 = MathHelper.m(vec3d.i);
        double d3 = l2 == 0 ? Double.MAX_VALUE : (double)l2 / vec3d.g;
        double d4 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / vec3d.h;
        double d5 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / vec3d.i;
        double d6 = d3 * (l2 > 0 ? 1.0 - MathHelper.h(vec3d3.g) : MathHelper.h(vec3d3.g));
        double d7 = d4 * (i1 > 0 ? 1.0 - MathHelper.h(vec3d3.h) : MathHelper.h(vec3d3.h));
        double d8 = d5 * (j1 > 0 ? 1.0 - MathHelper.h(vec3d3.i) : MathHelper.h(vec3d3.i));
        int k1 = 0;
        while (d6 <= 1.0 || d7 <= 1.0 || d8 <= 1.0) {
            Optional<Vec3D> optional;
            if (d6 < d7) {
                if (d6 < d8) {
                    i2 += l2;
                    d6 += d3;
                } else {
                    k2 += j1;
                    d8 += d5;
                }
            } else if (d7 < d8) {
                j2 += i1;
                d7 += d4;
            } else {
                k2 += j1;
                d8 += d5;
            }
            if ((optional = AxisAlignedBB.a(i2, j2, k2, i2 + 1, j2 + 1, k2 + 1, vec3d3, vec3d2)).isEmpty()) continue;
            Vec3D vec3d4 = optional.get();
            double d9 = MathHelper.a(vec3d4.g, (double)i2 + (double)1.0E-5f, (double)i2 + 1.0 - (double)1.0E-5f);
            double d10 = MathHelper.a(vec3d4.h, (double)j2 + (double)1.0E-5f, (double)j2 + 1.0 - (double)1.0E-5f);
            double d11 = MathHelper.a(vec3d4.i, (double)k2 + (double)1.0E-5f, (double)k2 + 1.0 - (double)1.0E-5f);
            int l1 = MathHelper.c(d9 - d0 * (double)baseblockposition.u());
            int i22 = MathHelper.c(d10 - d1 * (double)baseblockposition.v());
            int j22 = MathHelper.c(d11 - d2 * (double)baseblockposition.w());
            int k22 = ++k1;
            for (BlockPosition blockposition : BlockPosition.a(i2, j2, k2, l1, i22, j22, vec3d)) {
                if (!longset.add(blockposition.a()) || iblockaccess_a.visit(blockposition, k22)) continue;
                return -1;
            }
        }
        return k1;
    }

    private static BaseBlockPosition a(Vec3D vec3d) {
        int k2;
        double d0 = Math.abs(Vec3D.d.b(vec3d));
        double d1 = Math.abs(Vec3D.e.b(vec3d));
        double d2 = Math.abs(Vec3D.f.b(vec3d));
        int i2 = vec3d.g >= 0.0 ? 1 : -1;
        int j2 = vec3d.h >= 0.0 ? 1 : -1;
        int n2 = k2 = vec3d.i >= 0.0 ? 1 : -1;
        return d0 <= d1 && d0 <= d2 ? new BaseBlockPosition(-i2, -k2, j2) : (d1 <= d2 ? new BaseBlockPosition(k2, -j2, -i2) : new BaseBlockPosition(-j2, i2, -k2));
    }

    @FunctionalInterface
    public static interface a {
        public boolean visit(BlockPosition var1, int var2);
    }
}

