/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class TicketStorage
extends PersistentBase {
    private static final int c = 4;
    private static final Logger d = LogUtils.getLogger();
    private static final Codec<Pair<ChunkCoordIntPair, Ticket>> e = Codec.mapPair((MapCodec)ChunkCoordIntPair.a.fieldOf("chunk_pos"), Ticket.a).codec();
    public static final Codec<TicketStorage> a = RecordCodecBuilder.create(instance -> instance.group((App)e.listOf().optionalFieldOf("tickets", List.of()).forGetter(TicketStorage::g)).apply((Applicative)instance, TicketStorage::a));
    public static final SavedDataType<TicketStorage> b = new SavedDataType<TicketStorage>("chunks", TicketStorage::new, a, DataFixTypes.j);
    public final Long2ObjectOpenHashMap<List<Ticket>> f;
    private final Long2ObjectOpenHashMap<List<Ticket>> g;
    private LongSet h = new LongOpenHashSet();
    private @Nullable a i;
    private @Nullable a j;

    private TicketStorage(Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap, Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap1) {
        this.f = long2objectopenhashmap;
        this.g = long2objectopenhashmap1;
        this.h();
    }

    public TicketStorage() {
        this((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap());
    }

    private static TicketStorage a(List<Pair<ChunkCoordIntPair, Ticket>> list) {
        Long2ObjectOpenHashMap long2objectopenhashmap = new Long2ObjectOpenHashMap();
        for (Pair<ChunkCoordIntPair, Ticket> pair : list) {
            ChunkCoordIntPair chunkcoordintpair = (ChunkCoordIntPair)pair.getFirst();
            List list1 = (List)long2objectopenhashmap.computeIfAbsent(chunkcoordintpair.b(), i2 -> new ObjectArrayList(4));
            list1.add((Ticket)pair.getSecond());
        }
        return new TicketStorage((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)long2objectopenhashmap);
    }

    private List<Pair<ChunkCoordIntPair, Ticket>> g() {
        ArrayList<Pair<ChunkCoordIntPair, Ticket>> list = new ArrayList<Pair<ChunkCoordIntPair, Ticket>>();
        this.a((ChunkCoordIntPair chunkcoordintpair, Ticket ticket) -> {
            if (ticket.a().a()) {
                list.add(new Pair(chunkcoordintpair, ticket));
            }
        });
        return list;
    }

    private void a(BiConsumer<ChunkCoordIntPair, Ticket> biconsumer) {
        TicketStorage.a(biconsumer, this.f);
        TicketStorage.a(biconsumer, this.g);
    }

    private static void a(BiConsumer<ChunkCoordIntPair, Ticket> biconsumer, Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap) {
        for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(long2objectopenhashmap)) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(long2objectmap_entry.getLongKey());
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                biconsumer.accept(chunkcoordintpair, ticket);
            }
        }
    }

    public void b() {
        for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(this.g)) {
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                this.a(long2objectmap_entry.getLongKey(), ticket);
            }
        }
        this.g.clear();
    }

    public void a(@Nullable a ticketstorage_a) {
        this.i = ticketstorage_a;
    }

    public void b(@Nullable a ticketstorage_a) {
        this.j = ticketstorage_a;
    }

    public boolean c() {
        return !this.f.isEmpty();
    }

    public boolean d() {
        for (List list : this.f.values()) {
            for (Ticket ticket : list) {
                if (!ticket.a().d()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Ticket> a(long i2) {
        return (List)this.f.getOrDefault(i2, List.of());
    }

    private List<Ticket> b(long i2) {
        return (List)this.f.computeIfAbsent(i2, j2 -> new ObjectArrayList(4));
    }

    public void a(TicketType tickettype, ChunkCoordIntPair chunkcoordintpair, int i2) {
        Ticket ticket = new Ticket(tickettype, ChunkLevel.a(FullChunkStatus.b) - i2);
        this.a(chunkcoordintpair.b(), ticket);
    }

    public void a(Ticket ticket, ChunkCoordIntPair chunkcoordintpair) {
        this.a(chunkcoordintpair.b(), ticket);
    }

    public boolean a(long i2, Ticket ticket) {
        List<Ticket> list = this.b(i2);
        for (Ticket ticket1 : list) {
            if (!TicketStorage.a(ticket, ticket1)) continue;
            ticket1.c();
            this.u();
            return false;
        }
        int j2 = TicketStorage.a(list, true);
        int k2 = TicketStorage.a(list, false);
        list.add(ticket);
        if (SharedConstants.M) {
            d.debug("ATI {} {}", (Object)new ChunkCoordIntPair(i2), (Object)ticket);
        }
        if (ticket.a().c() && ticket.b() < j2 && this.j != null) {
            this.j.update(i2, ticket.b(), true);
        }
        if (ticket.a().b() && ticket.b() < k2 && this.i != null) {
            this.i.update(i2, ticket.b(), true);
        }
        if (ticket.a().equals(TicketType.l)) {
            this.h.add(i2);
        }
        this.u();
        return true;
    }

    private static boolean a(Ticket ticket, Ticket ticket1) {
        return ticket1.a() == ticket.a() && ticket1.b() == ticket.b() && Objects.equals(ticket.key, ticket1.key);
    }

    public int a(long i2, boolean flag) {
        return TicketStorage.a(this.a(i2), flag);
    }

    private static int a(List<Ticket> list, boolean flag) {
        Ticket ticket = TicketStorage.b(list, flag);
        return ticket == null ? ChunkLevel.b + 1 : ticket.b();
    }

    private static @Nullable Ticket b(@Nullable List<Ticket> list, boolean flag) {
        if (list == null) {
            return null;
        }
        Ticket ticket = null;
        for (Ticket ticket1 : list) {
            if (ticket != null && ticket1.b() >= ticket.b()) continue;
            if (flag && ticket1.a().c()) {
                ticket = ticket1;
                continue;
            }
            if (flag || !ticket1.a().b()) continue;
            ticket = ticket1;
        }
        return ticket;
    }

    public void b(TicketType tickettype, ChunkCoordIntPair chunkcoordintpair, int i2) {
        Ticket ticket = new Ticket(tickettype, ChunkLevel.a(FullChunkStatus.b) - i2);
        this.b(chunkcoordintpair.b(), ticket);
    }

    public void b(Ticket ticket, ChunkCoordIntPair chunkcoordintpair) {
        this.b(chunkcoordintpair.b(), ticket);
    }

    public boolean b(long i2, Ticket ticket) {
        List list = (List)this.f.get(i2);
        if (list == null) {
            return false;
        }
        boolean flag = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Ticket ticket1 = (Ticket)iterator.next();
            if (!TicketStorage.a(ticket, ticket1)) continue;
            iterator.remove();
            if (SharedConstants.M) {
                d.debug("RTI {} {}", (Object)new ChunkCoordIntPair(i2), (Object)ticket1);
            }
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        if (list.isEmpty()) {
            this.f.remove(i2);
        }
        if (ticket.a().c() && this.j != null) {
            this.j.update(i2, TicketStorage.a(list, true), false);
        }
        if (ticket.a().b() && this.i != null) {
            this.i.update(i2, TicketStorage.a(list, false), false);
        }
        if (ticket.a().equals(TicketType.l)) {
            this.h();
        }
        this.u();
        return true;
    }

    private void h() {
        this.h = this.a((Ticket ticket) -> ticket.a().equals(TicketType.l));
    }

    public String b(long i2, boolean flag) {
        List<Ticket> list = this.a(i2);
        Ticket ticket = TicketStorage.b(list, flag);
        return ticket == null ? "no_ticket" : ticket.toString();
    }

    public void a(PlayerChunkMap playerchunkmap) {
        this.a((Ticket ticket, long i2) -> {
            if (this.a(playerchunkmap, ticket, i2)) {
                ticket.d();
                return ticket.e();
            }
            return false;
        }, (Long2ObjectOpenHashMap<List<Ticket>>)((Long2ObjectOpenHashMap)null));
        this.u();
    }

    private boolean a(PlayerChunkMap playerchunkmap, Ticket ticket, long i2) {
        if (!ticket.a().f()) {
            return false;
        }
        if (ticket.a().e()) {
            return true;
        }
        PlayerChunk playerchunk = playerchunkmap.a(i2);
        return playerchunk == null || playerchunk.h();
    }

    public void e() {
        this.a((Ticket ticket, long i2) -> ticket.a() != TicketType.o, this.g);
    }

    public void a(b ticketstorage_b, @Nullable Long2ObjectOpenHashMap<List<Ticket>> long2objectopenhashmap) {
        ObjectIterator objectiterator = this.f.long2ObjectEntrySet().fastIterator();
        boolean flag = false;
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry long2objectmap_entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((List)long2objectmap_entry.getValue()).iterator();
            long i2 = long2objectmap_entry.getLongKey();
            boolean flag1 = false;
            boolean flag2 = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!ticketstorage_b.test(ticket, i2)) continue;
                if (long2objectopenhashmap != null) {
                    List list = (List)long2objectopenhashmap.computeIfAbsent(i2, j2 -> new ObjectArrayList(((List)long2objectmap_entry.getValue()).size()));
                    list.add(ticket);
                }
                iterator.remove();
                if (ticket.a().b()) {
                    flag2 = true;
                }
                if (ticket.a().c()) {
                    flag1 = true;
                }
                if (!ticket.a().equals(TicketType.l)) continue;
                flag = true;
            }
            if (!flag2 && !flag1) continue;
            if (flag2 && this.i != null) {
                this.i.update(i2, TicketStorage.a((List)long2objectmap_entry.getValue(), false), false);
            }
            if (flag1 && this.j != null) {
                this.j.update(i2, TicketStorage.a((List)long2objectmap_entry.getValue(), true), false);
            }
            this.u();
            if (!((List)long2objectmap_entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
        if (flag) {
            this.h();
        }
    }

    public void a(int i2, TicketType tickettype) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry long2objectmap_entry : this.f.long2ObjectEntrySet()) {
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                if (ticket.a() != tickettype) continue;
                list.add(Pair.of((Object)ticket, (Object)long2objectmap_entry.getLongKey()));
            }
        }
        for (Pair pair : list) {
            Long olong = (Long)pair.getSecond();
            Ticket ticket1 = (Ticket)pair.getFirst();
            this.b((long)olong, ticket1);
            TicketType tickettype1 = ticket1.a();
            this.a((long)olong, new Ticket(tickettype1, i2));
        }
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Ticket ticket = new Ticket(TicketType.l, PlayerChunkMap.c);
        return flag ? this.a(chunkcoordintpair.b(), ticket) : this.b(chunkcoordintpair.b(), ticket);
    }

    public LongSet f() {
        return this.h;
    }

    private LongSet a(Predicate<Ticket> predicate) {
        LongOpenHashSet longopenhashset = new LongOpenHashSet();
        block0: for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(this.f)) {
            for (Ticket ticket : (List)long2objectmap_entry.getValue()) {
                if (!predicate.test(ticket)) continue;
                longopenhashset.add(long2objectmap_entry.getLongKey());
                continue block0;
            }
        }
        return longopenhashset;
    }

    @FunctionalInterface
    public static interface a {
        public void update(long var1, int var3, boolean var4);
    }

    public static interface b {
        public boolean test(Ticket var1, long var2);
    }
}

