/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R7.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> g = ResourceKey.a(Registries.bE);
    public static final ResourceKey<World> h = ResourceKey.a(Registries.bE, MinecraftKey.b("overworld"));
    public static final ResourceKey<World> i = ResourceKey.a(Registries.bE, MinecraftKey.b("the_nether"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.bE, MinecraftKey.b("the_end"));
    public static final int k = 30000000;
    public static final int l = 512;
    public static final int m = 32;
    public static final int n = 15;
    public static final int o = 20000000;
    public static final int p = -20000000;
    public static final WeightedList<ExplosionParticleInfo> a = WeightedList.b().a(new ExplosionParticleInfo(Particles.af, 0.5f, 1.0f)).a(new ExplosionParticleInfo(Particles.ai, 1.0f, 1.0f)).a();
    protected final List<TickingBlockEntity> q = Lists.newArrayList();
    protected final CollectingNeighborUpdater r;
    private final List<TickingBlockEntity> b = Lists.newArrayList();
    private boolean c;
    public final Thread d;
    private final boolean e;
    private int f;
    protected int s = RandomSource.a().f();
    protected final int t = 1013904223;
    protected float u;
    public float v;
    protected float w;
    public float x;
    public final RandomSource y = RandomSource.a();
    @Deprecated
    private final RandomSource B = RandomSource.b();
    private final Holder<DimensionManager> C;
    public final WorldDataMutable z;
    private final boolean D;
    private final BiomeManager E;
    private final ResourceKey<World> F;
    private final IRegistryCustom G;
    private final DamageSources H;
    private final PalettedContainerFactory I;
    private long J;
    private final CraftWorld world;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CapturedBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new HashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    public final SpigotTimings.WorldTimingsHandler timings;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).d());
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
        this.z = worlddatamutable;
        this.C = holder;
        this.F = resourcekey;
        this.D = flag;
        this.d = Thread.currentThread();
        this.E = new BiomeManager(this, i2);
        this.e = flag1;
        this.r = new CollectingNeighborUpdater(this, j2);
        this.G = iregistrycustom;
        this.I = PalettedContainerFactory.a(iregistrycustom);
        this.H = new DamageSources(iregistrycustom);
        this.timings = new SpigotTimings.WorldTimingsHandler(this);
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
    }

    @Override
    public boolean B_() {
        return this.D;
    }

    @Override
    public @Nullable MinecraftServer s() {
        return null;
    }

    public boolean n(BlockPosition blockposition) {
        return !this.y(blockposition) && World.c(blockposition);
    }

    public boolean o(BlockPosition blockposition) {
        return !this.y(blockposition) && World.g(blockposition);
    }

    public static boolean p(BlockPosition blockposition) {
        return !World.b(blockposition.v()) && World.c(blockposition);
    }

    private static boolean c(BlockPosition blockposition) {
        return blockposition.u() >= -30000000 && blockposition.w() >= -30000000 && blockposition.u() < 30000000 && blockposition.w() < 30000000;
    }

    private static boolean g(BlockPosition blockposition) {
        int i2 = SectionPosition.a(blockposition.u());
        int j2 = SectionPosition.a(blockposition.w());
        return ChunkCoordIntPair.c(i2, j2);
    }

    private static boolean b(int i2) {
        return i2 < -20000000 || i2 >= 20000000;
    }

    public Chunk q(BlockPosition blockposition) {
        return this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public Chunk d(int i2, int j2) {
        return (Chunk)this.a(i2, j2, ChunkStatus.n);
    }

    @Override
    public @Nullable IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess = this.ac().a(i2, j2, chunkstatus, flag);
        if (ichunkaccess == null && flag) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, @Block.b int i2) {
        return this.a(blockposition, iblockdata, i2, 512);
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, @Block.b int i2, int j2) {
        IBlockData iblockdata1;
        if (this.captureTreeGeneration) {
            CapturedBlockState blockstate = this.capturedBlockStates.get(blockposition);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, blockposition, i2);
                this.capturedBlockStates.put(blockposition.j(), blockstate);
            }
            blockstate.setData(iblockdata);
            blockstate.setFlag(i2);
            return true;
        }
        if (!this.o(blockposition)) {
            return false;
        }
        if (!this.B_() && this.ar()) {
            return false;
        }
        Chunk chunk = this.q(blockposition);
        Block block = iblockdata.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(blockposition)) {
            CapturedBlockState blockstate = CapturedBlockState.getBlockState(this, blockposition, i2);
            this.capturedBlockStates.put(blockposition.j(), blockstate);
            captured = true;
        }
        if ((iblockdata1 = chunk.a(blockposition, iblockdata, i2)) == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(blockposition);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(blockposition);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(blockposition, chunk, iblockdata1, iblockdata, iblockdata2, i2, j2);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(blockposition);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.D || (i2 & 4) == 0) && (this.D || chunk == null || chunk.G() != null && chunk.G().a(FullChunkStatus.c))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            }
            if ((i2 & 1) != 0) {
                this.a(blockposition, iblockdata1.b());
                if (!this.D && iblockdata.q()) {
                    this.b(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b(this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                iblockdata.b(this, blockposition, k2, j2 - 1);
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        Fluid fluid = this.b_(blockposition);
        return this.a(blockposition, fluid.g(), 3 | (flag ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        boolean flag1;
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.l()) {
            return false;
        }
        Fluid fluid = this.b_(blockposition);
        if (!(iblockdata.b() instanceof BlockFireAbstract)) {
            this.c(2001, blockposition, Block.j(iblockdata));
        }
        if (flag) {
            TileEntity tileentity = iblockdata.x() ? this.c_(blockposition) : null;
            Block.a(iblockdata, this, blockposition, tileentity, entity, ItemStack.l);
        }
        if (flag1 = this.a(blockposition, fluid.g(), 3, i2)) {
            this.a(GameEvent.f, blockposition, GameEvent.a.a(entity, iblockdata));
        }
        return flag1;
    }

    public void b(BlockPosition blockposition, IBlockData iblockdata) {
    }

    public boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        return this.a(blockposition, iblockdata, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, @Block.b int var4);

    public void b(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    public void a(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection, @Nullable Orientation orientation) {
    }

    public void b(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
    }

    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
    }

    @Override
    public void a(EnumDirection enumdirection, BlockPosition blockposition, BlockPosition blockposition1, IBlockData iblockdata, @Block.b int i2, int j2) {
        this.r.a(enumdirection, iblockdata, blockposition, blockposition1, i2, j2);
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        int k2 = i2 >= -30000000 && j2 >= -30000000 && i2 < 30000000 && j2 < 30000000 ? (this.b(SectionPosition.a(i2), SectionPosition.a(j2)) ? this.d(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1 : this.K_()) : this.V() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine C_() {
        return this.ac().r();
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        CapturedBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (!this.o(blockposition)) {
            return Blocks.nY.m();
        }
        Chunk chunk = this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
        return chunk.a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        if (!this.o(blockposition)) {
            return FluidTypes.a.g();
        }
        Chunk chunk = this.q(blockposition);
        return chunk.b_(blockposition);
    }

    public boolean ag() {
        return !this.F_().d() && this.f < 4;
    }

    public boolean ah() {
        return !this.F_().d() && !this.ag();
    }

    @Override
    public void a(@Nullable Entity entity, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1);
    }

    public abstract void a(@Nullable Entity var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.a(entity, d0, d1, d2, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, i2);
    }

    public abstract void a(@Nullable Entity var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory) {
        this.a(entity, d0, d1, d2, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, d0, d1, d2, soundeffect, soundcategory, f2, f1, this.B.g());
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, d0, d1, d2, holder, soundcategory, f2, f1, this.B.g());
    }

    public void a(@Nullable Entity entity, Entity entity1, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entity, entity1, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, this.B.g());
    }

    public void a(BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
        this.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1, flag);
    }

    public void a(Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    public void a(double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
    }

    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, boolean flag1, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void b(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(TickingBlockEntity tickingblockentity) {
        (this.c ? this.b : this.q).add(tickingblockentity);
    }

    public void ai() {
        this.timings.tileEntityPending.startTiming();
        this.c = true;
        if (!this.b.isEmpty()) {
            this.q.addAll(this.b);
            this.b.clear();
        }
        this.timings.tileEntityPending.stopTiming();
        this.timings.tileEntityTick.startTiming();
        boolean flag = this.y().i();
        this.tileLimiter.initTick();
        for (int tilesThisCycle = 0; tilesThisCycle < this.q.size() && (tilesThisCycle % 10 != 0 || this.tileLimiter.shouldContinue()); ++tilesThisCycle) {
            this.tileTickPosition = this.tileTickPosition < this.q.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.q.get(this.tileTickPosition);
            if (tickingblockentity.b()) {
                --tilesThisCycle;
                this.q.remove(this.tileTickPosition--);
            } else if (flag && this.r(tickingblockentity.c())) {
                tickingblockentity.a();
            }
            ++this.tileTickPosition;
        }
        this.timings.tileEntityTick.stopTiming();
        this.c = false;
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends Entity> void a(Consumer<T> consumer, T t0) {
        try {
            SpigotTimings.tickEntityTimer.startTiming();
            consumer.accept(t0);
            SpigotTimings.tickEntityTimer.stopTiming();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking entity");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being ticked");
            t0.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    public boolean h(Entity entity) {
        return true;
    }

    public boolean a(long i2) {
        return true;
    }

    public boolean r(BlockPosition blockposition) {
        return this.a(ChunkCoordIntPair.a(blockposition));
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, float f2, a world_a) {
        this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, false, world_a, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public void a(@Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, flag, world_a, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3D vec3d, float f2, boolean flag, a world_a) {
        this.a(entity, damagesource, explosiondamagecalculator, vec3d.a(), vec3d.b(), vec3d.c(), f2, flag, world_a, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public abstract void a(@Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, a var12, ParticleParam var13, ParticleParam var14, WeightedList<ExplosionParticleInfo> var15, Holder<SoundEffect> var16);

    public abstract String P();

    @Override
    public @Nullable TileEntity c_(BlockPosition blockposition) {
        return this.getBlockEntity(blockposition, true);
    }

    public @Nullable TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        if (this.capturedTileEntities.containsKey(blockposition)) {
            return this.capturedTileEntities.get(blockposition);
        }
        return !this.o(blockposition) ? null : (!this.B_() && Thread.currentThread() != this.d ? null : this.q(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void b(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.aD_();
        if (this.o(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.j(), tileentity);
                return;
            }
            this.q(blockposition).b(tileentity);
        }
    }

    public void s(BlockPosition blockposition) {
        if (this.o(blockposition)) {
            this.q(blockposition).c(blockposition);
        }
    }

    public boolean t(BlockPosition blockposition) {
        return !this.o(blockposition) ? false : this.ac().b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public boolean a(BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
        if (!this.o(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()), ChunkStatus.n, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(blockposition).a((IBlockAccess)this, blockposition, entity, enumdirection);
    }

    public boolean a(BlockPosition blockposition, Entity entity) {
        return this.a(blockposition, entity, EnumDirection.b);
    }

    public void aj() {
        this.f = (int)(15.0f - this.c().a(EnvironmentAttributes.z).floatValue());
    }

    public void b(boolean flag) {
        this.ac().b(flag);
    }

    public abstract void a(WorldData.a var1);

    public abstract WorldData.a C();

    public WorldData.a b(WorldData.a worlddata_a) {
        WorldBorder worldborder = this.w();
        if (!worldborder.a(worlddata_a.b())) {
            BlockPosition blockposition = this.a(HeightMap.Type.e, BlockPosition.a(worldborder.h(), 0.0, worldborder.i()));
            return WorldData.a.a(worlddata_a.a(), blockposition, worlddata_a.d(), worlddata_a.e());
        }
        return worlddata_a;
    }

    protected void ak() {
        if (!this.F_().e()) {
            return;
        }
        if (this.z.h()) {
            this.v = 1.0f;
            if (this.z.f()) {
                this.x = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.ac().close();
    }

    @Override
    public @Nullable IBlockAccess c(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.n, false);
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, Predicate<? super Entity> predicate) {
        Profiler.a().f("getEntities");
        ArrayList list = Lists.newArrayList();
        this.M().a(axisalignedbb, (T entity1) -> {
            if (entity1 != entity && predicate.test((Entity)entity1)) {
                list.add(entity1);
            }
        });
        for (EntityComplexPart entitycomplexpart : this.v()) {
            if (entitycomplexpart == entity || entitycomplexpart.a == entity || !predicate.test(entitycomplexpart) || !axisalignedbb.c(entitycomplexpart.dj())) continue;
            list.add(entitycomplexpart);
        }
        return list;
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, axisalignedbb, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, axisalignedbb, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list, int i2) {
        Profiler.a().f("getEntities");
        this.M().a(entitytypetest, axisalignedbb, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gM()) {
                    Entity t0 = (Entity)entitytypetest.a(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    list.add((Object)t0);
                    if (list.size() < i2) continue;
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public <T extends Entity> boolean b(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        Profiler.a().f("hasEntities");
        MutableBoolean mutableboolean = new MutableBoolean();
        this.M().a(entitytypetest, axisalignedbb, (U entity) -> {
            if (predicate.test(entity)) {
                mutableboolean.setTrue();
                return AbortableIterationConsumer.a.b;
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gM()) {
                    Entity t0 = (Entity)entitytypetest.a(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    mutableboolean.setTrue();
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
        return mutableboolean.isTrue();
    }

    public List<Entity> k(Entity entity, AxisAlignedBB axisalignedbb) {
        return this.a(entity, axisalignedbb, IEntitySelector.a(entity));
    }

    public abstract @Nullable Entity a(int var1);

    public @Nullable Entity d(UUID uuid) {
        return this.M().a(uuid);
    }

    public @Nullable Entity a(UUID uuid) {
        return this.d(uuid);
    }

    public @Nullable EntityHuman b(UUID uuid) {
        return this.c(uuid);
    }

    public abstract Collection<EntityComplexPart> v();

    public void u(BlockPosition blockposition) {
        if (this.H(blockposition)) {
            this.q(blockposition).i();
        }
    }

    public void a(TileEntity tileentity) {
    }

    public long al() {
        return this.z.c();
    }

    public boolean a(Entity entity, BlockPosition blockposition) {
        return true;
    }

    public void a(Entity entity, byte b0) {
    }

    public void a(Entity entity, DamageSource damagesource) {
    }

    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.a_(blockposition).a(this, blockposition, i2, j2);
    }

    @Override
    public WorldData D_() {
        return this.z;
    }

    public abstract TickRateManager y();

    public float a(float f2) {
        return MathHelper.h(f2, this.w, this.x) * this.c(f2);
    }

    public void b(float f2) {
        float f1;
        this.w = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.x = f1;
    }

    public float c(float f2) {
        return MathHelper.h(f2, this.u, this.v);
    }

    public void d(float f2) {
        float f1;
        this.u = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.v = f1;
    }

    public boolean am() {
        return this.F_().e() && !this.F_().f() && this.aq() != j;
    }

    public boolean an() {
        return this.am() && (double)this.a(1.0f) > 0.9;
    }

    public boolean ao() {
        return this.am() && (double)this.c(1.0f) > 0.2;
    }

    public boolean v(BlockPosition blockposition) {
        return this.w(blockposition) == BiomeBase.Precipitation.b;
    }

    public BiomeBase.Precipitation w(BlockPosition blockposition) {
        if (!this.ao()) {
            return BiomeBase.Precipitation.a;
        }
        if (!this.k(blockposition)) {
            return BiomeBase.Precipitation.a;
        }
        if (this.a(HeightMap.Type.e, blockposition).v() > blockposition.v()) {
            return BiomeBase.Precipitation.a;
        }
        BiomeBase biomebase = this.z(blockposition).a();
        return biomebase.a(blockposition, this.V());
    }

    public abstract @Nullable WorldMap a(MapId var1);

    public void b(int i2, BlockPosition blockposition, int j2) {
    }

    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            List<? extends EntityHuman> list = this.E();
            int i2 = list.size();
            return i2 + " total; " + list.stream().map(EntityHuman::ht).collect(Collectors.joining(", "));
        });
        IChunkProvider ichunkprovider = this.ac();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.aq().a().toString());
        try {
            this.z.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double d0, double d1, double d2, double d3, double d4, double d5, List<FireworkExplosion> list) {
    }

    public abstract Scoreboard ab();

    public void b(BlockPosition blockposition, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (!this.H(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.hP)) {
                this.a(iblockdata, blockposition1, block, (Orientation)null, false);
                continue;
            }
            if (!iblockdata.d(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.hP)) continue;
            this.a(iblockdata, blockposition1, block, (Orientation)null, false);
        }
    }

    @Override
    public int E_() {
        return this.f;
    }

    public void c(int i2) {
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager F_() {
        return this.C.a();
    }

    public Holder<DimensionManager> ap() {
        return this.C;
    }

    public ResourceKey<World> aq() {
        return this.F;
    }

    @Override
    public RandomSource G_() {
        return this.y;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    public abstract RecipeAccess aa();

    public BlockPosition a(int i2, int j2, int k2, int l2) {
        this.s = this.s * 3 + 1013904223;
        int i1 = this.s >> 2;
        return new BlockPosition(i2 + (i1 & 0xF), j2 + (i1 >> 16 & l2), k2 + (i1 >> 8 & 0xF));
    }

    public boolean z() {
        return false;
    }

    @Override
    public BiomeManager H_() {
        return this.E;
    }

    public final boolean ar() {
        return this.e;
    }

    public abstract LevelEntityGetter<Entity> M();

    @Override
    public long I_() {
        return this.J++;
    }

    @Override
    public IRegistryCustom J_() {
        return this.G;
    }

    public DamageSources as() {
        return this.H;
    }

    public abstract EnvironmentAttributeSystem c();

    public abstract PotionBrewer R();

    public abstract FuelValues S();

    public int x(BlockPosition blockposition) {
        return 0;
    }

    public PalettedContainerFactory at() {
        return this.I;
    }

    public static enum a implements INamable
    {
        a("none"),
        b("block"),
        c("mob"),
        d("tnt"),
        e("trigger"),
        STANDARD("standard");

        public static final Codec<a> f;
        private final String g;

        private a(String s2) {
            this.g = s2;
        }

        @Override
        public String c() {
            return this.g;
        }

        static {
            f = INamable.a(a::values);
        }
    }
}

