/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.jspecify.annotations.Nullable;

public class BlockButtonAbstract
extends BlockAttachable {
    public static final MapCodec<BlockButtonAbstract> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(blockbuttonabstract -> blockbuttonabstract.d), (App)Codec.intRange((int)1, (int)1024).fieldOf("ticks_to_stay_pressed").forGetter(blockbuttonabstract -> blockbuttonabstract.e), BlockButtonAbstract.x()).apply((Applicative)instance, BlockButtonAbstract::new));
    public static final BlockStateBoolean b = BlockProperties.A;
    private final BlockSetType d;
    private final int e;
    private final Function<IBlockData, VoxelShape> g;

    public MapCodec<BlockButtonAbstract> a() {
        return a;
    }

    protected BlockButtonAbstract(BlockSetType blocksettype, int i2, BlockBase.Info blockbase_info) {
        super(blockbase_info.a(blocksettype.g()));
        this.d = blocksettype;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(f, EnumDirection.c)).b(b, false)).b(c, BlockPropertyAttachPosition.b));
        this.e = i2;
        this.g = this.b();
    }

    private Function<IBlockData, VoxelShape> b() {
        VoxelShape voxelshape = Block.a(14.0);
        VoxelShape voxelshape1 = Block.a(12.0);
        Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> map = VoxelShapes.e(Block.b(6.0, 4.0, 8.0, 16.0));
        return this.a((IBlockData iblockdata) -> VoxelShapes.a((VoxelShape)((Map)map.get(iblockdata.c(c))).get(iblockdata.c(f)), iblockdata.c(b) != false ? voxelshape : voxelshape1, OperatorBoolean.e));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.g.apply(iblockdata);
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (iblockdata.c(b).booleanValue()) {
            return EnumInteractionResult.c;
        }
        boolean powered = iblockdata.c(b);
        org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return EnumInteractionResult.a;
        }
        this.a(iblockdata, world, blockposition, entityhuman);
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.g() && !iblockdata.c(b).booleanValue()) {
            this.a(iblockdata, (World)worldserver, blockposition, (EntityHuman)null);
        }
        super.a(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable EntityHuman entityhuman) {
        world.a(blockposition, (IBlockData)iblockdata.b(b, true), 3);
        this.d(iblockdata, world, blockposition);
        world.a(blockposition, (Block)this, this.e);
        this.a(entityhuman, (GeneratorAccess)world, blockposition, true);
        world.a((net.minecraft.world.entity.Entity)entityhuman, GameEvent.a, blockposition);
    }

    protected void a(@Nullable EntityHuman entityhuman, GeneratorAccess generatoraccess, BlockPosition blockposition, boolean flag) {
        generatoraccess.a((net.minecraft.world.entity.Entity)(flag ? entityhuman : null), blockposition, this.a(flag), SoundCategory.e);
    }

    protected SoundEffect a(boolean flag) {
        return flag ? this.d.o() : this.d.n();
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        if (!flag && iblockdata.c(b).booleanValue()) {
            this.d(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(b) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(b) != false && BlockButtonAbstract.n(iblockdata) == enumdirection ? 15 : 0;
    }

    @Override
    protected boolean f_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(b).booleanValue()) {
            this.c(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (!world.B_() && this.d.e() && !iblockdata.c(b).booleanValue()) {
            this.c(iblockdata, world, blockposition);
        }
    }

    protected void c(IBlockData iblockdata, World world, BlockPosition blockposition) {
        EntityArrow entityarrow = this.d.e() ? (EntityArrow)world.a(EntityArrow.class, iblockdata.f(world, blockposition).a().a(blockposition)).stream().findFirst().orElse(null) : null;
        boolean flag = entityarrow != null;
        boolean flag1 = iblockdata.c(b);
        if (flag1 != flag && flag) {
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            EntityInteractEvent event = new EntityInteractEvent((Entity)entityarrow.getBukkitEntity(), block);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (flag != flag1) {
            boolean powered = flag1;
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            world.a(blockposition, (IBlockData)iblockdata.b(b, flag), 3);
            this.d(iblockdata, world, blockposition);
            this.a((EntityHuman)null, (GeneratorAccess)world, blockposition, flag);
            world.a((net.minecraft.world.entity.Entity)entityarrow, flag ? GameEvent.a : GameEvent.e, blockposition);
        }
        if (flag) {
            world.a(new BlockPosition(blockposition), (Block)this, this.e);
        }
    }

    private void d(IBlockData iblockdata, World world, BlockPosition blockposition) {
        EnumDirection enumdirection;
        Orientation orientation = ExperimentalRedstoneUtils.a(world, enumdirection, (enumdirection = BlockButtonAbstract.n(iblockdata).g()).o().d() ? EnumDirection.b : (EnumDirection)iblockdata.c(f));
        world.a(blockposition, (Block)this, orientation);
        world.a(blockposition.a(enumdirection), (Block)this, orientation);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(f, b, c);
    }
}

