/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockChest
extends BlockChestAbstract<TileEntityChest>
implements IBlockWaterlogged {
    public static final MapCodec<BlockChest> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.b.q().fieldOf("open_sound").forGetter(BlockChest::r), (App)BuiltInRegistries.b.q().fieldOf("close_sound").forGetter(BlockChest::s), BlockChest.x()).apply((Applicative)instance, (soundeffect, soundeffect1, blockbase_info) -> new BlockChest(() -> TileEntityTypes.b, (SoundEffect)soundeffect, (SoundEffect)soundeffect1, (BlockBase.Info)blockbase_info)));
    public static final BlockStateEnum<EnumDirection> c = BlockFacingHorizontal.f;
    public static final BlockStateEnum<BlockPropertyChestType> d = BlockProperties.bh;
    public static final BlockStateBoolean e = BlockProperties.I;
    public static final int f = 1;
    private static final VoxelShape g = Block.b(14.0, 0.0, 14.0);
    private static final Map<EnumDirection, VoxelShape> h = VoxelShapes.c(Block.a(14.0, 0.0, 14.0, 0.0, 15.0));
    private final SoundEffect i;
    private final SoundEffect D;
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>> R = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>>(){

        @Override
        public Optional<IInventory> a(TileEntityChest tileentitychest, TileEntityChest tileentitychest1) {
            return Optional.of(new InventoryLargeChest(tileentitychest, tileentitychest1));
        }

        @Override
        public Optional<IInventory> a(TileEntityChest tileentitychest) {
            return Optional.of(tileentitychest);
        }

        public Optional<IInventory> a() {
            return Optional.empty();
        }
    };
    public static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>> S = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>>(){

        @Override
        public Optional<ITileInventory> a(TileEntityChest tileentitychest, TileEntityChest tileentitychest1) {
            InventoryLargeChest iinventory = new InventoryLargeChest(tileentitychest, tileentitychest1);
            return Optional.of(new DoubleInventory(tileentitychest, tileentitychest1, iinventory));
        }

        @Override
        public Optional<ITileInventory> a(TileEntityChest tileentitychest) {
            return Optional.of(tileentitychest);
        }

        public Optional<ITileInventory> a() {
            return Optional.empty();
        }
    };

    @Override
    public MapCodec<? extends BlockChest> a() {
        return b;
    }

    protected BlockChest(Supplier<TileEntityTypes<? extends TileEntityChest>> supplier, SoundEffect soundeffect, SoundEffect soundeffect1, BlockBase.Info blockbase_info) {
        super(blockbase_info, supplier);
        this.i = soundeffect;
        this.D = soundeffect1;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(c, EnumDirection.c)).b(d, BlockPropertyChestType.a)).b(e, false));
    }

    public static DoubleBlockFinder.BlockType h(IBlockData iblockdata) {
        BlockPropertyChestType blockpropertychesttype = iblockdata.c(d);
        return blockpropertychesttype == BlockPropertyChestType.a ? DoubleBlockFinder.BlockType.a : (blockpropertychesttype == BlockPropertyChestType.c ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (iblockdata.c(e).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        if (this.i(iblockdata1) && enumdirection.o().d()) {
            BlockPropertyChestType blockpropertychesttype = iblockdata1.c(d);
            if (iblockdata.c(d) == BlockPropertyChestType.a && blockpropertychesttype != BlockPropertyChestType.a && iblockdata.c(c) == iblockdata1.c(c) && BlockChest.n(iblockdata1) == enumdirection.g()) {
                return (IBlockData)iblockdata.b(d, blockpropertychesttype.a());
            }
        } else if (BlockChest.n(iblockdata) == enumdirection) {
            return (IBlockData)iblockdata.b(d, BlockPropertyChestType.a);
        }
        return super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    public boolean i(IBlockData iblockdata) {
        return iblockdata.a(this);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return switch (iblockdata.c(d)) {
            case BlockPropertyChestType.a -> g;
            case BlockPropertyChestType.b, BlockPropertyChestType.c -> h.get(BlockChest.n(iblockdata));
            default -> throw new MatchException(null, null);
        };
    }

    public static EnumDirection n(IBlockData iblockdata) {
        EnumDirection enumdirection = iblockdata.c(c);
        return iblockdata.c(d) == BlockPropertyChestType.b ? enumdirection.h() : enumdirection.i();
    }

    public static BlockPosition b(BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection = BlockChest.n(iblockdata);
        return blockposition.a(enumdirection);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection2;
        BlockPropertyChestType blockpropertychesttype = BlockPropertyChestType.a;
        EnumDirection enumdirection = blockactioncontext.g().g();
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        boolean flag = blockactioncontext.h();
        EnumDirection enumdirection1 = blockactioncontext.k();
        if (enumdirection1.o().d() && flag && (enumdirection2 = this.b(blockactioncontext.q(), blockactioncontext.a(), enumdirection1.g())) != null && enumdirection2.o() != enumdirection1.o()) {
            enumdirection = enumdirection2;
            BlockPropertyChestType blockPropertyChestType = blockpropertychesttype = enumdirection2.i() == enumdirection1.g() ? BlockPropertyChestType.c : BlockPropertyChestType.b;
        }
        if (blockpropertychesttype == BlockPropertyChestType.a && !flag) {
            blockpropertychesttype = this.a(blockactioncontext.q(), blockactioncontext.a(), enumdirection);
        }
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(c, enumdirection)).b(d, blockpropertychesttype)).b(e, fluid.a() == FluidTypes.c);
    }

    protected BlockPropertyChestType a(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        return enumdirection == this.b(world, blockposition, enumdirection.h()) ? BlockPropertyChestType.b : (enumdirection == this.b(world, blockposition, enumdirection.i()) ? BlockPropertyChestType.c : BlockPropertyChestType.a);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(e) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    private @Nullable EnumDirection b(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        IBlockData iblockdata = world.a_(blockposition.a(enumdirection));
        return this.i(iblockdata) && iblockdata.c(d) == BlockPropertyChestType.a ? iblockdata.c(c) : null;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        InventoryUtils.a(iblockdata, worldserver, blockposition);
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ITileInventory itileinventory = this.a(iblockdata, world, blockposition);
            if (itileinventory != null) {
                entityhuman.a(itileinventory);
                entityhuman.b(this.d());
                PiglinAI.a(worldserver, entityhuman, true);
            }
        }
        return EnumInteractionResult.a;
    }

    protected Statistic<MinecraftKey> d() {
        return StatisticList.i.b(StatisticList.aq);
    }

    public TileEntityTypes<? extends TileEntityChest> q() {
        return (TileEntityTypes)this.a.get();
    }

    public static @Nullable IInventory a(BlockChest blockchest, IBlockData iblockdata, World world, BlockPosition blockposition, boolean flag) {
        return blockchest.a(iblockdata, world, blockposition, flag).apply(R).orElse(null);
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> a(IBlockData iblockdata, World world, BlockPosition blockposition, boolean flag) {
        BiPredicate<GeneratorAccess, BlockPosition> bipredicate = flag ? (generatoraccess, blockposition1) -> false : BlockChest::a;
        return DoubleBlockFinder.a((TileEntityTypes)this.a.get(), BlockChest::h, BlockChest::n, c, iblockdata, world, blockposition, bipredicate);
    }

    @Override
    protected @Nullable ITileInventory a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return this.getMenuProvider(iblockdata, world, blockposition, false);
    }

    public @Nullable ITileInventory getMenuProvider(IBlockData iblockdata, World world, BlockPosition blockposition, boolean ignoreObstructions) {
        return this.a(iblockdata, world, blockposition, ignoreObstructions).apply(S).orElse(null);
    }

    public static DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction> a(final LidBlockEntity lidblockentity) {
        return new DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction a(TileEntityChest tileentitychest, TileEntityChest tileentitychest1) {
                return f2 -> Math.max(tileentitychest.a(f2), tileentitychest1.a(f2));
            }

            @Override
            public Float2FloatFunction a(TileEntityChest tileentitychest) {
                Objects.requireNonNull(tileentitychest);
                return tileentitychest::a;
            }

            public Float2FloatFunction a() {
                LidBlockEntity lidblockentity1 = lidblockentity;
                Objects.requireNonNull(lidblockentity);
                return lidblockentity1::a;
            }
        };
    }

    @Override
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityChest(blockposition, iblockdata);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return world.B_() ? BlockChest.a(tileentitytypes, this.q(), TileEntityChest::a) : null;
    }

    public static boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        return BlockChest.a((IBlockAccess)generatoraccess, blockposition) || BlockChest.b(generatoraccess, blockposition);
    }

    private static boolean a(IBlockAccess iblockaccess, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.d();
        return iblockaccess.a_(blockposition1).d(iblockaccess, blockposition1);
    }

    private static boolean b(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        List<EntityCat> list = generatoraccess.a(EntityCat.class, new AxisAlignedBB(blockposition.u(), blockposition.v() + 1, blockposition.w(), blockposition.u() + 1, blockposition.v() + 2, blockposition.w() + 1));
        if (!list.isEmpty()) {
            for (EntityCat entitycat : list) {
                if (!entitycat.gQ()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean c_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        return Container.b(BlockChest.a(this, iblockdata, world, blockposition, false));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.b(c, enumblockrotation.a(iblockdata.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a(iblockdata.c(c)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(c, d, e);
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        TileEntity tileentity = worldserver.c_(blockposition);
        if (tileentity instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).l();
        }
    }

    public SoundEffect r() {
        return this.i;
    }

    public SoundEffect s() {
        return this.D;
    }

    public static class DoubleInventory
    implements ITileInventory {
        private final TileEntityChest tileentitychest;
        private final TileEntityChest tileentitychest1;
        public final InventoryLargeChest inventorylargechest;

        public DoubleInventory(TileEntityChest tileentitychest, TileEntityChest tileentitychest1, InventoryLargeChest inventorylargechest) {
            this.tileentitychest = tileentitychest;
            this.tileentitychest1 = tileentitychest1;
            this.inventorylargechest = inventorylargechest;
        }

        @Override
        public @Nullable Container createMenu(int i2, PlayerInventory playerinventory, EntityHuman entityhuman) {
            if (this.tileentitychest.b(entityhuman) && this.tileentitychest1.b(entityhuman)) {
                this.tileentitychest.f_(playerinventory.j);
                this.tileentitychest1.f_(playerinventory.j);
                return ContainerChest.b(i2, playerinventory, this.inventorylargechest);
            }
            EnumDirection enumdirection = BlockChest.n(this.tileentitychest.o());
            Vec3D vec3d = this.tileentitychest.aD_().b();
            Vec3D vec3d1 = vec3d.b((double)enumdirection.j() / 2.0, 0.0, (double)enumdirection.l() / 2.0);
            TileEntityContainer.a(vec3d1, entityhuman, this.R_());
            return null;
        }

        @Override
        public IChatBaseComponent R_() {
            return this.tileentitychest.i_() ? this.tileentitychest.R_() : (this.tileentitychest1.i_() ? this.tileentitychest1.R_() : IChatBaseComponent.c("container.chestDouble"));
        }
    }
}

