/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class BlockDoor
extends Block {
    public static final MapCodec<BlockDoor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(BlockDoor::b), BlockDoor.x()).apply((Applicative)instance, BlockDoor::new));
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.f;
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> c = BlockProperties.ah;
    public static final BlockStateEnum<BlockPropertyDoorHinge> d = BlockProperties.bj;
    public static final BlockStateBoolean e = BlockProperties.y;
    public static final BlockStateBoolean f = BlockProperties.A;
    private static final Map<EnumDirection, VoxelShape> g = VoxelShapes.c(Block.c(16.0, 13.0, 16.0));
    private final BlockSetType h;

    public MapCodec<? extends BlockDoor> a() {
        return a;
    }

    protected BlockDoor(BlockSetType blocksettype, BlockBase.Info blockbase_info) {
        super(blockbase_info.a(blocksettype.g()));
        this.h = blocksettype;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(b, EnumDirection.c)).b(e, false)).b(d, BlockPropertyDoorHinge.a)).b(f, false)).b(c, BlockPropertyDoubleBlockHalf.b));
    }

    public BlockSetType b() {
        return this.h;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        EnumDirection enumdirection = iblockdata.c(b);
        EnumDirection enumdirection1 = iblockdata.c(e).booleanValue() ? (iblockdata.c(d) == BlockPropertyDoorHinge.b ? enumdirection.i() : enumdirection.h()) : enumdirection;
        return g.get(enumdirection1);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        BlockPropertyDoubleBlockHalf blockpropertydoubleblockhalf = iblockdata.c(c);
        return enumdirection.o() == EnumDirection.EnumAxis.b && blockpropertydoubleblockhalf == BlockPropertyDoubleBlockHalf.b == (enumdirection == EnumDirection.b) ? (iblockdata1.b() instanceof BlockDoor && iblockdata1.c(c) != blockpropertydoubleblockhalf ? (IBlockData)iblockdata1.b(c, blockpropertydoubleblockhalf) : Blocks.a.m()) : (blockpropertydoubleblockhalf == BlockPropertyDoubleBlockHalf.b && enumdirection == EnumDirection.a && !iblockdata.a(iworldreader, blockposition) ? Blocks.a.m() : super.a(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource));
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.g() && iblockdata.c(c) == BlockPropertyDoubleBlockHalf.b && this.h.d() && !iblockdata.c(f).booleanValue()) {
            this.a((Entity)null, (World)worldserver, iblockdata, blockposition, !this.n(iblockdata));
        }
        super.a(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    @Override
    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        if (!(world.B_() || !entityhuman.gM() && entityhuman.d(iblockdata))) {
            BlockTallPlant.b(world, blockposition, iblockdata, entityhuman);
        }
        return super.a(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return switch (pathmode) {
            case PathMode.a, PathMode.c -> iblockdata.c(e);
            case PathMode.b -> false;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public @Nullable IBlockData a(BlockActionContext blockactioncontext) {
        BlockPosition blockposition = blockactioncontext.a();
        World world = blockactioncontext.q();
        if (blockposition.v() < world.aw() && world.a_(blockposition.d()).a(blockactioncontext)) {
            boolean flag = world.I(blockposition) || world.I(blockposition.d());
            return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(b, blockactioncontext.g())).b(d, this.b(blockactioncontext))).b(f, flag)).b(e, flag)).b(c, BlockPropertyDoubleBlockHalf.b);
        }
        return null;
    }

    @Override
    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, @Nullable EntityLiving entityliving, ItemStack itemstack) {
        world.a(blockposition.d(), (IBlockData)iblockdata.b(c, BlockPropertyDoubleBlockHalf.a), 3);
    }

    private BlockPropertyDoorHinge b(BlockActionContext blockactioncontext) {
        boolean flag1;
        World iblockaccess = blockactioncontext.q();
        BlockPosition blockposition = blockactioncontext.a();
        EnumDirection enumdirection = blockactioncontext.g();
        BlockPosition blockposition1 = blockposition.d();
        EnumDirection enumdirection1 = enumdirection.i();
        BlockPosition blockposition2 = blockposition.a(enumdirection1);
        IBlockData iblockdata = iblockaccess.a_(blockposition2);
        BlockPosition blockposition3 = blockposition1.a(enumdirection1);
        IBlockData iblockdata1 = iblockaccess.a_(blockposition3);
        EnumDirection enumdirection2 = enumdirection.h();
        BlockPosition blockposition4 = blockposition.a(enumdirection2);
        IBlockData iblockdata2 = iblockaccess.a_(blockposition4);
        BlockPosition blockposition5 = blockposition1.a(enumdirection2);
        IBlockData iblockdata3 = iblockaccess.a_(blockposition5);
        int i2 = (iblockdata.m(iblockaccess, blockposition2) ? -1 : 0) + (iblockdata1.m(iblockaccess, blockposition3) ? -1 : 0) + (iblockdata2.m(iblockaccess, blockposition4) ? 1 : 0) + (iblockdata3.m(iblockaccess, blockposition5) ? 1 : 0);
        boolean flag = iblockdata.b() instanceof BlockDoor && iblockdata.c(c) == BlockPropertyDoubleBlockHalf.b;
        boolean bl = flag1 = iblockdata2.b() instanceof BlockDoor && iblockdata2.c(c) == BlockPropertyDoubleBlockHalf.b;
        if ((!flag || flag1) && i2 <= 0) {
            if ((!flag1 || flag) && i2 >= 0) {
                int j2 = enumdirection.j();
                int k2 = enumdirection.l();
                Vec3D vec3d = blockactioncontext.l();
                double d0 = vec3d.g - (double)blockposition.u();
                double d1 = vec3d.i - (double)blockposition.w();
                return !(j2 < 0 && !(d1 >= 0.5) || j2 > 0 && !(d1 <= 0.5) || k2 < 0 && !(d0 <= 0.5) || k2 > 0 && !(d0 >= 0.5)) ? BlockPropertyDoorHinge.a : BlockPropertyDoorHinge.b;
            }
            return BlockPropertyDoorHinge.a;
        }
        return BlockPropertyDoorHinge.b;
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!this.h.c()) {
            return EnumInteractionResult.e;
        }
        iblockdata = (IBlockData)iblockdata.a(e);
        world.a(blockposition, iblockdata, 10);
        this.a(entityhuman, world, blockposition, (boolean)iblockdata.c(e));
        world.a((Entity)entityhuman, this.n(iblockdata) ? GameEvent.h : GameEvent.d, blockposition);
        return EnumInteractionResult.a;
    }

    public boolean n(IBlockData iblockdata) {
        return iblockdata.c(e);
    }

    public void a(@Nullable Entity entity, World world, IBlockData iblockdata, BlockPosition blockposition, boolean flag) {
        if (iblockdata.a(this) && iblockdata.c(e) != flag) {
            world.a(blockposition, (IBlockData)iblockdata.b(e, flag), 10);
            this.a(entity, world, blockposition, flag);
            world.a(entity, flag ? GameEvent.h : GameEvent.d, blockposition);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        int oldPower;
        BlockPosition otherHalf = blockposition.a(iblockdata.c(c) == BlockPropertyDoubleBlockHalf.b ? EnumDirection.b : EnumDirection.a);
        CraftWorld bworld = world.getWorld();
        org.bukkit.block.Block bukkitBlock = bworld.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
        org.bukkit.block.Block blockTop = bworld.getBlockAt(otherHalf.u(), otherHalf.v(), otherHalf.w());
        int power = bukkitBlock.getBlockPower();
        int powerTop = blockTop.getBlockPower();
        if (powerTop > power) {
            power = powerTop;
        }
        if ((oldPower = iblockdata.c(f) != false ? 15 : 0) == 0 ^ power == 0) {
            boolean flag1;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bukkitBlock, oldPower, power);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            if (flag1 != iblockdata.c(e)) {
                this.a((Entity)null, world, blockposition, flag1);
                world.a((Entity)null, flag1 ? GameEvent.h : GameEvent.d, blockposition);
            }
            world.a(blockposition, (IBlockData)((IBlockData)iblockdata.b(f, flag1)).b(e, flag1), 2);
        }
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata1 = iworldreader.a_(blockposition1);
        return iblockdata.c(c) == BlockPropertyDoubleBlockHalf.b ? iblockdata1.c((IBlockAccess)iworldreader, blockposition1, EnumDirection.b) : iblockdata1.a(this);
    }

    private void a(@Nullable Entity entity, World world, BlockPosition blockposition, boolean flag) {
        world.a(entity, blockposition, flag ? this.h.i() : this.h.h(), SoundCategory.e, 1.0f, world.G_().i() * 0.1f + 0.9f);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.b(b, enumblockrotation.a(iblockdata.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return enumblockmirror == EnumBlockMirror.a ? iblockdata : (IBlockData)iblockdata.a(enumblockmirror.a(iblockdata.c(b))).a(d);
    }

    @Override
    protected long a(IBlockData iblockdata, BlockPosition blockposition) {
        return MathHelper.b(blockposition.u(), blockposition.c(iblockdata.c(c) == BlockPropertyDoubleBlockHalf.b ? 0 : 1).v(), blockposition.w());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(c, b, e, d, f);
    }

    public static boolean a(World world, BlockPosition blockposition) {
        return BlockDoor.p(world.a_(blockposition));
    }

    public static boolean p(IBlockData iblockdata) {
        BlockDoor blockdoor;
        Block block = iblockdata.b();
        if (block instanceof BlockDoor && (blockdoor = (BlockDoor)block).b().c()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }
}

