/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockFire
extends BlockFireAbstract {
    public static final MapCodec<BlockFire> b = BlockFire.b(BlockFire::new);
    public static final int c = 15;
    public static final BlockStateInteger d = BlockProperties.aA;
    public static final BlockStateBoolean e = BlockSprawling.b;
    public static final BlockStateBoolean f = BlockSprawling.c;
    public static final BlockStateBoolean g = BlockSprawling.d;
    public static final BlockStateBoolean h = BlockSprawling.e;
    public static final BlockStateBoolean i = BlockSprawling.f;
    public static final Map<EnumDirection, BlockStateBoolean> D = BlockSprawling.h.entrySet().stream().filter(entry -> entry.getKey() != EnumDirection.a).collect(SystemUtils.a());
    private final Function<IBlockData, VoxelShape> R;
    private static final int S = 60;
    private static final int T = 30;
    private static final int U = 15;
    private static final int V = 5;
    private static final int W = 100;
    private static final int X = 60;
    private static final int Y = 20;
    private static final int Z = 5;
    public final Object2IntMap<Block> aa = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> ab = new Object2IntOpenHashMap();

    public MapCodec<BlockFire> a() {
        return b;
    }

    public BlockFire(BlockBase.Info blockbase_info) {
        super(blockbase_info, 1.0f);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(d, 0)).b(e, false)).b(f, false)).b(g, false)).b(h, false)).b(i, false));
        this.R = this.q();
    }

    private Function<IBlockData, VoxelShape> q() {
        Map<EnumDirection, VoxelShape> map = VoxelShapes.d(Block.c(16.0, 0.0, 1.0));
        return this.a((IBlockData iblockdata) -> {
            VoxelShape voxelshape = VoxelShapes.a();
            for (Map.Entry<EnumDirection, BlockStateBoolean> map_entry : D.entrySet()) {
                if (!((Boolean)iblockdata.c(map_entry.getValue())).booleanValue()) continue;
                voxelshape = VoxelShapes.a(voxelshape, (VoxelShape)map.get(map_entry.getKey()));
            }
            return voxelshape.c() ? a : voxelshape;
        }, d);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (!this.a(iblockdata, iworldreader, blockposition)) {
            if (!(iworldreader instanceof World)) {
                return Blocks.a.m();
            }
            World world = (World)iworldreader;
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockposition);
            blockState.setData(Blocks.a.m());
            BlockFadeEvent event = new BlockFadeEvent((org.bukkit.block.Block)blockState.getBlock(), (BlockState)blockState);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return this.a(iworldreader, blockposition, (int)iblockdata.c(d));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.R.apply(iblockdata);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        return this.b(blockactioncontext.q(), blockactioncontext.a());
    }

    protected IBlockData b(IBlockAccess iblockaccess, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata = iblockaccess.a_(blockposition1);
        if (!this.g(iblockdata) && !iblockdata.c(iblockaccess, blockposition1, EnumDirection.b)) {
            IBlockData iblockdata1 = this.m();
            for (EnumDirection enumdirection : EnumDirection.values()) {
                BlockStateBoolean blockstateboolean = D.get(enumdirection);
                if (blockstateboolean == null) continue;
                iblockdata1 = (IBlockData)iblockdata1.b(blockstateboolean, this.g(iblockaccess.a_(blockposition.a(enumdirection))));
            }
            return iblockdata1;
        }
        return this.m();
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        return iworldreader.a_(blockposition1).c((IBlockAccess)iworldreader, blockposition1, EnumDirection.b) || this.d(iworldreader, blockposition);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        worldserver.a(blockposition, (Block)this, BlockFire.a(worldserver.y));
        if (worldserver.j(blockposition)) {
            if (!iblockdata.a((IWorldReader)worldserver, blockposition)) {
                this.fireExtinguished(worldserver, blockposition);
            }
            IBlockData iblockdata1 = worldserver.a_(blockposition.e());
            boolean flag = iblockdata1.a(worldserver.F_().k());
            int i2 = iblockdata.c(d);
            if (!flag && worldserver.ao() && this.a(worldserver, blockposition) && randomsource.i() < 0.2f + (float)i2 * 0.03f) {
                this.fireExtinguished(worldserver, blockposition);
            } else {
                boolean flag1;
                int j2 = Math.min(15, i2 + randomsource.a(3) / 2);
                if (i2 != j2) {
                    iblockdata = (IBlockData)iblockdata.b(d, j2);
                    worldserver.a(blockposition, iblockdata, 260);
                }
                if (!flag) {
                    if (!this.d(worldserver, blockposition)) {
                        BlockPosition blockposition1 = blockposition.e();
                        if (!worldserver.a_(blockposition1).c((IBlockAccess)worldserver, blockposition1, EnumDirection.b) || i2 > 3) {
                            this.fireExtinguished(worldserver, blockposition);
                        }
                        return;
                    }
                    if (i2 == 15 && randomsource.a(4) == 0 && !this.g(worldserver.a_(blockposition.e()))) {
                        this.fireExtinguished(worldserver, blockposition);
                        return;
                    }
                }
                int k2 = (flag1 = worldserver.c().a(EnvironmentAttributes.G, blockposition).booleanValue()) ? -50 : 0;
                this.checkBurnOut(worldserver, blockposition.i(), 300 + k2, randomsource, i2, blockposition);
                this.checkBurnOut(worldserver, blockposition.h(), 300 + k2, randomsource, i2, blockposition);
                this.checkBurnOut(worldserver, blockposition.e(), 250 + k2, randomsource, i2, blockposition);
                this.checkBurnOut(worldserver, blockposition.d(), 250 + k2, randomsource, i2, blockposition);
                this.checkBurnOut(worldserver, blockposition.f(), 300 + k2, randomsource, i2, blockposition);
                this.checkBurnOut(worldserver, blockposition.g(), 300 + k2, randomsource, i2, blockposition);
                BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                for (int l2 = -1; l2 <= 1; ++l2) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l2 == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockposition_mutableblockposition.a(blockposition, l2, j1, i1);
                            int l1 = this.a((IWorldReader)worldserver, (BlockPosition)blockposition_mutableblockposition);
                            if (l1 <= 0) continue;
                            int i22 = (l1 + 40 + worldserver.av().a() * 7) / (i2 + 30);
                            if (flag1) {
                                i22 /= 2;
                            }
                            if (i22 <= 0 || randomsource.a(k1) > i22 || worldserver.ao() && this.a(worldserver, (BlockPosition)blockposition_mutableblockposition)) continue;
                            int j22 = Math.min(15, i2 + randomsource.a(5) / 4);
                            if (worldserver.a_(blockposition_mutableblockposition).b() == Blocks.cN || CraftEventFactory.callBlockIgniteEvent((World)worldserver, (BlockPosition)blockposition_mutableblockposition, blockposition).isCancelled()) continue;
                            CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition_mutableblockposition, this.a((IWorldReader)worldserver, (BlockPosition)blockposition_mutableblockposition, j22), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean a(World world, BlockPosition blockposition) {
        return world.v(blockposition) || world.v(blockposition.h()) || world.v(blockposition.i()) || world.v(blockposition.f()) || world.v(blockposition.g());
    }

    private int p(IBlockData iblockdata) {
        return iblockdata.b(BlockProperties.I) && iblockdata.c(BlockProperties.I) != false ? 0 : this.ab.getInt((Object)iblockdata.b());
    }

    private int r(IBlockData iblockdata) {
        return iblockdata.b(BlockProperties.I) && iblockdata.c(BlockProperties.I) != false ? 0 : this.aa.getInt((Object)iblockdata.b());
    }

    private void checkBurnOut(World world, BlockPosition blockposition, int i2, RandomSource randomsource, int j2, BlockPosition sourceposition) {
        int k2 = this.p(world.a_(blockposition));
        if (randomsource.a(i2) < k2) {
            IBlockData iblockdata = world.a_(blockposition);
            org.bukkit.block.Block theBlock = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            org.bukkit.block.Block sourceBlock = world.getWorld().getBlockAt(sourceposition.u(), sourceposition.v(), sourceposition.w());
            BlockBurnEvent event = new BlockBurnEvent(theBlock, sourceBlock);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (iblockdata.b() instanceof BlockTNT && !CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.FIRE, null, sourceposition)) {
                return;
            }
            if (randomsource.a(j2 + 10) < 5 && !world.v(blockposition)) {
                int l2 = Math.min(j2 + randomsource.a(5) / 4, 15);
                world.a(blockposition, this.a((IWorldReader)world, blockposition, l2), 3);
            } else {
                world.a(blockposition, false);
            }
            Block block = iblockdata.b();
            if (block instanceof BlockTNT) {
                BlockTNT.a(world, blockposition);
            }
        }
    }

    private IBlockData a(IWorldReader iworldreader, BlockPosition blockposition, int i2) {
        IBlockData iblockdata = BlockFire.a(iworldreader, blockposition);
        return iblockdata.a(Blocks.cN) ? (IBlockData)iblockdata.b(d, i2) : iblockdata;
    }

    private boolean d(IBlockAccess iblockaccess, BlockPosition blockposition) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.g(iblockaccess.a_(blockposition.a(enumdirection)))) continue;
            return true;
        }
        return false;
    }

    private int a(IWorldReader iworldreader, BlockPosition blockposition) {
        if (!iworldreader.A(blockposition)) {
            return 0;
        }
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            IBlockData iblockdata = iworldreader.a_(blockposition.a(enumdirection));
            i2 = Math.max(this.r(iblockdata), i2);
        }
        return i2;
    }

    @Override
    protected boolean g(IBlockData iblockdata) {
        return this.r(iblockdata) > 0;
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext context) {
        super.onPlace(iblockdata, world, blockposition, iblockdata1, flag, context);
        world.a(blockposition, (Block)this, BlockFire.a(world.y));
    }

    private static int a(RandomSource randomsource) {
        return 30 + randomsource.a(10);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(d, e, f, g, h, i);
    }

    public void a(Block block, int i2, int j2) {
        this.aa.put((Object)block, i2);
        this.ab.put((Object)block, j2);
    }

    public static void b() {
        BlockFire blockfire = (BlockFire)Blocks.cN;
        blockfire.a(Blocks.n, 5, 20);
        blockfire.a(Blocks.o, 5, 20);
        blockfire.a(Blocks.p, 5, 20);
        blockfire.a(Blocks.q, 5, 20);
        blockfire.a(Blocks.r, 5, 20);
        blockfire.a(Blocks.s, 5, 20);
        blockfire.a(Blocks.t, 5, 20);
        blockfire.a(Blocks.v, 5, 20);
        blockfire.a(Blocks.w, 5, 20);
        blockfire.a(Blocks.x, 5, 20);
        blockfire.a(Blocks.y, 5, 20);
        blockfire.a(Blocks.kl, 5, 20);
        blockfire.a(Blocks.km, 5, 20);
        blockfire.a(Blocks.kn, 5, 20);
        blockfire.a(Blocks.ko, 5, 20);
        blockfire.a(Blocks.kp, 5, 20);
        blockfire.a(Blocks.kq, 5, 20);
        blockfire.a(Blocks.kr, 5, 20);
        blockfire.a(Blocks.ks, 5, 20);
        blockfire.a(Blocks.kt, 5, 20);
        blockfire.a(Blocks.ku, 5, 20);
        blockfire.a(Blocks.kv, 5, 20);
        blockfire.a(Blocks.fQ, 5, 20);
        blockfire.a(Blocks.kO, 5, 20);
        blockfire.a(Blocks.kP, 5, 20);
        blockfire.a(Blocks.kQ, 5, 20);
        blockfire.a(Blocks.kR, 5, 20);
        blockfire.a(Blocks.kS, 5, 20);
        blockfire.a(Blocks.kT, 5, 20);
        blockfire.a(Blocks.kU, 5, 20);
        blockfire.a(Blocks.kV, 5, 20);
        blockfire.a(Blocks.kW, 5, 20);
        blockfire.a(Blocks.ex, 5, 20);
        blockfire.a(Blocks.kX, 5, 20);
        blockfire.a(Blocks.kY, 5, 20);
        blockfire.a(Blocks.kZ, 5, 20);
        blockfire.a(Blocks.la, 5, 20);
        blockfire.a(Blocks.lb, 5, 20);
        blockfire.a(Blocks.lc, 5, 20);
        blockfire.a(Blocks.ld, 5, 20);
        blockfire.a(Blocks.le, 5, 20);
        blockfire.a(Blocks.lf, 5, 20);
        blockfire.a(Blocks.cR, 5, 20);
        blockfire.a(Blocks.gA, 5, 20);
        blockfire.a(Blocks.gz, 5, 20);
        blockfire.a(Blocks.gB, 5, 20);
        blockfire.a(Blocks.iG, 5, 20);
        blockfire.a(Blocks.iH, 5, 20);
        blockfire.a(Blocks.iI, 5, 20);
        blockfire.a(Blocks.iJ, 5, 20);
        blockfire.a(Blocks.iK, 5, 20);
        blockfire.a(Blocks.iL, 5, 20);
        blockfire.a(Blocks.iM, 5, 20);
        blockfire.a(Blocks.X, 5, 5);
        blockfire.a(Blocks.Y, 5, 5);
        blockfire.a(Blocks.Z, 5, 5);
        blockfire.a(Blocks.aa, 5, 5);
        blockfire.a(Blocks.ab, 5, 5);
        blockfire.a(Blocks.ac, 5, 5);
        blockfire.a(Blocks.ae, 5, 5);
        blockfire.a(Blocks.ad, 5, 5);
        blockfire.a(Blocks.af, 5, 5);
        blockfire.a(Blocks.ai, 5, 5);
        blockfire.a(Blocks.aq, 5, 5);
        blockfire.a(Blocks.aj, 5, 5);
        blockfire.a(Blocks.ak, 5, 5);
        blockfire.a(Blocks.al, 5, 5);
        blockfire.a(Blocks.am, 5, 5);
        blockfire.a(Blocks.an, 5, 5);
        blockfire.a(Blocks.ao, 5, 5);
        blockfire.a(Blocks.ap, 5, 5);
        blockfire.a(Blocks.ar, 5, 5);
        blockfire.a(Blocks.as, 5, 5);
        blockfire.a(Blocks.aB, 5, 5);
        blockfire.a(Blocks.aC, 5, 5);
        blockfire.a(Blocks.aD, 5, 5);
        blockfire.a(Blocks.aE, 5, 5);
        blockfire.a(Blocks.aF, 5, 5);
        blockfire.a(Blocks.aG, 5, 5);
        blockfire.a(Blocks.aH, 5, 5);
        blockfire.a(Blocks.aI, 5, 5);
        blockfire.a(Blocks.aJ, 5, 5);
        blockfire.a(Blocks.at, 5, 5);
        blockfire.a(Blocks.au, 5, 5);
        blockfire.a(Blocks.av, 5, 5);
        blockfire.a(Blocks.aw, 5, 5);
        blockfire.a(Blocks.ax, 5, 5);
        blockfire.a(Blocks.ay, 5, 5);
        blockfire.a(Blocks.u, 5, 5);
        blockfire.a(Blocks.az, 5, 5);
        blockfire.a(Blocks.aA, 5, 5);
        blockfire.a(Blocks.ag, 5, 20);
        blockfire.a(Blocks.aK, 30, 60);
        blockfire.a(Blocks.aL, 30, 60);
        blockfire.a(Blocks.aM, 30, 60);
        blockfire.a(Blocks.aN, 30, 60);
        blockfire.a(Blocks.aO, 30, 60);
        blockfire.a(Blocks.aP, 30, 60);
        blockfire.a(Blocks.aQ, 30, 60);
        blockfire.a(Blocks.aR, 30, 60);
        blockfire.a(Blocks.aS, 30, 60);
        blockfire.a(Blocks.cv, 30, 20);
        blockfire.a(Blocks.cu, 15, 100);
        blockfire.a(Blocks.bA, 60, 100);
        blockfire.a(Blocks.bB, 60, 100);
        blockfire.a(Blocks.bC, 60, 100);
        blockfire.a(Blocks.bE, 60, 100);
        blockfire.a(Blocks.bF, 60, 100);
        blockfire.a(Blocks.jv, 60, 100);
        blockfire.a(Blocks.jw, 60, 100);
        blockfire.a(Blocks.jx, 60, 100);
        blockfire.a(Blocks.jy, 60, 100);
        blockfire.a(Blocks.jz, 60, 100);
        blockfire.a(Blocks.jA, 60, 100);
        blockfire.a(Blocks.cb, 60, 100);
        blockfire.a(Blocks.cd, 60, 100);
        blockfire.a(Blocks.uW, 60, 100);
        blockfire.a(Blocks.uX, 60, 100);
        blockfire.a(Blocks.ce, 60, 100);
        blockfire.a(Blocks.cf, 60, 100);
        blockfire.a(Blocks.cg, 60, 100);
        blockfire.a(Blocks.ch, 60, 100);
        blockfire.a(Blocks.ci, 60, 100);
        blockfire.a(Blocks.cj, 60, 100);
        blockfire.a(Blocks.ck, 60, 100);
        blockfire.a(Blocks.cl, 60, 100);
        blockfire.a(Blocks.cm, 60, 100);
        blockfire.a(Blocks.co, 60, 100);
        blockfire.a(Blocks.cc, 60, 100);
        blockfire.a(Blocks.ly, 60, 100);
        blockfire.a(Blocks.cn, 60, 100);
        blockfire.a(Blocks.tY, 60, 100);
        blockfire.a(Blocks.tZ, 60, 100);
        blockfire.a(Blocks.ua, 60, 100);
        blockfire.a(Blocks.et, 60, 100);
        blockfire.a(Blocks.bK, 30, 60);
        blockfire.a(Blocks.bL, 30, 60);
        blockfire.a(Blocks.bM, 30, 60);
        blockfire.a(Blocks.bN, 30, 60);
        blockfire.a(Blocks.bO, 30, 60);
        blockfire.a(Blocks.bP, 30, 60);
        blockfire.a(Blocks.bQ, 30, 60);
        blockfire.a(Blocks.bR, 30, 60);
        blockfire.a(Blocks.bS, 30, 60);
        blockfire.a(Blocks.bT, 30, 60);
        blockfire.a(Blocks.bU, 30, 60);
        blockfire.a(Blocks.bV, 30, 60);
        blockfire.a(Blocks.bW, 30, 60);
        blockfire.a(Blocks.bX, 30, 60);
        blockfire.a(Blocks.bY, 30, 60);
        blockfire.a(Blocks.bZ, 30, 60);
        blockfire.a(Blocks.fN, 15, 100);
        blockfire.a(Blocks.jt, 5, 5);
        blockfire.a(Blocks.jb, 60, 20);
        blockfire.a(Blocks.qd, 15, 20);
        blockfire.a(Blocks.jc, 60, 20);
        blockfire.a(Blocks.jd, 60, 20);
        blockfire.a(Blocks.je, 60, 20);
        blockfire.a(Blocks.jf, 60, 20);
        blockfire.a(Blocks.jg, 60, 20);
        blockfire.a(Blocks.jh, 60, 20);
        blockfire.a(Blocks.ji, 60, 20);
        blockfire.a(Blocks.jj, 60, 20);
        blockfire.a(Blocks.jk, 60, 20);
        blockfire.a(Blocks.jl, 60, 20);
        blockfire.a(Blocks.jm, 60, 20);
        blockfire.a(Blocks.jn, 60, 20);
        blockfire.a(Blocks.jo, 60, 20);
        blockfire.a(Blocks.jp, 60, 20);
        blockfire.a(Blocks.jq, 60, 20);
        blockfire.a(Blocks.jr, 60, 20);
        blockfire.a(Blocks.uT, 5, 100);
        blockfire.a(Blocks.uU, 5, 100);
        blockfire.a(Blocks.uV, 5, 100);
        blockfire.a(Blocks.na, 30, 60);
        blockfire.a(Blocks.nW, 60, 60);
        blockfire.a(Blocks.oP, 60, 60);
        blockfire.a(Blocks.oX, 30, 20);
        blockfire.a(Blocks.qc, 5, 20);
        blockfire.a(Blocks.pg, 60, 100);
        blockfire.a(Blocks.qf, 5, 20);
        blockfire.a(Blocks.qe, 30, 20);
        blockfire.a(Blocks.aT, 30, 60);
        blockfire.a(Blocks.aU, 30, 60);
        blockfire.a(Blocks.tS, 15, 60);
        blockfire.a(Blocks.tT, 15, 60);
        blockfire.a(Blocks.tU, 60, 100);
        blockfire.a(Blocks.tV, 30, 60);
        blockfire.a(Blocks.tW, 30, 60);
        blockfire.a(Blocks.uc, 60, 100);
        blockfire.a(Blocks.ud, 60, 100);
        blockfire.a(Blocks.ue, 60, 100);
        blockfire.a(Blocks.uf, 30, 60);
        blockfire.a(Blocks.fO, 15, 100);
        blockfire.a(Blocks.va, 60, 100);
        blockfire.a(Blocks.bD, 60, 100);
        blockfire.a(Blocks.cx, 30, 20);
        blockfire.a(Blocks.cy, 30, 20);
        blockfire.a(Blocks.cz, 30, 20);
        blockfire.a(Blocks.cA, 30, 20);
        blockfire.a(Blocks.cC, 30, 20);
        blockfire.a(Blocks.cD, 30, 20);
        blockfire.a(Blocks.cE, 30, 20);
        blockfire.a(Blocks.cF, 30, 20);
        blockfire.a(Blocks.cG, 30, 20);
        blockfire.a(Blocks.cH, 30, 20);
    }
}

