/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockSoulFire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BlockFireAbstract
extends Block {
    private static final int b = 8;
    private static final int c = 1;
    private static final int d = 3;
    private final float e;
    protected static final VoxelShape a = Block.b(16.0, 0.0, 1.0);

    public BlockFireAbstract(BlockBase.Info blockbase_info, float f2) {
        super(blockbase_info);
        this.e = f2;
    }

    protected abstract MapCodec<? extends BlockFireAbstract> a();

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        return BlockFireAbstract.a(blockactioncontext.q(), blockactioncontext.a());
    }

    public static IBlockData a(IBlockAccess iblockaccess, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata = iblockaccess.a_(blockposition1);
        return BlockSoulFire.p(iblockdata) ? Blocks.cO.m() : ((BlockFire)Blocks.cN).b(iblockaccess, blockposition);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return a;
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        block12: {
            block11: {
                BlockPosition blockposition1;
                IBlockData iblockdata1;
                if (randomsource.a(24) == 0) {
                    world.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.kH, SoundCategory.e, 1.0f + randomsource.i(), randomsource.i() * 0.7f + 0.3f, false);
                }
                if (this.g(iblockdata1 = world.a_(blockposition1 = blockposition.e())) || iblockdata1.c((IBlockAccess)world, blockposition1, EnumDirection.b)) break block11;
                if (this.g(world.a_(blockposition.h()))) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        double d0 = (double)blockposition.u() + randomsource.j() * (double)0.1f;
                        double d1 = (double)blockposition.v() + randomsource.j();
                        double d2 = (double)blockposition.w() + randomsource.j();
                        world.a(Particles.ab, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(world.a_(blockposition.i()))) {
                    for (int j2 = 0; j2 < 2; ++j2) {
                        double d3 = (double)(blockposition.u() + 1) - randomsource.j() * (double)0.1f;
                        double d4 = (double)blockposition.v() + randomsource.j();
                        double d5 = (double)blockposition.w() + randomsource.j();
                        world.a(Particles.ab, d3, d4, d5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(world.a_(blockposition.f()))) {
                    for (int k2 = 0; k2 < 2; ++k2) {
                        double d6 = (double)blockposition.u() + randomsource.j();
                        double d7 = (double)blockposition.v() + randomsource.j();
                        double d8 = (double)blockposition.w() + randomsource.j() * (double)0.1f;
                        world.a(Particles.ab, d6, d7, d8, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(world.a_(blockposition.g()))) {
                    for (int l2 = 0; l2 < 2; ++l2) {
                        double d9 = (double)blockposition.u() + randomsource.j();
                        double d10 = (double)blockposition.v() + randomsource.j();
                        double d11 = (double)(blockposition.w() + 1) - randomsource.j() * (double)0.1f;
                        world.a(Particles.ab, d9, d10, d11, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.g(world.a_(blockposition.d()))) break block12;
                for (int i1 = 0; i1 < 2; ++i1) {
                    double d12 = (double)blockposition.u() + randomsource.j();
                    double d13 = (double)(blockposition.v() + 1) - randomsource.j() * (double)0.1f;
                    double d14 = (double)blockposition.w() + randomsource.j();
                    world.a(Particles.ab, d12, d13, d14, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int j1 = 0; j1 < 3; ++j1) {
                double d15 = (double)blockposition.u() + randomsource.j();
                double d16 = (double)blockposition.v() + randomsource.j() * 0.5 + 0.5;
                double d17 = (double)blockposition.w() + randomsource.j();
                world.a(Particles.ab, d15, d16, d17, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean g(IBlockData var1);

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        insideblockeffectapplier.a(InsideBlockEffectType.b);
        insideblockeffectapplier.a(InsideBlockEffectType.c);
        insideblockeffectapplier.b(InsideBlockEffectType.c, entity1 -> entity1.a(entity1.ao().as().a(), this.e));
    }

    public static void a(net.minecraft.world.entity.Entity entity) {
        if (!entity.bx()) {
            if (entity.aS() < 0) {
                entity.h(entity.aS() + 1);
            } else if (entity instanceof EntityPlayer) {
                int i2 = entity.ao().G_().b(1, 3);
                entity.h(entity.aS() + i2);
            }
            if (entity.aS() >= 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent(entity.getBukkitEntity().getLocation().getBlock(), (Entity)entity.getBukkitEntity(), 8.0f);
                entity.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext context) {
        if (!iblockdata1.a(iblockdata.b())) {
            Optional<BlockPortalShape> optional;
            if (BlockFireAbstract.a(world) && (optional = BlockPortalShape.a(world, blockposition, EnumDirection.EnumAxis.a)).isPresent()) {
                optional.get().createPortalBlocks(world, context == null ? null : context.o());
                return;
            }
            if (!iblockdata.a((IWorldReader)world, blockposition)) {
                this.fireExtinguished(world, blockposition);
            }
        }
    }

    private static boolean a(World world) {
        return world.getTypeKey() == WorldDimension.b || world.getTypeKey() == WorldDimension.c;
    }

    @Override
    protected void a(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata) {
    }

    @Override
    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        if (!world.B_()) {
            world.a((net.minecraft.world.entity.Entity)null, 1009, blockposition, 0);
        }
        return super.a(world, blockposition, iblockdata, entityhuman);
    }

    public static boolean a(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        IBlockData iblockdata = world.a_(blockposition);
        return !iblockdata.l() ? false : BlockFireAbstract.a(world, blockposition).a((IWorldReader)world, blockposition) || BlockFireAbstract.b(world, blockposition, enumdirection);
    }

    private static boolean b(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        if (!BlockFireAbstract.a(world)) {
            return false;
        }
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        boolean flag = false;
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (!world.a_(blockposition_mutableblockposition.g(blockposition).c(enumdirection1)).a(Blocks.cK)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o().d() ? enumdirection.i().o() : EnumDirection.EnumDirectionLimit.a.b(world.y);
        return BlockPortalShape.a(world, blockposition, enumdirection_enumaxis).isPresent();
    }

    protected void fireExtinguished(GeneratorAccess world, BlockPosition position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.a.m()).isCancelled()) {
            world.a(position, false);
        }
    }
}

